#include <pro.h>
#include "findcrypt.hpp"

// Various constants used in crypto algorithms
// They were copied from public domain codes

//-----------------
static const unsigned int zinflate_lengthStarts[] =
{
  3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
  35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258
};
static const unsigned int zinflate_lengthExtraBits[] =
{
  0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2,
  3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0
};
static const unsigned int zinflate_distanceStarts[] =
{
  1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
  257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
  8193, 12289, 16385, 24577
};
static const unsigned int zinflate_distanceExtraBits[] =
{
  0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6,
  7, 7, 8, 8, 9, 9, 10, 10, 11, 11,
  12, 12, 13, 13
};
//-----------------
static const unsigned int zdeflate_lengthCodes[] =
{
  257, 258, 259, 260, 261, 262, 263, 264, 265, 265, 266, 266, 267, 267, 268, 268,
  269, 269, 269, 269, 270, 270, 270, 270, 271, 271, 271, 271, 272, 272, 272, 272,
  273, 273, 273, 273, 273, 273, 273, 273, 274, 274, 274, 274, 274, 274, 274, 274,
  275, 275, 275, 275, 275, 275, 275, 275, 276, 276, 276, 276, 276, 276, 276, 276,
  277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279,
  280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,
  281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281,
  281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281,
  282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282,
  282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282,
  283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283,
  283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283,
  284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284,
  284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 285
};

//-----------------
static const word64 Whirlpool_C0[256] =
{
  W64LIT(0x1818281878c0d878), W64LIT(0x23236523af0526af),
  W64LIT(0xc6c657c6f97eb8f9), W64LIT(0xe8e825e86f13fb6f),
  W64LIT(0x87879487a14ccba1), W64LIT(0xb8b8d5b862a91162),
  W64LIT(0x0101030105080905), W64LIT(0x4f4fd14f6e420d6e),
  W64LIT(0x36365a36eead9bee), W64LIT(0xa6a6f7a60459ff04),
  W64LIT(0xd2d26bd2bdde0cbd), W64LIT(0xf5f502f506fb0e06),
  W64LIT(0x79798b7980ef9680), W64LIT(0x6f6fb16fce5f30ce),
  W64LIT(0x9191ae91effc6def), W64LIT(0x5252f65207aaf807),
  W64LIT(0x6060a060fd2747fd), W64LIT(0xbcbcd9bc76893576),
  W64LIT(0x9b9bb09bcdac37cd), W64LIT(0x8e8e8f8e8c048a8c),
  W64LIT(0xa3a3f8a31571d215), W64LIT(0x0c0c140c3c606c3c),
  W64LIT(0x7b7b8d7b8aff848a), W64LIT(0x35355f35e1b580e1),
  W64LIT(0x1d1d271d69e8f569), W64LIT(0xe0e03de04753b347),
  W64LIT(0xd7d764d7acf621ac), W64LIT(0xc2c25bc2ed5e9ced),
  W64LIT(0x2e2e722e966d4396), W64LIT(0x4b4bdd4b7a62297a),
  W64LIT(0xfefe1ffe21a35d21), W64LIT(0x5757f9571682d516),
  W64LIT(0x15153f1541a8bd41), W64LIT(0x77779977b69fe8b6),
  W64LIT(0x37375937eba592eb), W64LIT(0xe5e532e5567b9e56),
  W64LIT(0x9f9fbc9fd98c13d9), W64LIT(0xf0f00df017d32317),
  W64LIT(0x4a4ade4a7f6a207f), W64LIT(0xdada73da959e4495),
  W64LIT(0x5858e85825faa225), W64LIT(0xc9c946c9ca06cfca),
  W64LIT(0x29297b298d557c8d), W64LIT(0x0a0a1e0a22505a22),
  W64LIT(0xb1b1ceb14fe1504f), W64LIT(0xa0a0fda01a69c91a),
  W64LIT(0x6b6bbd6bda7f14da), W64LIT(0x85859285ab5cd9ab),
  W64LIT(0xbdbddabd73813c73), W64LIT(0x5d5de75d34d28f34),
  W64LIT(0x1010301050809050), W64LIT(0xf4f401f403f30703),
  W64LIT(0xcbcb40cbc016ddc0), W64LIT(0x3e3e423ec6edd3c6),
  W64LIT(0x05050f0511282d11), W64LIT(0x6767a967e61f78e6),
  W64LIT(0xe4e431e453739753), W64LIT(0x27276927bb2502bb),
  W64LIT(0x4141c34158327358), W64LIT(0x8b8b808b9d2ca79d),
  W64LIT(0xa7a7f4a70151f601), W64LIT(0x7d7d877d94cfb294),
  W64LIT(0x9595a295fbdc49fb), W64LIT(0xd8d875d89f8e569f),
  W64LIT(0xfbfb10fb308b7030), W64LIT(0xeeee2fee7123cd71),
  W64LIT(0x7c7c847c91c7bb91), W64LIT(0x6666aa66e31771e3),
  W64LIT(0xdddd7add8ea67b8e), W64LIT(0x171739174bb8af4b),
  W64LIT(0x4747c94746024546), W64LIT(0x9e9ebf9edc841adc),
  W64LIT(0xcaca43cac51ed4c5), W64LIT(0x2d2d772d99755899),
  W64LIT(0xbfbfdcbf79912e79), W64LIT(0x070709071b383f1b),
  W64LIT(0xadadeaad2301ac23), W64LIT(0x5a5aee5a2feab02f),
  W64LIT(0x83839883b56cefb5), W64LIT(0x33335533ff85b6ff),
  W64LIT(0x6363a563f23f5cf2), W64LIT(0x020206020a10120a),
  W64LIT(0xaaaae3aa38399338), W64LIT(0x71719371a8afdea8),
  W64LIT(0xc8c845c8cf0ec6cf), W64LIT(0x19192b197dc8d17d),
  W64LIT(0x4949db4970723b70), W64LIT(0xd9d976d99a865f9a),
  W64LIT(0xf2f20bf21dc3311d), W64LIT(0xe3e338e3484ba848),
  W64LIT(0x5b5bed5b2ae2b92a), W64LIT(0x888885889234bc92),
  W64LIT(0x9a9ab39ac8a43ec8), W64LIT(0x26266a26be2d0bbe),
  W64LIT(0x32325632fa8dbffa), W64LIT(0xb0b0cdb04ae9594a),
  W64LIT(0xe9e926e96a1bf26a), W64LIT(0x0f0f110f33787733),
  W64LIT(0xd5d562d5a6e633a6), W64LIT(0x80809d80ba74f4ba),
  W64LIT(0xbebedfbe7c99277c), W64LIT(0xcdcd4acdde26ebde),
  W64LIT(0x34345c34e4bd89e4), W64LIT(0x4848d848757a3275),
  W64LIT(0xffff1cff24ab5424), W64LIT(0x7a7a8e7a8ff78d8f),
  W64LIT(0x9090ad90eaf464ea), W64LIT(0x5f5fe15f3ec29d3e),
  W64LIT(0x20206020a01d3da0), W64LIT(0x6868b868d5670fd5),
  W64LIT(0x1a1a2e1a72d0ca72), W64LIT(0xaeaeefae2c19b72c),
  W64LIT(0xb4b4c1b45ec97d5e), W64LIT(0x5454fc54199ace19),
  W64LIT(0x9393a893e5ec7fe5), W64LIT(0x22226622aa0d2faa),
  W64LIT(0x6464ac64e90763e9), W64LIT(0xf1f10ef112db2a12),
  W64LIT(0x73739573a2bfcca2), W64LIT(0x121236125a90825a),
  W64LIT(0x4040c0405d3a7a5d), W64LIT(0x0808180828404828),
  W64LIT(0xc3c358c3e85695e8), W64LIT(0xecec29ec7b33df7b),
  W64LIT(0xdbdb70db90964d90), W64LIT(0xa1a1fea11f61c01f),
  W64LIT(0x8d8d8a8d831c9183), W64LIT(0x3d3d473dc9f5c8c9),
  W64LIT(0x9797a497f1cc5bf1), W64LIT(0x0000000000000000),
  W64LIT(0xcfcf4ccfd436f9d4), W64LIT(0x2b2b7d2b87456e87),
  W64LIT(0x76769a76b397e1b3), W64LIT(0x82829b82b064e6b0),
  W64LIT(0xd6d667d6a9fe28a9), W64LIT(0x1b1b2d1b77d8c377),
  W64LIT(0xb5b5c2b55bc1745b), W64LIT(0xafafecaf2911be29),
  W64LIT(0x6a6abe6adf771ddf), W64LIT(0x5050f0500dbaea0d),
  W64LIT(0x4545cf454c12574c), W64LIT(0xf3f308f318cb3818),
  W64LIT(0x30305030f09dadf0), W64LIT(0xefef2cef742bc474),
  W64LIT(0x3f3f413fc3e5dac3), W64LIT(0x5555ff551c92c71c),
  W64LIT(0xa2a2fba21079db10), W64LIT(0xeaea23ea6503e965),
  W64LIT(0x6565af65ec0f6aec), W64LIT(0xbabad3ba68b90368),
  W64LIT(0x2f2f712f93654a93), W64LIT(0xc0c05dc0e74e8ee7),
  W64LIT(0xdede7fde81be6081), W64LIT(0x1c1c241c6ce0fc6c),
  W64LIT(0xfdfd1afd2ebb462e), W64LIT(0x4d4dd74d64521f64),
  W64LIT(0x9292ab92e0e476e0), W64LIT(0x75759f75bc8ffabc),
  W64LIT(0x06060a061e30361e), W64LIT(0x8a8a838a9824ae98),
  W64LIT(0xb2b2cbb240f94b40), W64LIT(0xe6e637e659638559),
  W64LIT(0x0e0e120e36707e36), W64LIT(0x1f1f211f63f8e763),
  W64LIT(0x6262a662f73755f7), W64LIT(0xd4d461d4a3ee3aa3),
  W64LIT(0xa8a8e5a832298132), W64LIT(0x9696a796f4c452f4),
  W64LIT(0xf9f916f93a9b623a), W64LIT(0xc5c552c5f666a3f6),
  W64LIT(0x25256f25b13510b1), W64LIT(0x5959eb5920f2ab20),
  W64LIT(0x84849184ae54d0ae), W64LIT(0x72729672a7b7c5a7),
  W64LIT(0x39394b39ddd5ecdd), W64LIT(0x4c4cd44c615a1661),
  W64LIT(0x5e5ee25e3bca943b), W64LIT(0x7878887885e79f85),
  W64LIT(0x38384838d8dde5d8), W64LIT(0x8c8c898c86149886),
  W64LIT(0xd1d16ed1b2c617b2), W64LIT(0xa5a5f2a50b41e40b),
  W64LIT(0xe2e23be24d43a14d), W64LIT(0x6161a361f82f4ef8),
  W64LIT(0xb3b3c8b345f14245), W64LIT(0x21216321a51534a5),
  W64LIT(0x9c9cb99cd69408d6), W64LIT(0x1e1e221e66f0ee66),
  W64LIT(0x4343c54352226152), W64LIT(0xc7c754c7fc76b1fc),
  W64LIT(0xfcfc19fc2bb34f2b), W64LIT(0x04040c0414202414),
  W64LIT(0x5151f35108b2e308), W64LIT(0x9999b699c7bc25c7),
  W64LIT(0x6d6db76dc44f22c4), W64LIT(0x0d0d170d39686539),
  W64LIT(0xfafa13fa35837935), W64LIT(0xdfdf7cdf84b66984),
  W64LIT(0x7e7e827e9bd7a99b), W64LIT(0x24246c24b43d19b4),
  W64LIT(0x3b3b4d3bd7c5fed7), W64LIT(0xababe0ab3d319a3d),
  W64LIT(0xcece4fced13ef0d1), W64LIT(0x1111331155889955),
  W64LIT(0x8f8f8c8f890c8389), W64LIT(0x4e4ed24e6b4a046b),
  W64LIT(0xb7b7c4b751d16651), W64LIT(0xebeb20eb600be060),
  W64LIT(0x3c3c443cccfdc1cc), W64LIT(0x81819e81bf7cfdbf),
  W64LIT(0x9494a194fed440fe), W64LIT(0xf7f704f70ceb1c0c),
  W64LIT(0xb9b9d6b967a11867), W64LIT(0x131335135f988b5f),
  W64LIT(0x2c2c742c9c7d519c), W64LIT(0xd3d368d3b8d605b8),
  W64LIT(0xe7e734e75c6b8c5c), W64LIT(0x6e6eb26ecb5739cb),
  W64LIT(0xc4c451c4f36eaaf3), W64LIT(0x030305030f181b0f),
  W64LIT(0x5656fa56138adc13), W64LIT(0x4444cc44491a5e49),
  W64LIT(0x7f7f817f9edfa09e), W64LIT(0xa9a9e6a937218837),
  W64LIT(0x2a2a7e2a824d6782), W64LIT(0xbbbbd0bb6db10a6d),
  W64LIT(0xc1c15ec1e24687e2), W64LIT(0x5353f55302a2f102),
  W64LIT(0xdcdc79dc8bae728b), W64LIT(0x0b0b1d0b27585327),
  W64LIT(0x9d9dba9dd39c01d3), W64LIT(0x6c6cb46cc1472bc1),
  W64LIT(0x31315331f595a4f5), W64LIT(0x74749c74b987f3b9),
  W64LIT(0xf6f607f609e31509), W64LIT(0x4646ca46430a4c43),
  W64LIT(0xacace9ac2609a526), W64LIT(0x89898689973cb597),
  W64LIT(0x14143c1444a0b444), W64LIT(0xe1e13ee1425bba42),
  W64LIT(0x16163a164eb0a64e), W64LIT(0x3a3a4e3ad2cdf7d2),
  W64LIT(0x6969bb69d06f06d0), W64LIT(0x09091b092d48412d),
  W64LIT(0x70709070ada7d7ad), W64LIT(0xb6b6c7b654d96f54),
  W64LIT(0xd0d06dd0b7ce1eb7), W64LIT(0xeded2aed7e3bd67e),
  W64LIT(0xcccc49ccdb2ee2db), W64LIT(0x4242c642572a6857),
  W64LIT(0x9898b598c2b42cc2), W64LIT(0xa4a4f1a40e49ed0e),
  W64LIT(0x28287828885d7588), W64LIT(0x5c5ce45c31da8631),
  W64LIT(0xf8f815f83f936b3f), W64LIT(0x86869786a444c2a4),
};

static const word64 Whirlpool_C1[256] =
{
  W64LIT(0x781818281878c0d8), W64LIT(0xaf23236523af0526),
  W64LIT(0xf9c6c657c6f97eb8), W64LIT(0x6fe8e825e86f13fb),
  W64LIT(0xa187879487a14ccb), W64LIT(0x62b8b8d5b862a911),
  W64LIT(0x0501010301050809), W64LIT(0x6e4f4fd14f6e420d),
  W64LIT(0xee36365a36eead9b), W64LIT(0x04a6a6f7a60459ff),
  W64LIT(0xbdd2d26bd2bdde0c), W64LIT(0x06f5f502f506fb0e),
  W64LIT(0x8079798b7980ef96), W64LIT(0xce6f6fb16fce5f30),
  W64LIT(0xef9191ae91effc6d), W64LIT(0x075252f65207aaf8),
  W64LIT(0xfd6060a060fd2747), W64LIT(0x76bcbcd9bc768935),
  W64LIT(0xcd9b9bb09bcdac37), W64LIT(0x8c8e8e8f8e8c048a),
  W64LIT(0x15a3a3f8a31571d2), W64LIT(0x3c0c0c140c3c606c),
  W64LIT(0x8a7b7b8d7b8aff84), W64LIT(0xe135355f35e1b580),
  W64LIT(0x691d1d271d69e8f5), W64LIT(0x47e0e03de04753b3),
  W64LIT(0xacd7d764d7acf621), W64LIT(0xedc2c25bc2ed5e9c),
  W64LIT(0x962e2e722e966d43), W64LIT(0x7a4b4bdd4b7a6229),
  W64LIT(0x21fefe1ffe21a35d), W64LIT(0x165757f9571682d5),
  W64LIT(0x4115153f1541a8bd), W64LIT(0xb677779977b69fe8),
  W64LIT(0xeb37375937eba592), W64LIT(0x56e5e532e5567b9e),
  W64LIT(0xd99f9fbc9fd98c13), W64LIT(0x17f0f00df017d323),
  W64LIT(0x7f4a4ade4a7f6a20), W64LIT(0x95dada73da959e44),
  W64LIT(0x255858e85825faa2), W64LIT(0xcac9c946c9ca06cf),
  W64LIT(0x8d29297b298d557c), W64LIT(0x220a0a1e0a22505a),
  W64LIT(0x4fb1b1ceb14fe150), W64LIT(0x1aa0a0fda01a69c9),
  W64LIT(0xda6b6bbd6bda7f14), W64LIT(0xab85859285ab5cd9),
  W64LIT(0x73bdbddabd73813c), W64LIT(0x345d5de75d34d28f),
  W64LIT(0x5010103010508090), W64LIT(0x03f4f401f403f307),
  W64LIT(0xc0cbcb40cbc016dd), W64LIT(0xc63e3e423ec6edd3),
  W64LIT(0x1105050f0511282d), W64LIT(0xe66767a967e61f78),
  W64LIT(0x53e4e431e4537397), W64LIT(0xbb27276927bb2502),
  W64LIT(0x584141c341583273), W64LIT(0x9d8b8b808b9d2ca7),
  W64LIT(0x01a7a7f4a70151f6), W64LIT(0x947d7d877d94cfb2),
  W64LIT(0xfb9595a295fbdc49), W64LIT(0x9fd8d875d89f8e56),
  W64LIT(0x30fbfb10fb308b70), W64LIT(0x71eeee2fee7123cd),
  W64LIT(0x917c7c847c91c7bb), W64LIT(0xe36666aa66e31771),
  W64LIT(0x8edddd7add8ea67b), W64LIT(0x4b171739174bb8af),
  W64LIT(0x464747c947460245), W64LIT(0xdc9e9ebf9edc841a),
  W64LIT(0xc5caca43cac51ed4), W64LIT(0x992d2d772d997558),
  W64LIT(0x79bfbfdcbf79912e), W64LIT(0x1b070709071b383f),
  W64LIT(0x23adadeaad2301ac), W64LIT(0x2f5a5aee5a2feab0),
  W64LIT(0xb583839883b56cef), W64LIT(0xff33335533ff85b6),
  W64LIT(0xf26363a563f23f5c), W64LIT(0x0a020206020a1012),
  W64LIT(0x38aaaae3aa383993), W64LIT(0xa871719371a8afde),
  W64LIT(0xcfc8c845c8cf0ec6), W64LIT(0x7d19192b197dc8d1),
  W64LIT(0x704949db4970723b), W64LIT(0x9ad9d976d99a865f),
  W64LIT(0x1df2f20bf21dc331), W64LIT(0x48e3e338e3484ba8),
  W64LIT(0x2a5b5bed5b2ae2b9), W64LIT(0x92888885889234bc),
  W64LIT(0xc89a9ab39ac8a43e), W64LIT(0xbe26266a26be2d0b),
  W64LIT(0xfa32325632fa8dbf), W64LIT(0x4ab0b0cdb04ae959),
  W64LIT(0x6ae9e926e96a1bf2), W64LIT(0x330f0f110f337877),
  W64LIT(0xa6d5d562d5a6e633), W64LIT(0xba80809d80ba74f4),
  W64LIT(0x7cbebedfbe7c9927), W64LIT(0xdecdcd4acdde26eb),
  W64LIT(0xe434345c34e4bd89), W64LIT(0x754848d848757a32),
  W64LIT(0x24ffff1cff24ab54), W64LIT(0x8f7a7a8e7a8ff78d),
  W64LIT(0xea9090ad90eaf464), W64LIT(0x3e5f5fe15f3ec29d),
  W64LIT(0xa020206020a01d3d), W64LIT(0xd56868b868d5670f),
  W64LIT(0x721a1a2e1a72d0ca), W64LIT(0x2caeaeefae2c19b7),
  W64LIT(0x5eb4b4c1b45ec97d), W64LIT(0x195454fc54199ace),
  W64LIT(0xe59393a893e5ec7f), W64LIT(0xaa22226622aa0d2f),
  W64LIT(0xe96464ac64e90763), W64LIT(0x12f1f10ef112db2a),
  W64LIT(0xa273739573a2bfcc), W64LIT(0x5a121236125a9082),
  W64LIT(0x5d4040c0405d3a7a), W64LIT(0x2808081808284048),
  W64LIT(0xe8c3c358c3e85695), W64LIT(0x7becec29ec7b33df),
  W64LIT(0x90dbdb70db90964d), W64LIT(0x1fa1a1fea11f61c0),
  W64LIT(0x838d8d8a8d831c91), W64LIT(0xc93d3d473dc9f5c8),
  W64LIT(0xf19797a497f1cc5b), W64LIT(0x0000000000000000),
  W64LIT(0xd4cfcf4ccfd436f9), W64LIT(0x872b2b7d2b87456e),
  W64LIT(0xb376769a76b397e1), W64LIT(0xb082829b82b064e6),
  W64LIT(0xa9d6d667d6a9fe28), W64LIT(0x771b1b2d1b77d8c3),
  W64LIT(0x5bb5b5c2b55bc174), W64LIT(0x29afafecaf2911be),
  W64LIT(0xdf6a6abe6adf771d), W64LIT(0x0d5050f0500dbaea),
  W64LIT(0x4c4545cf454c1257), W64LIT(0x18f3f308f318cb38),
  W64LIT(0xf030305030f09dad), W64LIT(0x74efef2cef742bc4),
  W64LIT(0xc33f3f413fc3e5da), W64LIT(0x1c5555ff551c92c7),
  W64LIT(0x10a2a2fba21079db), W64LIT(0x65eaea23ea6503e9),
  W64LIT(0xec6565af65ec0f6a), W64LIT(0x68babad3ba68b903),
  W64LIT(0x932f2f712f93654a), W64LIT(0xe7c0c05dc0e74e8e),
  W64LIT(0x81dede7fde81be60), W64LIT(0x6c1c1c241c6ce0fc),
  W64LIT(0x2efdfd1afd2ebb46), W64LIT(0x644d4dd74d64521f),
  W64LIT(0xe09292ab92e0e476), W64LIT(0xbc75759f75bc8ffa),
  W64LIT(0x1e06060a061e3036), W64LIT(0x988a8a838a9824ae),
  W64LIT(0x40b2b2cbb240f94b), W64LIT(0x59e6e637e6596385),
  W64LIT(0x360e0e120e36707e), W64LIT(0x631f1f211f63f8e7),
  W64LIT(0xf76262a662f73755), W64LIT(0xa3d4d461d4a3ee3a),
  W64LIT(0x32a8a8e5a8322981), W64LIT(0xf49696a796f4c452),
  W64LIT(0x3af9f916f93a9b62), W64LIT(0xf6c5c552c5f666a3),
  W64LIT(0xb125256f25b13510), W64LIT(0x205959eb5920f2ab),
  W64LIT(0xae84849184ae54d0), W64LIT(0xa772729672a7b7c5),
  W64LIT(0xdd39394b39ddd5ec), W64LIT(0x614c4cd44c615a16),
  W64LIT(0x3b5e5ee25e3bca94), W64LIT(0x857878887885e79f),
  W64LIT(0xd838384838d8dde5), W64LIT(0x868c8c898c861498),
  W64LIT(0xb2d1d16ed1b2c617), W64LIT(0x0ba5a5f2a50b41e4),
  W64LIT(0x4de2e23be24d43a1), W64LIT(0xf86161a361f82f4e),
  W64LIT(0x45b3b3c8b345f142), W64LIT(0xa521216321a51534),
  W64LIT(0xd69c9cb99cd69408), W64LIT(0x661e1e221e66f0ee),
  W64LIT(0x524343c543522261), W64LIT(0xfcc7c754c7fc76b1),
  W64LIT(0x2bfcfc19fc2bb34f), W64LIT(0x1404040c04142024),
  W64LIT(0x085151f35108b2e3), W64LIT(0xc79999b699c7bc25),
  W64LIT(0xc46d6db76dc44f22), W64LIT(0x390d0d170d396865),
  W64LIT(0x35fafa13fa358379), W64LIT(0x84dfdf7cdf84b669),
  W64LIT(0x9b7e7e827e9bd7a9), W64LIT(0xb424246c24b43d19),
  W64LIT(0xd73b3b4d3bd7c5fe), W64LIT(0x3dababe0ab3d319a),
  W64LIT(0xd1cece4fced13ef0), W64LIT(0x5511113311558899),
  W64LIT(0x898f8f8c8f890c83), W64LIT(0x6b4e4ed24e6b4a04),
  W64LIT(0x51b7b7c4b751d166), W64LIT(0x60ebeb20eb600be0),
  W64LIT(0xcc3c3c443cccfdc1), W64LIT(0xbf81819e81bf7cfd),
  W64LIT(0xfe9494a194fed440), W64LIT(0x0cf7f704f70ceb1c),
  W64LIT(0x67b9b9d6b967a118), W64LIT(0x5f131335135f988b),
  W64LIT(0x9c2c2c742c9c7d51), W64LIT(0xb8d3d368d3b8d605),
  W64LIT(0x5ce7e734e75c6b8c), W64LIT(0xcb6e6eb26ecb5739),
  W64LIT(0xf3c4c451c4f36eaa), W64LIT(0x0f030305030f181b),
  W64LIT(0x135656fa56138adc), W64LIT(0x494444cc44491a5e),
  W64LIT(0x9e7f7f817f9edfa0), W64LIT(0x37a9a9e6a9372188),
  W64LIT(0x822a2a7e2a824d67), W64LIT(0x6dbbbbd0bb6db10a),
  W64LIT(0xe2c1c15ec1e24687), W64LIT(0x025353f55302a2f1),
  W64LIT(0x8bdcdc79dc8bae72), W64LIT(0x270b0b1d0b275853),
  W64LIT(0xd39d9dba9dd39c01), W64LIT(0xc16c6cb46cc1472b),
  W64LIT(0xf531315331f595a4), W64LIT(0xb974749c74b987f3),
  W64LIT(0x09f6f607f609e315), W64LIT(0x434646ca46430a4c),
  W64LIT(0x26acace9ac2609a5), W64LIT(0x9789898689973cb5),
  W64LIT(0x4414143c1444a0b4), W64LIT(0x42e1e13ee1425bba),
  W64LIT(0x4e16163a164eb0a6), W64LIT(0xd23a3a4e3ad2cdf7),
  W64LIT(0xd06969bb69d06f06), W64LIT(0x2d09091b092d4841),
  W64LIT(0xad70709070ada7d7), W64LIT(0x54b6b6c7b654d96f),
  W64LIT(0xb7d0d06dd0b7ce1e), W64LIT(0x7eeded2aed7e3bd6),
  W64LIT(0xdbcccc49ccdb2ee2), W64LIT(0x574242c642572a68),
  W64LIT(0xc29898b598c2b42c), W64LIT(0x0ea4a4f1a40e49ed),
  W64LIT(0x8828287828885d75), W64LIT(0x315c5ce45c31da86),
  W64LIT(0x3ff8f815f83f936b), W64LIT(0xa486869786a444c2),
};

static const word64 Whirlpool_C2[256] =
{
  W64LIT(0xd8781818281878c0), W64LIT(0x26af23236523af05),
  W64LIT(0xb8f9c6c657c6f97e), W64LIT(0xfb6fe8e825e86f13),
  W64LIT(0xcba187879487a14c), W64LIT(0x1162b8b8d5b862a9),
  W64LIT(0x0905010103010508), W64LIT(0x0d6e4f4fd14f6e42),
  W64LIT(0x9bee36365a36eead), W64LIT(0xff04a6a6f7a60459),
  W64LIT(0x0cbdd2d26bd2bdde), W64LIT(0x0e06f5f502f506fb),
  W64LIT(0x968079798b7980ef), W64LIT(0x30ce6f6fb16fce5f),
  W64LIT(0x6def9191ae91effc), W64LIT(0xf8075252f65207aa),
  W64LIT(0x47fd6060a060fd27), W64LIT(0x3576bcbcd9bc7689),
  W64LIT(0x37cd9b9bb09bcdac), W64LIT(0x8a8c8e8e8f8e8c04),
  W64LIT(0xd215a3a3f8a31571), W64LIT(0x6c3c0c0c140c3c60),
  W64LIT(0x848a7b7b8d7b8aff), W64LIT(0x80e135355f35e1b5),
  W64LIT(0xf5691d1d271d69e8), W64LIT(0xb347e0e03de04753),
  W64LIT(0x21acd7d764d7acf6), W64LIT(0x9cedc2c25bc2ed5e),
  W64LIT(0x43962e2e722e966d), W64LIT(0x297a4b4bdd4b7a62),
  W64LIT(0x5d21fefe1ffe21a3), W64LIT(0xd5165757f9571682),
  W64LIT(0xbd4115153f1541a8), W64LIT(0xe8b677779977b69f),
  W64LIT(0x92eb37375937eba5), W64LIT(0x9e56e5e532e5567b),
  W64LIT(0x13d99f9fbc9fd98c), W64LIT(0x2317f0f00df017d3),
  W64LIT(0x207f4a4ade4a7f6a), W64LIT(0x4495dada73da959e),
  W64LIT(0xa2255858e85825fa), W64LIT(0xcfcac9c946c9ca06),
  W64LIT(0x7c8d29297b298d55), W64LIT(0x5a220a0a1e0a2250),
  W64LIT(0x504fb1b1ceb14fe1), W64LIT(0xc91aa0a0fda01a69),
  W64LIT(0x14da6b6bbd6bda7f), W64LIT(0xd9ab85859285ab5c),
  W64LIT(0x3c73bdbddabd7381), W64LIT(0x8f345d5de75d34d2),
  W64LIT(0x9050101030105080), W64LIT(0x0703f4f401f403f3),
  W64LIT(0xddc0cbcb40cbc016), W64LIT(0xd3c63e3e423ec6ed),
  W64LIT(0x2d1105050f051128), W64LIT(0x78e66767a967e61f),
  W64LIT(0x9753e4e431e45373), W64LIT(0x02bb27276927bb25),
  W64LIT(0x73584141c3415832), W64LIT(0xa79d8b8b808b9d2c),
  W64LIT(0xf601a7a7f4a70151), W64LIT(0xb2947d7d877d94cf),
  W64LIT(0x49fb9595a295fbdc), W64LIT(0x569fd8d875d89f8e),
  W64LIT(0x7030fbfb10fb308b), W64LIT(0xcd71eeee2fee7123),
  W64LIT(0xbb917c7c847c91c7), W64LIT(0x71e36666aa66e317),
  W64LIT(0x7b8edddd7add8ea6), W64LIT(0xaf4b171739174bb8),
  W64LIT(0x45464747c9474602), W64LIT(0x1adc9e9ebf9edc84),
  W64LIT(0xd4c5caca43cac51e), W64LIT(0x58992d2d772d9975),
  W64LIT(0x2e79bfbfdcbf7991), W64LIT(0x3f1b070709071b38),
  W64LIT(0xac23adadeaad2301), W64LIT(0xb02f5a5aee5a2fea),
  W64LIT(0xefb583839883b56c), W64LIT(0xb6ff33335533ff85),
  W64LIT(0x5cf26363a563f23f), W64LIT(0x120a020206020a10),
  W64LIT(0x9338aaaae3aa3839), W64LIT(0xdea871719371a8af),
  W64LIT(0xc6cfc8c845c8cf0e), W64LIT(0xd17d19192b197dc8),
  W64LIT(0x3b704949db497072), W64LIT(0x5f9ad9d976d99a86),
  W64LIT(0x311df2f20bf21dc3), W64LIT(0xa848e3e338e3484b),
  W64LIT(0xb92a5b5bed5b2ae2), W64LIT(0xbc92888885889234),
  W64LIT(0x3ec89a9ab39ac8a4), W64LIT(0x0bbe26266a26be2d),
  W64LIT(0xbffa32325632fa8d), W64LIT(0x594ab0b0cdb04ae9),
  W64LIT(0xf26ae9e926e96a1b), W64LIT(0x77330f0f110f3378),
  W64LIT(0x33a6d5d562d5a6e6), W64LIT(0xf4ba80809d80ba74),
  W64LIT(0x277cbebedfbe7c99), W64LIT(0xebdecdcd4acdde26),
  W64LIT(0x89e434345c34e4bd), W64LIT(0x32754848d848757a),
  W64LIT(0x5424ffff1cff24ab), W64LIT(0x8d8f7a7a8e7a8ff7),
  W64LIT(0x64ea9090ad90eaf4), W64LIT(0x9d3e5f5fe15f3ec2),
  W64LIT(0x3da020206020a01d), W64LIT(0x0fd56868b868d567),
  W64LIT(0xca721a1a2e1a72d0), W64LIT(0xb72caeaeefae2c19),
  W64LIT(0x7d5eb4b4c1b45ec9), W64LIT(0xce195454fc54199a),
  W64LIT(0x7fe59393a893e5ec), W64LIT(0x2faa22226622aa0d),
  W64LIT(0x63e96464ac64e907), W64LIT(0x2a12f1f10ef112db),
  W64LIT(0xcca273739573a2bf), W64LIT(0x825a121236125a90),
  W64LIT(0x7a5d4040c0405d3a), W64LIT(0x4828080818082840),
  W64LIT(0x95e8c3c358c3e856), W64LIT(0xdf7becec29ec7b33),
  W64LIT(0x4d90dbdb70db9096), W64LIT(0xc01fa1a1fea11f61),
  W64LIT(0x91838d8d8a8d831c), W64LIT(0xc8c93d3d473dc9f5),
  W64LIT(0x5bf19797a497f1cc), W64LIT(0x0000000000000000),
  W64LIT(0xf9d4cfcf4ccfd436), W64LIT(0x6e872b2b7d2b8745),
  W64LIT(0xe1b376769a76b397), W64LIT(0xe6b082829b82b064),
  W64LIT(0x28a9d6d667d6a9fe), W64LIT(0xc3771b1b2d1b77d8),
  W64LIT(0x745bb5b5c2b55bc1), W64LIT(0xbe29afafecaf2911),
  W64LIT(0x1ddf6a6abe6adf77), W64LIT(0xea0d5050f0500dba),
  W64LIT(0x574c4545cf454c12), W64LIT(0x3818f3f308f318cb),
  W64LIT(0xadf030305030f09d), W64LIT(0xc474efef2cef742b),
  W64LIT(0xdac33f3f413fc3e5), W64LIT(0xc71c5555ff551c92),
  W64LIT(0xdb10a2a2fba21079), W64LIT(0xe965eaea23ea6503),
  W64LIT(0x6aec6565af65ec0f), W64LIT(0x0368babad3ba68b9),
  W64LIT(0x4a932f2f712f9365), W64LIT(0x8ee7c0c05dc0e74e),
  W64LIT(0x6081dede7fde81be), W64LIT(0xfc6c1c1c241c6ce0),
  W64LIT(0x462efdfd1afd2ebb), W64LIT(0x1f644d4dd74d6452),
  W64LIT(0x76e09292ab92e0e4), W64LIT(0xfabc75759f75bc8f),
  W64LIT(0x361e06060a061e30), W64LIT(0xae988a8a838a9824),
  W64LIT(0x4b40b2b2cbb240f9), W64LIT(0x8559e6e637e65963),
  W64LIT(0x7e360e0e120e3670), W64LIT(0xe7631f1f211f63f8),
  W64LIT(0x55f76262a662f737), W64LIT(0x3aa3d4d461d4a3ee),
  W64LIT(0x8132a8a8e5a83229), W64LIT(0x52f49696a796f4c4),
  W64LIT(0x623af9f916f93a9b), W64LIT(0xa3f6c5c552c5f666),
  W64LIT(0x10b125256f25b135), W64LIT(0xab205959eb5920f2),
  W64LIT(0xd0ae84849184ae54), W64LIT(0xc5a772729672a7b7),
  W64LIT(0xecdd39394b39ddd5), W64LIT(0x16614c4cd44c615a),
  W64LIT(0x943b5e5ee25e3bca), W64LIT(0x9f857878887885e7),
  W64LIT(0xe5d838384838d8dd), W64LIT(0x98868c8c898c8614),
  W64LIT(0x17b2d1d16ed1b2c6), W64LIT(0xe40ba5a5f2a50b41),
  W64LIT(0xa14de2e23be24d43), W64LIT(0x4ef86161a361f82f),
  W64LIT(0x4245b3b3c8b345f1), W64LIT(0x34a521216321a515),
  W64LIT(0x08d69c9cb99cd694), W64LIT(0xee661e1e221e66f0),
  W64LIT(0x61524343c5435222), W64LIT(0xb1fcc7c754c7fc76),
  W64LIT(0x4f2bfcfc19fc2bb3), W64LIT(0x241404040c041420),
  W64LIT(0xe3085151f35108b2), W64LIT(0x25c79999b699c7bc),
  W64LIT(0x22c46d6db76dc44f), W64LIT(0x65390d0d170d3968),
  W64LIT(0x7935fafa13fa3583), W64LIT(0x6984dfdf7cdf84b6),
  W64LIT(0xa99b7e7e827e9bd7), W64LIT(0x19b424246c24b43d),
  W64LIT(0xfed73b3b4d3bd7c5), W64LIT(0x9a3dababe0ab3d31),
  W64LIT(0xf0d1cece4fced13e), W64LIT(0x9955111133115588),
  W64LIT(0x83898f8f8c8f890c), W64LIT(0x046b4e4ed24e6b4a),
  W64LIT(0x6651b7b7c4b751d1), W64LIT(0xe060ebeb20eb600b),
  W64LIT(0xc1cc3c3c443cccfd), W64LIT(0xfdbf81819e81bf7c),
  W64LIT(0x40fe9494a194fed4), W64LIT(0x1c0cf7f704f70ceb),
  W64LIT(0x1867b9b9d6b967a1), W64LIT(0x8b5f131335135f98),
  W64LIT(0x519c2c2c742c9c7d), W64LIT(0x05b8d3d368d3b8d6),
  W64LIT(0x8c5ce7e734e75c6b), W64LIT(0x39cb6e6eb26ecb57),
  W64LIT(0xaaf3c4c451c4f36e), W64LIT(0x1b0f030305030f18),
  W64LIT(0xdc135656fa56138a), W64LIT(0x5e494444cc44491a),
  W64LIT(0xa09e7f7f817f9edf), W64LIT(0x8837a9a9e6a93721),
  W64LIT(0x67822a2a7e2a824d), W64LIT(0x0a6dbbbbd0bb6db1),
  W64LIT(0x87e2c1c15ec1e246), W64LIT(0xf1025353f55302a2),
  W64LIT(0x728bdcdc79dc8bae), W64LIT(0x53270b0b1d0b2758),
  W64LIT(0x01d39d9dba9dd39c), W64LIT(0x2bc16c6cb46cc147),
  W64LIT(0xa4f531315331f595), W64LIT(0xf3b974749c74b987),
  W64LIT(0x1509f6f607f609e3), W64LIT(0x4c434646ca46430a),
  W64LIT(0xa526acace9ac2609), W64LIT(0xb59789898689973c),
  W64LIT(0xb44414143c1444a0), W64LIT(0xba42e1e13ee1425b),
  W64LIT(0xa64e16163a164eb0), W64LIT(0xf7d23a3a4e3ad2cd),
  W64LIT(0x06d06969bb69d06f), W64LIT(0x412d09091b092d48),
  W64LIT(0xd7ad70709070ada7), W64LIT(0x6f54b6b6c7b654d9),
  W64LIT(0x1eb7d0d06dd0b7ce), W64LIT(0xd67eeded2aed7e3b),
  W64LIT(0xe2dbcccc49ccdb2e), W64LIT(0x68574242c642572a),
  W64LIT(0x2cc29898b598c2b4), W64LIT(0xed0ea4a4f1a40e49),
  W64LIT(0x758828287828885d), W64LIT(0x86315c5ce45c31da),
  W64LIT(0x6b3ff8f815f83f93), W64LIT(0xc2a486869786a444),
};

static const word64 Whirlpool_C3[256] =
{
  W64LIT(0xc0d8781818281878), W64LIT(0x0526af23236523af),
  W64LIT(0x7eb8f9c6c657c6f9), W64LIT(0x13fb6fe8e825e86f),
  W64LIT(0x4ccba187879487a1), W64LIT(0xa91162b8b8d5b862),
  W64LIT(0x0809050101030105), W64LIT(0x420d6e4f4fd14f6e),
  W64LIT(0xad9bee36365a36ee), W64LIT(0x59ff04a6a6f7a604),
  W64LIT(0xde0cbdd2d26bd2bd), W64LIT(0xfb0e06f5f502f506),
  W64LIT(0xef968079798b7980), W64LIT(0x5f30ce6f6fb16fce),
  W64LIT(0xfc6def9191ae91ef), W64LIT(0xaaf8075252f65207),
  W64LIT(0x2747fd6060a060fd), W64LIT(0x893576bcbcd9bc76),
  W64LIT(0xac37cd9b9bb09bcd), W64LIT(0x048a8c8e8e8f8e8c),
  W64LIT(0x71d215a3a3f8a315), W64LIT(0x606c3c0c0c140c3c),
  W64LIT(0xff848a7b7b8d7b8a), W64LIT(0xb580e135355f35e1),
  W64LIT(0xe8f5691d1d271d69), W64LIT(0x53b347e0e03de047),
  W64LIT(0xf621acd7d764d7ac), W64LIT(0x5e9cedc2c25bc2ed),
  W64LIT(0x6d43962e2e722e96), W64LIT(0x62297a4b4bdd4b7a),
  W64LIT(0xa35d21fefe1ffe21), W64LIT(0x82d5165757f95716),
  W64LIT(0xa8bd4115153f1541), W64LIT(0x9fe8b677779977b6),
  W64LIT(0xa592eb37375937eb), W64LIT(0x7b9e56e5e532e556),
  W64LIT(0x8c13d99f9fbc9fd9), W64LIT(0xd32317f0f00df017),
  W64LIT(0x6a207f4a4ade4a7f), W64LIT(0x9e4495dada73da95),
  W64LIT(0xfaa2255858e85825), W64LIT(0x06cfcac9c946c9ca),
  W64LIT(0x557c8d29297b298d), W64LIT(0x505a220a0a1e0a22),
  W64LIT(0xe1504fb1b1ceb14f), W64LIT(0x69c91aa0a0fda01a),
  W64LIT(0x7f14da6b6bbd6bda), W64LIT(0x5cd9ab85859285ab),
  W64LIT(0x813c73bdbddabd73), W64LIT(0xd28f345d5de75d34),
  W64LIT(0x8090501010301050), W64LIT(0xf30703f4f401f403),
  W64LIT(0x16ddc0cbcb40cbc0), W64LIT(0xedd3c63e3e423ec6),
  W64LIT(0x282d1105050f0511), W64LIT(0x1f78e66767a967e6),
  W64LIT(0x739753e4e431e453), W64LIT(0x2502bb27276927bb),
  W64LIT(0x3273584141c34158), W64LIT(0x2ca79d8b8b808b9d),
  W64LIT(0x51f601a7a7f4a701), W64LIT(0xcfb2947d7d877d94),
  W64LIT(0xdc49fb9595a295fb), W64LIT(0x8e569fd8d875d89f),
  W64LIT(0x8b7030fbfb10fb30), W64LIT(0x23cd71eeee2fee71),
  W64LIT(0xc7bb917c7c847c91), W64LIT(0x1771e36666aa66e3),
  W64LIT(0xa67b8edddd7add8e), W64LIT(0xb8af4b171739174b),
  W64LIT(0x0245464747c94746), W64LIT(0x841adc9e9ebf9edc),
  W64LIT(0x1ed4c5caca43cac5), W64LIT(0x7558992d2d772d99),
  W64LIT(0x912e79bfbfdcbf79), W64LIT(0x383f1b070709071b),
  W64LIT(0x01ac23adadeaad23), W64LIT(0xeab02f5a5aee5a2f),
  W64LIT(0x6cefb583839883b5), W64LIT(0x85b6ff33335533ff),
  W64LIT(0x3f5cf26363a563f2), W64LIT(0x10120a020206020a),
  W64LIT(0x399338aaaae3aa38), W64LIT(0xafdea871719371a8),
  W64LIT(0x0ec6cfc8c845c8cf), W64LIT(0xc8d17d19192b197d),
  W64LIT(0x723b704949db4970), W64LIT(0x865f9ad9d976d99a),
  W64LIT(0xc3311df2f20bf21d), W64LIT(0x4ba848e3e338e348),
  W64LIT(0xe2b92a5b5bed5b2a), W64LIT(0x34bc928888858892),
  W64LIT(0xa43ec89a9ab39ac8), W64LIT(0x2d0bbe26266a26be),
  W64LIT(0x8dbffa32325632fa), W64LIT(0xe9594ab0b0cdb04a),
  W64LIT(0x1bf26ae9e926e96a), W64LIT(0x7877330f0f110f33),
  W64LIT(0xe633a6d5d562d5a6), W64LIT(0x74f4ba80809d80ba),
  W64LIT(0x99277cbebedfbe7c), W64LIT(0x26ebdecdcd4acdde),
  W64LIT(0xbd89e434345c34e4), W64LIT(0x7a32754848d84875),
  W64LIT(0xab5424ffff1cff24), W64LIT(0xf78d8f7a7a8e7a8f),
  W64LIT(0xf464ea9090ad90ea), W64LIT(0xc29d3e5f5fe15f3e),
  W64LIT(0x1d3da020206020a0), W64LIT(0x670fd56868b868d5),
  W64LIT(0xd0ca721a1a2e1a72), W64LIT(0x19b72caeaeefae2c),
  W64LIT(0xc97d5eb4b4c1b45e), W64LIT(0x9ace195454fc5419),
  W64LIT(0xec7fe59393a893e5), W64LIT(0x0d2faa22226622aa),
  W64LIT(0x0763e96464ac64e9), W64LIT(0xdb2a12f1f10ef112),
  W64LIT(0xbfcca273739573a2), W64LIT(0x90825a121236125a),
  W64LIT(0x3a7a5d4040c0405d), W64LIT(0x4048280808180828),
  W64LIT(0x5695e8c3c358c3e8), W64LIT(0x33df7becec29ec7b),
  W64LIT(0x964d90dbdb70db90), W64LIT(0x61c01fa1a1fea11f),
  W64LIT(0x1c91838d8d8a8d83), W64LIT(0xf5c8c93d3d473dc9),
  W64LIT(0xcc5bf19797a497f1), W64LIT(0x0000000000000000),
  W64LIT(0x36f9d4cfcf4ccfd4), W64LIT(0x456e872b2b7d2b87),
  W64LIT(0x97e1b376769a76b3), W64LIT(0x64e6b082829b82b0),
  W64LIT(0xfe28a9d6d667d6a9), W64LIT(0xd8c3771b1b2d1b77),
  W64LIT(0xc1745bb5b5c2b55b), W64LIT(0x11be29afafecaf29),
  W64LIT(0x771ddf6a6abe6adf), W64LIT(0xbaea0d5050f0500d),
  W64LIT(0x12574c4545cf454c), W64LIT(0xcb3818f3f308f318),
  W64LIT(0x9dadf030305030f0), W64LIT(0x2bc474efef2cef74),
  W64LIT(0xe5dac33f3f413fc3), W64LIT(0x92c71c5555ff551c),
  W64LIT(0x79db10a2a2fba210), W64LIT(0x03e965eaea23ea65),
  W64LIT(0x0f6aec6565af65ec), W64LIT(0xb90368babad3ba68),
  W64LIT(0x654a932f2f712f93), W64LIT(0x4e8ee7c0c05dc0e7),
  W64LIT(0xbe6081dede7fde81), W64LIT(0xe0fc6c1c1c241c6c),
  W64LIT(0xbb462efdfd1afd2e), W64LIT(0x521f644d4dd74d64),
  W64LIT(0xe476e09292ab92e0), W64LIT(0x8ffabc75759f75bc),
  W64LIT(0x30361e06060a061e), W64LIT(0x24ae988a8a838a98),
  W64LIT(0xf94b40b2b2cbb240), W64LIT(0x638559e6e637e659),
  W64LIT(0x707e360e0e120e36), W64LIT(0xf8e7631f1f211f63),
  W64LIT(0x3755f76262a662f7), W64LIT(0xee3aa3d4d461d4a3),
  W64LIT(0x298132a8a8e5a832), W64LIT(0xc452f49696a796f4),
  W64LIT(0x9b623af9f916f93a), W64LIT(0x66a3f6c5c552c5f6),
  W64LIT(0x3510b125256f25b1), W64LIT(0xf2ab205959eb5920),
  W64LIT(0x54d0ae84849184ae), W64LIT(0xb7c5a772729672a7),
  W64LIT(0xd5ecdd39394b39dd), W64LIT(0x5a16614c4cd44c61),
  W64LIT(0xca943b5e5ee25e3b), W64LIT(0xe79f857878887885),
  W64LIT(0xdde5d838384838d8), W64LIT(0x1498868c8c898c86),
  W64LIT(0xc617b2d1d16ed1b2), W64LIT(0x41e40ba5a5f2a50b),
  W64LIT(0x43a14de2e23be24d), W64LIT(0x2f4ef86161a361f8),
  W64LIT(0xf14245b3b3c8b345), W64LIT(0x1534a521216321a5),
  W64LIT(0x9408d69c9cb99cd6), W64LIT(0xf0ee661e1e221e66),
  W64LIT(0x2261524343c54352), W64LIT(0x76b1fcc7c754c7fc),
  W64LIT(0xb34f2bfcfc19fc2b), W64LIT(0x20241404040c0414),
  W64LIT(0xb2e3085151f35108), W64LIT(0xbc25c79999b699c7),
  W64LIT(0x4f22c46d6db76dc4), W64LIT(0x6865390d0d170d39),
  W64LIT(0x837935fafa13fa35), W64LIT(0xb66984dfdf7cdf84),
  W64LIT(0xd7a99b7e7e827e9b), W64LIT(0x3d19b424246c24b4),
  W64LIT(0xc5fed73b3b4d3bd7), W64LIT(0x319a3dababe0ab3d),
  W64LIT(0x3ef0d1cece4fced1), W64LIT(0x8899551111331155),
  W64LIT(0x0c83898f8f8c8f89), W64LIT(0x4a046b4e4ed24e6b),
  W64LIT(0xd16651b7b7c4b751), W64LIT(0x0be060ebeb20eb60),
  W64LIT(0xfdc1cc3c3c443ccc), W64LIT(0x7cfdbf81819e81bf),
  W64LIT(0xd440fe9494a194fe), W64LIT(0xeb1c0cf7f704f70c),
  W64LIT(0xa11867b9b9d6b967), W64LIT(0x988b5f131335135f),
  W64LIT(0x7d519c2c2c742c9c), W64LIT(0xd605b8d3d368d3b8),
  W64LIT(0x6b8c5ce7e734e75c), W64LIT(0x5739cb6e6eb26ecb),
  W64LIT(0x6eaaf3c4c451c4f3), W64LIT(0x181b0f030305030f),
  W64LIT(0x8adc135656fa5613), W64LIT(0x1a5e494444cc4449),
  W64LIT(0xdfa09e7f7f817f9e), W64LIT(0x218837a9a9e6a937),
  W64LIT(0x4d67822a2a7e2a82), W64LIT(0xb10a6dbbbbd0bb6d),
  W64LIT(0x4687e2c1c15ec1e2), W64LIT(0xa2f1025353f55302),
  W64LIT(0xae728bdcdc79dc8b), W64LIT(0x5853270b0b1d0b27),
  W64LIT(0x9c01d39d9dba9dd3), W64LIT(0x472bc16c6cb46cc1),
  W64LIT(0x95a4f531315331f5), W64LIT(0x87f3b974749c74b9),
  W64LIT(0xe31509f6f607f609), W64LIT(0x0a4c434646ca4643),
  W64LIT(0x09a526acace9ac26), W64LIT(0x3cb5978989868997),
  W64LIT(0xa0b44414143c1444), W64LIT(0x5bba42e1e13ee142),
  W64LIT(0xb0a64e16163a164e), W64LIT(0xcdf7d23a3a4e3ad2),
  W64LIT(0x6f06d06969bb69d0), W64LIT(0x48412d09091b092d),
  W64LIT(0xa7d7ad70709070ad), W64LIT(0xd96f54b6b6c7b654),
  W64LIT(0xce1eb7d0d06dd0b7), W64LIT(0x3bd67eeded2aed7e),
  W64LIT(0x2ee2dbcccc49ccdb), W64LIT(0x2a68574242c64257),
  W64LIT(0xb42cc29898b598c2), W64LIT(0x49ed0ea4a4f1a40e),
  W64LIT(0x5d75882828782888), W64LIT(0xda86315c5ce45c31),
  W64LIT(0x936b3ff8f815f83f), W64LIT(0x44c2a486869786a4),
};

static const word64 Whirlpool_rc[] =
{
  W64LIT(0x1823c6e887b8014f),
  W64LIT(0x36a6d2f5796f9152),
  W64LIT(0x60bc9b8ea30c7b35),
  W64LIT(0x1de0d7c22e4bfe57),
  W64LIT(0x157737e59ff04ada),
  W64LIT(0x58c9290ab1a06b85),
  W64LIT(0xbd5d10f4cb3e0567),
  W64LIT(0xe427418ba77d95d8),
  W64LIT(0xfbee7c66dd17479e),
  W64LIT(0xca2dbf07ad5a8333)
};
//-----------------
static const uint32 WAKE_tt[8] =
{
  0x726a8f3b,
  0xe69a3b5c,
  0xd3c71fe5,
  0xab3c73d2,
  0x4d3a8eb3,
  0x0396d6e8,
  0x3d4c2f7a,
  0x9ee27cf3,
};
//-----------------
static const word64 Tiger_table[4*256] =
{
  W64LIT(0x02AAB17CF7E90C5E)   /*    0 */,    W64LIT(0xAC424B03E243A8EC)   /*    1 */,
  W64LIT(0x72CD5BE30DD5FCD3)   /*    2 */,    W64LIT(0x6D019B93F6F97F3A)   /*    3 */,
  W64LIT(0xCD9978FFD21F9193)   /*    4 */,    W64LIT(0x7573A1C9708029E2)   /*    5 */,
  W64LIT(0xB164326B922A83C3)   /*    6 */,    W64LIT(0x46883EEE04915870)   /*    7 */,
  W64LIT(0xEAACE3057103ECE6)   /*    8 */,    W64LIT(0xC54169B808A3535C)   /*    9 */,
  W64LIT(0x4CE754918DDEC47C)   /*   10 */,    W64LIT(0x0AA2F4DFDC0DF40C)   /*   11 */,
  W64LIT(0x10B76F18A74DBEFA)   /*   12 */,    W64LIT(0xC6CCB6235AD1AB6A)   /*   13 */,
  W64LIT(0x13726121572FE2FF)   /*   14 */,    W64LIT(0x1A488C6F199D921E)   /*   15 */,
  W64LIT(0x4BC9F9F4DA0007CA)   /*   16 */,    W64LIT(0x26F5E6F6E85241C7)   /*   17 */,
  W64LIT(0x859079DBEA5947B6)   /*   18 */,    W64LIT(0x4F1885C5C99E8C92)   /*   19 */,
  W64LIT(0xD78E761EA96F864B)   /*   20 */,    W64LIT(0x8E36428C52B5C17D)   /*   21 */,
  W64LIT(0x69CF6827373063C1)   /*   22 */,    W64LIT(0xB607C93D9BB4C56E)   /*   23 */,
  W64LIT(0x7D820E760E76B5EA)   /*   24 */,    W64LIT(0x645C9CC6F07FDC42)   /*   25 */,
  W64LIT(0xBF38A078243342E0)   /*   26 */,    W64LIT(0x5F6B343C9D2E7D04)   /*   27 */,
  W64LIT(0xF2C28AEB600B0EC6)   /*   28 */,    W64LIT(0x6C0ED85F7254BCAC)   /*   29 */,
  W64LIT(0x71592281A4DB4FE5)   /*   30 */,    W64LIT(0x1967FA69CE0FED9F)   /*   31 */,
  W64LIT(0xFD5293F8B96545DB)   /*   32 */,    W64LIT(0xC879E9D7F2A7600B)   /*   33 */,
  W64LIT(0x860248920193194E)   /*   34 */,    W64LIT(0xA4F9533B2D9CC0B3)   /*   35 */,
  W64LIT(0x9053836C15957613)   /*   36 */,    W64LIT(0xDB6DCF8AFC357BF1)   /*   37 */,
  W64LIT(0x18BEEA7A7A370F57)   /*   38 */,    W64LIT(0x037117CA50B99066)   /*   39 */,
  W64LIT(0x6AB30A9774424A35)   /*   40 */,    W64LIT(0xF4E92F02E325249B)   /*   41 */,
  W64LIT(0x7739DB07061CCAE1)   /*   42 */,    W64LIT(0xD8F3B49CECA42A05)   /*   43 */,
  W64LIT(0xBD56BE3F51382F73)   /*   44 */,    W64LIT(0x45FAED5843B0BB28)   /*   45 */,
  W64LIT(0x1C813D5C11BF1F83)   /*   46 */,    W64LIT(0x8AF0E4B6D75FA169)   /*   47 */,
  W64LIT(0x33EE18A487AD9999)   /*   48 */,    W64LIT(0x3C26E8EAB1C94410)   /*   49 */,
  W64LIT(0xB510102BC0A822F9)   /*   50 */,    W64LIT(0x141EEF310CE6123B)   /*   51 */,
  W64LIT(0xFC65B90059DDB154)   /*   52 */,    W64LIT(0xE0158640C5E0E607)   /*   53 */,
  W64LIT(0x884E079826C3A3CF)   /*   54 */,    W64LIT(0x930D0D9523C535FD)   /*   55 */,
  W64LIT(0x35638D754E9A2B00)   /*   56 */,    W64LIT(0x4085FCCF40469DD5)   /*   57 */,
  W64LIT(0xC4B17AD28BE23A4C)   /*   58 */,    W64LIT(0xCAB2F0FC6A3E6A2E)   /*   59 */,
  W64LIT(0x2860971A6B943FCD)   /*   60 */,    W64LIT(0x3DDE6EE212E30446)   /*   61 */,
  W64LIT(0x6222F32AE01765AE)   /*   62 */,    W64LIT(0x5D550BB5478308FE)   /*   63 */,
  W64LIT(0xA9EFA98DA0EDA22A)   /*   64 */,    W64LIT(0xC351A71686C40DA7)   /*   65 */,
  W64LIT(0x1105586D9C867C84)   /*   66 */,    W64LIT(0xDCFFEE85FDA22853)   /*   67 */,
  W64LIT(0xCCFBD0262C5EEF76)   /*   68 */,    W64LIT(0xBAF294CB8990D201)   /*   69 */,
  W64LIT(0xE69464F52AFAD975)   /*   70 */,    W64LIT(0x94B013AFDF133E14)   /*   71 */,
  W64LIT(0x06A7D1A32823C958)   /*   72 */,    W64LIT(0x6F95FE5130F61119)   /*   73 */,
  W64LIT(0xD92AB34E462C06C0)   /*   74 */,    W64LIT(0xED7BDE33887C71D2)   /*   75 */,
  W64LIT(0x79746D6E6518393E)   /*   76 */,    W64LIT(0x5BA419385D713329)   /*   77 */,
  W64LIT(0x7C1BA6B948A97564)   /*   78 */,    W64LIT(0x31987C197BFDAC67)   /*   79 */,
  W64LIT(0xDE6C23C44B053D02)   /*   80 */,    W64LIT(0x581C49FED002D64D)   /*   81 */,
  W64LIT(0xDD474D6338261571)   /*   82 */,    W64LIT(0xAA4546C3E473D062)   /*   83 */,
  W64LIT(0x928FCE349455F860)   /*   84 */,    W64LIT(0x48161BBACAAB94D9)   /*   85 */,
  W64LIT(0x63912430770E6F68)   /*   86 */,    W64LIT(0x6EC8A5E602C6641C)   /*   87 */,
  W64LIT(0x87282515337DDD2B)   /*   88 */,    W64LIT(0x2CDA6B42034B701B)   /*   89 */,
  W64LIT(0xB03D37C181CB096D)   /*   90 */,    W64LIT(0xE108438266C71C6F)   /*   91 */,
  W64LIT(0x2B3180C7EB51B255)   /*   92 */,    W64LIT(0xDF92B82F96C08BBC)   /*   93 */,
  W64LIT(0x5C68C8C0A632F3BA)   /*   94 */,    W64LIT(0x5504CC861C3D0556)   /*   95 */,
  W64LIT(0xABBFA4E55FB26B8F)   /*   96 */,    W64LIT(0x41848B0AB3BACEB4)   /*   97 */,
  W64LIT(0xB334A273AA445D32)   /*   98 */,    W64LIT(0xBCA696F0A85AD881)   /*   99 */,
  W64LIT(0x24F6EC65B528D56C)   /*  100 */,    W64LIT(0x0CE1512E90F4524A)   /*  101 */,
  W64LIT(0x4E9DD79D5506D35A)   /*  102 */,    W64LIT(0x258905FAC6CE9779)   /*  103 */,
  W64LIT(0x2019295B3E109B33)   /*  104 */,    W64LIT(0xF8A9478B73A054CC)   /*  105 */,
  W64LIT(0x2924F2F934417EB0)   /*  106 */,    W64LIT(0x3993357D536D1BC4)   /*  107 */,
  W64LIT(0x38A81AC21DB6FF8B)   /*  108 */,    W64LIT(0x47C4FBF17D6016BF)   /*  109 */,
  W64LIT(0x1E0FAADD7667E3F5)   /*  110 */,    W64LIT(0x7ABCFF62938BEB96)   /*  111 */,
  W64LIT(0xA78DAD948FC179C9)   /*  112 */,    W64LIT(0x8F1F98B72911E50D)   /*  113 */,
  W64LIT(0x61E48EAE27121A91)   /*  114 */,    W64LIT(0x4D62F7AD31859808)   /*  115 */,
  W64LIT(0xECEBA345EF5CEAEB)   /*  116 */,    W64LIT(0xF5CEB25EBC9684CE)   /*  117 */,
  W64LIT(0xF633E20CB7F76221)   /*  118 */,    W64LIT(0xA32CDF06AB8293E4)   /*  119 */,
  W64LIT(0x985A202CA5EE2CA4)   /*  120 */,    W64LIT(0xCF0B8447CC8A8FB1)   /*  121 */,
  W64LIT(0x9F765244979859A3)   /*  122 */,    W64LIT(0xA8D516B1A1240017)   /*  123 */,
  W64LIT(0x0BD7BA3EBB5DC726)   /*  124 */,    W64LIT(0xE54BCA55B86ADB39)   /*  125 */,
  W64LIT(0x1D7A3AFD6C478063)   /*  126 */,    W64LIT(0x519EC608E7669EDD)   /*  127 */,
  W64LIT(0x0E5715A2D149AA23)   /*  128 */,    W64LIT(0x177D4571848FF194)   /*  129 */,
  W64LIT(0xEEB55F3241014C22)   /*  130 */,    W64LIT(0x0F5E5CA13A6E2EC2)   /*  131 */,
  W64LIT(0x8029927B75F5C361)   /*  132 */,    W64LIT(0xAD139FABC3D6E436)   /*  133 */,
  W64LIT(0x0D5DF1A94CCF402F)   /*  134 */,    W64LIT(0x3E8BD948BEA5DFC8)   /*  135 */,
  W64LIT(0xA5A0D357BD3FF77E)   /*  136 */,    W64LIT(0xA2D12E251F74F645)   /*  137 */,
  W64LIT(0x66FD9E525E81A082)   /*  138 */,    W64LIT(0x2E0C90CE7F687A49)   /*  139 */,
  W64LIT(0xC2E8BCBEBA973BC5)   /*  140 */,    W64LIT(0x000001BCE509745F)   /*  141 */,
  W64LIT(0x423777BBE6DAB3D6)   /*  142 */,    W64LIT(0xD1661C7EAEF06EB5)   /*  143 */,
  W64LIT(0xA1781F354DAACFD8)   /*  144 */,    W64LIT(0x2D11284A2B16AFFC)   /*  145 */,
  W64LIT(0xF1FC4F67FA891D1F)   /*  146 */,    W64LIT(0x73ECC25DCB920ADA)   /*  147 */,
  W64LIT(0xAE610C22C2A12651)   /*  148 */,    W64LIT(0x96E0A810D356B78A)   /*  149 */,
  W64LIT(0x5A9A381F2FE7870F)   /*  150 */,    W64LIT(0xD5AD62EDE94E5530)   /*  151 */,
  W64LIT(0xD225E5E8368D1427)   /*  152 */,    W64LIT(0x65977B70C7AF4631)   /*  153 */,
  W64LIT(0x99F889B2DE39D74F)   /*  154 */,    W64LIT(0x233F30BF54E1D143)   /*  155 */,
  W64LIT(0x9A9675D3D9A63C97)   /*  156 */,    W64LIT(0x5470554FF334F9A8)   /*  157 */,
  W64LIT(0x166ACB744A4F5688)   /*  158 */,    W64LIT(0x70C74CAAB2E4AEAD)   /*  159 */,
  W64LIT(0xF0D091646F294D12)   /*  160 */,    W64LIT(0x57B82A89684031D1)   /*  161 */,
  W64LIT(0xEFD95A5A61BE0B6B)   /*  162 */,    W64LIT(0x2FBD12E969F2F29A)   /*  163 */,
  W64LIT(0x9BD37013FEFF9FE8)   /*  164 */,    W64LIT(0x3F9B0404D6085A06)   /*  165 */,
  W64LIT(0x4940C1F3166CFE15)   /*  166 */,    W64LIT(0x09542C4DCDF3DEFB)   /*  167 */,
  W64LIT(0xB4C5218385CD5CE3)   /*  168 */,    W64LIT(0xC935B7DC4462A641)   /*  169 */,
  W64LIT(0x3417F8A68ED3B63F)   /*  170 */,    W64LIT(0xB80959295B215B40)   /*  171 */,
  W64LIT(0xF99CDAEF3B8C8572)   /*  172 */,    W64LIT(0x018C0614F8FCB95D)   /*  173 */,
  W64LIT(0x1B14ACCD1A3ACDF3)   /*  174 */,    W64LIT(0x84D471F200BB732D)   /*  175 */,
  W64LIT(0xC1A3110E95E8DA16)   /*  176 */,    W64LIT(0x430A7220BF1A82B8)   /*  177 */,
  W64LIT(0xB77E090D39DF210E)   /*  178 */,    W64LIT(0x5EF4BD9F3CD05E9D)   /*  179 */,
  W64LIT(0x9D4FF6DA7E57A444)   /*  180 */,    W64LIT(0xDA1D60E183D4A5F8)   /*  181 */,
  W64LIT(0xB287C38417998E47)   /*  182 */,    W64LIT(0xFE3EDC121BB31886)   /*  183 */,
  W64LIT(0xC7FE3CCC980CCBEF)   /*  184 */,    W64LIT(0xE46FB590189BFD03)   /*  185 */,
  W64LIT(0x3732FD469A4C57DC)   /*  186 */,    W64LIT(0x7EF700A07CF1AD65)   /*  187 */,
  W64LIT(0x59C64468A31D8859)   /*  188 */,    W64LIT(0x762FB0B4D45B61F6)   /*  189 */,
  W64LIT(0x155BAED099047718)   /*  190 */,    W64LIT(0x68755E4C3D50BAA6)   /*  191 */,
  W64LIT(0xE9214E7F22D8B4DF)   /*  192 */,    W64LIT(0x2ADDBF532EAC95F4)   /*  193 */,
  W64LIT(0x32AE3909B4BD0109)   /*  194 */,    W64LIT(0x834DF537B08E3450)   /*  195 */,
  W64LIT(0xFA209DA84220728D)   /*  196 */,    W64LIT(0x9E691D9B9EFE23F7)   /*  197 */,
  W64LIT(0x0446D288C4AE8D7F)   /*  198 */,    W64LIT(0x7B4CC524E169785B)   /*  199 */,
  W64LIT(0x21D87F0135CA1385)   /*  200 */,    W64LIT(0xCEBB400F137B8AA5)   /*  201 */,
  W64LIT(0x272E2B66580796BE)   /*  202 */,    W64LIT(0x3612264125C2B0DE)   /*  203 */,
  W64LIT(0x057702BDAD1EFBB2)   /*  204 */,    W64LIT(0xD4BABB8EACF84BE9)   /*  205 */,
  W64LIT(0x91583139641BC67B)   /*  206 */,    W64LIT(0x8BDC2DE08036E024)   /*  207 */,
  W64LIT(0x603C8156F49F68ED)   /*  208 */,    W64LIT(0xF7D236F7DBEF5111)   /*  209 */,
  W64LIT(0x9727C4598AD21E80)   /*  210 */,    W64LIT(0xA08A0896670A5FD7)   /*  211 */,
  W64LIT(0xCB4A8F4309EBA9CB)   /*  212 */,    W64LIT(0x81AF564B0F7036A1)   /*  213 */,
  W64LIT(0xC0B99AA778199ABD)   /*  214 */,    W64LIT(0x959F1EC83FC8E952)   /*  215 */,
  W64LIT(0x8C505077794A81B9)   /*  216 */,    W64LIT(0x3ACAAF8F056338F0)   /*  217 */,
  W64LIT(0x07B43F50627A6778)   /*  218 */,    W64LIT(0x4A44AB49F5ECCC77)   /*  219 */,
  W64LIT(0x3BC3D6E4B679EE98)   /*  220 */,    W64LIT(0x9CC0D4D1CF14108C)   /*  221 */,
  W64LIT(0x4406C00B206BC8A0)   /*  222 */,    W64LIT(0x82A18854C8D72D89)   /*  223 */,
  W64LIT(0x67E366B35C3C432C)   /*  224 */,    W64LIT(0xB923DD61102B37F2)   /*  225 */,
  W64LIT(0x56AB2779D884271D)   /*  226 */,    W64LIT(0xBE83E1B0FF1525AF)   /*  227 */,
  W64LIT(0xFB7C65D4217E49A9)   /*  228 */,    W64LIT(0x6BDBE0E76D48E7D4)   /*  229 */,
  W64LIT(0x08DF828745D9179E)   /*  230 */,    W64LIT(0x22EA6A9ADD53BD34)   /*  231 */,
  W64LIT(0xE36E141C5622200A)   /*  232 */,    W64LIT(0x7F805D1B8CB750EE)   /*  233 */,
  W64LIT(0xAFE5C7A59F58E837)   /*  234 */,    W64LIT(0xE27F996A4FB1C23C)   /*  235 */,
  W64LIT(0xD3867DFB0775F0D0)   /*  236 */,    W64LIT(0xD0E673DE6E88891A)   /*  237 */,
  W64LIT(0x123AEB9EAFB86C25)   /*  238 */,    W64LIT(0x30F1D5D5C145B895)   /*  239 */,
  W64LIT(0xBB434A2DEE7269E7)   /*  240 */,    W64LIT(0x78CB67ECF931FA38)   /*  241 */,
  W64LIT(0xF33B0372323BBF9C)   /*  242 */,    W64LIT(0x52D66336FB279C74)   /*  243 */,
  W64LIT(0x505F33AC0AFB4EAA)   /*  244 */,    W64LIT(0xE8A5CD99A2CCE187)   /*  245 */,
  W64LIT(0x534974801E2D30BB)   /*  246 */,    W64LIT(0x8D2D5711D5876D90)   /*  247 */,
  W64LIT(0x1F1A412891BC038E)   /*  248 */,    W64LIT(0xD6E2E71D82E56648)   /*  249 */,
  W64LIT(0x74036C3A497732B7)   /*  250 */,    W64LIT(0x89B67ED96361F5AB)   /*  251 */,
  W64LIT(0xFFED95D8F1EA02A2)   /*  252 */,    W64LIT(0xE72B3BD61464D43D)   /*  253 */,
  W64LIT(0xA6300F170BDC4820)   /*  254 */,    W64LIT(0xEBC18760ED78A77A)   /*  255 */,
  W64LIT(0xE6A6BE5A05A12138)   /*  256 */,    W64LIT(0xB5A122A5B4F87C98)   /*  257 */,
  W64LIT(0x563C6089140B6990)   /*  258 */,    W64LIT(0x4C46CB2E391F5DD5)   /*  259 */,
  W64LIT(0xD932ADDBC9B79434)   /*  260 */,    W64LIT(0x08EA70E42015AFF5)   /*  261 */,
  W64LIT(0xD765A6673E478CF1)   /*  262 */,    W64LIT(0xC4FB757EAB278D99)   /*  263 */,
  W64LIT(0xDF11C6862D6E0692)   /*  264 */,    W64LIT(0xDDEB84F10D7F3B16)   /*  265 */,
  W64LIT(0x6F2EF604A665EA04)   /*  266 */,    W64LIT(0x4A8E0F0FF0E0DFB3)   /*  267 */,
  W64LIT(0xA5EDEEF83DBCBA51)   /*  268 */,    W64LIT(0xFC4F0A2A0EA4371E)   /*  269 */,
  W64LIT(0xE83E1DA85CB38429)   /*  270 */,    W64LIT(0xDC8FF882BA1B1CE2)   /*  271 */,
  W64LIT(0xCD45505E8353E80D)   /*  272 */,    W64LIT(0x18D19A00D4DB0717)   /*  273 */,
  W64LIT(0x34A0CFEDA5F38101)   /*  274 */,    W64LIT(0x0BE77E518887CAF2)   /*  275 */,
  W64LIT(0x1E341438B3C45136)   /*  276 */,    W64LIT(0xE05797F49089CCF9)   /*  277 */,
  W64LIT(0xFFD23F9DF2591D14)   /*  278 */,    W64LIT(0x543DDA228595C5CD)   /*  279 */,
  W64LIT(0x661F81FD99052A33)   /*  280 */,    W64LIT(0x8736E641DB0F7B76)   /*  281 */,
  W64LIT(0x15227725418E5307)   /*  282 */,    W64LIT(0xE25F7F46162EB2FA)   /*  283 */,
  W64LIT(0x48A8B2126C13D9FE)   /*  284 */,    W64LIT(0xAFDC541792E76EEA)   /*  285 */,
  W64LIT(0x03D912BFC6D1898F)   /*  286 */,    W64LIT(0x31B1AAFA1B83F51B)   /*  287 */,
  W64LIT(0xF1AC2796E42AB7D9)   /*  288 */,    W64LIT(0x40A3A7D7FCD2EBAC)   /*  289 */,
  W64LIT(0x1056136D0AFBBCC5)   /*  290 */,    W64LIT(0x7889E1DD9A6D0C85)   /*  291 */,
  W64LIT(0xD33525782A7974AA)   /*  292 */,    W64LIT(0xA7E25D09078AC09B)   /*  293 */,
  W64LIT(0xBD4138B3EAC6EDD0)   /*  294 */,    W64LIT(0x920ABFBE71EB9E70)   /*  295 */,
  W64LIT(0xA2A5D0F54FC2625C)   /*  296 */,    W64LIT(0xC054E36B0B1290A3)   /*  297 */,
  W64LIT(0xF6DD59FF62FE932B)   /*  298 */,    W64LIT(0x3537354511A8AC7D)   /*  299 */,
  W64LIT(0xCA845E9172FADCD4)   /*  300 */,    W64LIT(0x84F82B60329D20DC)   /*  301 */,
  W64LIT(0x79C62CE1CD672F18)   /*  302 */,    W64LIT(0x8B09A2ADD124642C)   /*  303 */,
  W64LIT(0xD0C1E96A19D9E726)   /*  304 */,    W64LIT(0x5A786A9B4BA9500C)   /*  305 */,
  W64LIT(0x0E020336634C43F3)   /*  306 */,    W64LIT(0xC17B474AEB66D822)   /*  307 */,
  W64LIT(0x6A731AE3EC9BAAC2)   /*  308 */,    W64LIT(0x8226667AE0840258)   /*  309 */,
  W64LIT(0x67D4567691CAECA5)   /*  310 */,    W64LIT(0x1D94155C4875ADB5)   /*  311 */,
  W64LIT(0x6D00FD985B813FDF)   /*  312 */,    W64LIT(0x51286EFCB774CD06)   /*  313 */,
  W64LIT(0x5E8834471FA744AF)   /*  314 */,    W64LIT(0xF72CA0AEE761AE2E)   /*  315 */,
  W64LIT(0xBE40E4CDAEE8E09A)   /*  316 */,    W64LIT(0xE9970BBB5118F665)   /*  317 */,
  W64LIT(0x726E4BEB33DF1964)   /*  318 */,    W64LIT(0x703B000729199762)   /*  319 */,
  W64LIT(0x4631D816F5EF30A7)   /*  320 */,    W64LIT(0xB880B5B51504A6BE)   /*  321 */,
  W64LIT(0x641793C37ED84B6C)   /*  322 */,    W64LIT(0x7B21ED77F6E97D96)   /*  323 */,
  W64LIT(0x776306312EF96B73)   /*  324 */,    W64LIT(0xAE528948E86FF3F4)   /*  325 */,
  W64LIT(0x53DBD7F286A3F8F8)   /*  326 */,    W64LIT(0x16CADCE74CFC1063)   /*  327 */,
  W64LIT(0x005C19BDFA52C6DD)   /*  328 */,    W64LIT(0x68868F5D64D46AD3)   /*  329 */,
  W64LIT(0x3A9D512CCF1E186A)   /*  330 */,    W64LIT(0x367E62C2385660AE)   /*  331 */,
  W64LIT(0xE359E7EA77DCB1D7)   /*  332 */,    W64LIT(0x526C0773749ABE6E)   /*  333 */,
  W64LIT(0x735AE5F9D09F734B)   /*  334 */,    W64LIT(0x493FC7CC8A558BA8)   /*  335 */,
  W64LIT(0xB0B9C1533041AB45)   /*  336 */,    W64LIT(0x321958BA470A59BD)   /*  337 */,
  W64LIT(0x852DB00B5F46C393)   /*  338 */,    W64LIT(0x91209B2BD336B0E5)   /*  339 */,
  W64LIT(0x6E604F7D659EF19F)   /*  340 */,    W64LIT(0xB99A8AE2782CCB24)   /*  341 */,
  W64LIT(0xCCF52AB6C814C4C7)   /*  342 */,    W64LIT(0x4727D9AFBE11727B)   /*  343 */,
  W64LIT(0x7E950D0C0121B34D)   /*  344 */,    W64LIT(0x756F435670AD471F)   /*  345 */,
  W64LIT(0xF5ADD442615A6849)   /*  346 */,    W64LIT(0x4E87E09980B9957A)   /*  347 */,
  W64LIT(0x2ACFA1DF50AEE355)   /*  348 */,    W64LIT(0xD898263AFD2FD556)   /*  349 */,
  W64LIT(0xC8F4924DD80C8FD6)   /*  350 */,    W64LIT(0xCF99CA3D754A173A)   /*  351 */,
  W64LIT(0xFE477BACAF91BF3C)   /*  352 */,    W64LIT(0xED5371F6D690C12D)   /*  353 */,
  W64LIT(0x831A5C285E687094)   /*  354 */,    W64LIT(0xC5D3C90A3708A0A4)   /*  355 */,
  W64LIT(0x0F7F903717D06580)   /*  356 */,    W64LIT(0x19F9BB13B8FDF27F)   /*  357 */,
  W64LIT(0xB1BD6F1B4D502843)   /*  358 */,    W64LIT(0x1C761BA38FFF4012)   /*  359 */,
  W64LIT(0x0D1530C4E2E21F3B)   /*  360 */,    W64LIT(0x8943CE69A7372C8A)   /*  361 */,
  W64LIT(0xE5184E11FEB5CE66)   /*  362 */,    W64LIT(0x618BDB80BD736621)   /*  363 */,
  W64LIT(0x7D29BAD68B574D0B)   /*  364 */,    W64LIT(0x81BB613E25E6FE5B)   /*  365 */,
  W64LIT(0x071C9C10BC07913F)   /*  366 */,    W64LIT(0xC7BEEB7909AC2D97)   /*  367 */,
  W64LIT(0xC3E58D353BC5D757)   /*  368 */,    W64LIT(0xEB017892F38F61E8)   /*  369 */,
  W64LIT(0xD4EFFB9C9B1CC21A)   /*  370 */,    W64LIT(0x99727D26F494F7AB)   /*  371 */,
  W64LIT(0xA3E063A2956B3E03)   /*  372 */,    W64LIT(0x9D4A8B9A4AA09C30)   /*  373 */,
  W64LIT(0x3F6AB7D500090FB4)   /*  374 */,    W64LIT(0x9CC0F2A057268AC0)   /*  375 */,
  W64LIT(0x3DEE9D2DEDBF42D1)   /*  376 */,    W64LIT(0x330F49C87960A972)   /*  377 */,
  W64LIT(0xC6B2720287421B41)   /*  378 */,    W64LIT(0x0AC59EC07C00369C)   /*  379 */,
  W64LIT(0xEF4EAC49CB353425)   /*  380 */,    W64LIT(0xF450244EEF0129D8)   /*  381 */,
  W64LIT(0x8ACC46E5CAF4DEB6)   /*  382 */,    W64LIT(0x2FFEAB63989263F7)   /*  383 */,
  W64LIT(0x8F7CB9FE5D7A4578)   /*  384 */,    W64LIT(0x5BD8F7644E634635)   /*  385 */,
  W64LIT(0x427A7315BF2DC900)   /*  386 */,    W64LIT(0x17D0C4AA2125261C)   /*  387 */,
  W64LIT(0x3992486C93518E50)   /*  388 */,    W64LIT(0xB4CBFEE0A2D7D4C3)   /*  389 */,
  W64LIT(0x7C75D6202C5DDD8D)   /*  390 */,    W64LIT(0xDBC295D8E35B6C61)   /*  391 */,
  W64LIT(0x60B369D302032B19)   /*  392 */,    W64LIT(0xCE42685FDCE44132)   /*  393 */,
  W64LIT(0x06F3DDB9DDF65610)   /*  394 */,    W64LIT(0x8EA4D21DB5E148F0)   /*  395 */,
  W64LIT(0x20B0FCE62FCD496F)   /*  396 */,    W64LIT(0x2C1B912358B0EE31)   /*  397 */,
  W64LIT(0xB28317B818F5A308)   /*  398 */,    W64LIT(0xA89C1E189CA6D2CF)   /*  399 */,
  W64LIT(0x0C6B18576AAADBC8)   /*  400 */,    W64LIT(0xB65DEAA91299FAE3)   /*  401 */,
  W64LIT(0xFB2B794B7F1027E7)   /*  402 */,    W64LIT(0x04E4317F443B5BEB)   /*  403 */,
  W64LIT(0x4B852D325939D0A6)   /*  404 */,    W64LIT(0xD5AE6BEEFB207FFC)   /*  405 */,
  W64LIT(0x309682B281C7D374)   /*  406 */,    W64LIT(0xBAE309A194C3B475)   /*  407 */,
  W64LIT(0x8CC3F97B13B49F05)   /*  408 */,    W64LIT(0x98A9422FF8293967)   /*  409 */,
  W64LIT(0x244B16B01076FF7C)   /*  410 */,    W64LIT(0xF8BF571C663D67EE)   /*  411 */,
  W64LIT(0x1F0D6758EEE30DA1)   /*  412 */,    W64LIT(0xC9B611D97ADEB9B7)   /*  413 */,
  W64LIT(0xB7AFD5887B6C57A2)   /*  414 */,    W64LIT(0x6290AE846B984FE1)   /*  415 */,
  W64LIT(0x94DF4CDEACC1A5FD)   /*  416 */,    W64LIT(0x058A5BD1C5483AFF)   /*  417 */,
  W64LIT(0x63166CC142BA3C37)   /*  418 */,    W64LIT(0x8DB8526EB2F76F40)   /*  419 */,
  W64LIT(0xE10880036F0D6D4E)   /*  420 */,    W64LIT(0x9E0523C9971D311D)   /*  421 */,
  W64LIT(0x45EC2824CC7CD691)   /*  422 */,    W64LIT(0x575B8359E62382C9)   /*  423 */,
  W64LIT(0xFA9E400DC4889995)   /*  424 */,    W64LIT(0xD1823ECB45721568)   /*  425 */,
  W64LIT(0xDAFD983B8206082F)   /*  426 */,    W64LIT(0xAA7D29082386A8CB)   /*  427 */,
  W64LIT(0x269FCD4403B87588)   /*  428 */,    W64LIT(0x1B91F5F728BDD1E0)   /*  429 */,
  W64LIT(0xE4669F39040201F6)   /*  430 */,    W64LIT(0x7A1D7C218CF04ADE)   /*  431 */,
  W64LIT(0x65623C29D79CE5CE)   /*  432 */,    W64LIT(0x2368449096C00BB1)   /*  433 */,
  W64LIT(0xAB9BF1879DA503BA)   /*  434 */,    W64LIT(0xBC23ECB1A458058E)   /*  435 */,
  W64LIT(0x9A58DF01BB401ECC)   /*  436 */,    W64LIT(0xA070E868A85F143D)   /*  437 */,
  W64LIT(0x4FF188307DF2239E)   /*  438 */,    W64LIT(0x14D565B41A641183)   /*  439 */,
  W64LIT(0xEE13337452701602)   /*  440 */,    W64LIT(0x950E3DCF3F285E09)   /*  441 */,
  W64LIT(0x59930254B9C80953)   /*  442 */,    W64LIT(0x3BF299408930DA6D)   /*  443 */,
  W64LIT(0xA955943F53691387)   /*  444 */,    W64LIT(0xA15EDECAA9CB8784)   /*  445 */,
  W64LIT(0x29142127352BE9A0)   /*  446 */,    W64LIT(0x76F0371FFF4E7AFB)   /*  447 */,
  W64LIT(0x0239F450274F2228)   /*  448 */,    W64LIT(0xBB073AF01D5E868B)   /*  449 */,
  W64LIT(0xBFC80571C10E96C1)   /*  450 */,    W64LIT(0xD267088568222E23)   /*  451 */,
  W64LIT(0x9671A3D48E80B5B0)   /*  452 */,    W64LIT(0x55B5D38AE193BB81)   /*  453 */,
  W64LIT(0x693AE2D0A18B04B8)   /*  454 */,    W64LIT(0x5C48B4ECADD5335F)   /*  455 */,
  W64LIT(0xFD743B194916A1CA)   /*  456 */,    W64LIT(0x2577018134BE98C4)   /*  457 */,
  W64LIT(0xE77987E83C54A4AD)   /*  458 */,    W64LIT(0x28E11014DA33E1B9)   /*  459 */,
  W64LIT(0x270CC59E226AA213)   /*  460 */,    W64LIT(0x71495F756D1A5F60)   /*  461 */,
  W64LIT(0x9BE853FB60AFEF77)   /*  462 */,    W64LIT(0xADC786A7F7443DBF)   /*  463 */,
  W64LIT(0x0904456173B29A82)   /*  464 */,    W64LIT(0x58BC7A66C232BD5E)   /*  465 */,
  W64LIT(0xF306558C673AC8B2)   /*  466 */,    W64LIT(0x41F639C6B6C9772A)   /*  467 */,
  W64LIT(0x216DEFE99FDA35DA)   /*  468 */,    W64LIT(0x11640CC71C7BE615)   /*  469 */,
  W64LIT(0x93C43694565C5527)   /*  470 */,    W64LIT(0xEA038E6246777839)   /*  471 */,
  W64LIT(0xF9ABF3CE5A3E2469)   /*  472 */,    W64LIT(0x741E768D0FD312D2)   /*  473 */,
  W64LIT(0x0144B883CED652C6)   /*  474 */,    W64LIT(0xC20B5A5BA33F8552)   /*  475 */,
  W64LIT(0x1AE69633C3435A9D)   /*  476 */,    W64LIT(0x97A28CA4088CFDEC)   /*  477 */,
  W64LIT(0x8824A43C1E96F420)   /*  478 */,    W64LIT(0x37612FA66EEEA746)   /*  479 */,
  W64LIT(0x6B4CB165F9CF0E5A)   /*  480 */,    W64LIT(0x43AA1C06A0ABFB4A)   /*  481 */,
  W64LIT(0x7F4DC26FF162796B)   /*  482 */,    W64LIT(0x6CBACC8E54ED9B0F)   /*  483 */,
  W64LIT(0xA6B7FFEFD2BB253E)   /*  484 */,    W64LIT(0x2E25BC95B0A29D4F)   /*  485 */,
  W64LIT(0x86D6A58BDEF1388C)   /*  486 */,    W64LIT(0xDED74AC576B6F054)   /*  487 */,
  W64LIT(0x8030BDBC2B45805D)   /*  488 */,    W64LIT(0x3C81AF70E94D9289)   /*  489 */,
  W64LIT(0x3EFF6DDA9E3100DB)   /*  490 */,    W64LIT(0xB38DC39FDFCC8847)   /*  491 */,
  W64LIT(0x123885528D17B87E)   /*  492 */,    W64LIT(0xF2DA0ED240B1B642)   /*  493 */,
  W64LIT(0x44CEFADCD54BF9A9)   /*  494 */,    W64LIT(0x1312200E433C7EE6)   /*  495 */,
  W64LIT(0x9FFCC84F3A78C748)   /*  496 */,    W64LIT(0xF0CD1F72248576BB)   /*  497 */,
  W64LIT(0xEC6974053638CFE4)   /*  498 */,    W64LIT(0x2BA7B67C0CEC4E4C)   /*  499 */,
  W64LIT(0xAC2F4DF3E5CE32ED)   /*  500 */,    W64LIT(0xCB33D14326EA4C11)   /*  501 */,
  W64LIT(0xA4E9044CC77E58BC)   /*  502 */,    W64LIT(0x5F513293D934FCEF)   /*  503 */,
  W64LIT(0x5DC9645506E55444)   /*  504 */,    W64LIT(0x50DE418F317DE40A)   /*  505 */,
  W64LIT(0x388CB31A69DDE259)   /*  506 */,    W64LIT(0x2DB4A83455820A86)   /*  507 */,
  W64LIT(0x9010A91E84711AE9)   /*  508 */,    W64LIT(0x4DF7F0B7B1498371)   /*  509 */,
  W64LIT(0xD62A2EABC0977179)   /*  510 */,    W64LIT(0x22FAC097AA8D5C0E)   /*  511 */,
  W64LIT(0xF49FCC2FF1DAF39B)   /*  512 */,    W64LIT(0x487FD5C66FF29281)   /*  513 */,
  W64LIT(0xE8A30667FCDCA83F)   /*  514 */,    W64LIT(0x2C9B4BE3D2FCCE63)   /*  515 */,
  W64LIT(0xDA3FF74B93FBBBC2)   /*  516 */,    W64LIT(0x2FA165D2FE70BA66)   /*  517 */,
  W64LIT(0xA103E279970E93D4)   /*  518 */,    W64LIT(0xBECDEC77B0E45E71)   /*  519 */,
  W64LIT(0xCFB41E723985E497)   /*  520 */,    W64LIT(0xB70AAA025EF75017)   /*  521 */,
  W64LIT(0xD42309F03840B8E0)   /*  522 */,    W64LIT(0x8EFC1AD035898579)   /*  523 */,
  W64LIT(0x96C6920BE2B2ABC5)   /*  524 */,    W64LIT(0x66AF4163375A9172)   /*  525 */,
  W64LIT(0x2174ABDCCA7127FB)   /*  526 */,    W64LIT(0xB33CCEA64A72FF41)   /*  527 */,
  W64LIT(0xF04A4933083066A5)   /*  528 */,    W64LIT(0x8D970ACDD7289AF5)   /*  529 */,
  W64LIT(0x8F96E8E031C8C25E)   /*  530 */,    W64LIT(0xF3FEC02276875D47)   /*  531 */,
  W64LIT(0xEC7BF310056190DD)   /*  532 */,    W64LIT(0xF5ADB0AEBB0F1491)   /*  533 */,
  W64LIT(0x9B50F8850FD58892)   /*  534 */,    W64LIT(0x4975488358B74DE8)   /*  535 */,
  W64LIT(0xA3354FF691531C61)   /*  536 */,    W64LIT(0x0702BBE481D2C6EE)   /*  537 */,
  W64LIT(0x89FB24057DEDED98)   /*  538 */,    W64LIT(0xAC3075138596E902)   /*  539 */,
  W64LIT(0x1D2D3580172772ED)   /*  540 */,    W64LIT(0xEB738FC28E6BC30D)   /*  541 */,
  W64LIT(0x5854EF8F63044326)   /*  542 */,    W64LIT(0x9E5C52325ADD3BBE)   /*  543 */,
  W64LIT(0x90AA53CF325C4623)   /*  544 */,    W64LIT(0xC1D24D51349DD067)   /*  545 */,
  W64LIT(0x2051CFEEA69EA624)   /*  546 */,    W64LIT(0x13220F0A862E7E4F)   /*  547 */,
  W64LIT(0xCE39399404E04864)   /*  548 */,    W64LIT(0xD9C42CA47086FCB7)   /*  549 */,
  W64LIT(0x685AD2238A03E7CC)   /*  550 */,    W64LIT(0x066484B2AB2FF1DB)   /*  551 */,
  W64LIT(0xFE9D5D70EFBF79EC)   /*  552 */,    W64LIT(0x5B13B9DD9C481854)   /*  553 */,
  W64LIT(0x15F0D475ED1509AD)   /*  554 */,    W64LIT(0x0BEBCD060EC79851)   /*  555 */,
  W64LIT(0xD58C6791183AB7F8)   /*  556 */,    W64LIT(0xD1187C5052F3EEE4)   /*  557 */,
  W64LIT(0xC95D1192E54E82FF)   /*  558 */,    W64LIT(0x86EEA14CB9AC6CA2)   /*  559 */,
  W64LIT(0x3485BEB153677D5D)   /*  560 */,    W64LIT(0xDD191D781F8C492A)   /*  561 */,
  W64LIT(0xF60866BAA784EBF9)   /*  562 */,    W64LIT(0x518F643BA2D08C74)   /*  563 */,
  W64LIT(0x8852E956E1087C22)   /*  564 */,    W64LIT(0xA768CB8DC410AE8D)   /*  565 */,
  W64LIT(0x38047726BFEC8E1A)   /*  566 */,    W64LIT(0xA67738B4CD3B45AA)   /*  567 */,
  W64LIT(0xAD16691CEC0DDE19)   /*  568 */,    W64LIT(0xC6D4319380462E07)   /*  569 */,
  W64LIT(0xC5A5876D0BA61938)   /*  570 */,    W64LIT(0x16B9FA1FA58FD840)   /*  571 */,
  W64LIT(0x188AB1173CA74F18)   /*  572 */,    W64LIT(0xABDA2F98C99C021F)   /*  573 */,
  W64LIT(0x3E0580AB134AE816)   /*  574 */,    W64LIT(0x5F3B05B773645ABB)   /*  575 */,
  W64LIT(0x2501A2BE5575F2F6)   /*  576 */,    W64LIT(0x1B2F74004E7E8BA9)   /*  577 */,
  W64LIT(0x1CD7580371E8D953)   /*  578 */,    W64LIT(0x7F6ED89562764E30)   /*  579 */,
  W64LIT(0xB15926FF596F003D)   /*  580 */,    W64LIT(0x9F65293DA8C5D6B9)   /*  581 */,
  W64LIT(0x6ECEF04DD690F84C)   /*  582 */,    W64LIT(0x4782275FFF33AF88)   /*  583 */,
  W64LIT(0xE41433083F820801)   /*  584 */,    W64LIT(0xFD0DFE409A1AF9B5)   /*  585 */,
  W64LIT(0x4325A3342CDB396B)   /*  586 */,    W64LIT(0x8AE77E62B301B252)   /*  587 */,
  W64LIT(0xC36F9E9F6655615A)   /*  588 */,    W64LIT(0x85455A2D92D32C09)   /*  589 */,
  W64LIT(0xF2C7DEA949477485)   /*  590 */,    W64LIT(0x63CFB4C133A39EBA)   /*  591 */,
  W64LIT(0x83B040CC6EBC5462)   /*  592 */,    W64LIT(0x3B9454C8FDB326B0)   /*  593 */,
  W64LIT(0x56F56A9E87FFD78C)   /*  594 */,    W64LIT(0x2DC2940D99F42BC6)   /*  595 */,
  W64LIT(0x98F7DF096B096E2D)   /*  596 */,    W64LIT(0x19A6E01E3AD852BF)   /*  597 */,
  W64LIT(0x42A99CCBDBD4B40B)   /*  598 */,    W64LIT(0xA59998AF45E9C559)   /*  599 */,
  W64LIT(0x366295E807D93186)   /*  600 */,    W64LIT(0x6B48181BFAA1F773)   /*  601 */,
  W64LIT(0x1FEC57E2157A0A1D)   /*  602 */,    W64LIT(0x4667446AF6201AD5)   /*  603 */,
  W64LIT(0xE615EBCACFB0F075)   /*  604 */,    W64LIT(0xB8F31F4F68290778)   /*  605 */,
  W64LIT(0x22713ED6CE22D11E)   /*  606 */,    W64LIT(0x3057C1A72EC3C93B)   /*  607 */,
  W64LIT(0xCB46ACC37C3F1F2F)   /*  608 */,    W64LIT(0xDBB893FD02AAF50E)   /*  609 */,
  W64LIT(0x331FD92E600B9FCF)   /*  610 */,    W64LIT(0xA498F96148EA3AD6)   /*  611 */,
  W64LIT(0xA8D8426E8B6A83EA)   /*  612 */,    W64LIT(0xA089B274B7735CDC)   /*  613 */,
  W64LIT(0x87F6B3731E524A11)   /*  614 */,    W64LIT(0x118808E5CBC96749)   /*  615 */,
  W64LIT(0x9906E4C7B19BD394)   /*  616 */,    W64LIT(0xAFED7F7E9B24A20C)   /*  617 */,
  W64LIT(0x6509EADEEB3644A7)   /*  618 */,    W64LIT(0x6C1EF1D3E8EF0EDE)   /*  619 */,
  W64LIT(0xB9C97D43E9798FB4)   /*  620 */,    W64LIT(0xA2F2D784740C28A3)   /*  621 */,
  W64LIT(0x7B8496476197566F)   /*  622 */,    W64LIT(0x7A5BE3E6B65F069D)   /*  623 */,
  W64LIT(0xF96330ED78BE6F10)   /*  624 */,    W64LIT(0xEEE60DE77A076A15)   /*  625 */,
  W64LIT(0x2B4BEE4AA08B9BD0)   /*  626 */,    W64LIT(0x6A56A63EC7B8894E)   /*  627 */,
  W64LIT(0x02121359BA34FEF4)   /*  628 */,    W64LIT(0x4CBF99F8283703FC)   /*  629 */,
  W64LIT(0x398071350CAF30C8)   /*  630 */,    W64LIT(0xD0A77A89F017687A)   /*  631 */,
  W64LIT(0xF1C1A9EB9E423569)   /*  632 */,    W64LIT(0x8C7976282DEE8199)   /*  633 */,
  W64LIT(0x5D1737A5DD1F7ABD)   /*  634 */,    W64LIT(0x4F53433C09A9FA80)   /*  635 */,
  W64LIT(0xFA8B0C53DF7CA1D9)   /*  636 */,    W64LIT(0x3FD9DCBC886CCB77)   /*  637 */,
  W64LIT(0xC040917CA91B4720)   /*  638 */,    W64LIT(0x7DD00142F9D1DCDF)   /*  639 */,
  W64LIT(0x8476FC1D4F387B58)   /*  640 */,    W64LIT(0x23F8E7C5F3316503)   /*  641 */,
  W64LIT(0x032A2244E7E37339)   /*  642 */,    W64LIT(0x5C87A5D750F5A74B)   /*  643 */,
  W64LIT(0x082B4CC43698992E)   /*  644 */,    W64LIT(0xDF917BECB858F63C)   /*  645 */,
  W64LIT(0x3270B8FC5BF86DDA)   /*  646 */,    W64LIT(0x10AE72BB29B5DD76)   /*  647 */,
  W64LIT(0x576AC94E7700362B)   /*  648 */,    W64LIT(0x1AD112DAC61EFB8F)   /*  649 */,
  W64LIT(0x691BC30EC5FAA427)   /*  650 */,    W64LIT(0xFF246311CC327143)   /*  651 */,
  W64LIT(0x3142368E30E53206)   /*  652 */,    W64LIT(0x71380E31E02CA396)   /*  653 */,
  W64LIT(0x958D5C960AAD76F1)   /*  654 */,    W64LIT(0xF8D6F430C16DA536)   /*  655 */,
  W64LIT(0xC8FFD13F1BE7E1D2)   /*  656 */,    W64LIT(0x7578AE66004DDBE1)   /*  657 */,
  W64LIT(0x05833F01067BE646)   /*  658 */,    W64LIT(0xBB34B5AD3BFE586D)   /*  659 */,
  W64LIT(0x095F34C9A12B97F0)   /*  660 */,    W64LIT(0x247AB64525D60CA8)   /*  661 */,
  W64LIT(0xDCDBC6F3017477D1)   /*  662 */,    W64LIT(0x4A2E14D4DECAD24D)   /*  663 */,
  W64LIT(0xBDB5E6D9BE0A1EEB)   /*  664 */,    W64LIT(0x2A7E70F7794301AB)   /*  665 */,
  W64LIT(0xDEF42D8A270540FD)   /*  666 */,    W64LIT(0x01078EC0A34C22C1)   /*  667 */,
  W64LIT(0xE5DE511AF4C16387)   /*  668 */,    W64LIT(0x7EBB3A52BD9A330A)   /*  669 */,
  W64LIT(0x77697857AA7D6435)   /*  670 */,    W64LIT(0x004E831603AE4C32)   /*  671 */,
  W64LIT(0xE7A21020AD78E312)   /*  672 */,    W64LIT(0x9D41A70C6AB420F2)   /*  673 */,
  W64LIT(0x28E06C18EA1141E6)   /*  674 */,    W64LIT(0xD2B28CBD984F6B28)   /*  675 */,
  W64LIT(0x26B75F6C446E9D83)   /*  676 */,    W64LIT(0xBA47568C4D418D7F)   /*  677 */,
  W64LIT(0xD80BADBFE6183D8E)   /*  678 */,    W64LIT(0x0E206D7F5F166044)   /*  679 */,
  W64LIT(0xE258A43911CBCA3E)   /*  680 */,    W64LIT(0x723A1746B21DC0BC)   /*  681 */,
  W64LIT(0xC7CAA854F5D7CDD3)   /*  682 */,    W64LIT(0x7CAC32883D261D9C)   /*  683 */,
  W64LIT(0x7690C26423BA942C)   /*  684 */,    W64LIT(0x17E55524478042B8)   /*  685 */,
  W64LIT(0xE0BE477656A2389F)   /*  686 */,    W64LIT(0x4D289B5E67AB2DA0)   /*  687 */,
  W64LIT(0x44862B9C8FBBFD31)   /*  688 */,    W64LIT(0xB47CC8049D141365)   /*  689 */,
  W64LIT(0x822C1B362B91C793)   /*  690 */,    W64LIT(0x4EB14655FB13DFD8)   /*  691 */,
  W64LIT(0x1ECBBA0714E2A97B)   /*  692 */,    W64LIT(0x6143459D5CDE5F14)   /*  693 */,
  W64LIT(0x53A8FBF1D5F0AC89)   /*  694 */,    W64LIT(0x97EA04D81C5E5B00)   /*  695 */,
  W64LIT(0x622181A8D4FDB3F3)   /*  696 */,    W64LIT(0xE9BCD341572A1208)   /*  697 */,
  W64LIT(0x1411258643CCE58A)   /*  698 */,    W64LIT(0x9144C5FEA4C6E0A4)   /*  699 */,
  W64LIT(0x0D33D06565CF620F)   /*  700 */,    W64LIT(0x54A48D489F219CA1)   /*  701 */,
  W64LIT(0xC43E5EAC6D63C821)   /*  702 */,    W64LIT(0xA9728B3A72770DAF)   /*  703 */,
  W64LIT(0xD7934E7B20DF87EF)   /*  704 */,    W64LIT(0xE35503B61A3E86E5)   /*  705 */,
  W64LIT(0xCAE321FBC819D504)   /*  706 */,    W64LIT(0x129A50B3AC60BFA6)   /*  707 */,
  W64LIT(0xCD5E68EA7E9FB6C3)   /*  708 */,    W64LIT(0xB01C90199483B1C7)   /*  709 */,
  W64LIT(0x3DE93CD5C295376C)   /*  710 */,    W64LIT(0xAED52EDF2AB9AD13)   /*  711 */,
  W64LIT(0x2E60F512C0A07884)   /*  712 */,    W64LIT(0xBC3D86A3E36210C9)   /*  713 */,
  W64LIT(0x35269D9B163951CE)   /*  714 */,    W64LIT(0x0C7D6E2AD0CDB5FA)   /*  715 */,
  W64LIT(0x59E86297D87F5733)   /*  716 */,    W64LIT(0x298EF221898DB0E7)   /*  717 */,
  W64LIT(0x55000029D1A5AA7E)   /*  718 */,    W64LIT(0x8BC08AE1B5061B45)   /*  719 */,
  W64LIT(0xC2C31C2B6C92703A)   /*  720 */,    W64LIT(0x94CC596BAF25EF42)   /*  721 */,
  W64LIT(0x0A1D73DB22540456)   /*  722 */,    W64LIT(0x04B6A0F9D9C4179A)   /*  723 */,
  W64LIT(0xEFFDAFA2AE3D3C60)   /*  724 */,    W64LIT(0xF7C8075BB49496C4)   /*  725 */,
  W64LIT(0x9CC5C7141D1CD4E3)   /*  726 */,    W64LIT(0x78BD1638218E5534)   /*  727 */,
  W64LIT(0xB2F11568F850246A)   /*  728 */,    W64LIT(0xEDFABCFA9502BC29)   /*  729 */,
  W64LIT(0x796CE5F2DA23051B)   /*  730 */,    W64LIT(0xAAE128B0DC93537C)   /*  731 */,
  W64LIT(0x3A493DA0EE4B29AE)   /*  732 */,    W64LIT(0xB5DF6B2C416895D7)   /*  733 */,
  W64LIT(0xFCABBD25122D7F37)   /*  734 */,    W64LIT(0x70810B58105DC4B1)   /*  735 */,
  W64LIT(0xE10FDD37F7882A90)   /*  736 */,    W64LIT(0x524DCAB5518A3F5C)   /*  737 */,
  W64LIT(0x3C9E85878451255B)   /*  738 */,    W64LIT(0x4029828119BD34E2)   /*  739 */,
  W64LIT(0x74A05B6F5D3CECCB)   /*  740 */,    W64LIT(0xB610021542E13ECA)   /*  741 */,
  W64LIT(0x0FF979D12F59E2AC)   /*  742 */,    W64LIT(0x6037DA27E4F9CC50)   /*  743 */,
  W64LIT(0x5E92975A0DF1847D)   /*  744 */,    W64LIT(0xD66DE190D3E623FE)   /*  745 */,
  W64LIT(0x5032D6B87B568048)   /*  746 */,    W64LIT(0x9A36B7CE8235216E)   /*  747 */,
  W64LIT(0x80272A7A24F64B4A)   /*  748 */,    W64LIT(0x93EFED8B8C6916F7)   /*  749 */,
  W64LIT(0x37DDBFF44CCE1555)   /*  750 */,    W64LIT(0x4B95DB5D4B99BD25)   /*  751 */,
  W64LIT(0x92D3FDA169812FC0)   /*  752 */,    W64LIT(0xFB1A4A9A90660BB6)   /*  753 */,
  W64LIT(0x730C196946A4B9B2)   /*  754 */,    W64LIT(0x81E289AA7F49DA68)   /*  755 */,
  W64LIT(0x64669A0F83B1A05F)   /*  756 */,    W64LIT(0x27B3FF7D9644F48B)   /*  757 */,
  W64LIT(0xCC6B615C8DB675B3)   /*  758 */,    W64LIT(0x674F20B9BCEBBE95)   /*  759 */,
  W64LIT(0x6F31238275655982)   /*  760 */,    W64LIT(0x5AE488713E45CF05)   /*  761 */,
  W64LIT(0xBF619F9954C21157)   /*  762 */,    W64LIT(0xEABAC46040A8EAE9)   /*  763 */,
  W64LIT(0x454C6FE9F2C0C1CD)   /*  764 */,    W64LIT(0x419CF6496412691C)   /*  765 */,
  W64LIT(0xD3DC3BEF265B0F70)   /*  766 */,    W64LIT(0x6D0E60F5C3578A9E)   /*  767 */,
  W64LIT(0x5B0E608526323C55)   /*  768 */,    W64LIT(0x1A46C1A9FA1B59F5)   /*  769 */,
  W64LIT(0xA9E245A17C4C8FFA)   /*  770 */,    W64LIT(0x65CA5159DB2955D7)   /*  771 */,
  W64LIT(0x05DB0A76CE35AFC2)   /*  772 */,    W64LIT(0x81EAC77EA9113D45)   /*  773 */,
  W64LIT(0x528EF88AB6AC0A0D)   /*  774 */,    W64LIT(0xA09EA253597BE3FF)   /*  775 */,
  W64LIT(0x430DDFB3AC48CD56)   /*  776 */,    W64LIT(0xC4B3A67AF45CE46F)   /*  777 */,
  W64LIT(0x4ECECFD8FBE2D05E)   /*  778 */,    W64LIT(0x3EF56F10B39935F0)   /*  779 */,
  W64LIT(0x0B22D6829CD619C6)   /*  780 */,    W64LIT(0x17FD460A74DF2069)   /*  781 */,
  W64LIT(0x6CF8CC8E8510ED40)   /*  782 */,    W64LIT(0xD6C824BF3A6ECAA7)   /*  783 */,
  W64LIT(0x61243D581A817049)   /*  784 */,    W64LIT(0x048BACB6BBC163A2)   /*  785 */,
  W64LIT(0xD9A38AC27D44CC32)   /*  786 */,    W64LIT(0x7FDDFF5BAAF410AB)   /*  787 */,
  W64LIT(0xAD6D495AA804824B)   /*  788 */,    W64LIT(0xE1A6A74F2D8C9F94)   /*  789 */,
  W64LIT(0xD4F7851235DEE8E3)   /*  790 */,    W64LIT(0xFD4B7F886540D893)   /*  791 */,
  W64LIT(0x247C20042AA4BFDA)   /*  792 */,    W64LIT(0x096EA1C517D1327C)   /*  793 */,
  W64LIT(0xD56966B4361A6685)   /*  794 */,    W64LIT(0x277DA5C31221057D)   /*  795 */,
  W64LIT(0x94D59893A43ACFF7)   /*  796 */,    W64LIT(0x64F0C51CCDC02281)   /*  797 */,
  W64LIT(0x3D33BCC4FF6189DB)   /*  798 */,    W64LIT(0xE005CB184CE66AF1)   /*  799 */,
  W64LIT(0xFF5CCD1D1DB99BEA)   /*  800 */,    W64LIT(0xB0B854A7FE42980F)   /*  801 */,
  W64LIT(0x7BD46A6A718D4B9F)   /*  802 */,    W64LIT(0xD10FA8CC22A5FD8C)   /*  803 */,
  W64LIT(0xD31484952BE4BD31)   /*  804 */,    W64LIT(0xC7FA975FCB243847)   /*  805 */,
  W64LIT(0x4886ED1E5846C407)   /*  806 */,    W64LIT(0x28CDDB791EB70B04)   /*  807 */,
  W64LIT(0xC2B00BE2F573417F)   /*  808 */,    W64LIT(0x5C9590452180F877)   /*  809 */,
  W64LIT(0x7A6BDDFFF370EB00)   /*  810 */,    W64LIT(0xCE509E38D6D9D6A4)   /*  811 */,
  W64LIT(0xEBEB0F00647FA702)   /*  812 */,    W64LIT(0x1DCC06CF76606F06)   /*  813 */,
  W64LIT(0xE4D9F28BA286FF0A)   /*  814 */,    W64LIT(0xD85A305DC918C262)   /*  815 */,
  W64LIT(0x475B1D8732225F54)   /*  816 */,    W64LIT(0x2D4FB51668CCB5FE)   /*  817 */,
  W64LIT(0xA679B9D9D72BBA20)   /*  818 */,    W64LIT(0x53841C0D912D43A5)   /*  819 */,
  W64LIT(0x3B7EAA48BF12A4E8)   /*  820 */,    W64LIT(0x781E0E47F22F1DDF)   /*  821 */,
  W64LIT(0xEFF20CE60AB50973)   /*  822 */,    W64LIT(0x20D261D19DFFB742)   /*  823 */,
  W64LIT(0x16A12B03062A2E39)   /*  824 */,    W64LIT(0x1960EB2239650495)   /*  825 */,
  W64LIT(0x251C16FED50EB8B8)   /*  826 */,    W64LIT(0x9AC0C330F826016E)   /*  827 */,
  W64LIT(0xED152665953E7671)   /*  828 */,    W64LIT(0x02D63194A6369570)   /*  829 */,
  W64LIT(0x5074F08394B1C987)   /*  830 */,    W64LIT(0x70BA598C90B25CE1)   /*  831 */,
  W64LIT(0x794A15810B9742F6)   /*  832 */,    W64LIT(0x0D5925E9FCAF8C6C)   /*  833 */,
  W64LIT(0x3067716CD868744E)   /*  834 */,    W64LIT(0x910AB077E8D7731B)   /*  835 */,
  W64LIT(0x6A61BBDB5AC42F61)   /*  836 */,    W64LIT(0x93513EFBF0851567)   /*  837 */,
  W64LIT(0xF494724B9E83E9D5)   /*  838 */,    W64LIT(0xE887E1985C09648D)   /*  839 */,
  W64LIT(0x34B1D3C675370CFD)   /*  840 */,    W64LIT(0xDC35E433BC0D255D)   /*  841 */,
  W64LIT(0xD0AAB84234131BE0)   /*  842 */,    W64LIT(0x08042A50B48B7EAF)   /*  843 */,
  W64LIT(0x9997C4EE44A3AB35)   /*  844 */,    W64LIT(0x829A7B49201799D0)   /*  845 */,
  W64LIT(0x263B8307B7C54441)   /*  846 */,    W64LIT(0x752F95F4FD6A6CA6)   /*  847 */,
  W64LIT(0x927217402C08C6E5)   /*  848 */,    W64LIT(0x2A8AB754A795D9EE)   /*  849 */,
  W64LIT(0xA442F7552F72943D)   /*  850 */,    W64LIT(0x2C31334E19781208)   /*  851 */,
  W64LIT(0x4FA98D7CEAEE6291)   /*  852 */,    W64LIT(0x55C3862F665DB309)   /*  853 */,
  W64LIT(0xBD0610175D53B1F3)   /*  854 */,    W64LIT(0x46FE6CB840413F27)   /*  855 */,
  W64LIT(0x3FE03792DF0CFA59)   /*  856 */,    W64LIT(0xCFE700372EB85E8F)   /*  857 */,
  W64LIT(0xA7BE29E7ADBCE118)   /*  858 */,    W64LIT(0xE544EE5CDE8431DD)   /*  859 */,
  W64LIT(0x8A781B1B41F1873E)   /*  860 */,    W64LIT(0xA5C94C78A0D2F0E7)   /*  861 */,
  W64LIT(0x39412E2877B60728)   /*  862 */,    W64LIT(0xA1265EF3AFC9A62C)   /*  863 */,
  W64LIT(0xBCC2770C6A2506C5)   /*  864 */,    W64LIT(0x3AB66DD5DCE1CE12)   /*  865 */,
  W64LIT(0xE65499D04A675B37)   /*  866 */,    W64LIT(0x7D8F523481BFD216)   /*  867 */,
  W64LIT(0x0F6F64FCEC15F389)   /*  868 */,    W64LIT(0x74EFBE618B5B13C8)   /*  869 */,
  W64LIT(0xACDC82B714273E1D)   /*  870 */,    W64LIT(0xDD40BFE003199D17)   /*  871 */,
  W64LIT(0x37E99257E7E061F8)   /*  872 */,    W64LIT(0xFA52626904775AAA)   /*  873 */,
  W64LIT(0x8BBBF63A463D56F9)   /*  874 */,    W64LIT(0xF0013F1543A26E64)   /*  875 */,
  W64LIT(0xA8307E9F879EC898)   /*  876 */,    W64LIT(0xCC4C27A4150177CC)   /*  877 */,
  W64LIT(0x1B432F2CCA1D3348)   /*  878 */,    W64LIT(0xDE1D1F8F9F6FA013)   /*  879 */,
  W64LIT(0x606602A047A7DDD6)   /*  880 */,    W64LIT(0xD237AB64CC1CB2C7)   /*  881 */,
  W64LIT(0x9B938E7225FCD1D3)   /*  882 */,    W64LIT(0xEC4E03708E0FF476)   /*  883 */,
  W64LIT(0xFEB2FBDA3D03C12D)   /*  884 */,    W64LIT(0xAE0BCED2EE43889A)   /*  885 */,
  W64LIT(0x22CB8923EBFB4F43)   /*  886 */,    W64LIT(0x69360D013CF7396D)   /*  887 */,
  W64LIT(0x855E3602D2D4E022)   /*  888 */,    W64LIT(0x073805BAD01F784C)   /*  889 */,
  W64LIT(0x33E17A133852F546)   /*  890 */,    W64LIT(0xDF4874058AC7B638)   /*  891 */,
  W64LIT(0xBA92B29C678AA14A)   /*  892 */,    W64LIT(0x0CE89FC76CFAADCD)   /*  893 */,
  W64LIT(0x5F9D4E0908339E34)   /*  894 */,    W64LIT(0xF1AFE9291F5923B9)   /*  895 */,
  W64LIT(0x6E3480F60F4A265F)   /*  896 */,    W64LIT(0xEEBF3A2AB29B841C)   /*  897 */,
  W64LIT(0xE21938A88F91B4AD)   /*  898 */,    W64LIT(0x57DFEFF845C6D3C3)   /*  899 */,
  W64LIT(0x2F006B0BF62CAAF2)   /*  900 */,    W64LIT(0x62F479EF6F75EE78)   /*  901 */,
  W64LIT(0x11A55AD41C8916A9)   /*  902 */,    W64LIT(0xF229D29084FED453)   /*  903 */,
  W64LIT(0x42F1C27B16B000E6)   /*  904 */,    W64LIT(0x2B1F76749823C074)   /*  905 */,
  W64LIT(0x4B76ECA3C2745360)   /*  906 */,    W64LIT(0x8C98F463B91691BD)   /*  907 */,
  W64LIT(0x14BCC93CF1ADE66A)   /*  908 */,    W64LIT(0x8885213E6D458397)   /*  909 */,
  W64LIT(0x8E177DF0274D4711)   /*  910 */,    W64LIT(0xB49B73B5503F2951)   /*  911 */,
  W64LIT(0x10168168C3F96B6B)   /*  912 */,    W64LIT(0x0E3D963B63CAB0AE)   /*  913 */,
  W64LIT(0x8DFC4B5655A1DB14)   /*  914 */,    W64LIT(0xF789F1356E14DE5C)   /*  915 */,
  W64LIT(0x683E68AF4E51DAC1)   /*  916 */,    W64LIT(0xC9A84F9D8D4B0FD9)   /*  917 */,
  W64LIT(0x3691E03F52A0F9D1)   /*  918 */,    W64LIT(0x5ED86E46E1878E80)   /*  919 */,
  W64LIT(0x3C711A0E99D07150)   /*  920 */,    W64LIT(0x5A0865B20C4E9310)   /*  921 */,
  W64LIT(0x56FBFC1FE4F0682E)   /*  922 */,    W64LIT(0xEA8D5DE3105EDF9B)   /*  923 */,
  W64LIT(0x71ABFDB12379187A)   /*  924 */,    W64LIT(0x2EB99DE1BEE77B9C)   /*  925 */,
  W64LIT(0x21ECC0EA33CF4523)   /*  926 */,    W64LIT(0x59A4D7521805C7A1)   /*  927 */,
  W64LIT(0x3896F5EB56AE7C72)   /*  928 */,    W64LIT(0xAA638F3DB18F75DC)   /*  929 */,
  W64LIT(0x9F39358DABE9808E)   /*  930 */,    W64LIT(0xB7DEFA91C00B72AC)   /*  931 */,
  W64LIT(0x6B5541FD62492D92)   /*  932 */,    W64LIT(0x6DC6DEE8F92E4D5B)   /*  933 */,
  W64LIT(0x353F57ABC4BEEA7E)   /*  934 */,    W64LIT(0x735769D6DA5690CE)   /*  935 */,
  W64LIT(0x0A234AA642391484)   /*  936 */,    W64LIT(0xF6F9508028F80D9D)   /*  937 */,
  W64LIT(0xB8E319A27AB3F215)   /*  938 */,    W64LIT(0x31AD9C1151341A4D)   /*  939 */,
  W64LIT(0x773C22A57BEF5805)   /*  940 */,    W64LIT(0x45C7561A07968633)   /*  941 */,
  W64LIT(0xF913DA9E249DBE36)   /*  942 */,    W64LIT(0xDA652D9B78A64C68)   /*  943 */,
  W64LIT(0x4C27A97F3BC334EF)   /*  944 */,    W64LIT(0x76621220E66B17F4)   /*  945 */,
  W64LIT(0x967743899ACD7D0B)   /*  946 */,    W64LIT(0xF3EE5BCAE0ED6782)   /*  947 */,
  W64LIT(0x409F753600C879FC)   /*  948 */,    W64LIT(0x06D09A39B5926DB6)   /*  949 */,
  W64LIT(0x6F83AEB0317AC588)   /*  950 */,    W64LIT(0x01E6CA4A86381F21)   /*  951 */,
  W64LIT(0x66FF3462D19F3025)   /*  952 */,    W64LIT(0x72207C24DDFD3BFB)   /*  953 */,
  W64LIT(0x4AF6B6D3E2ECE2EB)   /*  954 */,    W64LIT(0x9C994DBEC7EA08DE)   /*  955 */,
  W64LIT(0x49ACE597B09A8BC4)   /*  956 */,    W64LIT(0xB38C4766CF0797BA)   /*  957 */,
  W64LIT(0x131B9373C57C2A75)   /*  958 */,    W64LIT(0xB1822CCE61931E58)   /*  959 */,
  W64LIT(0x9D7555B909BA1C0C)   /*  960 */,    W64LIT(0x127FAFDD937D11D2)   /*  961 */,
  W64LIT(0x29DA3BADC66D92E4)   /*  962 */,    W64LIT(0xA2C1D57154C2ECBC)   /*  963 */,
  W64LIT(0x58C5134D82F6FE24)   /*  964 */,    W64LIT(0x1C3AE3515B62274F)   /*  965 */,
  W64LIT(0xE907C82E01CB8126)   /*  966 */,    W64LIT(0xF8ED091913E37FCB)   /*  967 */,
  W64LIT(0x3249D8F9C80046C9)   /*  968 */,    W64LIT(0x80CF9BEDE388FB63)   /*  969 */,
  W64LIT(0x1881539A116CF19E)   /*  970 */,    W64LIT(0x5103F3F76BD52457)   /*  971 */,
  W64LIT(0x15B7E6F5AE47F7A8)   /*  972 */,    W64LIT(0xDBD7C6DED47E9CCF)   /*  973 */,
  W64LIT(0x44E55C410228BB1A)   /*  974 */,    W64LIT(0xB647D4255EDB4E99)   /*  975 */,
  W64LIT(0x5D11882BB8AAFC30)   /*  976 */,    W64LIT(0xF5098BBB29D3212A)   /*  977 */,
  W64LIT(0x8FB5EA14E90296B3)   /*  978 */,    W64LIT(0x677B942157DD025A)   /*  979 */,
  W64LIT(0xFB58E7C0A390ACB5)   /*  980 */,    W64LIT(0x89D3674C83BD4A01)   /*  981 */,
  W64LIT(0x9E2DA4DF4BF3B93B)   /*  982 */,    W64LIT(0xFCC41E328CAB4829)   /*  983 */,
  W64LIT(0x03F38C96BA582C52)   /*  984 */,    W64LIT(0xCAD1BDBD7FD85DB2)   /*  985 */,
  W64LIT(0xBBB442C16082AE83)   /*  986 */,    W64LIT(0xB95FE86BA5DA9AB0)   /*  987 */,
  W64LIT(0xB22E04673771A93F)   /*  988 */,    W64LIT(0x845358C9493152D8)   /*  989 */,
  W64LIT(0xBE2A488697B4541E)   /*  990 */,    W64LIT(0x95A2DC2DD38E6966)   /*  991 */,
  W64LIT(0xC02C11AC923C852B)   /*  992 */,    W64LIT(0x2388B1990DF2A87B)   /*  993 */,
  W64LIT(0x7C8008FA1B4F37BE)   /*  994 */,    W64LIT(0x1F70D0C84D54E503)   /*  995 */,
  W64LIT(0x5490ADEC7ECE57D4)   /*  996 */,    W64LIT(0x002B3C27D9063A3A)   /*  997 */,
  W64LIT(0x7EAEA3848030A2BF)   /*  998 */,    W64LIT(0xC602326DED2003C0)   /*  999 */,
  W64LIT(0x83A7287D69A94086)   /* 1000 */,    W64LIT(0xC57A5FCB30F57A8A)   /* 1001 */,
  W64LIT(0xB56844E479EBE779)   /* 1002 */,    W64LIT(0xA373B40F05DCBCE9)   /* 1003 */,
  W64LIT(0xD71A786E88570EE2)   /* 1004 */,    W64LIT(0x879CBACDBDE8F6A0)   /* 1005 */,
  W64LIT(0x976AD1BCC164A32F)   /* 1006 */,    W64LIT(0xAB21E25E9666D78B)   /* 1007 */,
  W64LIT(0x901063AAE5E5C33C)   /* 1008 */,    W64LIT(0x9818B34448698D90)   /* 1009 */,
  W64LIT(0xE36487AE3E1E8ABB)   /* 1010 */,    W64LIT(0xAFBDF931893BDCB4)   /* 1011 */,
  W64LIT(0x6345A0DC5FBBD519)   /* 1012 */,    W64LIT(0x8628FE269B9465CA)   /* 1013 */,
  W64LIT(0x1E5D01603F9C51EC)   /* 1014 */,    W64LIT(0x4DE44006A15049B7)   /* 1015 */,
  W64LIT(0xBF6C70E5F776CBB1)   /* 1016 */,    W64LIT(0x411218F2EF552BED)   /* 1017 */,
  W64LIT(0xCB0C0708705A36A3)   /* 1018 */,    W64LIT(0xE74D14754F986044)   /* 1019 */,
  W64LIT(0xCD56D9430EA8280E)   /* 1020 */,    W64LIT(0xC12591D7535F5065)   /* 1021 */,
  W64LIT(0xC83223F1720AEF96)   /* 1022 */,    W64LIT(0xC3A0396F7363A51F)   /* 1023 */
};

//-----------------
static const byte Twofish_q[2*256] =
{
  0xA9, 0x67, 0xB3, 0xE8, 0x04, 0xFD, 0xA3, 0x76, 0x9A, 0x92, 0x80, 0x78,
  0xE4, 0xDD, 0xD1, 0x38, 0x0D, 0xC6, 0x35, 0x98, 0x18, 0xF7, 0xEC, 0x6C,
  0x43, 0x75, 0x37, 0x26, 0xFA, 0x13, 0x94, 0x48, 0xF2, 0xD0, 0x8B, 0x30,
  0x84, 0x54, 0xDF, 0x23, 0x19, 0x5B, 0x3D, 0x59, 0xF3, 0xAE, 0xA2, 0x82,
  0x63, 0x01, 0x83, 0x2E, 0xD9, 0x51, 0x9B, 0x7C, 0xA6, 0xEB, 0xA5, 0xBE,
  0x16, 0x0C, 0xE3, 0x61, 0xC0, 0x8C, 0x3A, 0xF5, 0x73, 0x2C, 0x25, 0x0B,
  0xBB, 0x4E, 0x89, 0x6B, 0x53, 0x6A, 0xB4, 0xF1, 0xE1, 0xE6, 0xBD, 0x45,
  0xE2, 0xF4, 0xB6, 0x66, 0xCC, 0x95, 0x03, 0x56, 0xD4, 0x1C, 0x1E, 0xD7,
  0xFB, 0xC3, 0x8E, 0xB5, 0xE9, 0xCF, 0xBF, 0xBA, 0xEA, 0x77, 0x39, 0xAF,
  0x33, 0xC9, 0x62, 0x71, 0x81, 0x79, 0x09, 0xAD, 0x24, 0xCD, 0xF9, 0xD8,
  0xE5, 0xC5, 0xB9, 0x4D, 0x44, 0x08, 0x86, 0xE7, 0xA1, 0x1D, 0xAA, 0xED,
  0x06, 0x70, 0xB2, 0xD2, 0x41, 0x7B, 0xA0, 0x11, 0x31, 0xC2, 0x27, 0x90,
  0x20, 0xF6, 0x60, 0xFF, 0x96, 0x5C, 0xB1, 0xAB, 0x9E, 0x9C, 0x52, 0x1B,
  0x5F, 0x93, 0x0A, 0xEF, 0x91, 0x85, 0x49, 0xEE, 0x2D, 0x4F, 0x8F, 0x3B,
  0x47, 0x87, 0x6D, 0x46, 0xD6, 0x3E, 0x69, 0x64, 0x2A, 0xCE, 0xCB, 0x2F,
  0xFC, 0x97, 0x05, 0x7A, 0xAC, 0x7F, 0xD5, 0x1A, 0x4B, 0x0E, 0xA7, 0x5A,
  0x28, 0x14, 0x3F, 0x29, 0x88, 0x3C, 0x4C, 0x02, 0xB8, 0xDA, 0xB0, 0x17,
  0x55, 0x1F, 0x8A, 0x7D, 0x57, 0xC7, 0x8D, 0x74, 0xB7, 0xC4, 0x9F, 0x72,
  0x7E, 0x15, 0x22, 0x12, 0x58, 0x07, 0x99, 0x34, 0x6E, 0x50, 0xDE, 0x68,
  0x65, 0xBC, 0xDB, 0xF8, 0xC8, 0xA8, 0x2B, 0x40, 0xDC, 0xFE, 0x32, 0xA4,
  0xCA, 0x10, 0x21, 0xF0, 0xD3, 0x5D, 0x0F, 0x00, 0x6F, 0x9D, 0x36, 0x42,
  0x4A, 0x5E, 0xC1, 0xE0,

  0x75, 0xF3, 0xC6, 0xF4, 0xDB, 0x7B, 0xFB, 0xC8, 0x4A, 0xD3, 0xE6, 0x6B,
  0x45, 0x7D, 0xE8, 0x4B, 0xD6, 0x32, 0xD8, 0xFD, 0x37, 0x71, 0xF1, 0xE1,
  0x30, 0x0F, 0xF8, 0x1B, 0x87, 0xFA, 0x06, 0x3F, 0x5E, 0xBA, 0xAE, 0x5B,
  0x8A, 0x00, 0xBC, 0x9D, 0x6D, 0xC1, 0xB1, 0x0E, 0x80, 0x5D, 0xD2, 0xD5,
  0xA0, 0x84, 0x07, 0x14, 0xB5, 0x90, 0x2C, 0xA3, 0xB2, 0x73, 0x4C, 0x54,
  0x92, 0x74, 0x36, 0x51, 0x38, 0xB0, 0xBD, 0x5A, 0xFC, 0x60, 0x62, 0x96,
  0x6C, 0x42, 0xF7, 0x10, 0x7C, 0x28, 0x27, 0x8C, 0x13, 0x95, 0x9C, 0xC7,
  0x24, 0x46, 0x3B, 0x70, 0xCA, 0xE3, 0x85, 0xCB, 0x11, 0xD0, 0x93, 0xB8,
  0xA6, 0x83, 0x20, 0xFF, 0x9F, 0x77, 0xC3, 0xCC, 0x03, 0x6F, 0x08, 0xBF,
  0x40, 0xE7, 0x2B, 0xE2, 0x79, 0x0C, 0xAA, 0x82, 0x41, 0x3A, 0xEA, 0xB9,
  0xE4, 0x9A, 0xA4, 0x97, 0x7E, 0xDA, 0x7A, 0x17, 0x66, 0x94, 0xA1, 0x1D,
  0x3D, 0xF0, 0xDE, 0xB3, 0x0B, 0x72, 0xA7, 0x1C, 0xEF, 0xD1, 0x53, 0x3E,
  0x8F, 0x33, 0x26, 0x5F, 0xEC, 0x76, 0x2A, 0x49, 0x81, 0x88, 0xEE, 0x21,
  0xC4, 0x1A, 0xEB, 0xD9, 0xC5, 0x39, 0x99, 0xCD, 0xAD, 0x31, 0x8B, 0x01,
  0x18, 0x23, 0xDD, 0x1F, 0x4E, 0x2D, 0xF9, 0x48, 0x4F, 0xF2, 0x65, 0x8E,
  0x78, 0x5C, 0x58, 0x19, 0x8D, 0xE5, 0x98, 0x57, 0x67, 0x7F, 0x05, 0x64,
  0xAF, 0x63, 0xB6, 0xFE, 0xF5, 0xB7, 0x3C, 0xA5, 0xCE, 0xE9, 0x68, 0x44,
  0xE0, 0x4D, 0x43, 0x69, 0x29, 0x2E, 0xAC, 0x15, 0x59, 0xA8, 0x0A, 0x9E,
  0x6E, 0x47, 0xDF, 0x34, 0x35, 0x6A, 0xCF, 0xDC, 0x22, 0xC9, 0xC0, 0x9B,
  0x89, 0xD4, 0xED, 0xAB, 0x12, 0xA2, 0x0D, 0x52, 0xBB, 0x02, 0x2F, 0xA9,
  0xD7, 0x61, 0x1E, 0xB4, 0x50, 0x04, 0xF6, 0xC2, 0x16, 0x25, 0x86, 0x56,
  0x55, 0x09, 0xBE, 0x91
};

static const word32 Twofish_mds[4*256] =
{
  0xbcbc3275, 0xecec21f3, 0x202043c6, 0xb3b3c9f4,
  0xdada03db, 0x02028b7b, 0xe2e22bfb, 0x9e9efac8,
  0xc9c9ec4a, 0xd4d409d3, 0x18186be6, 0x1e1e9f6b,
  0x98980e45, 0xb2b2387d, 0xa6a6d2e8, 0x2626b74b,
  0x3c3c57d6, 0x93938a32, 0x8282eed8, 0x525298fd,
  0x7b7bd437, 0xbbbb3771, 0x5b5b97f1, 0x474783e1,
  0x24243c30, 0x5151e20f, 0xbabac6f8, 0x4a4af31b,
  0xbfbf4887, 0x0d0d70fa, 0xb0b0b306, 0x7575de3f,
  0xd2d2fd5e, 0x7d7d20ba, 0x666631ae, 0x3a3aa35b,
  0x59591c8a, 0x00000000, 0xcdcd93bc, 0x1a1ae09d,
  0xaeae2c6d, 0x7f7fabc1, 0x2b2bc7b1, 0xbebeb90e,
  0xe0e0a080, 0x8a8a105d, 0x3b3b52d2, 0x6464bad5,
  0xd8d888a0, 0xe7e7a584, 0x5f5fe807, 0x1b1b1114,
  0x2c2cc2b5, 0xfcfcb490, 0x3131272c, 0x808065a3,
  0x73732ab2, 0x0c0c8173, 0x79795f4c, 0x6b6b4154,
  0x4b4b0292, 0x53536974, 0x94948f36, 0x83831f51,
  0x2a2a3638, 0xc4c49cb0, 0x2222c8bd, 0xd5d5f85a,
  0xbdbdc3fc, 0x48487860, 0xffffce62, 0x4c4c0796,
  0x4141776c, 0xc7c7e642, 0xebeb24f7, 0x1c1c1410,
  0x5d5d637c, 0x36362228, 0x6767c027, 0xe9e9af8c,
  0x4444f913, 0x1414ea95, 0xf5f5bb9c, 0xcfcf18c7,
  0x3f3f2d24, 0xc0c0e346, 0x7272db3b, 0x54546c70,
  0x29294cca, 0xf0f035e3, 0x0808fe85, 0xc6c617cb,
  0xf3f34f11, 0x8c8ce4d0, 0xa4a45993, 0xcaca96b8,
  0x68683ba6, 0xb8b84d83, 0x38382820, 0xe5e52eff,
  0xadad569f, 0x0b0b8477, 0xc8c81dc3, 0x9999ffcc,
  0x5858ed03, 0x19199a6f, 0x0e0e0a08, 0x95957ebf,
  0x70705040, 0xf7f730e7, 0x6e6ecf2b, 0x1f1f6ee2,
  0xb5b53d79, 0x09090f0c, 0x616134aa, 0x57571682,
  0x9f9f0b41, 0x9d9d803a, 0x111164ea, 0x2525cdb9,
  0xafafdde4, 0x4545089a, 0xdfdf8da4, 0xa3a35c97,
  0xeaead57e, 0x353558da, 0xededd07a, 0x4343fc17,
  0xf8f8cb66, 0xfbfbb194, 0x3737d3a1, 0xfafa401d,
  0xc2c2683d, 0xb4b4ccf0, 0x32325dde, 0x9c9c71b3,
  0x5656e70b, 0xe3e3da72, 0x878760a7, 0x15151b1c,
  0xf9f93aef, 0x6363bfd1, 0x3434a953, 0x9a9a853e,
  0xb1b1428f, 0x7c7cd133, 0x88889b26, 0x3d3da65f,
  0xa1a1d7ec, 0xe4e4df76, 0x8181942a, 0x91910149,
  0x0f0ffb81, 0xeeeeaa88, 0x161661ee, 0xd7d77321,
  0x9797f5c4, 0xa5a5a81a, 0xfefe3feb, 0x6d6db5d9,
  0x7878aec5, 0xc5c56d39, 0x1d1de599, 0x7676a4cd,
  0x3e3edcad, 0xcbcb6731, 0xb6b6478b, 0xefef5b01,
  0x12121e18, 0x6060c523, 0x6a6ab0dd, 0x4d4df61f,
  0xcecee94e, 0xdede7c2d, 0x55559df9, 0x7e7e5a48,
  0x2121b24f, 0x03037af2, 0xa0a02665, 0x5e5e198e,
  0x5a5a6678, 0x65654b5c, 0x62624e58, 0xfdfd4519,
  0x0606f48d, 0x404086e5, 0xf2f2be98, 0x3333ac57,
  0x17179067, 0x05058e7f, 0xe8e85e05, 0x4f4f7d64,
  0x89896aaf, 0x10109563, 0x74742fb6, 0x0a0a75fe,
  0x5c5c92f5, 0x9b9b74b7, 0x2d2d333c, 0x3030d6a5,
  0x2e2e49ce, 0x494989e9, 0x46467268, 0x77775544,
  0xa8a8d8e0, 0x9696044d, 0x2828bd43, 0xa9a92969,
  0xd9d97929, 0x8686912e, 0xd1d187ac, 0xf4f44a15,
  0x8d8d1559, 0xd6d682a8, 0xb9b9bc0a, 0x42420d9e,
  0xf6f6c16e, 0x2f2fb847, 0xdddd06df, 0x23233934,
  0xcccc6235, 0xf1f1c46a, 0xc1c112cf, 0x8585ebdc,
  0x8f8f9e22, 0x7171a1c9, 0x9090f0c0, 0xaaaa539b,
  0x0101f189, 0x8b8be1d4, 0x4e4e8ced, 0x8e8e6fab,
  0xababa212, 0x6f6f3ea2, 0xe6e6540d, 0xdbdbf252,
  0x92927bbb, 0xb7b7b602, 0x6969ca2f, 0x3939d9a9,
  0xd3d30cd7, 0xa7a72361, 0xa2a2ad1e, 0xc3c399b4,
  0x6c6c4450, 0x07070504, 0x04047ff6, 0x272746c2,
  0xacaca716, 0xd0d07625, 0x50501386, 0xdcdcf756,
  0x84841a55, 0xe1e15109, 0x7a7a25be, 0x1313ef91,

  0xa9d93939, 0x67901717, 0xb3719c9c, 0xe8d2a6a6,
  0x04050707, 0xfd985252, 0xa3658080, 0x76dfe4e4,
  0x9a084545, 0x92024b4b, 0x80a0e0e0, 0x78665a5a,
  0xe4ddafaf, 0xddb06a6a, 0xd1bf6363, 0x38362a2a,
  0x0d54e6e6, 0xc6432020, 0x3562cccc, 0x98bef2f2,
  0x181e1212, 0xf724ebeb, 0xecd7a1a1, 0x6c774141,
  0x43bd2828, 0x7532bcbc, 0x37d47b7b, 0x269b8888,
  0xfa700d0d, 0x13f94444, 0x94b1fbfb, 0x485a7e7e,
  0xf27a0303, 0xd0e48c8c, 0x8b47b6b6, 0x303c2424,
  0x84a5e7e7, 0x54416b6b, 0xdf06dddd, 0x23c56060,
  0x1945fdfd, 0x5ba33a3a, 0x3d68c2c2, 0x59158d8d,
  0xf321ecec, 0xae316666, 0xa23e6f6f, 0x82165757,
  0x63951010, 0x015befef, 0x834db8b8, 0x2e918686,
  0xd9b56d6d, 0x511f8383, 0x9b53aaaa, 0x7c635d5d,
  0xa63b6868, 0xeb3ffefe, 0xa5d63030, 0xbe257a7a,
  0x16a7acac, 0x0c0f0909, 0xe335f0f0, 0x6123a7a7,
  0xc0f09090, 0x8cafe9e9, 0x3a809d9d, 0xf5925c5c,
  0x73810c0c, 0x2c273131, 0x2576d0d0, 0x0be75656,
  0xbb7b9292, 0x4ee9cece, 0x89f10101, 0x6b9f1e1e,
  0x53a93434, 0x6ac4f1f1, 0xb499c3c3, 0xf1975b5b,
  0xe1834747, 0xe66b1818, 0xbdc82222, 0x450e9898,
  0xe26e1f1f, 0xf4c9b3b3, 0xb62f7474, 0x66cbf8f8,
  0xccff9999, 0x95ea1414, 0x03ed5858, 0x56f7dcdc,
  0xd4e18b8b, 0x1c1b1515, 0x1eada2a2, 0xd70cd3d3,
  0xfb2be2e2, 0xc31dc8c8, 0x8e195e5e, 0xb5c22c2c,
  0xe9894949, 0xcf12c1c1, 0xbf7e9595, 0xba207d7d,
  0xea641111, 0x77840b0b, 0x396dc5c5, 0xaf6a8989,
  0x33d17c7c, 0xc9a17171, 0x62ceffff, 0x7137bbbb,
  0x81fb0f0f, 0x793db5b5, 0x0951e1e1, 0xaddc3e3e,
  0x242d3f3f, 0xcda47676, 0xf99d5555, 0xd8ee8282,
  0xe5864040, 0xc5ae7878, 0xb9cd2525, 0x4d049696,
  0x44557777, 0x080a0e0e, 0x86135050, 0xe730f7f7,
  0xa1d33737, 0x1d40fafa, 0xaa346161, 0xed8c4e4e,
  0x06b3b0b0, 0x706c5454, 0xb22a7373, 0xd2523b3b,
  0x410b9f9f, 0x7b8b0202, 0xa088d8d8, 0x114ff3f3,
  0x3167cbcb, 0xc2462727, 0x27c06767, 0x90b4fcfc,
  0x20283838, 0xf67f0404, 0x60784848, 0xff2ee5e5,
  0x96074c4c, 0x5c4b6565, 0xb1c72b2b, 0xab6f8e8e,
  0x9e0d4242, 0x9cbbf5f5, 0x52f2dbdb, 0x1bf34a4a,
  0x5fa63d3d, 0x9359a4a4, 0x0abcb9b9, 0xef3af9f9,
  0x91ef1313, 0x85fe0808, 0x49019191, 0xee611616,
  0x2d7cdede, 0x4fb22121, 0x8f42b1b1, 0x3bdb7272,
  0x47b82f2f, 0x8748bfbf, 0x6d2caeae, 0x46e3c0c0,
  0xd6573c3c, 0x3e859a9a, 0x6929a9a9, 0x647d4f4f,
  0x2a948181, 0xce492e2e, 0xcb17c6c6, 0x2fca6969,
  0xfcc3bdbd, 0x975ca3a3, 0x055ee8e8, 0x7ad0eded,
  0xac87d1d1, 0x7f8e0505, 0xd5ba6464, 0x1aa8a5a5,
  0x4bb72626, 0x0eb9bebe, 0xa7608787, 0x5af8d5d5,
  0x28223636, 0x14111b1b, 0x3fde7575, 0x2979d9d9,
  0x88aaeeee, 0x3c332d2d, 0x4c5f7979, 0x02b6b7b7,
  0xb896caca, 0xda583535, 0xb09cc4c4, 0x17fc4343,
  0x551a8484, 0x1ff64d4d, 0x8a1c5959, 0x7d38b2b2,
  0x57ac3333, 0xc718cfcf, 0x8df40606, 0x74695353,
  0xb7749b9b, 0xc4f59797, 0x9f56adad, 0x72dae3e3,
  0x7ed5eaea, 0x154af4f4, 0x229e8f8f, 0x12a2abab,
  0x584e6262, 0x07e85f5f, 0x99e51d1d, 0x34392323,
  0x6ec1f6f6, 0x50446c6c, 0xde5d3232, 0x68724646,
  0x6526a0a0, 0xbc93cdcd, 0xdb03dada, 0xf8c6baba,
  0xc8fa9e9e, 0xa882d6d6, 0x2bcf6e6e, 0x40507070,
  0xdceb8585, 0xfe750a0a, 0x328a9393, 0xa48ddfdf,
  0xca4c2929, 0x10141c1c, 0x2173d7d7, 0xf0ccb4b4,
  0xd309d4d4, 0x5d108a8a, 0x0fe25151, 0x00000000,
  0x6f9a1919, 0x9de01a1a, 0x368f9494, 0x42e6c7c7,
  0x4aecc9c9, 0x5efdd2d2, 0xc1ab7f7f, 0xe0d8a8a8,

  0xbc75bc32, 0xecf3ec21, 0x20c62043, 0xb3f4b3c9,
  0xdadbda03, 0x027b028b, 0xe2fbe22b, 0x9ec89efa,
  0xc94ac9ec, 0xd4d3d409, 0x18e6186b, 0x1e6b1e9f,
  0x9845980e, 0xb27db238, 0xa6e8a6d2, 0x264b26b7,
  0x3cd63c57, 0x9332938a, 0x82d882ee, 0x52fd5298,
  0x7b377bd4, 0xbb71bb37, 0x5bf15b97, 0x47e14783,
  0x2430243c, 0x510f51e2, 0xbaf8bac6, 0x4a1b4af3,
  0xbf87bf48, 0x0dfa0d70, 0xb006b0b3, 0x753f75de,
  0xd25ed2fd, 0x7dba7d20, 0x66ae6631, 0x3a5b3aa3,
  0x598a591c, 0x00000000, 0xcdbccd93, 0x1a9d1ae0,
  0xae6dae2c, 0x7fc17fab, 0x2bb12bc7, 0xbe0ebeb9,
  0xe080e0a0, 0x8a5d8a10, 0x3bd23b52, 0x64d564ba,
  0xd8a0d888, 0xe784e7a5, 0x5f075fe8, 0x1b141b11,
  0x2cb52cc2, 0xfc90fcb4, 0x312c3127, 0x80a38065,
  0x73b2732a, 0x0c730c81, 0x794c795f, 0x6b546b41,
  0x4b924b02, 0x53745369, 0x9436948f, 0x8351831f,
  0x2a382a36, 0xc4b0c49c, 0x22bd22c8, 0xd55ad5f8,
  0xbdfcbdc3, 0x48604878, 0xff62ffce, 0x4c964c07,
  0x416c4177, 0xc742c7e6, 0xebf7eb24, 0x1c101c14,
  0x5d7c5d63, 0x36283622, 0x672767c0, 0xe98ce9af,
  0x441344f9, 0x149514ea, 0xf59cf5bb, 0xcfc7cf18,
  0x3f243f2d, 0xc046c0e3, 0x723b72db, 0x5470546c,
  0x29ca294c, 0xf0e3f035, 0x088508fe, 0xc6cbc617,
  0xf311f34f, 0x8cd08ce4, 0xa493a459, 0xcab8ca96,
  0x68a6683b, 0xb883b84d, 0x38203828, 0xe5ffe52e,
  0xad9fad56, 0x0b770b84, 0xc8c3c81d, 0x99cc99ff,
  0x580358ed, 0x196f199a, 0x0e080e0a, 0x95bf957e,
  0x70407050, 0xf7e7f730, 0x6e2b6ecf, 0x1fe21f6e,
  0xb579b53d, 0x090c090f, 0x61aa6134, 0x57825716,
  0x9f419f0b, 0x9d3a9d80, 0x11ea1164, 0x25b925cd,
  0xafe4afdd, 0x459a4508, 0xdfa4df8d, 0xa397a35c,
  0xea7eead5, 0x35da3558, 0xed7aedd0, 0x431743fc,
  0xf866f8cb, 0xfb94fbb1, 0x37a137d3, 0xfa1dfa40,
  0xc23dc268, 0xb4f0b4cc, 0x32de325d, 0x9cb39c71,
  0x560b56e7, 0xe372e3da, 0x87a78760, 0x151c151b,
  0xf9eff93a, 0x63d163bf, 0x345334a9, 0x9a3e9a85,
  0xb18fb142, 0x7c337cd1, 0x8826889b, 0x3d5f3da6,
  0xa1eca1d7, 0xe476e4df, 0x812a8194, 0x91499101,
  0x0f810ffb, 0xee88eeaa, 0x16ee1661, 0xd721d773,
  0x97c497f5, 0xa51aa5a8, 0xfeebfe3f, 0x6dd96db5,
  0x78c578ae, 0xc539c56d, 0x1d991de5, 0x76cd76a4,
  0x3ead3edc, 0xcb31cb67, 0xb68bb647, 0xef01ef5b,
  0x1218121e, 0x602360c5, 0x6add6ab0, 0x4d1f4df6,
  0xce4ecee9, 0xde2dde7c, 0x55f9559d, 0x7e487e5a,
  0x214f21b2, 0x03f2037a, 0xa065a026, 0x5e8e5e19,
  0x5a785a66, 0x655c654b, 0x6258624e, 0xfd19fd45,
  0x068d06f4, 0x40e54086, 0xf298f2be, 0x335733ac,
  0x17671790, 0x057f058e, 0xe805e85e, 0x4f644f7d,
  0x89af896a, 0x10631095, 0x74b6742f, 0x0afe0a75,
  0x5cf55c92, 0x9bb79b74, 0x2d3c2d33, 0x30a530d6,
  0x2ece2e49, 0x49e94989, 0x46684672, 0x77447755,
  0xa8e0a8d8, 0x964d9604, 0x284328bd, 0xa969a929,
  0xd929d979, 0x862e8691, 0xd1acd187, 0xf415f44a,
  0x8d598d15, 0xd6a8d682, 0xb90ab9bc, 0x429e420d,
  0xf66ef6c1, 0x2f472fb8, 0xdddfdd06, 0x23342339,
  0xcc35cc62, 0xf16af1c4, 0xc1cfc112, 0x85dc85eb,
  0x8f228f9e, 0x71c971a1, 0x90c090f0, 0xaa9baa53,
  0x018901f1, 0x8bd48be1, 0x4eed4e8c, 0x8eab8e6f,
  0xab12aba2, 0x6fa26f3e, 0xe60de654, 0xdb52dbf2,
  0x92bb927b, 0xb702b7b6, 0x692f69ca, 0x39a939d9,
  0xd3d7d30c, 0xa761a723, 0xa21ea2ad, 0xc3b4c399,
  0x6c506c44, 0x07040705, 0x04f6047f, 0x27c22746,
  0xac16aca7, 0xd025d076, 0x50865013, 0xdc56dcf7,
  0x8455841a, 0xe109e151, 0x7abe7a25, 0x139113ef,

  0xd939a9d9, 0x90176790, 0x719cb371, 0xd2a6e8d2,
  0x05070405, 0x9852fd98, 0x6580a365, 0xdfe476df,
  0x08459a08, 0x024b9202, 0xa0e080a0, 0x665a7866,
  0xddafe4dd, 0xb06addb0, 0xbf63d1bf, 0x362a3836,
  0x54e60d54, 0x4320c643, 0x62cc3562, 0xbef298be,
  0x1e12181e, 0x24ebf724, 0xd7a1ecd7, 0x77416c77,
  0xbd2843bd, 0x32bc7532, 0xd47b37d4, 0x9b88269b,
  0x700dfa70, 0xf94413f9, 0xb1fb94b1, 0x5a7e485a,
  0x7a03f27a, 0xe48cd0e4, 0x47b68b47, 0x3c24303c,
  0xa5e784a5, 0x416b5441, 0x06dddf06, 0xc56023c5,
  0x45fd1945, 0xa33a5ba3, 0x68c23d68, 0x158d5915,
  0x21ecf321, 0x3166ae31, 0x3e6fa23e, 0x16578216,
  0x95106395, 0x5bef015b, 0x4db8834d, 0x91862e91,
  0xb56dd9b5, 0x1f83511f, 0x53aa9b53, 0x635d7c63,
  0x3b68a63b, 0x3ffeeb3f, 0xd630a5d6, 0x257abe25,
  0xa7ac16a7, 0x0f090c0f, 0x35f0e335, 0x23a76123,
  0xf090c0f0, 0xafe98caf, 0x809d3a80, 0x925cf592,
  0x810c7381, 0x27312c27, 0x76d02576, 0xe7560be7,
  0x7b92bb7b, 0xe9ce4ee9, 0xf10189f1, 0x9f1e6b9f,
  0xa93453a9, 0xc4f16ac4, 0x99c3b499, 0x975bf197,
  0x8347e183, 0x6b18e66b, 0xc822bdc8, 0x0e98450e,
  0x6e1fe26e, 0xc9b3f4c9, 0x2f74b62f, 0xcbf866cb,
  0xff99ccff, 0xea1495ea, 0xed5803ed, 0xf7dc56f7,
  0xe18bd4e1, 0x1b151c1b, 0xada21ead, 0x0cd3d70c,
  0x2be2fb2b, 0x1dc8c31d, 0x195e8e19, 0xc22cb5c2,
  0x8949e989, 0x12c1cf12, 0x7e95bf7e, 0x207dba20,
  0x6411ea64, 0x840b7784, 0x6dc5396d, 0x6a89af6a,
  0xd17c33d1, 0xa171c9a1, 0xceff62ce, 0x37bb7137,
  0xfb0f81fb, 0x3db5793d, 0x51e10951, 0xdc3eaddc,
  0x2d3f242d, 0xa476cda4, 0x9d55f99d, 0xee82d8ee,
  0x8640e586, 0xae78c5ae, 0xcd25b9cd, 0x04964d04,
  0x55774455, 0x0a0e080a, 0x13508613, 0x30f7e730,
  0xd337a1d3, 0x40fa1d40, 0x3461aa34, 0x8c4eed8c,
  0xb3b006b3, 0x6c54706c, 0x2a73b22a, 0x523bd252,
  0x0b9f410b, 0x8b027b8b, 0x88d8a088, 0x4ff3114f,
  0x67cb3167, 0x4627c246, 0xc06727c0, 0xb4fc90b4,
  0x28382028, 0x7f04f67f, 0x78486078, 0x2ee5ff2e,
  0x074c9607, 0x4b655c4b, 0xc72bb1c7, 0x6f8eab6f,
  0x0d429e0d, 0xbbf59cbb, 0xf2db52f2, 0xf34a1bf3,
  0xa63d5fa6, 0x59a49359, 0xbcb90abc, 0x3af9ef3a,
  0xef1391ef, 0xfe0885fe, 0x01914901, 0x6116ee61,
  0x7cde2d7c, 0xb2214fb2, 0x42b18f42, 0xdb723bdb,
  0xb82f47b8, 0x48bf8748, 0x2cae6d2c, 0xe3c046e3,
  0x573cd657, 0x859a3e85, 0x29a96929, 0x7d4f647d,
  0x94812a94, 0x492ece49, 0x17c6cb17, 0xca692fca,
  0xc3bdfcc3, 0x5ca3975c, 0x5ee8055e, 0xd0ed7ad0,
  0x87d1ac87, 0x8e057f8e, 0xba64d5ba, 0xa8a51aa8,
  0xb7264bb7, 0xb9be0eb9, 0x6087a760, 0xf8d55af8,
  0x22362822, 0x111b1411, 0xde753fde, 0x79d92979,
  0xaaee88aa, 0x332d3c33, 0x5f794c5f, 0xb6b702b6,
  0x96cab896, 0x5835da58, 0x9cc4b09c, 0xfc4317fc,
  0x1a84551a, 0xf64d1ff6, 0x1c598a1c, 0x38b27d38,
  0xac3357ac, 0x18cfc718, 0xf4068df4, 0x69537469,
  0x749bb774, 0xf597c4f5, 0x56ad9f56, 0xdae372da,
  0xd5ea7ed5, 0x4af4154a, 0x9e8f229e, 0xa2ab12a2,
  0x4e62584e, 0xe85f07e8, 0xe51d99e5, 0x39233439,
  0xc1f66ec1, 0x446c5044, 0x5d32de5d, 0x72466872,
  0x26a06526, 0x93cdbc93, 0x03dadb03, 0xc6baf8c6,
  0xfa9ec8fa, 0x82d6a882, 0xcf6e2bcf, 0x50704050,
  0xeb85dceb, 0x750afe75, 0x8a93328a, 0x8ddfa48d,
  0x4c29ca4c, 0x141c1014, 0x73d72173, 0xccb4f0cc,
  0x09d4d309, 0x108a5d10, 0xe2510fe2, 0x00000000,
  0x9a196f9a, 0xe01a9de0, 0x8f94368f, 0xe6c742e6,
  0xecc94aec, 0xfdd25efd, 0xab7fc1ab, 0xd8a8e0d8
};

//-----------------
static const word32 Square_Te[4*256] =
{
  0x97b1b126, 0x69cecea7, 0x73c3c3b0, 0xdf95954a,
  0xb45a5aee, 0xafadad02, 0x3be7e7dc, 0x04020206,
  0x9a4d4dd7, 0x884444cc, 0x03fbfbf8, 0xd7919146,
  0x180c0c14, 0xfb87877c, 0xb7a1a116, 0xa05050f0,
  0x63cbcba8, 0xce6767a9, 0xa85454fc, 0x4fdddd92,
  0x8c4646ca, 0xeb8f8f64, 0x37e1e1d6, 0x9c4e4ed2,
  0x15f0f0e5, 0x0ffdfdf2, 0x0dfcfcf1, 0x23ebebc8,
  0x07f9f9fe, 0x7dc4c4b9, 0x341a1a2e, 0xdc6e6eb2,
  0xbc5e5ee2, 0x1ff5f5ea, 0x6dcccca1, 0xef8d8d62,
  0x381c1c24, 0xac5656fa, 0x864343c5, 0x09fefef7,
  0x0e070709, 0xc26161a3, 0x05f8f8fd, 0xea75759f,
  0xb25959eb, 0x0bfffff4, 0x06030305, 0x44222266,
  0xe18a8a6b, 0x57d1d186, 0x26131335, 0x29eeeec7,
  0xe588886d, 0x00000000, 0x1c0e0e12, 0x6834345c,
  0x2a15153f, 0xf5808075, 0xdd949449, 0x33e3e3d0,
  0x2fededc2, 0x9fb5b52a, 0xa65353f5, 0x46232365,
  0x964b4bdd, 0x8e4747c9, 0x2e171739, 0xbba7a71c,
  0xd5909045, 0x6a35355f, 0xa3abab08, 0x45d8d89d,
  0x85b8b83d, 0x4bdfdf94, 0x9e4f4fd1, 0xae5757f9,
  0xc19a9a5b, 0xd1929243, 0x43dbdb98, 0x361b1b2d,
  0x783c3c44, 0x65c8c8ad, 0xc799995e, 0x0804040c,
  0xe98e8e67, 0x35e0e0d5, 0x5bd7d78c, 0xfa7d7d87,
  0xff85857a, 0x83bbbb38, 0x804040c0, 0x582c2c74,
  0x743a3a4e, 0x8a4545cf, 0x17f1f1e6, 0x844242c6,
  0xca6565af, 0x40202060, 0x824141c3, 0x30181828,
  0xe4727296, 0x4a25256f, 0xd3939340, 0xe0707090,
  0x6c36365a, 0x0a05050f, 0x11f2f2e3, 0x160b0b1d,
  0xb3a3a310, 0xf279798b, 0x2dececc1, 0x10080818,
  0x4e272769, 0x62313153, 0x64323256, 0x99b6b62f,
  0xf87c7c84, 0x95b0b025, 0x140a0a1e, 0xe6737395,
  0xb65b5bed, 0xf67b7b8d, 0x9bb7b72c, 0xf7818176,
  0x51d2d283, 0x1a0d0d17, 0xd46a6abe, 0x4c26266a,
  0xc99e9e57, 0xb05858e8, 0xcd9c9c51, 0xf3838370,
  0xe874749c, 0x93b3b320, 0xadacac01, 0x60303050,
  0xf47a7a8e, 0xd26969bb, 0xee777799, 0x1e0f0f11,
  0xa9aeae07, 0x42212163, 0x49dede97, 0x55d0d085,
  0x5c2e2e72, 0xdb97974c, 0x20101030, 0xbda4a419,
  0xc598985d, 0xa5a8a80d, 0x5dd4d489, 0xd06868b8,
  0x5a2d2d77, 0xc46262a6, 0x5229297b, 0xda6d6db7,
  0x2c16163a, 0x924949db, 0xec76769a, 0x7bc7c7bc,
  0x25e8e8cd, 0x77c1c1b6, 0xd996964f, 0x6e373759,
  0x3fe5e5da, 0x61cacaab, 0x1df4f4e9, 0x27e9e9ce,
  0xc66363a5, 0x24121236, 0x71c2c2b3, 0xb9a6a61f,
  0x2814143c, 0x8dbcbc31, 0x53d3d380, 0x50282878,
  0xabafaf04, 0x5e2f2f71, 0x39e6e6df, 0x4824246c,
  0xa45252f6, 0x79c6c6bf, 0xb5a0a015, 0x1209091b,
  0x8fbdbd32, 0xed8c8c61, 0x6bcfcfa4, 0xba5d5de7,
  0x22111133, 0xbe5f5fe1, 0x02010103, 0x7fc5c5ba,
  0xcb9f9f54, 0x7a3d3d47, 0xb1a2a213, 0xc39b9b58,
  0x67c9c9ae, 0x763b3b4d, 0x89bebe37, 0xa25151f3,
  0x3219192b, 0x3e1f1f21, 0x7e3f3f41, 0xb85c5ce4,
  0x91b2b223, 0x2befefc4, 0x944a4ade, 0x6fcdcda2,
  0x8bbfbf34, 0x81baba3b, 0xde6f6fb1, 0xc86464ac,
  0x47d9d99e, 0x13f3f3e0, 0x7c3e3e42, 0x9db4b429,
  0xa1aaaa0b, 0x4ddcdc91, 0x5fd5d58a, 0x0c06060a,
  0x75c0c0b5, 0xfc7e7e82, 0x19f6f6ef, 0xcc6666aa,
  0xd86c6cb4, 0xfd848479, 0xe2717193, 0x70383848,
  0x87b9b93e, 0x3a1d1d27, 0xfe7f7f81, 0xcf9d9d52,
  0x904848d8, 0xe38b8b68, 0x542a2a7e, 0x41dada9b,
  0xbfa5a51a, 0x66333355, 0xf1828273, 0x7239394b,
  0x59d6d68f, 0xf0787888, 0xf986867f, 0x01fafafb,
  0x3de4e4d9, 0x562b2b7d, 0xa7a9a90e, 0x3c1e1e22,
  0xe789896e, 0xc06060a0, 0xd66b6bbd, 0x21eaeacb,
  0xaa5555ff, 0x984c4cd4, 0x1bf7f7ec, 0x31e2e2d3,

  0x2697b1b1, 0xa769cece, 0xb073c3c3, 0x4adf9595,
  0xeeb45a5a, 0x02afadad, 0xdc3be7e7, 0x06040202,
  0xd79a4d4d, 0xcc884444, 0xf803fbfb, 0x46d79191,
  0x14180c0c, 0x7cfb8787, 0x16b7a1a1, 0xf0a05050,
  0xa863cbcb, 0xa9ce6767, 0xfca85454, 0x924fdddd,
  0xca8c4646, 0x64eb8f8f, 0xd637e1e1, 0xd29c4e4e,
  0xe515f0f0, 0xf20ffdfd, 0xf10dfcfc, 0xc823ebeb,
  0xfe07f9f9, 0xb97dc4c4, 0x2e341a1a, 0xb2dc6e6e,
  0xe2bc5e5e, 0xea1ff5f5, 0xa16dcccc, 0x62ef8d8d,
  0x24381c1c, 0xfaac5656, 0xc5864343, 0xf709fefe,
  0x090e0707, 0xa3c26161, 0xfd05f8f8, 0x9fea7575,
  0xebb25959, 0xf40bffff, 0x05060303, 0x66442222,
  0x6be18a8a, 0x8657d1d1, 0x35261313, 0xc729eeee,
  0x6de58888, 0x00000000, 0x121c0e0e, 0x5c683434,
  0x3f2a1515, 0x75f58080, 0x49dd9494, 0xd033e3e3,
  0xc22feded, 0x2a9fb5b5, 0xf5a65353, 0x65462323,
  0xdd964b4b, 0xc98e4747, 0x392e1717, 0x1cbba7a7,
  0x45d59090, 0x5f6a3535, 0x08a3abab, 0x9d45d8d8,
  0x3d85b8b8, 0x944bdfdf, 0xd19e4f4f, 0xf9ae5757,
  0x5bc19a9a, 0x43d19292, 0x9843dbdb, 0x2d361b1b,
  0x44783c3c, 0xad65c8c8, 0x5ec79999, 0x0c080404,
  0x67e98e8e, 0xd535e0e0, 0x8c5bd7d7, 0x87fa7d7d,
  0x7aff8585, 0x3883bbbb, 0xc0804040, 0x74582c2c,
  0x4e743a3a, 0xcf8a4545, 0xe617f1f1, 0xc6844242,
  0xafca6565, 0x60402020, 0xc3824141, 0x28301818,
  0x96e47272, 0x6f4a2525, 0x40d39393, 0x90e07070,
  0x5a6c3636, 0x0f0a0505, 0xe311f2f2, 0x1d160b0b,
  0x10b3a3a3, 0x8bf27979, 0xc12decec, 0x18100808,
  0x694e2727, 0x53623131, 0x56643232, 0x2f99b6b6,
  0x84f87c7c, 0x2595b0b0, 0x1e140a0a, 0x95e67373,
  0xedb65b5b, 0x8df67b7b, 0x2c9bb7b7, 0x76f78181,
  0x8351d2d2, 0x171a0d0d, 0xbed46a6a, 0x6a4c2626,
  0x57c99e9e, 0xe8b05858, 0x51cd9c9c, 0x70f38383,
  0x9ce87474, 0x2093b3b3, 0x01adacac, 0x50603030,
  0x8ef47a7a, 0xbbd26969, 0x99ee7777, 0x111e0f0f,
  0x07a9aeae, 0x63422121, 0x9749dede, 0x8555d0d0,
  0x725c2e2e, 0x4cdb9797, 0x30201010, 0x19bda4a4,
  0x5dc59898, 0x0da5a8a8, 0x895dd4d4, 0xb8d06868,
  0x775a2d2d, 0xa6c46262, 0x7b522929, 0xb7da6d6d,
  0x3a2c1616, 0xdb924949, 0x9aec7676, 0xbc7bc7c7,
  0xcd25e8e8, 0xb677c1c1, 0x4fd99696, 0x596e3737,
  0xda3fe5e5, 0xab61caca, 0xe91df4f4, 0xce27e9e9,
  0xa5c66363, 0x36241212, 0xb371c2c2, 0x1fb9a6a6,
  0x3c281414, 0x318dbcbc, 0x8053d3d3, 0x78502828,
  0x04abafaf, 0x715e2f2f, 0xdf39e6e6, 0x6c482424,
  0xf6a45252, 0xbf79c6c6, 0x15b5a0a0, 0x1b120909,
  0x328fbdbd, 0x61ed8c8c, 0xa46bcfcf, 0xe7ba5d5d,
  0x33221111, 0xe1be5f5f, 0x03020101, 0xba7fc5c5,
  0x54cb9f9f, 0x477a3d3d, 0x13b1a2a2, 0x58c39b9b,
  0xae67c9c9, 0x4d763b3b, 0x3789bebe, 0xf3a25151,
  0x2b321919, 0x213e1f1f, 0x417e3f3f, 0xe4b85c5c,
  0x2391b2b2, 0xc42befef, 0xde944a4a, 0xa26fcdcd,
  0x348bbfbf, 0x3b81baba, 0xb1de6f6f, 0xacc86464,
  0x9e47d9d9, 0xe013f3f3, 0x427c3e3e, 0x299db4b4,
  0x0ba1aaaa, 0x914ddcdc, 0x8a5fd5d5, 0x0a0c0606,
  0xb575c0c0, 0x82fc7e7e, 0xef19f6f6, 0xaacc6666,
  0xb4d86c6c, 0x79fd8484, 0x93e27171, 0x48703838,
  0x3e87b9b9, 0x273a1d1d, 0x81fe7f7f, 0x52cf9d9d,
  0xd8904848, 0x68e38b8b, 0x7e542a2a, 0x9b41dada,
  0x1abfa5a5, 0x55663333, 0x73f18282, 0x4b723939,
  0x8f59d6d6, 0x88f07878, 0x7ff98686, 0xfb01fafa,
  0xd93de4e4, 0x7d562b2b, 0x0ea7a9a9, 0x223c1e1e,
  0x6ee78989, 0xa0c06060, 0xbdd66b6b, 0xcb21eaea,
  0xffaa5555, 0xd4984c4c, 0xec1bf7f7, 0xd331e2e2,

  0xb12697b1, 0xcea769ce, 0xc3b073c3, 0x954adf95,
  0x5aeeb45a, 0xad02afad, 0xe7dc3be7, 0x02060402,
  0x4dd79a4d, 0x44cc8844, 0xfbf803fb, 0x9146d791,
  0x0c14180c, 0x877cfb87, 0xa116b7a1, 0x50f0a050,
  0xcba863cb, 0x67a9ce67, 0x54fca854, 0xdd924fdd,
  0x46ca8c46, 0x8f64eb8f, 0xe1d637e1, 0x4ed29c4e,
  0xf0e515f0, 0xfdf20ffd, 0xfcf10dfc, 0xebc823eb,
  0xf9fe07f9, 0xc4b97dc4, 0x1a2e341a, 0x6eb2dc6e,
  0x5ee2bc5e, 0xf5ea1ff5, 0xcca16dcc, 0x8d62ef8d,
  0x1c24381c, 0x56faac56, 0x43c58643, 0xfef709fe,
  0x07090e07, 0x61a3c261, 0xf8fd05f8, 0x759fea75,
  0x59ebb259, 0xfff40bff, 0x03050603, 0x22664422,
  0x8a6be18a, 0xd18657d1, 0x13352613, 0xeec729ee,
  0x886de588, 0x00000000, 0x0e121c0e, 0x345c6834,
  0x153f2a15, 0x8075f580, 0x9449dd94, 0xe3d033e3,
  0xedc22fed, 0xb52a9fb5, 0x53f5a653, 0x23654623,
  0x4bdd964b, 0x47c98e47, 0x17392e17, 0xa71cbba7,
  0x9045d590, 0x355f6a35, 0xab08a3ab, 0xd89d45d8,
  0xb83d85b8, 0xdf944bdf, 0x4fd19e4f, 0x57f9ae57,
  0x9a5bc19a, 0x9243d192, 0xdb9843db, 0x1b2d361b,
  0x3c44783c, 0xc8ad65c8, 0x995ec799, 0x040c0804,
  0x8e67e98e, 0xe0d535e0, 0xd78c5bd7, 0x7d87fa7d,
  0x857aff85, 0xbb3883bb, 0x40c08040, 0x2c74582c,
  0x3a4e743a, 0x45cf8a45, 0xf1e617f1, 0x42c68442,
  0x65afca65, 0x20604020, 0x41c38241, 0x18283018,
  0x7296e472, 0x256f4a25, 0x9340d393, 0x7090e070,
  0x365a6c36, 0x050f0a05, 0xf2e311f2, 0x0b1d160b,
  0xa310b3a3, 0x798bf279, 0xecc12dec, 0x08181008,
  0x27694e27, 0x31536231, 0x32566432, 0xb62f99b6,
  0x7c84f87c, 0xb02595b0, 0x0a1e140a, 0x7395e673,
  0x5bedb65b, 0x7b8df67b, 0xb72c9bb7, 0x8176f781,
  0xd28351d2, 0x0d171a0d, 0x6abed46a, 0x266a4c26,
  0x9e57c99e, 0x58e8b058, 0x9c51cd9c, 0x8370f383,
  0x749ce874, 0xb32093b3, 0xac01adac, 0x30506030,
  0x7a8ef47a, 0x69bbd269, 0x7799ee77, 0x0f111e0f,
  0xae07a9ae, 0x21634221, 0xde9749de, 0xd08555d0,
  0x2e725c2e, 0x974cdb97, 0x10302010, 0xa419bda4,
  0x985dc598, 0xa80da5a8, 0xd4895dd4, 0x68b8d068,
  0x2d775a2d, 0x62a6c462, 0x297b5229, 0x6db7da6d,
  0x163a2c16, 0x49db9249, 0x769aec76, 0xc7bc7bc7,
  0xe8cd25e8, 0xc1b677c1, 0x964fd996, 0x37596e37,
  0xe5da3fe5, 0xcaab61ca, 0xf4e91df4, 0xe9ce27e9,
  0x63a5c663, 0x12362412, 0xc2b371c2, 0xa61fb9a6,
  0x143c2814, 0xbc318dbc, 0xd38053d3, 0x28785028,
  0xaf04abaf, 0x2f715e2f, 0xe6df39e6, 0x246c4824,
  0x52f6a452, 0xc6bf79c6, 0xa015b5a0, 0x091b1209,
  0xbd328fbd, 0x8c61ed8c, 0xcfa46bcf, 0x5de7ba5d,
  0x11332211, 0x5fe1be5f, 0x01030201, 0xc5ba7fc5,
  0x9f54cb9f, 0x3d477a3d, 0xa213b1a2, 0x9b58c39b,
  0xc9ae67c9, 0x3b4d763b, 0xbe3789be, 0x51f3a251,
  0x192b3219, 0x1f213e1f, 0x3f417e3f, 0x5ce4b85c,
  0xb22391b2, 0xefc42bef, 0x4ade944a, 0xcda26fcd,
  0xbf348bbf, 0xba3b81ba, 0x6fb1de6f, 0x64acc864,
  0xd99e47d9, 0xf3e013f3, 0x3e427c3e, 0xb4299db4,
  0xaa0ba1aa, 0xdc914ddc, 0xd58a5fd5, 0x060a0c06,
  0xc0b575c0, 0x7e82fc7e, 0xf6ef19f6, 0x66aacc66,
  0x6cb4d86c, 0x8479fd84, 0x7193e271, 0x38487038,
  0xb93e87b9, 0x1d273a1d, 0x7f81fe7f, 0x9d52cf9d,
  0x48d89048, 0x8b68e38b, 0x2a7e542a, 0xda9b41da,
  0xa51abfa5, 0x33556633, 0x8273f182, 0x394b7239,
  0xd68f59d6, 0x7888f078, 0x867ff986, 0xfafb01fa,
  0xe4d93de4, 0x2b7d562b, 0xa90ea7a9, 0x1e223c1e,
  0x896ee789, 0x60a0c060, 0x6bbdd66b, 0xeacb21ea,
  0x55ffaa55, 0x4cd4984c, 0xf7ec1bf7, 0xe2d331e2,

  0xb1b12697, 0xcecea769, 0xc3c3b073, 0x95954adf,
  0x5a5aeeb4, 0xadad02af, 0xe7e7dc3b, 0x02020604,
  0x4d4dd79a, 0x4444cc88, 0xfbfbf803, 0x919146d7,
  0x0c0c1418, 0x87877cfb, 0xa1a116b7, 0x5050f0a0,
  0xcbcba863, 0x6767a9ce, 0x5454fca8, 0xdddd924f,
  0x4646ca8c, 0x8f8f64eb, 0xe1e1d637, 0x4e4ed29c,
  0xf0f0e515, 0xfdfdf20f, 0xfcfcf10d, 0xebebc823,
  0xf9f9fe07, 0xc4c4b97d, 0x1a1a2e34, 0x6e6eb2dc,
  0x5e5ee2bc, 0xf5f5ea1f, 0xcccca16d, 0x8d8d62ef,
  0x1c1c2438, 0x5656faac, 0x4343c586, 0xfefef709,
  0x0707090e, 0x6161a3c2, 0xf8f8fd05, 0x75759fea,
  0x5959ebb2, 0xfffff40b, 0x03030506, 0x22226644,
  0x8a8a6be1, 0xd1d18657, 0x13133526, 0xeeeec729,
  0x88886de5, 0x00000000, 0x0e0e121c, 0x34345c68,
  0x15153f2a, 0x808075f5, 0x949449dd, 0xe3e3d033,
  0xededc22f, 0xb5b52a9f, 0x5353f5a6, 0x23236546,
  0x4b4bdd96, 0x4747c98e, 0x1717392e, 0xa7a71cbb,
  0x909045d5, 0x35355f6a, 0xabab08a3, 0xd8d89d45,
  0xb8b83d85, 0xdfdf944b, 0x4f4fd19e, 0x5757f9ae,
  0x9a9a5bc1, 0x929243d1, 0xdbdb9843, 0x1b1b2d36,
  0x3c3c4478, 0xc8c8ad65, 0x99995ec7, 0x04040c08,
  0x8e8e67e9, 0xe0e0d535, 0xd7d78c5b, 0x7d7d87fa,
  0x85857aff, 0xbbbb3883, 0x4040c080, 0x2c2c7458,
  0x3a3a4e74, 0x4545cf8a, 0xf1f1e617, 0x4242c684,
  0x6565afca, 0x20206040, 0x4141c382, 0x18182830,
  0x727296e4, 0x25256f4a, 0x939340d3, 0x707090e0,
  0x36365a6c, 0x05050f0a, 0xf2f2e311, 0x0b0b1d16,
  0xa3a310b3, 0x79798bf2, 0xececc12d, 0x08081810,
  0x2727694e, 0x31315362, 0x32325664, 0xb6b62f99,
  0x7c7c84f8, 0xb0b02595, 0x0a0a1e14, 0x737395e6,
  0x5b5bedb6, 0x7b7b8df6, 0xb7b72c9b, 0x818176f7,
  0xd2d28351, 0x0d0d171a, 0x6a6abed4, 0x26266a4c,
  0x9e9e57c9, 0x5858e8b0, 0x9c9c51cd, 0x838370f3,
  0x74749ce8, 0xb3b32093, 0xacac01ad, 0x30305060,
  0x7a7a8ef4, 0x6969bbd2, 0x777799ee, 0x0f0f111e,
  0xaeae07a9, 0x21216342, 0xdede9749, 0xd0d08555,
  0x2e2e725c, 0x97974cdb, 0x10103020, 0xa4a419bd,
  0x98985dc5, 0xa8a80da5, 0xd4d4895d, 0x6868b8d0,
  0x2d2d775a, 0x6262a6c4, 0x29297b52, 0x6d6db7da,
  0x16163a2c, 0x4949db92, 0x76769aec, 0xc7c7bc7b,
  0xe8e8cd25, 0xc1c1b677, 0x96964fd9, 0x3737596e,
  0xe5e5da3f, 0xcacaab61, 0xf4f4e91d, 0xe9e9ce27,
  0x6363a5c6, 0x12123624, 0xc2c2b371, 0xa6a61fb9,
  0x14143c28, 0xbcbc318d, 0xd3d38053, 0x28287850,
  0xafaf04ab, 0x2f2f715e, 0xe6e6df39, 0x24246c48,
  0x5252f6a4, 0xc6c6bf79, 0xa0a015b5, 0x09091b12,
  0xbdbd328f, 0x8c8c61ed, 0xcfcfa46b, 0x5d5de7ba,
  0x11113322, 0x5f5fe1be, 0x01010302, 0xc5c5ba7f,
  0x9f9f54cb, 0x3d3d477a, 0xa2a213b1, 0x9b9b58c3,
  0xc9c9ae67, 0x3b3b4d76, 0xbebe3789, 0x5151f3a2,
  0x19192b32, 0x1f1f213e, 0x3f3f417e, 0x5c5ce4b8,
  0xb2b22391, 0xefefc42b, 0x4a4ade94, 0xcdcda26f,
  0xbfbf348b, 0xbaba3b81, 0x6f6fb1de, 0x6464acc8,
  0xd9d99e47, 0xf3f3e013, 0x3e3e427c, 0xb4b4299d,
  0xaaaa0ba1, 0xdcdc914d, 0xd5d58a5f, 0x06060a0c,
  0xc0c0b575, 0x7e7e82fc, 0xf6f6ef19, 0x6666aacc,
  0x6c6cb4d8, 0x848479fd, 0x717193e2, 0x38384870,
  0xb9b93e87, 0x1d1d273a, 0x7f7f81fe, 0x9d9d52cf,
  0x4848d890, 0x8b8b68e3, 0x2a2a7e54, 0xdada9b41,
  0xa5a51abf, 0x33335566, 0x828273f1, 0x39394b72,
  0xd6d68f59, 0x787888f0, 0x86867ff9, 0xfafafb01,
  0xe4e4d93d, 0x2b2b7d56, 0xa9a90ea7, 0x1e1e223c,
  0x89896ee7, 0x6060a0c0, 0x6b6bbdd6, 0xeaeacb21,
  0x5555ffaa, 0x4c4cd498, 0xf7f7ec1b, 0xe2e2d331,
};

static const word32 Square_Td[4*256] =
{
  0xe368bc02, 0x5585620c, 0x2a3f2331, 0x61ab13f7,
  0x98d46d72, 0x21cb9a19, 0x3c22a461, 0x459d3dcd,
  0x05fdb423, 0x2bc4075f, 0x9b2c01c0, 0x3dd9800f,
  0x486c5c74, 0xf97f7e85, 0xf173ab1f, 0xb6edde0e,
  0x283c6bed, 0x4997781a, 0x9f2a918d, 0xc9579f33,
  0xa907a8aa, 0xa50ded7d, 0x7c422d8f, 0x764db0c9,
  0x4d91e857, 0xcea963cc, 0xb4ee96d2, 0x3028e1b6,
  0x0df161b9, 0xbd196726, 0x419bad80, 0xc0a06ec7,
  0x5183f241, 0x92dbf034, 0x6fa21efc, 0x8f32ce4c,
  0x13e03373, 0x69a7c66d, 0xe56d6493, 0xbf1a2ffa,
  0xbb1cbfb7, 0x587403b5, 0xe76e2c4f, 0x5d89b796,
  0xe89c052a, 0x446619a3, 0x342e71fb, 0x0ff22965,
  0xfe81827a, 0xb11322f1, 0xa30835ec, 0xcd510f7e,
  0xff7aa614, 0x5c7293f8, 0x2fc29712, 0xf370e3c3,
  0x992f491c, 0xd1431568, 0xc2a3261b, 0x88cc32b3,
  0x8acf7a6f, 0xb0e8069f, 0x7a47f51e, 0xd2bb79da,
  0xe6950821, 0x4398e55c, 0xd0b83106, 0x11e37baf,
  0x7e416553, 0xccaa2b10, 0xd8b4e49c, 0x6456a7d4,
  0xfb7c3659, 0x724b2084, 0xea9f4df6, 0x6a5faadf,
  0x2dc1dfce, 0x70486858, 0xcaaff381, 0x0605d891,
  0x5a774b69, 0x94de28a5, 0x39df1042, 0x813bc347,
  0xfc82caa6, 0x23c8d2c5, 0x03f86cb2, 0x080cd59a,
  0xdab7ac40, 0x7db909e1, 0x3824342c, 0xcf5247a2,
  0xdcb274d1, 0x63a85b2b, 0x35d55595, 0x479e7511,
  0x15e5ebe2, 0x4b9430c6, 0x4a6f14a8, 0x91239c86,
  0x4c6acc39, 0x5f8aff4a, 0x0406904d, 0xee99ddbb,
  0x1e1152ca, 0xaaffc418, 0xeb646998, 0x07fefcff,
  0x8b345e01, 0x567d0ebe, 0xbae79bd9, 0x4263c132,
  0x75b5dc7b, 0x97264417, 0x67aecb66, 0x95250ccb,
  0xec9a9567, 0x57862ad0, 0x60503799, 0xb8e4d305,
  0x65ad83ba, 0x19efae35, 0xa4f6c913, 0xc15b4aa9,
  0x873e1bd6, 0xa0f0595e, 0x18148a5b, 0xaf02703b,
  0xab04e076, 0xdd4950bf, 0xdf4a1863, 0xc6a5b656,
  0x853d530a, 0xfa871237, 0x77b694a7, 0x4665517f,
  0xed61b109, 0x1bece6e9, 0xd5458525, 0xf5753b52,
  0x7fba413d, 0x27ce4288, 0xb2eb4e43, 0xd6bde997,
  0x527b9ef3, 0x62537f45, 0x2c3afba0, 0x7bbcd170,
  0xb91ff76b, 0x121b171d, 0xfd79eec8, 0x3a277cf0,
  0x0c0a45d7, 0x96dd6079, 0x2233f6ab, 0xacfa1c89,
  0xc8acbb5d, 0xa10b7d30, 0xd4bea14b, 0xbee10b94,
  0x25cd0a54, 0x547e4662, 0xa2f31182, 0x17e6a33e,
  0x263566e6, 0xc3580275, 0x83388b9b, 0x7844bdc2,
  0x020348dc, 0x4f92a08b, 0x2e39b37c, 0x4e6984e5,
  0xf0888f71, 0x362d3927, 0x9cd2fd3f, 0x01fb246e,
  0x893716dd, 0x00000000, 0xf68d57e0, 0xe293986c,
  0x744ef815, 0x9320d45a, 0xad0138e7, 0xd3405db4,
  0x1a17c287, 0xb3106a2d, 0x5078d62f, 0xf48e1f3c,
  0xa70ea5a1, 0x71b34c36, 0x9ad725ae, 0x5e71db24,
  0x161d8750, 0xef62f9d5, 0x8d318690, 0x1c121a16,
  0xa6f581cf, 0x5b8c6f07, 0x37d61d49, 0x6e593a92,
  0x84c67764, 0x86c53fb8, 0xd746cdf9, 0xe090d0b0,
  0x29c74f83, 0xe49640fd, 0x0e090d0b, 0x6da15620,
  0x8ec9ea22, 0xdb4c882e, 0xf776738e, 0xb515b2bc,
  0x10185fc1, 0x322ba96a, 0x6ba48eb1, 0xaef95455,
  0x406089ee, 0x6655ef08, 0xe9672144, 0x3e21ecbd,
  0x2030be77, 0xf28bc7ad, 0x80c0e729, 0x141ecf8c,
  0xbce24348, 0xc4a6fe8a, 0x31d3c5d8, 0xb716fa60,
  0x5380ba9d, 0xd94fc0f2, 0x1de93e78, 0x24362e3a,
  0xe16bf4de, 0xcb54d7ef, 0x09f7f1f4, 0x82c3aff5,
  0x0bf4b928, 0x9d29d951, 0xc75e9238, 0xf8845aeb,
  0x90d8b8e8, 0xdeb13c0d, 0x33d08d04, 0x685ce203,
  0xc55ddae4, 0x3bdc589e, 0x0a0f9d46, 0x3fdac8d3,
  0x598f27db, 0xa8fc8cc4, 0x79bf99ac, 0x6c5a724e,
  0x8ccaa2fe, 0x9ed1b5e3, 0x1fea76a4, 0x73b004ea,

  0x02e368bc, 0x0c558562, 0x312a3f23, 0xf761ab13,
  0x7298d46d, 0x1921cb9a, 0x613c22a4, 0xcd459d3d,
  0x2305fdb4, 0x5f2bc407, 0xc09b2c01, 0x0f3dd980,
  0x74486c5c, 0x85f97f7e, 0x1ff173ab, 0x0eb6edde,
  0xed283c6b, 0x1a499778, 0x8d9f2a91, 0x33c9579f,
  0xaaa907a8, 0x7da50ded, 0x8f7c422d, 0xc9764db0,
  0x574d91e8, 0xcccea963, 0xd2b4ee96, 0xb63028e1,
  0xb90df161, 0x26bd1967, 0x80419bad, 0xc7c0a06e,
  0x415183f2, 0x3492dbf0, 0xfc6fa21e, 0x4c8f32ce,
  0x7313e033, 0x6d69a7c6, 0x93e56d64, 0xfabf1a2f,
  0xb7bb1cbf, 0xb5587403, 0x4fe76e2c, 0x965d89b7,
  0x2ae89c05, 0xa3446619, 0xfb342e71, 0x650ff229,
  0x7afe8182, 0xf1b11322, 0xeca30835, 0x7ecd510f,
  0x14ff7aa6, 0xf85c7293, 0x122fc297, 0xc3f370e3,
  0x1c992f49, 0x68d14315, 0x1bc2a326, 0xb388cc32,
  0x6f8acf7a, 0x9fb0e806, 0x1e7a47f5, 0xdad2bb79,
  0x21e69508, 0x5c4398e5, 0x06d0b831, 0xaf11e37b,
  0x537e4165, 0x10ccaa2b, 0x9cd8b4e4, 0xd46456a7,
  0x59fb7c36, 0x84724b20, 0xf6ea9f4d, 0xdf6a5faa,
  0xce2dc1df, 0x58704868, 0x81caaff3, 0x910605d8,
  0x695a774b, 0xa594de28, 0x4239df10, 0x47813bc3,
  0xa6fc82ca, 0xc523c8d2, 0xb203f86c, 0x9a080cd5,
  0x40dab7ac, 0xe17db909, 0x2c382434, 0xa2cf5247,
  0xd1dcb274, 0x2b63a85b, 0x9535d555, 0x11479e75,
  0xe215e5eb, 0xc64b9430, 0xa84a6f14, 0x8691239c,
  0x394c6acc, 0x4a5f8aff, 0x4d040690, 0xbbee99dd,
  0xca1e1152, 0x18aaffc4, 0x98eb6469, 0xff07fefc,
  0x018b345e, 0xbe567d0e, 0xd9bae79b, 0x324263c1,
  0x7b75b5dc, 0x17972644, 0x6667aecb, 0xcb95250c,
  0x67ec9a95, 0xd057862a, 0x99605037, 0x05b8e4d3,
  0xba65ad83, 0x3519efae, 0x13a4f6c9, 0xa9c15b4a,
  0xd6873e1b, 0x5ea0f059, 0x5b18148a, 0x3baf0270,
  0x76ab04e0, 0xbfdd4950, 0x63df4a18, 0x56c6a5b6,
  0x0a853d53, 0x37fa8712, 0xa777b694, 0x7f466551,
  0x09ed61b1, 0xe91bece6, 0x25d54585, 0x52f5753b,
  0x3d7fba41, 0x8827ce42, 0x43b2eb4e, 0x97d6bde9,
  0xf3527b9e, 0x4562537f, 0xa02c3afb, 0x707bbcd1,
  0x6bb91ff7, 0x1d121b17, 0xc8fd79ee, 0xf03a277c,
  0xd70c0a45, 0x7996dd60, 0xab2233f6, 0x89acfa1c,
  0x5dc8acbb, 0x30a10b7d, 0x4bd4bea1, 0x94bee10b,
  0x5425cd0a, 0x62547e46, 0x82a2f311, 0x3e17e6a3,
  0xe6263566, 0x75c35802, 0x9b83388b, 0xc27844bd,
  0xdc020348, 0x8b4f92a0, 0x7c2e39b3, 0xe54e6984,
  0x71f0888f, 0x27362d39, 0x3f9cd2fd, 0x6e01fb24,
  0xdd893716, 0x00000000, 0xe0f68d57, 0x6ce29398,
  0x15744ef8, 0x5a9320d4, 0xe7ad0138, 0xb4d3405d,
  0x871a17c2, 0x2db3106a, 0x2f5078d6, 0x3cf48e1f,
  0xa1a70ea5, 0x3671b34c, 0xae9ad725, 0x245e71db,
  0x50161d87, 0xd5ef62f9, 0x908d3186, 0x161c121a,
  0xcfa6f581, 0x075b8c6f, 0x4937d61d, 0x926e593a,
  0x6484c677, 0xb886c53f, 0xf9d746cd, 0xb0e090d0,
  0x8329c74f, 0xfde49640, 0x0b0e090d, 0x206da156,
  0x228ec9ea, 0x2edb4c88, 0x8ef77673, 0xbcb515b2,
  0xc110185f, 0x6a322ba9, 0xb16ba48e, 0x55aef954,
  0xee406089, 0x086655ef, 0x44e96721, 0xbd3e21ec,
  0x772030be, 0xadf28bc7, 0x2980c0e7, 0x8c141ecf,
  0x48bce243, 0x8ac4a6fe, 0xd831d3c5, 0x60b716fa,
  0x9d5380ba, 0xf2d94fc0, 0x781de93e, 0x3a24362e,
  0xdee16bf4, 0xefcb54d7, 0xf409f7f1, 0xf582c3af,
  0x280bf4b9, 0x519d29d9, 0x38c75e92, 0xebf8845a,
  0xe890d8b8, 0x0ddeb13c, 0x0433d08d, 0x03685ce2,
  0xe4c55dda, 0x9e3bdc58, 0x460a0f9d, 0xd33fdac8,
  0xdb598f27, 0xc4a8fc8c, 0xac79bf99, 0x4e6c5a72,
  0xfe8ccaa2, 0xe39ed1b5, 0xa41fea76, 0xea73b004,

  0xbc02e368, 0x620c5585, 0x23312a3f, 0x13f761ab,
  0x6d7298d4, 0x9a1921cb, 0xa4613c22, 0x3dcd459d,
  0xb42305fd, 0x075f2bc4, 0x01c09b2c, 0x800f3dd9,
  0x5c74486c, 0x7e85f97f, 0xab1ff173, 0xde0eb6ed,
  0x6bed283c, 0x781a4997, 0x918d9f2a, 0x9f33c957,
  0xa8aaa907, 0xed7da50d, 0x2d8f7c42, 0xb0c9764d,
  0xe8574d91, 0x63cccea9, 0x96d2b4ee, 0xe1b63028,
  0x61b90df1, 0x6726bd19, 0xad80419b, 0x6ec7c0a0,
  0xf2415183, 0xf03492db, 0x1efc6fa2, 0xce4c8f32,
  0x337313e0, 0xc66d69a7, 0x6493e56d, 0x2ffabf1a,
  0xbfb7bb1c, 0x03b55874, 0x2c4fe76e, 0xb7965d89,
  0x052ae89c, 0x19a34466, 0x71fb342e, 0x29650ff2,
  0x827afe81, 0x22f1b113, 0x35eca308, 0x0f7ecd51,
  0xa614ff7a, 0x93f85c72, 0x97122fc2, 0xe3c3f370,
  0x491c992f, 0x1568d143, 0x261bc2a3, 0x32b388cc,
  0x7a6f8acf, 0x069fb0e8, 0xf51e7a47, 0x79dad2bb,
  0x0821e695, 0xe55c4398, 0x3106d0b8, 0x7baf11e3,
  0x65537e41, 0x2b10ccaa, 0xe49cd8b4, 0xa7d46456,
  0x3659fb7c, 0x2084724b, 0x4df6ea9f, 0xaadf6a5f,
  0xdfce2dc1, 0x68587048, 0xf381caaf, 0xd8910605,
  0x4b695a77, 0x28a594de, 0x104239df, 0xc347813b,
  0xcaa6fc82, 0xd2c523c8, 0x6cb203f8, 0xd59a080c,
  0xac40dab7, 0x09e17db9, 0x342c3824, 0x47a2cf52,
  0x74d1dcb2, 0x5b2b63a8, 0x559535d5, 0x7511479e,
  0xebe215e5, 0x30c64b94, 0x14a84a6f, 0x9c869123,
  0xcc394c6a, 0xff4a5f8a, 0x904d0406, 0xddbbee99,
  0x52ca1e11, 0xc418aaff, 0x6998eb64, 0xfcff07fe,
  0x5e018b34, 0x0ebe567d, 0x9bd9bae7, 0xc1324263,
  0xdc7b75b5, 0x44179726, 0xcb6667ae, 0x0ccb9525,
  0x9567ec9a, 0x2ad05786, 0x37996050, 0xd305b8e4,
  0x83ba65ad, 0xae3519ef, 0xc913a4f6, 0x4aa9c15b,
  0x1bd6873e, 0x595ea0f0, 0x8a5b1814, 0x703baf02,
  0xe076ab04, 0x50bfdd49, 0x1863df4a, 0xb656c6a5,
  0x530a853d, 0x1237fa87, 0x94a777b6, 0x517f4665,
  0xb109ed61, 0xe6e91bec, 0x8525d545, 0x3b52f575,
  0x413d7fba, 0x428827ce, 0x4e43b2eb, 0xe997d6bd,
  0x9ef3527b, 0x7f456253, 0xfba02c3a, 0xd1707bbc,
  0xf76bb91f, 0x171d121b, 0xeec8fd79, 0x7cf03a27,
  0x45d70c0a, 0x607996dd, 0xf6ab2233, 0x1c89acfa,
  0xbb5dc8ac, 0x7d30a10b, 0xa14bd4be, 0x0b94bee1,
  0x0a5425cd, 0x4662547e, 0x1182a2f3, 0xa33e17e6,
  0x66e62635, 0x0275c358, 0x8b9b8338, 0xbdc27844,
  0x48dc0203, 0xa08b4f92, 0xb37c2e39, 0x84e54e69,
  0x8f71f088, 0x3927362d, 0xfd3f9cd2, 0x246e01fb,
  0x16dd8937, 0x00000000, 0x57e0f68d, 0x986ce293,
  0xf815744e, 0xd45a9320, 0x38e7ad01, 0x5db4d340,
  0xc2871a17, 0x6a2db310, 0xd62f5078, 0x1f3cf48e,
  0xa5a1a70e, 0x4c3671b3, 0x25ae9ad7, 0xdb245e71,
  0x8750161d, 0xf9d5ef62, 0x86908d31, 0x1a161c12,
  0x81cfa6f5, 0x6f075b8c, 0x1d4937d6, 0x3a926e59,
  0x776484c6, 0x3fb886c5, 0xcdf9d746, 0xd0b0e090,
  0x4f8329c7, 0x40fde496, 0x0d0b0e09, 0x56206da1,
  0xea228ec9, 0x882edb4c, 0x738ef776, 0xb2bcb515,
  0x5fc11018, 0xa96a322b, 0x8eb16ba4, 0x5455aef9,
  0x89ee4060, 0xef086655, 0x2144e967, 0xecbd3e21,
  0xbe772030, 0xc7adf28b, 0xe72980c0, 0xcf8c141e,
  0x4348bce2, 0xfe8ac4a6, 0xc5d831d3, 0xfa60b716,
  0xba9d5380, 0xc0f2d94f, 0x3e781de9, 0x2e3a2436,
  0xf4dee16b, 0xd7efcb54, 0xf1f409f7, 0xaff582c3,
  0xb9280bf4, 0xd9519d29, 0x9238c75e, 0x5aebf884,
  0xb8e890d8, 0x3c0ddeb1, 0x8d0433d0, 0xe203685c,
  0xdae4c55d, 0x589e3bdc, 0x9d460a0f, 0xc8d33fda,
  0x27db598f, 0x8cc4a8fc, 0x99ac79bf, 0x724e6c5a,
  0xa2fe8cca, 0xb5e39ed1, 0x76a41fea, 0x04ea73b0,

  0x68bc02e3, 0x85620c55, 0x3f23312a, 0xab13f761,
  0xd46d7298, 0xcb9a1921, 0x22a4613c, 0x9d3dcd45,
  0xfdb42305, 0xc4075f2b, 0x2c01c09b, 0xd9800f3d,
  0x6c5c7448, 0x7f7e85f9, 0x73ab1ff1, 0xedde0eb6,
  0x3c6bed28, 0x97781a49, 0x2a918d9f, 0x579f33c9,
  0x07a8aaa9, 0x0ded7da5, 0x422d8f7c, 0x4db0c976,
  0x91e8574d, 0xa963ccce, 0xee96d2b4, 0x28e1b630,
  0xf161b90d, 0x196726bd, 0x9bad8041, 0xa06ec7c0,
  0x83f24151, 0xdbf03492, 0xa21efc6f, 0x32ce4c8f,
  0xe0337313, 0xa7c66d69, 0x6d6493e5, 0x1a2ffabf,
  0x1cbfb7bb, 0x7403b558, 0x6e2c4fe7, 0x89b7965d,
  0x9c052ae8, 0x6619a344, 0x2e71fb34, 0xf229650f,
  0x81827afe, 0x1322f1b1, 0x0835eca3, 0x510f7ecd,
  0x7aa614ff, 0x7293f85c, 0xc297122f, 0x70e3c3f3,
  0x2f491c99, 0x431568d1, 0xa3261bc2, 0xcc32b388,
  0xcf7a6f8a, 0xe8069fb0, 0x47f51e7a, 0xbb79dad2,
  0x950821e6, 0x98e55c43, 0xb83106d0, 0xe37baf11,
  0x4165537e, 0xaa2b10cc, 0xb4e49cd8, 0x56a7d464,
  0x7c3659fb, 0x4b208472, 0x9f4df6ea, 0x5faadf6a,
  0xc1dfce2d, 0x48685870, 0xaff381ca, 0x05d89106,
  0x774b695a, 0xde28a594, 0xdf104239, 0x3bc34781,
  0x82caa6fc, 0xc8d2c523, 0xf86cb203, 0x0cd59a08,
  0xb7ac40da, 0xb909e17d, 0x24342c38, 0x5247a2cf,
  0xb274d1dc, 0xa85b2b63, 0xd5559535, 0x9e751147,
  0xe5ebe215, 0x9430c64b, 0x6f14a84a, 0x239c8691,
  0x6acc394c, 0x8aff4a5f, 0x06904d04, 0x99ddbbee,
  0x1152ca1e, 0xffc418aa, 0x646998eb, 0xfefcff07,
  0x345e018b, 0x7d0ebe56, 0xe79bd9ba, 0x63c13242,
  0xb5dc7b75, 0x26441797, 0xaecb6667, 0x250ccb95,
  0x9a9567ec, 0x862ad057, 0x50379960, 0xe4d305b8,
  0xad83ba65, 0xefae3519, 0xf6c913a4, 0x5b4aa9c1,
  0x3e1bd687, 0xf0595ea0, 0x148a5b18, 0x02703baf,
  0x04e076ab, 0x4950bfdd, 0x4a1863df, 0xa5b656c6,
  0x3d530a85, 0x871237fa, 0xb694a777, 0x65517f46,
  0x61b109ed, 0xece6e91b, 0x458525d5, 0x753b52f5,
  0xba413d7f, 0xce428827, 0xeb4e43b2, 0xbde997d6,
  0x7b9ef352, 0x537f4562, 0x3afba02c, 0xbcd1707b,
  0x1ff76bb9, 0x1b171d12, 0x79eec8fd, 0x277cf03a,
  0x0a45d70c, 0xdd607996, 0x33f6ab22, 0xfa1c89ac,
  0xacbb5dc8, 0x0b7d30a1, 0xbea14bd4, 0xe10b94be,
  0xcd0a5425, 0x7e466254, 0xf31182a2, 0xe6a33e17,
  0x3566e626, 0x580275c3, 0x388b9b83, 0x44bdc278,
  0x0348dc02, 0x92a08b4f, 0x39b37c2e, 0x6984e54e,
  0x888f71f0, 0x2d392736, 0xd2fd3f9c, 0xfb246e01,
  0x3716dd89, 0x00000000, 0x8d57e0f6, 0x93986ce2,
  0x4ef81574, 0x20d45a93, 0x0138e7ad, 0x405db4d3,
  0x17c2871a, 0x106a2db3, 0x78d62f50, 0x8e1f3cf4,
  0x0ea5a1a7, 0xb34c3671, 0xd725ae9a, 0x71db245e,
  0x1d875016, 0x62f9d5ef, 0x3186908d, 0x121a161c,
  0xf581cfa6, 0x8c6f075b, 0xd61d4937, 0x593a926e,
  0xc6776484, 0xc53fb886, 0x46cdf9d7, 0x90d0b0e0,
  0xc74f8329, 0x9640fde4, 0x090d0b0e, 0xa156206d,
  0xc9ea228e, 0x4c882edb, 0x76738ef7, 0x15b2bcb5,
  0x185fc110, 0x2ba96a32, 0xa48eb16b, 0xf95455ae,
  0x6089ee40, 0x55ef0866, 0x672144e9, 0x21ecbd3e,
  0x30be7720, 0x8bc7adf2, 0xc0e72980, 0x1ecf8c14,
  0xe24348bc, 0xa6fe8ac4, 0xd3c5d831, 0x16fa60b7,
  0x80ba9d53, 0x4fc0f2d9, 0xe93e781d, 0x362e3a24,
  0x6bf4dee1, 0x54d7efcb, 0xf7f1f409, 0xc3aff582,
  0xf4b9280b, 0x29d9519d, 0x5e9238c7, 0x845aebf8,
  0xd8b8e890, 0xb13c0dde, 0xd08d0433, 0x5ce20368,
  0x5ddae4c5, 0xdc589e3b, 0x0f9d460a, 0xdac8d33f,
  0x8f27db59, 0xfc8cc4a8, 0xbf99ac79, 0x5a724e6c,
  0xcaa2fe8c, 0xd1b5e39e, 0xea76a41f, 0xb004ea73,
};
//-----------------
static const byte SKIPJACK_fTable[256] =
{
  0xa3,0xd7,0x09,0x83,0xf8,0x48,0xf6,0xf4,0xb3,0x21,0x15,0x78,0x99,0xb1,0xaf,0xf9,
  0xe7,0x2d,0x4d,0x8a,0xce,0x4c,0xca,0x2e,0x52,0x95,0xd9,0x1e,0x4e,0x38,0x44,0x28,
  0x0a,0xdf,0x02,0xa0,0x17,0xf1,0x60,0x68,0x12,0xb7,0x7a,0xc3,0xe9,0xfa,0x3d,0x53,
  0x96,0x84,0x6b,0xba,0xf2,0x63,0x9a,0x19,0x7c,0xae,0xe5,0xf5,0xf7,0x16,0x6a,0xa2,
  0x39,0xb6,0x7b,0x0f,0xc1,0x93,0x81,0x1b,0xee,0xb4,0x1a,0xea,0xd0,0x91,0x2f,0xb8,
  0x55,0xb9,0xda,0x85,0x3f,0x41,0xbf,0xe0,0x5a,0x58,0x80,0x5f,0x66,0x0b,0xd8,0x90,
  0x35,0xd5,0xc0,0xa7,0x33,0x06,0x65,0x69,0x45,0x00,0x94,0x56,0x6d,0x98,0x9b,0x76,
  0x97,0xfc,0xb2,0xc2,0xb0,0xfe,0xdb,0x20,0xe1,0xeb,0xd6,0xe4,0xdd,0x47,0x4a,0x1d,
  0x42,0xed,0x9e,0x6e,0x49,0x3c,0xcd,0x43,0x27,0xd2,0x07,0xd4,0xde,0xc7,0x67,0x18,
  0x89,0xcb,0x30,0x1f,0x8d,0xc6,0x8f,0xaa,0xc8,0x74,0xdc,0xc9,0x5d,0x5c,0x31,0xa4,
  0x70,0x88,0x61,0x2c,0x9f,0x0d,0x2b,0x87,0x50,0x82,0x54,0x64,0x26,0x7d,0x03,0x40,
  0x34,0x4b,0x1c,0x73,0xd1,0xc4,0xfd,0x3b,0xcc,0xfb,0x7f,0xab,0xe6,0x3e,0x5b,0xa5,
  0xad,0x04,0x23,0x9c,0x14,0x51,0x22,0xf0,0x29,0x79,0x71,0x7e,0xff,0x8c,0x0e,0xe2,
  0x0c,0xef,0xbc,0x72,0x75,0x6f,0x37,0xa1,0xec,0xd3,0x8e,0x62,0x8b,0x86,0x10,0xe8,
  0x08,0x77,0x11,0xbe,0x92,0x4f,0x24,0xc5,0x32,0x36,0x9d,0xcf,0xf3,0xa6,0xbb,0xac,
  0x5e,0x6c,0xa9,0x13,0x57,0x25,0xb5,0xe3,0xbd,0xa8,0x3a,0x01,0x05,0x59,0x2a,0x46
};
//-----------------
static const byte Square_Se_or_SHARK_enc_sbox[256] =
{
  177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12, 135, 161,  80,
  203, 103,  84, 221,  70, 143, 225,  78, 240, 253, 252, 235, 249, 196,  26, 110,
   94, 245, 204, 141,  28,  86,  67, 254,   7,  97, 248, 117,  89, 255,   3,  34,
  138, 209,  19, 238, 136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35,
   75,  71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146, 219,  27,
   60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,  44,  58,  69, 241,  66,
  101,  32,  65,  24, 114,  37, 147, 112,  54,   5, 242,  11, 163, 121, 236,   8,
   39,  49,  50, 182, 124, 176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38,
  158,  88, 156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222, 208,
   46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,  22,  73, 118, 199,
  232, 193, 150,  55, 229, 202, 244, 233,  99,  18, 194, 166,  20, 188, 211,  40,
  175,  47, 230,  36,  82, 198, 160,   9, 189, 140, 207,  93,  17,  95,   1, 197,
  159,  61, 162, 155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205,
  191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192, 126, 246, 102,
  108, 132, 113,  56, 185,  29, 127, 157,  72, 139,  42, 218, 165,  51, 130,  57,
  214, 120, 134, 250, 228,  43, 169,  30, 137,  96, 107, 234,  85,  76, 247, 226,
};

static const byte Square_Sd_or_SHARK_dec_sbox[256] =
{
   53, 190,   7,  46,  83, 105, 219,  40, 111, 183, 118, 107,  12, 125,  54, 139,
  146, 188, 169,  50, 172,  56, 156,  66,  99, 200,  30,  79,  36, 229, 247, 201,
   97, 141,  47,  63, 179, 101, 127, 112, 175, 154, 234, 245,  91, 152, 144, 177,
  135, 113, 114, 237,  55,  69, 104, 163, 227, 239,  92, 197,  80, 193, 214, 202,
   90,  98,  95,  38,   9,  93,  20,  65, 232, 157, 206,  64, 253,   8,  23,  74,
   15, 199, 180,  62,  18, 252,  37,  75, 129,  44,   4, 120, 203, 187,  32, 189,
  249,  41, 153, 168, 211,  96, 223,  17, 151, 137, 126, 250, 224, 155,  31, 210,
  103, 226, 100, 119, 132,  43, 158, 138, 241, 109, 136, 121, 116,  87, 221, 230,
   57, 123, 238, 131, 225,  88, 242,  13,  52, 248,  48, 233, 185,  35,  84,  21,
   68,  11,  77, 102,  58,   3, 162, 145, 148,  82,  76, 195, 130, 231, 128, 192,
  182,  14, 194, 108, 147, 236, 171,  67, 149, 246, 216,  70, 134,   5, 140, 176,
  117,   0, 204, 133, 215,  61, 115, 122,  72, 228, 209,  89, 173, 184, 198, 208,
  220, 161, 170,   2,  29, 191, 181, 159,  81, 196, 165,  16,  34, 207,   1, 186,
  143,  49, 124, 174, 150, 218, 240,  86,  71, 212, 235,  78, 217,  19, 142,  73,
   85,  22, 255,  59, 244, 164, 178,   6, 160, 167, 251,  27, 110,  60,  51, 205,
   24,  94, 106, 213, 166,  33, 222, 254,  42,  28, 243,  10,  26,  25,  39,  45,
};

static const word64 SHARK_enc_cbox[8*256] =
{
/* box 0 */
W64LIT(0x060d838f16f3a365),
W64LIT(0xa68857ee5cae56f6),
W64LIT(0xebf516353c2c4d89),
W64LIT(0x652174be88e85bdc),
W64LIT(0x0d4e9a8086c17921),
W64LIT(0x27ba7d33cffa58a1),
W64LIT(0x88d9e104a237b530),
W64LIT(0x693b8755a4fbe816),
W64LIT(0xdac9591826b254a0),
W64LIT(0x45c2e369fb336af3),
W64LIT(0xa96e1fb87b3e4ef4),
W64LIT(0xb7578f1435eb7ef0),
W64LIT(0x839af80b32056f74),
W64LIT(0xae37f55cc71f277a),
W64LIT(0xa4208538fdff37d5),
W64LIT(0x35991e74ad3cdb6f),
W64LIT(0xba191594b32a07d1),
W64LIT(0x5344d1772e572b7b),
W64LIT(0xe7efe5de103ffe43),
W64LIT(0xa3796fdc41de5e5b),
W64LIT(0x2cf9643c5fc882e5),
W64LIT(0xffdbf6fd48196d22),
W64LIT(0x33949dfbbbcf780a),
W64LIT(0x7d15679dd0cec8bd),
W64LIT(0x5f5e229c024498b1),
W64LIT(0x1223634762c683ce),
W64LIT(0xdcc4da973041f7c5),
W64LIT(0x0b43190f9032da44),
W64LIT(0xc05598eddfc5a6e2),
W64LIT(0x9e5fd31a7753f4b8),
W64LIT(0x9afa8243c0f136fe),
W64LIT(0xcc4f6b06f3d61528),
W64LIT(0xdf38612a3bc25c0d),
W64LIT(0x43cf60e6edc0c996),
W64LIT(0xcfb3d0bbf855bee0),
W64LIT(0x96e071a8ece28534),
W64LIT(0x21b7febcd909fbc4),
W64LIT(0x8ed4628bb4c41655),
W64LIT(0x30682646b04cd3c2),
W64LIT(0xb5ff5dc294ba1fd3),
W64LIT(0x75aac52f4b7fb931),
W64LIT(0xe809ad8837afe641),
W64LIT(0x0eb2213d8d42d2e9),
W64LIT(0x9852509561a057dd),
W64LIT(0xaa92a40570bde53c),
W64LIT(0x7b18e412c63d6bd8),
W64LIT(0xa7dc3e85f67c9c1d),
W64LIT(0xd8618bce87e33583),
W64LIT(0xe34ab487a79d3c05),
W64LIT(0x20e397d773db312f),
W64LIT(0x05f138321d7008ad),
W64LIT(0x17d25b757fb68b63),
W64LIT(0x8a7133d20366d413),
W64LIT(0x0000000000000000),
W64LIT(0xeaa17f5e96fe8762),
W64LIT(0xc101f18675176c09),
W64LIT(0xbebc44cd0488c597),
W64LIT(0xdb9d30738c609e4b),
W64LIT(0xabc6cd6eda6f2fd7),
W64LIT(0x5aaf1aae1f34901c),
W64LIT(0xb00e65f089ca177e),
W64LIT(0xd47b7825abf08649),
W64LIT(0x924520f15b404772),
W64LIT(0x1686321ed5644188),
W64LIT(0x618425e73f4a999a),
W64LIT(0xe21eddec0d4ff6ee),
W64LIT(0xd787c398a0732d81),
W64LIT(0x1f6df9c7e407faef),
W64LIT(0x79b036c4676c0afb),
W64LIT(0x0fe6485627901802),
W64LIT(0x9cf701ccd602959b),
W64LIT(0xbfe82da6ae5a0f7c),
W64LIT(0x990639fecb729d36),
W64LIT(0xca42e889e525b64d),
W64LIT(0xb3f2de4d8249bcb6),
W64LIT(0x4033db5be643625e),
W64LIT(0x4167b2304c91a8b5),
W64LIT(0x108bb191c397e2ed),
W64LIT(0x1834132358269361),
W64LIT(0x541d3b93927642f5),
W64LIT(0x90edf227fa112651),
W64LIT(0x1dc52b1145569bcc),
W64LIT(0xe6bb8cb5baed34a8),
W64LIT(0xd276fbaabd03252c),
W64LIT(0x313c4f2d1a9e1929),
W64LIT(0xfd73242be9480c01),
W64LIT(0x9baeeb286a23fc15),
W64LIT(0xc9be5334eea61d85),
W64LIT(0xc70c720963e4cf6c),
W64LIT(0x3eda077b3d0e012b),
W64LIT(0x97b418c346304fdf),
W64LIT(0x32c0f490111db2e1),
W64LIT(0x2ba08ed8e3e9eb6b),
W64LIT(0x8b255ab9a9b41ef8),
W64LIT(0x91b99b4c50c3ecba),
W64LIT(0xfe8f9f96e2cba7c9),
W64LIT(0x3a7f56228aacc36d),
W64LIT(0xb15a0c9b2318dd95),
W64LIT(0x5953a11314b73bd4),
W64LIT(0xf3c10516640adee8),
W64LIT(0xedf895ba2adfeeec),
W64LIT(0xadcb4ee1cc9c8cb2),
W64LIT(0xde6c0841911096e6),
W64LIT(0x84c312ef8e2406fa),
W64LIT(0xa83a76d3d1ec841f),
W64LIT(0x1c91427aef845127),
W64LIT(0x3665a5c9a6bf70a7),
W64LIT(0xf6303d24797ad645),
W64LIT(0xcd1b026d5904dfc3),
W64LIT(0x1bc8a89e53a538a9),
W64LIT(0x7ee9dc20db4d6375),
W64LIT(0x51ec03a18f064a58),
W64LIT(0xc4f0c9b4686764a4),
W64LIT(0xdd90b3fc9a933d2e),
W64LIT(0x7a4c8d796cefa133),
W64LIT(0x73a746a05d8c1a54),
W64LIT(0x0759eae4bc21698e),
W64LIT(0xc8ea3a5f4474d76e),
W64LIT(0x38d784f42bfda24e),
W64LIT(0x231f2c6a78589ae7),
W64LIT(0xc3a92350d4460d2a),
W64LIT(0x72f32fcbf75ed0bf),
W64LIT(0xbd40ff700f0b6e5f),
W64LIT(0x157a89a3dee7ea40),
W64LIT(0x873fa95285a7ad32),
W64LIT(0x4d7d41db60821b7f),
W64LIT(0x1e3990ac4ed53004),
W64LIT(0x0a1770643ae010af),
W64LIT(0x9311499af1928d99),
W64LIT(0x64751dd5223a9137),
W64LIT(0xfa2acecf5569658f),
W64LIT(0x7c410ef67a1c0256),
W64LIT(0x56b5e945332723d6),
W64LIT(0x6f3604dab2084b73),
W64LIT(0xe95dc4e39d7d2caa),
W64LIT(0x13770a2cc8144925),
W64LIT(0xbc14961ba5d9a4b4),
W64LIT(0xb9e5ae29b8a9ac19),
W64LIT(0xf169d7c0c55bbfcb),
W64LIT(0x2446c68ec479f369),
W64LIT(0x806643b63986c4bc),
W64LIT(0x7fbdb54b719fa99e),
W64LIT(0x04a55159b7a2c246),
W64LIT(0xee042e07215c4524),
W64LIT(0x5bfb73c5b5e65af7),
W64LIT(0x0c1af3eb2c13b3ca),
W64LIT(0xa22d06b7eb0c94b0),
W64LIT(0xb8b1c742127b66f2),
W64LIT(0x285c3565e86a40a3),
W64LIT(0x3b2b3f49207e0986),
W64LIT(0x3c72d5ad9c5f6008),
W64LIT(0x770217f9ea2ed812),
W64LIT(0xfc274d40439ac6ea),
W64LIT(0x4fd5930dc1d37a5c),
W64LIT(0x2e51b6eafe99e3c6),
W64LIT(0x6b93558305aa8935),
W64LIT(0x19607a48f2f4598a),
W64LIT(0x08bfa2b29bb1718c),
W64LIT(0x3f8e6e1097dccbc0),
W64LIT(0x3983ed9f812f68a5),
W64LIT(0xac9f278a664e4659),
W64LIT(0x82ce916098d7a59f),
W64LIT(0xc2fd4a3b7e94c7c1),
W64LIT(0x66ddcf03836bf014),
W64LIT(0xe1e2665106cc5d26),
W64LIT(0x74feac44e1ad73da),
W64LIT(0x8d28d936bf47bd9d),
W64LIT(0x62789e5a34c93252),
W64LIT(0x81322add93540e57),
W64LIT(0xcb1681e24ff77ca6),
W64LIT(0x2512afe56eab3982),
W64LIT(0xd18a4017b6808ee4),
W64LIT(0x705bfd1d560fb19c),
W64LIT(0x4b70c2547671b81a),
W64LIT(0x49d81082d720d939),
W64LIT(0xe0b60f3aac1e97cd),
W64LIT(0x4e81fa666b01b0b7),
W64LIT(0x951cca15e7612efc),
W64LIT(0x463e58d4f0b0c13b),
W64LIT(0x632cf7319e1bf8b9),
W64LIT(0x5ca2992109c73379),
W64LIT(0xf764544fd3a81cae),
W64LIT(0x6ac73ce8af7843de),
W64LIT(0x9f0bba71dd813e53),
W64LIT(0x85977b8424f6cc11),
W64LIT(0x5807c878be65f13f),
W64LIT(0x686fee3e0e2922fd),
W64LIT(0x78e45fafcdbec010),
W64LIT(0x6ccabf67b98be0bb),
W64LIT(0x11dfd8fa69452806),
W64LIT(0xcee7b9d05287740b),
W64LIT(0x50b86aca25d480b3),
W64LIT(0x5df6f04aa315f992),
W64LIT(0x5e0a4bf7a896525a),
W64LIT(0x03fcbbbd0b83abc8),
W64LIT(0x8f800be01e16dcbe),
W64LIT(0xd32292c117d1efc7),
W64LIT(0xe5473708b16e9f60),
W64LIT(0x224b4501d28a500c),
W64LIT(0xfb7ea7a4ffbbaf64),
W64LIT(0x3d26bcc6368daae3),
W64LIT(0x866bc0392f7567d9),
W64LIT(0x3731cca20c6dba4c),
W64LIT(0xb603e67f9f39b41b),
W64LIT(0xa1d1bd0ae08f3f78),
W64LIT(0xd935e2a52d31ff68),
W64LIT(0xaf639c376dcded91),
W64LIT(0x0154696baad2caeb),
W64LIT(0xecacfcd1800d2407),
W64LIT(0xf03dbeab6f897520),
W64LIT(0x02a8d2d6a1516123),
W64LIT(0xf498eff2d82bb766),
W64LIT(0x710f9476fcdd7b77),
W64LIT(0xf8821c19f43804ac),
W64LIT(0xf9d675725eeace47),
W64LIT(0x1a9cc1f5f977f242),
W64LIT(0x5210b81c8485e190),
W64LIT(0x6d9ed60c13592a50),
W64LIT(0xf2956c7dced81403),
W64LIT(0xbb4d7cff19f8cd3a),
W64LIT(0x4c2928b0ca50d194),
W64LIT(0x6e626db118da8198),
W64LIT(0xe4135e631bbc558b),
W64LIT(0x9da368a77cd05f70),
W64LIT(0xa574ec53572dfd3e),
W64LIT(0x09ebcbd93163bb67),
W64LIT(0x4a24ab3fdca372f1),
W64LIT(0x429b098d4712037d),
W64LIT(0x57e1802e99f5e93d),
W64LIT(0xef50476c8b8e8fcf),
W64LIT(0xa085d4614a5df593),
W64LIT(0x34cd771f07ee1184),
W64LIT(0xc6581b62c9360587),
W64LIT(0x2dad0d57f51a480e),
W64LIT(0x898d886f08e57fdb),
W64LIT(0xd6d3aaf30aa1e76a),
W64LIT(0x76567e9240fc12f9),
W64LIT(0xb4ab34a93e68d538),
W64LIT(0xb2a6b726289b765d),
W64LIT(0x8c7cb05d15957776),
W64LIT(0x554952f838a4881e),
W64LIT(0xd52f114e01224ca2),
W64LIT(0x60d04c8c95985371),
W64LIT(0x6789a66829b93aff),
W64LIT(0x2f05df81544b292d),
W64LIT(0x476a31bf5a620bd0),
W64LIT(0xf5cc869972f97d8d),
W64LIT(0x488c79e97df213d2),
W64LIT(0x44968a0251e1a018),
W64LIT(0x26ee14586528924a),
W64LIT(0xd0de297c1c52440f),
W64LIT(0xc5a4a0dfc2b5ae4f),
W64LIT(0x29085c0e42b88a48),
W64LIT(0x142ee0c8743520ab),
W64LIT(0x2af4e7b3493b2180),
W64LIT(0x9448a37e4db3e417),
/* box 1 */
W64LIT(0xe2795ba105ba30ce),
W64LIT(0x65b5d634f5e0fbdd),
W64LIT(0x2d7d7f1464dd8c55),
W64LIT(0xeefbf778add1c20b),
W64LIT(0x1eb0fbd1f11968e7),
W64LIT(0xe6073f45ce30cd8d),
W64LIT(0x21ffd3cdccb67e90),
W64LIT(0xdf0941cfa750a262),
W64LIT(0xc61df5b1b75ef18a),
W64LIT(0xc5c7defa9dc337c6),
W64LIT(0x2581b729073c83d3),
W64LIT(0xa5e97513167173cf),
W64LIT(0xdd3673bd381526b9),
W64LIT(0xe8baa1eef91ebb93),
W64LIT(0x3b314cf8f625eb34),
W64LIT(0x579d4bc8d5fc5df8),
W64LIT(0xbb598ec2e7681b28),
W64LIT(0xc8a06b1a80708794),
W64LIT(0x1c8fc9a36e5cec3c),
W64LIT(0xf60a5a3f0807d374),
W64LIT(0x1ace9f353a9395a4),
W64LIT(0x7e9e50387aab2cee),
W64LIT(0xb5e41069d0466d36),
W64LIT(0x8cea6ee3b92602d9),
W64LIT(0xf952ddad8af1e7fd),
W64LIT(0xb19a748d1bcc9075),
W64LIT(0x2464ae10b2e4c144),
W64LIT(0xfcc9a070f4a35829),
W64LIT(0xfa88f6e6a06c21b1),
W64LIT(0x2c98662dd105cec2),
W64LIT(0x9065a740d77aeee5),
W64LIT(0xcb7a4051aaed41d8),
W64LIT(0x55a279ba4ab9d923),
W64LIT(0x27be855b98790708),
W64LIT(0xbabc97fb52b059bf),
W64LIT(0xa19711f7ddfb8e8c),
W64LIT(0x047e64e4cb8afd43),
W64LIT(0xc386886cc90c4e5e),
W64LIT(0xc422c7c3281b7551),
W64LIT(0xfb6defdf15b46326),
W64LIT(0x01e51939b5d84297),
W64LIT(0x5cbba8be9c809432),
W64LIT(0x6f762c7b09447080),
W64LIT(0xcee13d8cd4bffe0c),
W64LIT(0x54476083ff619bb4),
W64LIT(0x6e933542bc9c3217),
W64LIT(0x4af79b520e78f353),
W64LIT(0x98996f7db49be163),
W64LIT(0xa07208ce6823cc1b),
W64LIT(0x2b3c29823012f5cd),
W64LIT(0x93bf8c0bfde728a9),
W64LIT(0x2225f886e62bb8dc),
W64LIT(0x7f7b4901cf736e79),
W64LIT(0x0000000000000000),
W64LIT(0x023f32729f4584db),
W64LIT(0xd5cabb805bf4293f),
W64LIT(0x07a44fafe1173b0f),
W64LIT(0xe95fb8d74cc6f904),
W64LIT(0x7b052de504f9933a),
W64LIT(0x6aed51a67716cf54),
W64LIT(0x68d263d4e8534b8f),
W64LIT(0xa96bd9cabe1a810a),
W64LIT(0x1d6ad09adb84aeab),
W64LIT(0x0d67b5e01db3b052),
W64LIT(0x52063615abaee22c),
W64LIT(0x8f3045a893bbc495),
W64LIT(0xd8ad0e604647996d),
W64LIT(0xaf2a8f5cead5f892),
W64LIT(0x3017af8ebf5922fe),
W64LIT(0x4034611df2dc780e),
W64LIT(0x721cfce1d2c0de2b),
W64LIT(0x28e602c91a8f3381),
W64LIT(0xe1a370ea2f27f682),
W64LIT(0x29031bf0af577116),
W64LIT(0x1914b47e100e53e8),
W64LIT(0x567852f160241f6f),
W64LIT(0x793a1f979bbc17e1),
W64LIT(0xef1eee411809809c),
W64LIT(0x6211999b14f7c0d2),
W64LIT(0x059b7ddd7e52bfd4),
W64LIT(0x43ee4a56d841be42),
W64LIT(0xf1ae1590e910e87b),
W64LIT(0x33cd84c595c4e4b2),
W64LIT(0x4b12826bbba0b1c4),
W64LIT(0xeb608aa5d3837ddf),
W64LIT(0x201acaf4796e3c07),
W64LIT(0xbf27ea262ce2e66b),
W64LIT(0x58c5cc5a570a6971),
W64LIT(0x37b3e0215e4e19f1),
W64LIT(0xab54ebb8215f05d1),
W64LIT(0x8ed55c9126638602),
W64LIT(0x9aa65d0f2bde65b8),
W64LIT(0xd7f589f2c4b1ade4),
W64LIT(0x5039046734eb66f7),
W64LIT(0x6cac073023d9b6cc),
W64LIT(0x51dc1d5e81332460),
W64LIT(0x17a92ad5272025f6),
W64LIT(0x47902eb213cb4301),
W64LIT(0x1b2b860c8f4bd733),
W64LIT(0x4f6ce68f702a4c87),
W64LIT(0xcf0424b56167bc9b),
W64LIT(0x997c76440143a3f4),
W64LIT(0x7ae034dcb121d1ad),
W64LIT(0x100d657ac6371ef9),
W64LIT(0x0ac3fa4ffca48b5d),
W64LIT(0xdeec58f61288e0f5),
W64LIT(0x265b9c622da1459f),
W64LIT(0xdcd36a848dcd642e),
W64LIT(0xe4380d3751754956),
W64LIT(0x13d74e31ecaad8b5),
W64LIT(0xfd2cb949417b1abe),
W64LIT(0x9624f1d683b5977d),
W64LIT(0x4675378ba6130196),
W64LIT(0x0b26e376497cc9ca),
W64LIT(0x41d1782447043a99),
W64LIT(0xe39c4298b0627259),
W64LIT(0xcd3b16c7fe223840),
W64LIT(0x7787813cac9261ff),
W64LIT(0x492db01924e5351f),
W64LIT(0x5afafe28c84fedaa),
W64LIT(0x8b4e214c583139d6),
W64LIT(0xccde0ffe4bfa7ad7),
W64LIT(0x76629805194a2368),
W64LIT(0x7ca1624ae5eea835),
W64LIT(0x61cbb2d03e6a069e),
W64LIT(0x48c8a920913d7788),
W64LIT(0x8068c23a114df01c),
W64LIT(0xd38bed160f3b50a7),
W64LIT(0x32289dfc201ca625),
W64LIT(0xc1b9ba1e5649ca85),
W64LIT(0xed21dc33874c0447),
W64LIT(0xa3a8238542be0a57),
W64LIT(0x5b1fe7117d97af3d),
W64LIT(0x3d701a6ea2ea92ac),
W64LIT(0x73f9e5d867189cbc),
W64LIT(0x9ed839ebe05498fb),
W64LIT(0x5920d563e2d22be6),
W64LIT(0xca9f59681f35034f),
W64LIT(0x11e87c4373ef5c6e),
W64LIT(0x97c1e8ef366dd5ea),
W64LIT(0xacf0a417c0483ede),
W64LIT(0xd26ef42fbae31230),
W64LIT(0xbcfdc16d067f2027),
W64LIT(0xbec2f31f993aa4fc),
W64LIT(0x45af1cc08c8ec7da),
W64LIT(0x31f2b6b70a816069),
W64LIT(0xd9481759f39fdbfa),
W64LIT(0xe5dd140ee4ad0bc1),
W64LIT(0xa6335e583cecb583),
W64LIT(0x38eb67b3dcb82d78),
W64LIT(0xf5d07174229a1538),
W64LIT(0x5f6183f5b61d527e),
W64LIT(0x0f58879282f63489),
W64LIT(0x164c33ec92f86761),
W64LIT(0x444a05f93956854d),
W64LIT(0x818ddb03a495b28b),
W64LIT(0x4d53d4fdef6fc85c),
W64LIT(0x8d0f77da0cfe404e),
W64LIT(0x8416a6dedac70d5f),
W64LIT(0x666ffd7fdf7d3d91),
W64LIT(0xb63e3b22fadbab7a),
W64LIT(0xf2743edbc38d2e37),
W64LIT(0xa40c6c2aa3a93158),
W64LIT(0x9f3d20d2558cda6c),
W64LIT(0xfef692026be6dcf2),
W64LIT(0x2ea7545f4e404a19),
W64LIT(0xb2405fc631515639),
W64LIT(0x23c0e1bf53f3fa4b),
W64LIT(0x83b2e9713bd03650),
W64LIT(0x0641569654cf7998),
W64LIT(0xb883a589cdf5dd64),
W64LIT(0x3ad455c143fda9a3),
W64LIT(0x925a9532483f6a3e),
W64LIT(0xaab1f28194874746),
W64LIT(0xf435684d974257af),
W64LIT(0xd1b4df64907ed47c),
W64LIT(0x390e7e8a69606fef),
W64LIT(0xd051c65d25a696eb),
W64LIT(0xb4010950659e2fa1),
W64LIT(0x0c82acd9a86bf2c5),
W64LIT(0x88940a0772acff9a),
W64LIT(0xf39127e276556ca0),
W64LIT(0xaecf96655f0dba05),
W64LIT(0x03da2b4b2a9dc64c),
W64LIT(0x3f4f281c3daf1677),
W64LIT(0x3469cb6a74d3dfbd),
W64LIT(0xf04b0ca95cc8aaec),
W64LIT(0x1f55e2e844c12a70),
W64LIT(0x4cb6cdc45ab78acb),
W64LIT(0xc05ca327e3918812),
W64LIT(0x95feda9da9285131),
W64LIT(0xb966bcb0782d9ff3),
W64LIT(0xa7d647618934f714),
W64LIT(0xd61090cb7169ef73),
W64LIT(0x71c6d7aaf85d1867),
W64LIT(0xecc4c50a329446d0),
W64LIT(0x6450cf0d4038b94a),
W64LIT(0x420b536f6d99fcd5),
W64LIT(0x75b8b34e33d7e524),
W64LIT(0xc26391557cd40cc9),
W64LIT(0xda923c12d9021db6),
W64LIT(0x4e89ffb6c5f20e10),
W64LIT(0x0919d104d6394d11),
W64LIT(0x8aab3875ede97b41),
W64LIT(0xa88ec0f30bc2c39d),
W64LIT(0xb7db221b4f03e9ed),
W64LIT(0xc7f8ec880286b31d),
W64LIT(0x2f424d66fb98088e),
W64LIT(0xe04669d39affb415),
W64LIT(0x3eaa3125887754e0),
W64LIT(0x5e849acc03c510e9),
W64LIT(0x8257f0488e0874c7),
W64LIT(0xbd18d854b3a762b0),
W64LIT(0xb3a546ff848914ae),
W64LIT(0x9ce70b997f111c20),
W64LIT(0x3c9503571732d03b),
W64LIT(0xe7e2267c7be88f1a),
W64LIT(0x63f480a2a12f8245),
W64LIT(0x602eabe98bb24409),
W64LIT(0x941bc3a41cf013a6),
W64LIT(0x678ae4466aa57f06),
W64LIT(0x1232570859729a22),
W64LIT(0x6d491e099601f45b),
W64LIT(0x5d5eb1872958d6a5),
W64LIT(0x1473019e0dbde3ba),
W64LIT(0xa24d3abcf76648c0),
W64LIT(0x85f3bfe76f1f4fc8),
W64LIT(0x08fcc83d63e10f86),
W64LIT(0x745daa77860fa7b3),
W64LIT(0x9180be7962a2ac72),
W64LIT(0x87cc8d95f05acb13),
W64LIT(0x78df06ae2e645576),
W64LIT(0x18f1ad47a5d6117f),
W64LIT(0x358cd253c10b9d2a),
W64LIT(0x0ebd9eab372e761e),
W64LIT(0xf7ef4306bddf91e3),
W64LIT(0x7023ce934d855af0),
W64LIT(0xd42fa2b9ee2c6ba8),
W64LIT(0x3656f918eb965b66),
W64LIT(0x9d0212a0cac95eb7),
W64LIT(0x2ad930bb85cab75a),
W64LIT(0x862994ac45828984),
W64LIT(0x7d447b735036eaa2),
W64LIT(0xb07f6db4ae14d2e2),
W64LIT(0x6b08489fc2ce8dc3),
W64LIT(0x9b4344369e06272f),
W64LIT(0xad15bd2e75907c49),
W64LIT(0xdb77252b6cda5f21),
W64LIT(0xea85939c665b3f48),
W64LIT(0xc945722335a8c503),
W64LIT(0x159618a7b865a12d),
W64LIT(0x69377aed5d8b0918),
W64LIT(0x8971133ec774bd0d),
W64LIT(0x53e32f2c1e76a0bb),
W64LIT(0xf8b7c4943f29a56a),
W64LIT(0xff138b3bde3e9e65),
/* box 2 */
W64LIT(0x7c6a2eb5fdabecc6),
W64LIT(0x401cda0a752bbea0),
W64LIT(0x1925217156dc57c4),
W64LIT(0x56dec6d301d70787),
W64LIT(0x41c751ff73c6ac58),
W64LIT(0xc9067697a92cb5f9),
W64LIT(0x3391c917aaa0bc85),
W64LIT(0xae0a9a4c0e742afe),
W64LIT(0xaa8ca972162a62f4),
W64LIT(0x5aa193912935df99),
W64LIT(0x86fd9135fe27e5ba),
W64LIT(0xffca074b1d3f538e),
W64LIT(0x0e3cb65d24cdfc1b),
W64LIT(0x4384b2e07fe9885d),
W64LIT(0xc73ac0ca8de149e2),
W64LIT(0x48e5bc7645972eb4),
W64LIT(0xbe0d56b46ef9ffd6),
W64LIT(0x200e6d05c0ef5f50),
W64LIT(0xe1f17dee597f7abd),
W64LIT(0x0243e31f0c2f2405),
W64LIT(0xf4ab09dd2741f567),
W64LIT(0xe4acc52547cc204f),
W64LIT(0x348f92c3b83cc272),
W64LIT(0x53837e181f645d75),
W64LIT(0xd8da319acf4c7229),
W64LIT(0x81e3cae1ecbb9b4d),
W64LIT(0xd6e687c7eb818e32),
W64LIT(0x3dad7f4a8e6d409e),
W64LIT(0x28f70b79f053cf44),
W64LIT(0x493e3783437a3c4c),
W64LIT(0xb27203f6461b27c8),
W64LIT(0xd02357e6fff0e23d),
W64LIT(0xe8d390676f2ef851),
W64LIT(0x26cbbd24d49e335f),
W64LIT(0xee1640467b5f945e),
W64LIT(0x4aa65f6949b80ab1),
W64LIT(0xb56c58225487593f),
W64LIT(0x4ffbe7a2570b5043),
W64LIT(0x0aba85633c93b411),
W64LIT(0x78ec1d8be5f5a4cc),
W64LIT(0x501b16f215a66b88),
W64LIT(0x271036d1d27321a7),
W64LIT(0x7ff2465ff769da3b),
W64LIT(0x35541936bed1d08a),
W64LIT(0xb8c886957a8893d9),
W64LIT(0x2fe950ade2cfb1b3),
W64LIT(0xf90fd76a094e3f81),
W64LIT(0x2daab3b2eee095b6),
W64LIT(0x1abd499b5c1e6139),
W64LIT(0x0c7f554228e2d81e),
W64LIT(0x425f391579049aa5),
W64LIT(0xc3bcf3f495bf01e8),
W64LIT(0xb4b7d3d7526a4bc7),
W64LIT(0x0000000000000000),
W64LIT(0xa0362c112ab9d6e5),
W64LIT(0x91e406198c364e65),
W64LIT(0x454162c16b98e452),
W64LIT(0x139fa4126a4fe3d5),
W64LIT(0x01db8bf506ed12f8),
W64LIT(0x9a85088fb648e88c),
W64LIT(0x3ab3249e9cf13e69),
W64LIT(0xd57eef2de143b8cf),
W64LIT(0xb1ea6b1c4cd91135),
W64LIT(0x7aaffe94e9da80c9),
W64LIT(0xad92f2a604b61c03),
W64LIT(0xa3ae44fb207be018),
W64LIT(0xeb4bf88d65ecceac),
W64LIT(0xc0249b1e9f7d3715),
W64LIT(0xa8cf4a6d1a0546f1),
W64LIT(0xc6e14b3f8b0c5b1a),
W64LIT(0xce182d43bbb0cb0e),
W64LIT(0xfc526fa117fd6573),
W64LIT(0x8c471456c2b451ab),
W64LIT(0xac497953025b0efb),
W64LIT(0x0486333e185e480a),
W64LIT(0x18feaa845031453c),
W64LIT(0xa1eda7e42c54c41d),
W64LIT(0x06c5d02114716c0f),
W64LIT(0x055db8cb1eb35af2),
W64LIT(0xe5774ed0412132b7),
W64LIT(0x36cc71dcb413e677),
W64LIT(0x470281de67b7c057),
W64LIT(0x58e2708e251afb9c),
W64LIT(0xa914c1981ce85409),
W64LIT(0xb3a9880340f63530),
W64LIT(0x638adfe5bf06d70d),
W64LIT(0x0b610e963a7ea6e9),
W64LIT(0x927c6ef386f47898),
W64LIT(0xed8e28ac719da2a3),
W64LIT(0x7548c33ccbfa6e2a),
W64LIT(0xf3b5520935dd8b90),
W64LIT(0x8d9c9fa3c4594353),
W64LIT(0x31d22a08a68f9880),
W64LIT(0x0da4deb72e0fcae6),
W64LIT(0x8fdf7cbcc8766756),
W64LIT(0x5dbfc8453ba9a16e),
W64LIT(0x8e04f749ce9b75ae),
W64LIT(0x83a029fee094bf48),
W64LIT(0xa4b01f2f32e79eef),
W64LIT(0x1c7899ba486f0d36),
W64LIT(0x654f0fc4ab77bb02),
W64LIT(0x7db1a540fb46fe3e),
W64LIT(0x51c09d07134b7970),
W64LIT(0xcb459588a50391fc),
W64LIT(0x3fee9c558242649b),
W64LIT(0xfe118cbe1bd24176),
W64LIT(0x76d0abd6c13858d7),
W64LIT(0x5e27a0af316b9793),
W64LIT(0x69305a868395631c),
W64LIT(0x3b68af6b9a1c2c91),
W64LIT(0x6db669b89bcb2b16),
W64LIT(0xa72877c53825a812),
W64LIT(0xd3bb3f0cf532d4c0),
W64LIT(0x6ff58aa797e40f13),
W64LIT(0x96fa5dcd9eaa3092),
W64LIT(0x2c713847e80d874e),
W64LIT(0xc57923d581ce6de7),
W64LIT(0x2b6f6393fa91f9b9),
W64LIT(0x0922ed89365182ec),
W64LIT(0x324a42e2ac4dae7d),
W64LIT(0x16c21cd974fcb927),
W64LIT(0x956235279468066f),
W64LIT(0x7b747561ef379231),
W64LIT(0x449ae9346d75f6aa),
W64LIT(0xf570822821ace79f),
W64LIT(0x5939fb7b23f7e964),
W64LIT(0x7937967ee318b634),
W64LIT(0x84be722af208c1bf),
W64LIT(0x08f9667c30bc9014),
W64LIT(0xefcdcbb37db286a6),
W64LIT(0xa6f3fc303ec8baea),
W64LIT(0xea9073786301dc54),
W64LIT(0x62515410b9ebc5f5),
W64LIT(0xd260b4f9f3dfc638),
W64LIT(0x9e033bb1ae16a086),
W64LIT(0x38f0c78190de1a6c),
W64LIT(0xc267780193521310),
W64LIT(0x80384114ea5689b5),
W64LIT(0x9b5e837ab0a5fa74),
W64LIT(0xf73361372d83c39a),
W64LIT(0x3009a1fda0628a78),
W64LIT(0xd4a564d8e7aeaa37),
W64LIT(0xfb4c347505611b84),
W64LIT(0x5b7a18642fd8cd61),
W64LIT(0x239605efca2d69ad),
W64LIT(0xf8d45c9f0fa32d79),
W64LIT(0xbb50ee7f704aa524),
W64LIT(0x392b4c7496330894),
W64LIT(0x0fe73da82220eee3),
W64LIT(0x3717fa29b2fef48f),
W64LIT(0xf26ed9fc33309968),
W64LIT(0xd73d0c32ed6c9cca),
W64LIT(0xda99d285c363562c),
W64LIT(0xde1fe1bbdb3d1e26),
W64LIT(0x738d131ddf8b0225),
W64LIT(0x292c808cf6beddbc),
W64LIT(0xbc4eb5ab62d6dbd3),
W64LIT(0x039868ea0ac236fd),
W64LIT(0xcc5bce5cb79fef0b),
W64LIT(0xb031e0e94a3403cd),
W64LIT(0xc4a2a82087237f1f),
W64LIT(0xb72fbb3d58a87d3a),
W64LIT(0xafd111b908993806),
W64LIT(0x68ebd173857871e4),
W64LIT(0x9d9b535ba4d4967b),
W64LIT(0xe9081b9269c3eaa9),
W64LIT(0x71cef002d3a42620),
W64LIT(0x93a7e50680196a60),
W64LIT(0x891aac9ddc070b59),
W64LIT(0x155a74337e3e8fda),
W64LIT(0x4e206c5751e642bb),
W64LIT(0x9721d6389847226a),
W64LIT(0x12442fe76ca2f12d),
W64LIT(0x2553d5cede5c05a2),
W64LIT(0xa275cf0e2696f2e0),
W64LIT(0x24885e3bd8b1175a),
W64LIT(0x670cecdba7589f07),
W64LIT(0x749348c9cd177cd2),
W64LIT(0x64948431ad9aa9fa),
W64LIT(0x2ab4e866fc7ceb41),
W64LIT(0xe6ef263a4be3044a),
W64LIT(0xe734adcf4d0e16b2),
W64LIT(0x903f8dec8adb5c9d),
W64LIT(0xf02d3ae33f1fbd6d),
W64LIT(0x725698e8d96610dd),
W64LIT(0x1da3124f4e821fce),
W64LIT(0x1719972c7211abdf),
W64LIT(0x11dc470d6660c7d0),
W64LIT(0xec55a3597770b05b),
W64LIT(0xbfd6dd416814ed2e),
W64LIT(0x57054d26073a157f),
W64LIT(0x1e3b7aa544402933),
W64LIT(0x5ffc2b5a3786856b),
W64LIT(0x61c93cfab329f308),
W64LIT(0x3e3517a084af7663),
W64LIT(0xf6e8eac22b6ed162),
W64LIT(0x1007ccf8608dd528),
W64LIT(0x66d7672ea1b58dff),
W64LIT(0x8b594f82d0282f5c),
W64LIT(0x1fe0f15042ad3bcb),
W64LIT(0x4b7dd49c4f551849),
W64LIT(0x4c638f485dc966be),
W64LIT(0xcfc3a6b6bd5dd9f6),
W64LIT(0x46d90a2b615ad2af),
W64LIT(0x8565f9dff4e5d347),
W64LIT(0x94b9bed292851497),
W64LIT(0xfa97bf80038c097c),
W64LIT(0xb9130d607c658121),
W64LIT(0xdc5c02a4d7123a23),
W64LIT(0x224d8e1accc07b55),
W64LIT(0x87261ac0f8caf742),
W64LIT(0xd901ba6fc9a160d1),
W64LIT(0xab57228710c7700c),
W64LIT(0x21d5e6f0c6024da8),
W64LIT(0x98c6eb90ba67cc89),
W64LIT(0x827ba20be679adb0),
W64LIT(0x991d6065bc8ade71),
W64LIT(0x5546ae390b15317a),
W64LIT(0xa56b94da340a8c17),
W64LIT(0x071e5bd4129c7ef7),
W64LIT(0xe02af61b5f926845),
W64LIT(0x6b73b9998fba4719),
W64LIT(0xdfc46a4eddd00cde),
W64LIT(0x770b2023c7d54a2f),
W64LIT(0x7e29cdaaf184c8c3),
W64LIT(0xba8b658a76a7b7dc),
W64LIT(0x9c40d8aea2398483),
W64LIT(0x9fd8b044a8fbb27e),
W64LIT(0xdb425970c58e44d4),
W64LIT(0xe269150453bd4c40),
W64LIT(0x3c76f4bf88805266),
W64LIT(0xf1f6b11639f2af95),
W64LIT(0x549d25cc0df82382),
W64LIT(0x4db804bd5b247446),
W64LIT(0x8a82c477d6c53da4),
W64LIT(0x5258f5ed19894f8d),
W64LIT(0x6e2e015291091deb),
W64LIT(0xc1ff10eb999025ed),
W64LIT(0xbd953e5e643bc92b),
W64LIT(0xc8ddfd62afc1a701),
W64LIT(0x5c6443b03d44b396),
W64LIT(0x6c6de24d9d2639ee),
W64LIT(0x1481ffc678d39d22),
W64LIT(0xd1f8dc13f91df0c5),
W64LIT(0xca9e1e7da3ee8304),
W64LIT(0xdd878951d1ff28db),
W64LIT(0x6012b70fb5c4e1f0),
W64LIT(0x1b66c26e5af373c1),
W64LIT(0xe3b29ef155505eb8),
W64LIT(0x70157bf7d54934d8),
W64LIT(0x2e32db58e422a34b),
W64LIT(0x6aa8326c895755e1),
W64LIT(0xb6f430c85e456fc2),
W64LIT(0xfd89e4541110778b),
W64LIT(0x88c12768daea19a1),
W64LIT(0xcd8045a9b172fdf3),
/* box 3 */
W64LIT(0x99183e616655b742),
W64LIT(0xb2872032a50d6860),
W64LIT(0x0946f63b060528ef),
W64LIT(0x36612b9a141ef07d),
W64LIT(0x0634da84dd49579b),
W64LIT(0xfc9c9e9b486c8a57),
W64LIT(0xa63fe3c0744e6fd0),
W64LIT(0xf1515758d8b46bf9),
W64LIT(0x3e82559fcd5197ff),
W64LIT(0x92e12d262bc40177),
W64LIT(0xc3bb433a5a7752c5),
W64LIT(0x21c3852a5183267a),
W64LIT(0x39130725cf528f09),
W64LIT(0x9ba7db1d2dc12998),
W64LIT(0xc58f99be873e055e),
W64LIT(0xd9d424498f32656c),
W64LIT(0x27f75fae8cca71e1),
W64LIT(0x59b91019a8fc3430),
W64LIT(0xce768af9caafb36b),
W64LIT(0x9d930199f0887e03),
W64LIT(0x63b07a7ef3706a8e),
W64LIT(0xb5167288a70e7096),
W64LIT(0x40cc1a28e967d22e),
W64LIT(0x4d01d3eb79bf3380),
W64LIT(0x9e896cdb6456afb4),
W64LIT(0x2548bad2c75eef3b),
W64LIT(0xa79a6bfeab0420bd),
W64LIT(0x9f2ce4e5bb1ce0d9),
W64LIT(0x32ea146282c3393c),
W64LIT(0x6d67defff7765a97),
W64LIT(0x83775912b31080eb),
W64LIT(0xf5da68a04e69a2b8),
W64LIT(0x1196743498d4819c),
W64LIT(0x0bf913474d91b635),
W64LIT(0x43d6776a7db90399),
W64LIT(0x444725d07fba1b6f),
W64LIT(0x6584a0fa2e393d15),
W64LIT(0x3f27dda1121bd892),
W64LIT(0xf6c005e2dab7730f),
W64LIT(0x56cb3ca673b04b44),
W64LIT(0x642128c4f1737278),
W64LIT(0xbf4ae9f135d589ce),
W64LIT(0xb038c54eee99f6ba),
W64LIT(0xf47fe09e9123edd5),
W64LIT(0x75b75cf069a7f3e4),
W64LIT(0xd419ed8a1fea84c2),
W64LIT(0x73838674b4eea47f),
W64LIT(0x498aec13ef62fac1),
W64LIT(0x20660d148ec96917),
W64LIT(0xa48006bc3fdaf10a),
W64LIT(0x2f1421ab55851663),
W64LIT(0x0a5c9b7992dbf958),
W64LIT(0xd1375a4c567d02ee),
W64LIT(0x0000000000000000),
W64LIT(0xc842507d17e6e4f0),
W64LIT(0xf3eeb2249320f523),
W64LIT(0xc9e7d843c8acab9d),
W64LIT(0xff86f3d9dcb25be0),
W64LIT(0xb4b3fab678443ffb),
W64LIT(0xb19d4d7031d3b9d7),
W64LIT(0x79df1d0d26355d27),
W64LIT(0x8eba90d123c86145),
W64LIT(0xaa57a23d3bdcc113),
W64LIT(0xcb583d3f83383547),
W64LIT(0xd871ac7750782a01),
W64LIT(0xe162ab529f2aa508),
W64LIT(0x38b68f1b1018c064),
W64LIT(0x237c60561a17b8a0),
W64LIT(0xa31154063dd9e9fc),
W64LIT(0x713c6308ff7a3aa5),
W64LIT(0x1a6f6773d54537a9),
W64LIT(0x08e37e05d94f6782),
W64LIT(0x357b46d880c021ca),
W64LIT(0x6cc256c1283c15fa),
W64LIT(0xcfd302c715e5fc06),
W64LIT(0xbdf50c8d7e411714),
W64LIT(0x7cf1aacb6fa2db0b),
W64LIT(0x5240035ee56d8205),
W64LIT(0x7b60f8716da1c3fd),
W64LIT(0x01a5883edf4a4f6d),
W64LIT(0xdd5f1bb119efac2d),
W64LIT(0x5474d9da3824d59e),
W64LIT(0x0f722cbfdb4c7f74),
W64LIT(0x17a2aeb0459dd607),
W64LIT(0x37c4a3a4cb54bf10),
W64LIT(0xc21ecb04853d1da8),
W64LIT(0x4273ff54a2f34cf4),
W64LIT(0xdace490b1becb4db),
W64LIT(0x6af68c45f5754261),
W64LIT(0x46f8c0ac342e85b5),
W64LIT(0x854383966e59d770),
W64LIT(0x81c8bc6ef8841e31),
W64LIT(0x3bace25984c611d3),
W64LIT(0x1033fc0a479ecef1),
W64LIT(0x1c5bbdf7080c6032),
W64LIT(0x7412d4ceb6edbc89),
W64LIT(0xa8e8474170485fc9),
W64LIT(0xb8dbbb4b37d69138),
W64LIT(0x079152ba020318f6),
W64LIT(0x72260e4a6ba4eb12),
W64LIT(0x905ec85a60509fad),
W64LIT(0x2dabc4d71e1188b9),
W64LIT(0xd092d27289374d83),
W64LIT(0x610f9f02b8e4f454),
W64LIT(0x02bfe57c4b949eda),
W64LIT(0x95707f9c29c71981),
W64LIT(0x6fd83b83bce2c44d),
W64LIT(0x5d322fe13e21fd71),
W64LIT(0x34decee65f8a6ea7),
W64LIT(0xcd6ce7bb5e7162dc),
W64LIT(0xfb0dcc214a6f92a1),
W64LIT(0x2eb1a9958acf590e),
W64LIT(0xdcfa938fc6a5e340),
W64LIT(0x669ecdb8bae7eca2),
W64LIT(0x151d4bcc0e0948dd),
W64LIT(0xfd3916a59726c53a),
W64LIT(0x581c982777b67b5d),
W64LIT(0x1bcaef4d0a0f78c4),
W64LIT(0xdfe0fecd527b32f7),
W64LIT(0x128c19760c0a502b),
W64LIT(0x84e60ba8b113981d),
W64LIT(0x3c3db0e386c50925),
W64LIT(0x7febc789fb7c0abc),
W64LIT(0x7d5422f5b0e89466),
W64LIT(0xd70380c88b345575),
W64LIT(0xbbc1d609a308408f),
W64LIT(0xe278c6100bf474bf),
W64LIT(0x5e2842a3aaff2cc6),
W64LIT(0x6b53047b2a3f0d0c),
W64LIT(0xf7658ddc05fd3c62),
W64LIT(0x9a025323f28b66f5),
W64LIT(0x8c0575ad685cff9f),
W64LIT(0x76ad31b2fd792253),
W64LIT(0x68496939bee1dcbb),
W64LIT(0x7e4e4fb7243645d1),
W64LIT(0xe44c1c94d6bd2324),
W64LIT(0xbeef61cfea9fc6a3),
W64LIT(0x91fb4064bf1ad0c0),
W64LIT(0x052eb7c64997862c),
W64LIT(0x4a9081517bbc2b76),
W64LIT(0x8f1f18effc822e28),
W64LIT(0x3a096a675b8c5ebe),
W64LIT(0xee1087ed4466da7c),
W64LIT(0x2652d79053803e8c),
W64LIT(0x7099eb36203075c8),
W64LIT(0xc7307cc2ccaa9b84),
W64LIT(0x5c97a7dfe16bb21c),
W64LIT(0x50ffe622aef91cdf),
W64LIT(0x8da0fd93b716b0f2),
W64LIT(0x69ece10761ab93d6),
W64LIT(0x31f07920161de88b),
W64LIT(0x13299148d3401f46),
W64LIT(0x031a6d4294ded1b7),
W64LIT(0xccc96f85813b2db1),
W64LIT(0x14b8c3f2d14307b0),
W64LIT(0x8659eed4fa8706c7),
W64LIT(0xba645e377c420fe2),
W64LIT(0x2920fb2f88cc41f8),
W64LIT(0x87fc66ea25cd49aa),
W64LIT(0x1ee4588b4398fee8),
W64LIT(0xecaf62910ff244a6),
W64LIT(0xf817a163deb14316),
W64LIT(0x45e2adeea0f05402),
W64LIT(0x806d345027ce515c),
W64LIT(0x576eb498acfa0429),
W64LIT(0xa5258e82e090be67),
W64LIT(0x892bc26b21cb79b3),
W64LIT(0x6e7db3bd63a88b20),
W64LIT(0x4e1bbea9ed61e237),
W64LIT(0xadc6f08739dfd9e5),
W64LIT(0x8b9427176a5fe769),
W64LIT(0xa1aeb17a764d7726),
W64LIT(0x4b35096fa4f6641b),
W64LIT(0x22d9e868c55df7cd),
W64LIT(0x55d151e4e76e9af3),
W64LIT(0x966a12debd19c836),
W64LIT(0x0dcdc9c390d8e1ae),
W64LIT(0xf24b3a1a4c6aba4e),
W64LIT(0x24ed32ec1814a056),
W64LIT(0xaf7915fb724b473f),
W64LIT(0x2885731157860e95),
W64LIT(0x9c3689a72fc2316e),
W64LIT(0x475d4892eb64cad8),
W64LIT(0xac6378b9e6959688),
W64LIT(0xa00b3944a907384b),
W64LIT(0xc695f4fc13e0d4e9),
W64LIT(0x3055f11ec957a7e6),
W64LIT(0x6215f2402c3a25e3),
W64LIT(0xde4576f38d317d9a),
W64LIT(0x9344a518f48e4e1a),
W64LIT(0x82d2d12c6c5acf86),
W64LIT(0xefb50fd39b2c9511),
W64LIT(0xe981d5574665c28a),
W64LIT(0x5f8dca9d75b563ab),
W64LIT(0xb60c1fca33d0a121),
W64LIT(0xfe237be703f8148d),
W64LIT(0xd6a608f6547e1a18),
W64LIT(0xb97e3375e89cde55),
W64LIT(0xd388bf301de99c34),
W64LIT(0x5b06f565e368aaea),
W64LIT(0xf0f4df6607fe2494),
W64LIT(0x1607268e9ad7996a),
W64LIT(0xaedc9dc5ad010852),
W64LIT(0xe0c7236c4060ea65),
W64LIT(0xea9bb815d2bb133d),
W64LIT(0x888e4a55fe8136de),
W64LIT(0x5aa37d5b3c22e587),
W64LIT(0xc104a64611e3cc1f),
W64LIT(0x515a6e1c71b353b2),
W64LIT(0xc42a118058744a33),
W64LIT(0x7708b98c22336d3e),
W64LIT(0x2a3a966d1c12904f),
W64LIT(0x8a31af29b515a804),
W64LIT(0xed0aeaafd0b80bcb),
W64LIT(0x2c0e4ce9c15bc7d4),
W64LIT(0x0c6841fd4f92aec3),
W64LIT(0x98bdb65fb91ff82f),
W64LIT(0x1f41d0b59cd2b185),
W64LIT(0xb322a80c7a47270d),
W64LIT(0xe6f3f9e89d29bdfe),
W64LIT(0x7ac5704fb2eb8c90),
W64LIT(0xa94dcf7faf0210a4),
W64LIT(0x787a9533f97f124a),
W64LIT(0xdb6bc135c4a6fbb6),
W64LIT(0x048b3ff896ddc941),
W64LIT(0xe8245d69992f8de7),
W64LIT(0xe3dd4e2ed4be3bd2),
W64LIT(0xcafdb5015c727a2a),
W64LIT(0xb7a997f4ec9aee4c),
W64LIT(0xe75671d64263f293),
W64LIT(0x2b9f1e53c358df22),
W64LIT(0x18d0820f9ed1a973),
W64LIT(0xabf22a03e4968e7e),
W64LIT(0xa2b4dc38e293a691),
W64LIT(0x673b458665ada3cf),
W64LIT(0xf9b2295d01fb0c7b),
W64LIT(0xd22d370ec2a3d359),
W64LIT(0x97cf9ae06253875b),
W64LIT(0x0ed7a48104063019),
W64LIT(0x482f642d3028b5ac),
W64LIT(0xc0a12e78cea98372),
W64LIT(0x4fbe3697322bad5a),
W64LIT(0x19750a31419be61e),
W64LIT(0x41699216362d9d43),
W64LIT(0xd5bc65b4c0a0cbaf),
W64LIT(0xe5e994aa09f76c49),
W64LIT(0xeb3e302b0df15c50),
W64LIT(0x94d5f7a2f68d56ec),
W64LIT(0x53e58b603a27cd68),
W64LIT(0x3d9838dd598f4648),
W64LIT(0x60aa173c67aebb39),
W64LIT(0x1dfe35c9d7462f5f),
W64LIT(0x4ca45bd5a6f57ced),
W64LIT(0xbc5084b3a10b5879),
W64LIT(0xfaa8441f9525ddcc),
W64LIT(0x334f9c5c5d897651),
/* box 4 */
W64LIT(0xda1687a883adf27e),
W64LIT(0xe35c9378578d9f22),
W64LIT(0x303ca4531637fa40),
W64LIT(0xa088321f74b20375),
W64LIT(0xc9863f3a9acb95e9),
W64LIT(0x5fcf47c57d0b0ed4),
W64LIT(0x4aa211e4e1280b4b),
W64LIT(0xe1a4c9ba871d1289),
W64LIT(0x4926664759f03a4f),
W64LIT(0xadfb36ede3707bca),
W64LIT(0xcf7bd1891f8ef7e1),
W64LIT(0x9735559e8f882792),
W64LIT(0x5932a976f84e6cdc),
W64LIT(0x9dc792bef547818a),
W64LIT(0x06fdeeb385456208),
W64LIT(0x46ad38771ea2cf5b),
W64LIT(0x5eb36aa41543b27b),
W64LIT(0x8b2eb33cd1bcb511),
W64LIT(0x71105ff6e598ebbc),
W64LIT(0x5441ad846f8c1463),
W64LIT(0x4c5fff57646d6943),
W64LIT(0xf3485c49f633c9b1),
W64LIT(0x9cbbbfdf9d0f3d25),
W64LIT(0x22d031a067192178),
W64LIT(0xca0248992213a4ed),
W64LIT(0x19627fb263a9c18f),
W64LIT(0x9330e1efda5dc831),
W64LIT(0x1390b89219666797),
W64LIT(0x2edf18339893e568),
W64LIT(0x6c779435d3e4c590),
W64LIT(0x53c06e568281cac4),
W64LIT(0x6ff3e3966b3cf494),
W64LIT(0xfe3b58bb61f1b10e),
W64LIT(0x77edb14560dd89b4),
W64LIT(0x02f85ac2d0908dab),
W64LIT(0x12ec95f3712edb38),
W64LIT(0x85d9c06dfea6fcaa),
W64LIT(0x90b4964c6285f935),
W64LIT(0xf1b0068b26a3441a),
W64LIT(0x729428555d40dab8),
W64LIT(0x5c4b3066c5d33fd0),
W64LIT(0x5d371d07ad9b837f),
W64LIT(0xa48d866e2167ecd6),
W64LIT(0xb661139d504937ee),
W64LIT(0xa27068dda4228ede),
W64LIT(0xf8c6b608e4b4d306),
W64LIT(0x6bf657e73ee91b37),
W64LIT(0xac871b8c8b38c765),
W64LIT(0x4ea7a595b4fde4e8),
W64LIT(0x0d7304f297c278bf),
W64LIT(0xb71d3efc38018b41),
W64LIT(0xae7f414e5ba84ace),
W64LIT(0xaf036c2f33e0f661),
W64LIT(0x0000000000000000),
W64LIT(0xb89660cc7f537e55),
W64LIT(0xa675dcacf1f7617d),
W64LIT(0x610490c74426bd2f),
W64LIT(0xc18ca2d83094be5a),
W64LIT(0x2adaac42cd460acb),
W64LIT(0x7d1f76651a122fac),
W64LIT(0xc58916a9654151f9),
W64LIT(0xedabe0297897d699),
W64LIT(0x2d5b6f90204bd46c),
W64LIT(0x26d585d132cccedb),
W64LIT(0x9f3fc87c25d70c21),
W64LIT(0xc60d610add9960fd),
W64LIT(0x80a0597dc33bafa6),
W64LIT(0xd0e44088f9625466),
W64LIT(0x1d67cbc3367c2e2c),
W64LIT(0x2c2742f1480368c3),
W64LIT(0x89d6e9fe012c38ba),
W64LIT(0xe9ae54582d42393a),
W64LIT(0x3ecbd702392db3fb),
W64LIT(0xb5e5643ee89106ea),
W64LIT(0xa882affddeed28c6),
W64LIT(0x1ae60811db71f08b),
W64LIT(0x924ccc8eb215749e),
W64LIT(0xfcc30279b1613ca5),
W64LIT(0x825803bf13ab220d),
W64LIT(0xd992f00b3b75c37a),
W64LIT(0xc8fa125bf2832946),
W64LIT(0x35453d432baaa94c),
W64LIT(0xf9ba9b698cfc6fa9),
W64LIT(0x37bd6781fb3a24e7),
W64LIT(0x791ac2144fc7c00f),
W64LIT(0x16e9218224fb349b),
W64LIT(0xdb6aaac9ebe54ed1),
W64LIT(0xd8eedd6a533d7fd5),
W64LIT(0x7c635b04725a9303),
W64LIT(0x553d80e507c4a8cc),
W64LIT(0x9a46516c184a5f2d),
W64LIT(0x14117b40f46bb930),
W64LIT(0x1ee3bc608ea41f28),
W64LIT(0x27a9a8b05a847274),
W64LIT(0x4050d6c49be7ad53),
W64LIT(0x7be298d69f574da4),
W64LIT(0x6a8a7a8656a1a798),
W64LIT(0x4d23d2360c25d5ec),
W64LIT(0x1014cf31a1be5693),
W64LIT(0xb264a7ec059cd84d),
W64LIT(0xea2a23fb959a083e),
W64LIT(0xf0cc2bea4eebf8b5),
W64LIT(0x76919c240895351b),
W64LIT(0x0b8eea4112871ab7),
W64LIT(0x47d1151676ea73f4),
W64LIT(0xbdeff9dc42ce2d59),
W64LIT(0x2ba68123a50eb664),
W64LIT(0x057999103d9d530c),
W64LIT(0xe759270902587081),
W64LIT(0xef53baeba8075b32),
W64LIT(0x4fdb88f4dcb55847),
W64LIT(0x6e8fcef70374483b),
W64LIT(0x1168e250c9f6ea3c),
W64LIT(0x1b9a2570b3394c24),
W64LIT(0x706c72978dd05713),
W64LIT(0x865db7ce467ecdae),
W64LIT(0x52bc4337eac9766b),
W64LIT(0x504419f53a59fbc0),
W64LIT(0x8f2b074d84695ab2),
W64LIT(0x6078bda62c6e0180),
W64LIT(0x43d4a167233f9c57),
W64LIT(0x0ef773512f1a49bb),
W64LIT(0x0c0f2993ff8ac410),
W64LIT(0x4bde3c858960b7e4),
W64LIT(0x66855315a92b6388),
W64LIT(0xd360372b41ba6562),
W64LIT(0x584e84179006d073),
W64LIT(0x9b3a7c0d7002e382),
W64LIT(0xa5f1ab0f492f5079),
W64LIT(0x2822f6801dd68760),
W64LIT(0x445562b5ce3242f0),
W64LIT(0xaa7af53f0e7da56d),
W64LIT(0x3c338dc0e9bd3e50),
W64LIT(0x3bb24e1204b0e0f7),
W64LIT(0xd59dd998c4ff076a),
W64LIT(0x91c8bb2d0acd459a),
W64LIT(0x84a5ed0c96ee4005),
W64LIT(0x33b8d3f0aeefcb44),
W64LIT(0x57c5da27d7542567),
W64LIT(0x32c4fe91c6a777eb),
W64LIT(0x3439102243e215e3),
W64LIT(0xc7714c6bb5d1dc52),
W64LIT(0x3fb7fa6351650f54),
W64LIT(0x87219aaf2e367101),
W64LIT(0xf5b5b2fa7376abb9),
W64LIT(0x412cfba5f3af11fc),
W64LIT(0xdceb691b06e89076),
W64LIT(0xbb12176fc78b4f51),
W64LIT(0x73e8053435086617),
W64LIT(0xe220be193fc5238d),
W64LIT(0xb09cfd2ed50c55e6),
W64LIT(0xb9ea4dad171bc2fa),
W64LIT(0x9e43e51d4d9fb08e),
W64LIT(0x36c14ae093729848),
W64LIT(0xa9fe829cb6a59469),
W64LIT(0x0405b47155d5efa3),
W64LIT(0x0af2c7207acfa618),
W64LIT(0x7e9b01c6a2ca1ea8),
W64LIT(0xdd97447a6ea02cd9),
W64LIT(0x0781c3d2ed0ddea7),
W64LIT(0x7866ef75278f7ca0),
W64LIT(0xd1986de9912ae8c9),
W64LIT(0xcb7e65f84a5b1842),
W64LIT(0xcd838b4bcf1e7a4a),
W64LIT(0xab06d85e663519c2),
W64LIT(0xd4e1f4f9acb7bbc5),
W64LIT(0xfdbf2f18d929800a),
W64LIT(0xf23471289e7b751e),
W64LIT(0xbc93d4bd2a8691f6),
W64LIT(0x3d4fa0a181f582ff),
W64LIT(0xba6e3a0eafc3f3fe),
W64LIT(0x5ab6ded540965dd8),
W64LIT(0xeb560e9afdd2b491),
W64LIT(0x0976b083c217971c),
W64LIT(0xecd7cd4810df6a36),
W64LIT(0x23ac1cc10f519dd7),
W64LIT(0xbe6b8e7ffa161c5d),
W64LIT(0x7fe72ca7ca82a207),
W64LIT(0xc0f08fb958dc02f5),
W64LIT(0x7a9eb5b7f71ff10b),
W64LIT(0xa709f1cd99bfddd2),
W64LIT(0x8dd35d8f54f9d719),
W64LIT(0x8caf70ee3cb16bb6),
W64LIT(0xe4dd50aaba804185),
W64LIT(0x83242ede7be39ea2),
W64LIT(0x98be0baec8dad286),
W64LIT(0x690e0d25ee79969c),
W64LIT(0x95cd0f5c5f18aa39),
W64LIT(0x56b9f746bf1c99c8),
W64LIT(0x7469c6e6d805b8b0),
W64LIT(0x8a529e5db9f409be),
W64LIT(0xe6250a686a10cc2e),
W64LIT(0x2fa33552f0db59c7),
W64LIT(0x42a88c064b7720f8),
W64LIT(0x6d0bb954bbac793f),
W64LIT(0x181e52d30be17d20),
W64LIT(0xbf17a31e925ea0f2),
W64LIT(0x94b1223d37501696),
W64LIT(0xe8d27939450a8595),
W64LIT(0xccffa62aa756c6e5),
W64LIT(0x383639b1bc68d1f3),
W64LIT(0xee2f978ac04fe79d),
W64LIT(0xa30c45bccc6a3271),
W64LIT(0x1f9f9101e6eca387),
W64LIT(0xb1e0d04fbd44e949),
W64LIT(0x242ddf13e25c4370),
W64LIT(0x156d56219c23059f),
W64LIT(0x88aac49f69648415),
W64LIT(0x6280e764fcfe8c2b),
W64LIT(0xdf6f1eb8be30a172),
W64LIT(0xe5a17dcbd2c8fd2a),
W64LIT(0xe0d8e4dbef55ae26),
W64LIT(0x63fcca0594b63084),
W64LIT(0xa1f41f7e1cfabfda),
W64LIT(0x295edbe1759e3bcf),
W64LIT(0x67f97e74c163df27),
W64LIT(0x038477a3b8d83104),
W64LIT(0xde1333d9d6781ddd),
W64LIT(0x3ace63736cf85c58),
W64LIT(0xd619ae3b7c27366e),
W64LIT(0x5bcaf3b428dee177),
W64LIT(0xb3188a8d6dd464e2),
W64LIT(0x1c1be6a25e349283),
W64LIT(0x017c2d616848bcaf),
W64LIT(0x8e572a2cec21e61d),
W64LIT(0xf631c559cbae9abd),
W64LIT(0x81dc741cab731309),
W64LIT(0xff4775da09b90da1),
W64LIT(0xb499495f80d9ba45),
W64LIT(0x0f8b5e304752f514),
W64LIT(0x394a14d0d4206d5c),
W64LIT(0xce07fce877c64b4e),
W64LIT(0xf4c99f9b1b3e1716),
W64LIT(0xc4f53bc80d09ed56),
W64LIT(0xc208d57b884c8f5e),
W64LIT(0x080a9de2aa5f2bb3),
W64LIT(0x314089327e7f46ef),
W64LIT(0xfa3eecca34245ead),
W64LIT(0x20286b62b789acd3),
W64LIT(0x7515eb87b04d041f),
W64LIT(0x513834945211476f),
W64LIT(0x650124b611f3528c),
W64LIT(0x17950ce34cb38834),
W64LIT(0x45294fd4a67afe5f),
W64LIT(0x21544603dfc1107c),
W64LIT(0x485a4b2631b886e0),
W64LIT(0x6872204486312a33),
W64LIT(0x647d09d779bbee23),
W64LIT(0x2551f2728a14ffdf),
W64LIT(0xd765835a146f8ac1),
W64LIT(0xd21c1a4a29f2d9cd),
W64LIT(0x99c226cfa0926e29),
W64LIT(0xfb42c1ab5c6ce202),
W64LIT(0xc374f81ae00433f1),
W64LIT(0x964978ffe7c09b3d),
W64LIT(0xf74de838a3e62612),
/* box 5 */
W64LIT(0x74b87b36b0592c6a),
W64LIT(0x3d82d75dffb4b81c),
W64LIT(0x8884246715267825),
W64LIT(0xdaf2d8a77ed4e5de),
W64LIT(0xfeb118650e53f9c7),
W64LIT(0xbd2d1aea59226b06),
W64LIT(0x26ce87f6dbabb191),
W64LIT(0x32772ecbeb66bd0a),
W64LIT(0xd4bbf82bc5104c8c),
W64LIT(0x055357720c4e03a1),
W64LIT(0xef5be62a32d0f6fd),
W64LIT(0xbe1c84c45d186aca),
W64LIT(0xacc7e4a565a1643c),
W64LIT(0x8dd7731519687b84),
W64LIT(0x11eafe4f3c830f3a),
W64LIT(0x04ef8e68a358afe5),
W64LIT(0x40ad9ca1534b930d),
W64LIT(0xe44191d4855a5c0e),
W64LIT(0x6001d20b809420f1),
W64LIT(0x73666b70173b8243),
W64LIT(0x372479b9e728beab),
W64LIT(0x45fecbd35f0590ac),
W64LIT(0x7057f55e1301838f),
W64LIT(0xff0dc17fa1455583),
W64LIT(0x0cc467b810e804da),
W64LIT(0xb9c29482fa7ac4e3),
W64LIT(0xa003831d754960e6),
W64LIT(0x8a096353be0ad5ad),
W64LIT(0xdd2cc8e1d9b64bf7),
W64LIT(0xc7dc415052bfee3e),
W64LIT(0x9f0c137421d17572),
W64LIT(0x35a93e8d4c041323),
W64LIT(0x9a5f44062d9f76d3),
W64LIT(0x71eb2c44bc172fcb),
W64LIT(0x0ff5f99614d20516),
W64LIT(0x7789e518b4632da6),
W64LIT(0xc99561dce97b476c),
W64LIT(0x5276fcc06bf29dfb),
W64LIT(0x4a0b32454bd795ba),
W64LIT(0x9274add69e2fddec),
W64LIT(0x4f5865374799961b),
W64LIT(0xb2d8e37c4df06e10),
W64LIT(0xc4eddf7e5685eff2),
W64LIT(0xb3643a66e2e6c254),
W64LIT(0xd50721316a06e0c8),
W64LIT(0x8bb5ba49111c79e9),
W64LIT(0x2bb639546455190f),
W64LIT(0xf8d3d1390627fbaa),
W64LIT(0x38d1802ff3fabbbd),
W64LIT(0xdfa18fd5729ae67f),
W64LIT(0x4ee4bc2de88f3a5f),
W64LIT(0xf72628af12f5febc),
W64LIT(0x0aa6aee4189c06b7),
W64LIT(0x0000000000000000),
W64LIT(0x9eb0ca6e8ec7d936),
W64LIT(0xcb1826e84257eae4),
W64LIT(0x187dce8520250841),
W64LIT(0xc28f16225ef1ed9f),
W64LIT(0xc333cf38f1e741db),
W64LIT(0x4220db95f8673e85),
W64LIT(0xdc9011fb76a0e7b3),
W64LIT(0x105627559395a37e),
W64LIT(0x2f59b73cc70db6ea),
W64LIT(0xe112c6a689145faf),
W64LIT(0x82228a830dba7e92),
W64LIT(0x2ee56e26681b1aae),
W64LIT(0x2a0ae04ecb43b54b),
W64LIT(0x47738ce7f4293d24),
W64LIT(0xa7dd935bd22bcecf),
W64LIT(0xd2d93177cd644ee1),
W64LIT(0xebb4684291885918),
W64LIT(0x0e49208cbbc4a952),
W64LIT(0xa550d46f79076347),
W64LIT(0x411145bbfc5d3f49),
W64LIT(0xe6ccd6e02e76f186),
W64LIT(0x4bb7eb5fe4c139fe),
W64LIT(0x5d8305567f2098ed),
W64LIT(0x95aabd90394d73c5),
W64LIT(0x25ff19d8df91b05d),
W64LIT(0x86cd04ebaee2d177),
W64LIT(0x03319e2e043a01cc),
W64LIT(0x6b1ba5f5371e8a02),
W64LIT(0x76353c021b7581e2),
W64LIT(0x64ee5c6323cc8f14),
W64LIT(0x5c3fdc4cd03634a9),
W64LIT(0x6996e2c19c32278a),
W64LIT(0x8938fd7dba30d461),
W64LIT(0x7b4d82a0a48b297c),
W64LIT(0xbfa05ddef20ec68e),
W64LIT(0x8ee6ed3b1d527a48),
W64LIT(0x61bd0b112f828cb5),
W64LIT(0x66631b5788e0229c),
W64LIT(0x55a8ec86cc9033d2),
W64LIT(0x1c9240ed837da7a4),
W64LIT(0x150570279fdba0df),
W64LIT(0x53ca25dac4e431bf),
W64LIT(0xd636bf1f6e3ce104),
W64LIT(0xcaa4fff2ed4146a0),
W64LIT(0x787c1c8ea0b128b0),
W64LIT(0xad7b3dbfcab7c878),
W64LIT(0xfc3c5f51a57f544f),
W64LIT(0xb78bb40e41be6db1),
W64LIT(0x8c6baa0fb67ed7c0),
W64LIT(0xce4b719a4e19e945),
W64LIT(0xf96f0823a93157ee),
W64LIT(0x7d2f4bfcacff2b11),
W64LIT(0x3eb34973fb8eb9d0),
W64LIT(0xe39f81922238f227),
W64LIT(0x239dd084d7e5b230),
W64LIT(0x1fa3dec38747a668),
W64LIT(0xc5510664f99343b6),
W64LIT(0xc829b8c6466deb28),
W64LIT(0x85fc9ac5aad8d0bb),
W64LIT(0xb6376d14eea8c1f5),
W64LIT(0x9d8154408afdd8fa),
W64LIT(0x3be01e01f7c0ba71),
W64LIT(0x628c953f2bb88d79),
W64LIT(0x6d796ca93f6a886f),
W64LIT(0xfa5e960dad0b5622),
W64LIT(0xe5fd48ce2a4cf04a),
W64LIT(0xe7700ffa81605dc2),
W64LIT(0x2dd4f0086c211b62),
W64LIT(0x2221099e78f31e74),
W64LIT(0xdb4e01bdd1c2499a),
W64LIT(0xf417b68116cfff70),
W64LIT(0xb506f33aea92c039),
W64LIT(0x514762ee6fc89c37),
W64LIT(0x9c3d8d5a25eb74be),
W64LIT(0x396d59355cec17f9),
W64LIT(0xccc636aee53544cd),
W64LIT(0x0b1a77feb78aaaf3),
W64LIT(0xe9392f763aa4f490),
W64LIT(0xaaa52df96dd56651),
W64LIT(0x46cf55fd5b3f9160),
W64LIT(0xa4ec0d75d611cf03),
W64LIT(0xaff67a8b619b65f0),
W64LIT(0x3415e797e312bf67),
W64LIT(0x7af15bba0b9d8538),
W64LIT(0x811314ad09807f5e),
W64LIT(0x8771ddf101f47d33),
W64LIT(0x969b23be3d777209),
W64LIT(0xd365e86d6272e2a5),
W64LIT(0x58d05224736e9b4c),
W64LIT(0xc660984afda9427a),
W64LIT(0x5414359c63869f96),
W64LIT(0xe885f66c95b258d4),
W64LIT(0x655285798cda2350),
W64LIT(0x6cc5b5b3907c242b),
W64LIT(0x6ff42b9d944625e7),
W64LIT(0xc0025116f5dd4017),
W64LIT(0xa28ec429de65cd6e),
W64LIT(0x63304c2584ae213d),
W64LIT(0x7fa20cc807d38699),
W64LIT(0x996eda2829a5771f),
W64LIT(0x1b4c50ab241f098d),
W64LIT(0x1e1f07d928510a2c),
W64LIT(0x33cbf7d14470114e),
W64LIT(0xb055a448e6dcc398),
W64LIT(0x98d2033286b3db5b),
W64LIT(0xec6a780436eaf731),
W64LIT(0xa1bf5a07da5fcca2),
W64LIT(0xbaf30aacfe40c52f),
W64LIT(0xf144e1f31a81fcd1),
W64LIT(0xe0ae1fbc2602f3eb),
W64LIT(0x14b9a93d30cd0c9b),
W64LIT(0x596c8b3edc783708),
W64LIT(0x682a3bdb33248bce),
W64LIT(0xb87e4d98556c68a7),
W64LIT(0x80afcdb7a696d31a),
W64LIT(0x5725abb267bc9e5a),
W64LIT(0x914533f89a15dc20),
W64LIT(0x5eb29b787b1a9921),
W64LIT(0x01bcd91aaf16ac44),
W64LIT(0xc1be880c5acbec53),
W64LIT(0xedd6a11e99fc5b75),
W64LIT(0x028d4734ab2cad88),
W64LIT(0x8f5a3421b244d60c),
W64LIT(0x4dd52203ecb53b93),
W64LIT(0x3f0f906954981594),
W64LIT(0xae4aa391ce8dc9b4),
W64LIT(0x3698a0a3483e12ef),
W64LIT(0xf5ab6f9bb9d95334),
W64LIT(0x082be9d0b3b0ab3f),
W64LIT(0xd1e8af59c95e4f2d),
W64LIT(0xd87f9f93d5f84856),
W64LIT(0x6e48f2873b5089a3),
W64LIT(0x2443c0c270871c19),
W64LIT(0xb1e97d5249ca6fdc),
W64LIT(0x7c9392e603e98755),
W64LIT(0x839e5399a2acd2d6),
W64LIT(0x19c1179f8f33a405),
W64LIT(0xde1d56cfdd8c4a3b),
W64LIT(0x20ac4eaad3dfb3fc),
W64LIT(0x1af089b18b09a5c9),
W64LIT(0x3a5cc71b58d61635),
W64LIT(0x444212c9f0133ce8),
W64LIT(0x72dab26ab82d2e07),
W64LIT(0x4c69fb1943a397d7),
W64LIT(0xf3c9a6c7b1ad5159),
W64LIT(0x1d2e99f72c6b0be0),
W64LIT(0xb4ba2a2045846c7d),
W64LIT(0xe22358888d2e5e63),
W64LIT(0x2887a77a606f18c3),
W64LIT(0xa8286acdc6f9cbd9),
W64LIT(0x5f0e4262d40c3565),
W64LIT(0xeee73f309dc65ab9),
W64LIT(0x9be39d1c8289da97),
W64LIT(0x1634ee099be1a113),
W64LIT(0xea08b1583e9ef55c),
W64LIT(0x9727faa49261de4d),
W64LIT(0x2c682912c337b726),
W64LIT(0xcff7a880e10f4501),
W64LIT(0x1788371334f70d57),
W64LIT(0x27725eec74bd1dd5),
W64LIT(0x3146b0e5ef5cbcc6),
W64LIT(0x099730ca1ca6077b),
W64LIT(0xf2757fdd1ebbfd1d),
W64LIT(0x6aa77cef98082646),
W64LIT(0xbb4fd3b65156696b),
W64LIT(0x569972a8c8aa321e),
W64LIT(0xa3321d337173612a),
W64LIT(0x50fbbbf4c0de3073),
W64LIT(0x5a5d1510d84236c4),
W64LIT(0xfd80864b0a69f80b),
W64LIT(0x07de1046a762ae29),
W64LIT(0xa6614a417d3d628b),
W64LIT(0xd78a6605c12a4d40),
W64LIT(0x67dfc24d27f68ed8),
W64LIT(0xbc91c3f0f634c742),
W64LIT(0xd05476436648e369),
W64LIT(0x493aac6b4fed9476),
W64LIT(0x12db606138b90ef6),
W64LIT(0xa994b3d769ef679d),
W64LIT(0x211097b07cc91fb8),
W64LIT(0x30fa69ff404a1082),
W64LIT(0x3c3e0e4750a21458),
W64LIT(0x7504a22c1f4f802e),
W64LIT(0x844043df05ce7cff),
W64LIT(0xf0f838e9b5975095),
W64LIT(0x7e1ed5d2a8c52add),
W64LIT(0x90f9eae235037064),
W64LIT(0x0662c95c0874026d),
W64LIT(0x9416648a965bdf81),
W64LIT(0xf69af1b5bde352f8),
W64LIT(0x0d78bea2bffea89e),
W64LIT(0x293b7e60cf79b487),
W64LIT(0xd9c346897aeee412),
W64LIT(0xfbe24f17021dfa66),
W64LIT(0x1367b97b97afa2b2),
W64LIT(0xab19f4e3c2c3ca15),
W64LIT(0x48867571e0fb3832),
W64LIT(0x93c874cc313971a8),
W64LIT(0x79c0c5940fa784f4),
W64LIT(0xcd7aefb44a23e889),
W64LIT(0x439c028f577192c1),
W64LIT(0x5be1cc0a77549a80),
/* box 6 */
W64LIT(0x714d28d778656928),
W64LIT(0xc88a7c6b84f64f7c),
W64LIT(0xec43cac5ab89aaca),
W64LIT(0x777fa38110dc16a3),
W64LIT(0x0f7d5c87e4213b5c),
W64LIT(0x73f051e5f3a1ef51),
W64LIT(0xea714193c330d541),
W64LIT(0x95e5f3dae016c4f3),
W64LIT(0x63d3738095a0e173),
W64LIT(0x9825d66f8ff379d6),
W64LIT(0xe8cc38a148f45338),
W64LIT(0xa840b0c025f06bb0),
W64LIT(0x944135c35f748735),
W64LIT(0x74661caa247ad31c),
W64LIT(0xe7b16426acd56864),
W64LIT(0xd1e689df6e6f0589),
W64LIT(0xa73dec47c1d150ec),
W64LIT(0x64453ecf427bdd3e),
W64LIT(0x0ed99a9e5b43789a),
W64LIT(0x7b1b402dc05be840),
W64LIT(0x0dc025b56fe5bd25),
W64LIT(0x3f183a284e22293a),
W64LIT(0xa0aba108160a6ca1),
W64LIT(0x46be033705bd4703),
W64LIT(0x86df6e94b2b10f6e),
W64LIT(0xa216d83a9dceead8),
W64LIT(0x129e5b57edc5885b),
W64LIT(0x7e3074509c445274),
W64LIT(0x7d29cb7ba8e297cb),
W64LIT(0x1611a9330eb871a9),
W64LIT(0x486799a95efe3f99),
W64LIT(0x9fb39b205828459b),
W64LIT(0xd0424fc6d10d464f),
W64LIT(0xe968feb8f79610fe),
W64LIT(0x5d6f8fb164e08b8f),
W64LIT(0xaafdc9f2ae34edc9),
W64LIT(0x02bd79328bc48679),
W64LIT(0x9b3c6944bb55bc69),
W64LIT(0x6277b5992ac2a2b5),
W64LIT(0x877ba88d0dd34ca8),
W64LIT(0xfa5263f6a531db63),
W64LIT(0x2e9fde54974164de),
W64LIT(0xcda14816d8e9f548),
W64LIT(0x675c81e476dd1881),
W64LIT(0x2a102c30743c9d2c),
W64LIT(0x37f32be07dd82e2b),
W64LIT(0x256d70b7901da670),
W64LIT(0x4ce86bcdbd83c66b),
W64LIT(0x50afaa040b0536aa),
W64LIT(0xef5a75ee9f2f6f75),
W64LIT(0xb3913c4644ada73c),
W64LIT(0x1187e47cd9634de4),
W64LIT(0xc54a59deeb13f259),
W64LIT(0x0000000000000000),
W64LIT(0x01a4c619bf6243c6),
W64LIT(0x90cec7a7bc097ec7),
W64LIT(0xf94bdcdd91971edc),
W64LIT(0x8e347f5c814b087f),
W64LIT(0xc7f720ec60d77420),
W64LIT(0x354e52d2f61ca852),
W64LIT(0x34ea94cb497eeb94),
W64LIT(0xae723b964d49143b),
W64LIT(0xf48bf968fe72a3f9),
W64LIT(0xfc60e8a0cd88a4e8),
W64LIT(0x2909931b409a5893),
W64LIT(0xbd48a6d81feedfa6),
W64LIT(0x6cae2f077181da2f),
W64LIT(0xad6b84bd79efd184),
W64LIT(0x18c833ad55fb0933),
W64LIT(0x204644cacc021c44),
W64LIT(0x392ab17e269b56b1),
W64LIT(0x14acd001857cf7d0),
W64LIT(0x8abb8d386236f18d),
W64LIT(0xeefeb3f7204d2cb3),
W64LIT(0xf636805a75b62580),
W64LIT(0x2bb4ea29cb5edeea),
W64LIT(0xc653e6f5dfb537e6),
W64LIT(0x8d2dc077b5edcdc0),
W64LIT(0x31c1a0b6156151a0),
W64LIT(0xf8ef1ac42ef55d1a),
W64LIT(0xdbb0e125d65184e1),
W64LIT(0x82509cf051ccf69c),
W64LIT(0xe33e96424fa89196),
W64LIT(0xdf3f1341352c7d13),
W64LIT(0x8f90b9453e294bb9),
W64LIT(0x1023226566010e22),
W64LIT(0xa58095754a15d695),
W64LIT(0x2c22a7661c85e2a7),
W64LIT(0xe183ef70c46c17ef),
W64LIT(0xafd6fd8ff22b57fd),
W64LIT(0x471ac52ebadf04c5),
W64LIT(0x4d4cadd402e185ad),
W64LIT(0x916a01be036b3d01),
W64LIT(0x28ad5502fff81b55),
W64LIT(0x3657edf9c2ba6ded),
W64LIT(0xd2ff36f45ac9c036),
W64LIT(0xf1a0cd15a26d19cd),
W64LIT(0xd90d98175d950298),
W64LIT(0xf7924643cad46646),
W64LIT(0xdd826a73bee8fb6a),
W64LIT(0x9d0ee212d3ecc3e2),
W64LIT(0xb6ba083b18b21d08),
W64LIT(0x3da5431ac5e6af43),
W64LIT(0x08eb11c833fa0711),
W64LIT(0x052b347d5c1fba34),
W64LIT(0x6fb7902c45271f90),
W64LIT(0x133a9d4e52a7cb9d),
W64LIT(0x6e135635fa455c56),
W64LIT(0x725497fc4cc3ac97),
W64LIT(0xf31db42729a99fb4),
W64LIT(0x846217a639758917),
W64LIT(0x4b7e26826a58fa26),
W64LIT(0x235ffbe1f8a4d9fb),
W64LIT(0xff79578bf92e6157),
W64LIT(0xda14273c6933c727),
W64LIT(0x8b1f4b21dd54b24b),
W64LIT(0x9caa240b6c8e8024),
W64LIT(0xc1c5abba086e0bab),
W64LIT(0xde9bd5588a4e3ed5),
W64LIT(0x2d86617fa3e7a161),
W64LIT(0xbff5dfea942a59df),
W64LIT(0x66f847fdc9bf5b47),
W64LIT(0x3b97c84cad5fd0c8),
W64LIT(0x3ebcfc31f1406afc),
W64LIT(0xca3705590f32c905),
W64LIT(0x24c9b6ae2f7fe5b6),
W64LIT(0x408c88616d043888),
W64LIT(0x93d7788c88afbb78),
W64LIT(0x196cf5b4ea994af5),
W64LIT(0x9a98af5d0437ffaf),
W64LIT(0x8c89066e0a8f8e06),
W64LIT(0xab590feb1156ae0f),
W64LIT(0xd7d4028906d67a02),
W64LIT(0xe4a8db0d9873addb),
W64LIT(0xc378d28883aa8dd2),
W64LIT(0x4ff1d4e6892503d4),
W64LIT(0xd670c490b9b439c4),
W64LIT(0x65e1f8d6fd199ef8),
W64LIT(0xf2b9723e96cbdc72),
W64LIT(0xb12c4574cf692145),
W64LIT(0x569d215263bc4921),
W64LIT(0x69851b7a2d9e601b),
W64LIT(0x5e76309a50464e30),
W64LIT(0x5fd2f683ef240df6),
W64LIT(0xd8a95e0ee2f7415e),
W64LIT(0xe29a505bf0cad250),
W64LIT(0x96fc4cf1d4b0014c),
W64LIT(0x8806f40ae9f277f4),
W64LIT(0x53b6152f3fa3f315),
W64LIT(0x1c47c1c9b686f0c1),
W64LIT(0x80ede5c2da0870e5),
W64LIT(0xd5697bbb8d12fc7b),
W64LIT(0xfdc42eb972eae72e),
W64LIT(0x0bf2aee3075cc2ae),
W64LIT(0x22fb3df847c69a3d),
W64LIT(0xbadeeb97c835e3eb),
W64LIT(0xdc26ac6a018ab8ac),
W64LIT(0xbcec60c1a08c9c60),
W64LIT(0x4231f153e6c0bef1),
W64LIT(0x337cd9849ea5d7d9),
W64LIT(0x5b5d04e70c59f404),
W64LIT(0x79a6391f4b9f6e39),
W64LIT(0x5212d33680c1b0d3),
W64LIT(0xb5a3b7102c14d8b7),
W64LIT(0x7f94b249232611b2),
W64LIT(0x17b56f2ab1da326f),
W64LIT(0x59e07dd5879d727d),
W64LIT(0xebd5878a7c529687),
W64LIT(0xbb7a2d8e7757a02d),
W64LIT(0x0319bf2b34a6c5bf),
W64LIT(0x5ccb49a8db82c849),
W64LIT(0x1de307d009e4b307),
W64LIT(0x49c35fb0e19c7c5f),
W64LIT(0x55849e79571a8c9e),
W64LIT(0x7abf86347f39ab86),
W64LIT(0x9273be9537cdf8be),
W64LIT(0xe615a23f13b72ba2),
W64LIT(0x6821dd6392fc23dd),
W64LIT(0x5af9c2feb33bb7c2),
W64LIT(0x06328b5668b97f8b),
W64LIT(0x44037a058e79c17a),
W64LIT(0x83f45ae9eeaeb55a),
W64LIT(0x5739e74bdcde0ae7),
W64LIT(0xfbf6a5ef1a5398a5),
W64LIT(0xe50c1d142711ee1d),
W64LIT(0x1a754a9fde3f8f4a),
W64LIT(0x7802ff06f4fd2dff),
W64LIT(0xf52f3f714110e03f),
W64LIT(0x2674cf9ca4bb63cf),
W64LIT(0x60caccaba10624cc),
W64LIT(0xb088836d700b6283),
W64LIT(0xa6992a5e7eb3132a),
W64LIT(0xa9e476d99a922876),
W64LIT(0x6b386248a65ae662),
W64LIT(0xc2dc14913cc8ce14),
W64LIT(0x76db6598afbe5565),
W64LIT(0x32d81f9d21c7941f),
W64LIT(0x21e282d373605f82),
W64LIT(0xc0616da3b70c486d),
W64LIT(0x616e0ab21e64670a),
W64LIT(0x6d0ae91ecee399e9),
W64LIT(0x27d009851bd92009),
W64LIT(0xfedd9192464c2291),
W64LIT(0x45a7bc1c311b82bc),
W64LIT(0x54205860e878cf58),
W64LIT(0xa10f6711a9682f67),
W64LIT(0x9981107630913a10),
W64LIT(0xede70cdc14ebe90c),
W64LIT(0x70e9eecec7072aee),
W64LIT(0x1f5e7ee28220357e),
W64LIT(0x2f3b184d28232718),
W64LIT(0x41284e78d2667b4e),
W64LIT(0xa424536cf5779553),
W64LIT(0xa3b21e2322aca91e),
W64LIT(0x4e5512ff36474012),
W64LIT(0x1efab8fb3d4276b8),
W64LIT(0x89a2321356903432),
W64LIT(0xcb93c340b0508ac3),
W64LIT(0x306566afaa031266),
W64LIT(0x4adae09bd53ab9e0),
W64LIT(0xc92eba723b940cba),
W64LIT(0x094fd7d18c9844d7),
W64LIT(0xcc058e0f678bb68e),
W64LIT(0xd4cdbda23270bfbd),
W64LIT(0x0a5668fab83e8168),
W64LIT(0x510b6c1db467756c),
W64LIT(0xb86392a543f16592),
W64LIT(0x048ff264e37df9f2),
W64LIT(0x3a330e55123d930e),
W64LIT(0xb235fa5ffbcfe4fa),
W64LIT(0xb9c754bcfc932654),
W64LIT(0x3c0185037a84ec85),
W64LIT(0x0c64e3acd087fee3),
W64LIT(0xe02729697b0e5429),
W64LIT(0x07964d4fd7db3c4d),
W64LIT(0x814923db656a3323),
W64LIT(0x388e776799f91577),
W64LIT(0x6a9ca4511938a5a4),
W64LIT(0x1bd18c86615dcc8c),
W64LIT(0xb407710993769b71),
W64LIT(0x150816183a1eb416),
W64LIT(0x4395374a59a2fd37),
W64LIT(0xc4ee9fc75471b19f),
W64LIT(0x5844bbcc38ff31bb),
W64LIT(0xcf1c3124532d7331),
W64LIT(0xb71ece22a7d05ece),
W64LIT(0xaccf42a4c68d9242),
W64LIT(0x97588ae86bd2428a),
W64LIT(0x75c2dab39b1890da),
W64LIT(0x9e175d39e74a065d),
W64LIT(0xf0040b0c1d0f5a0b),
W64LIT(0xceb8f73dec4f30f7),
W64LIT(0xbe5119f32b481a19),
W64LIT(0xd35bf0ede5ab83f0),
W64LIT(0x7c8d0d621780d40d),
W64LIT(0x85c6d1bf8617cad1),
/* box 7 */
W64LIT(0xb1c742127b66f2a4),
W64LIT(0xce916098d7a59fc1),
W64LIT(0xc312ef8e2406fa70),
W64LIT(0x956c7dced81403d5),
W64LIT(0x5a0c9b2318dd9520),
W64LIT(0xad0d57f51a480e8b),
W64LIT(0xe7b9d05287740b01),
W64LIT(0x0217f9ea2ed81268),
W64LIT(0x4d7cff19f8cd3a06),
W64LIT(0x44d1772e572b7b67),
W64LIT(0xfb73c5b5e65af72e),
W64LIT(0x91427aef84512705),
W64LIT(0x0c720963e4cf6c85),
W64LIT(0x87c398a0732d8117),
W64LIT(0xa17f5e96fe87620e),
W64LIT(0x50476c8b8e8fcf1d),
W64LIT(0xcb4ee1cc9c8cb225),
W64LIT(0x67b2304c91a8b59a),
W64LIT(0x54696baad2caebcd),
W64LIT(0xddcf03836bf01437),
W64LIT(0x46c68ec479f3690f),
W64LIT(0x8f9f96e2cba7c942),
W64LIT(0xe1802e99f5e93db9),
W64LIT(0x4e9a8086c179215a),
W64LIT(0xf0c9b4686764a427),
W64LIT(0xfd4a3b7e94c7c196),
W64LIT(0xfcbbbd0b83abc8a2),
W64LIT(0xebcbd93163bb6784),
W64LIT(0xf9643c5fc882e546),
W64LIT(0xc4da973041f7c5fc),
W64LIT(0x1af3eb2c13b3ca97),
W64LIT(0x6e1fb87b3e4ef4fb),
W64LIT(0x5e229c024498b1f0),
W64LIT(0xf516353c2c4d89c3),
W64LIT(0xcc869972f97d8da9),
W64LIT(0x8d886f08e57fdb2a),
W64LIT(0x1cca15e7612efc2f),
W64LIT(0x567e9240fc12f9a5),
W64LIT(0x43190f9032da44eb),
W64LIT(0xfeac44e1ad73daca),
W64LIT(0x07c878be65f13f8c),
W64LIT(0x618bce87e3358322),
W64LIT(0xf895ba2adfeeec72),
W64LIT(0x751dd5223a913758),
W64LIT(0x59eae4bc21698e7c),
W64LIT(0xff5dc294ba1fd3fe),
W64LIT(0x03e67f9f39b41b5c),
W64LIT(0x2292c117d1efc7c9),
W64LIT(0x8a4017b6808ee4a6),
W64LIT(0xd1bd0ae08f3f78b2),
W64LIT(0x135e631bbc558bf6),
W64LIT(0xee14586528924a60),
W64LIT(0x8857ee5cae56f6ce),
W64LIT(0x0000000000000000),
W64LIT(0x0e65f089ca177eed),
W64LIT(0x34132358269361db),
W64LIT(0x15679dd0cec8bd4e),
W64LIT(0x800be01e16dcbe9b),
W64LIT(0x949dfbbbcf780ae1),
W64LIT(0xe397d773db312fd1),
W64LIT(0xedf227fa1126513c),
W64LIT(0xb5e945332723d674),
W64LIT(0x53a11314b73bd441),
W64LIT(0x23634762c683cefd),
W64LIT(0x4b4501d28a500cbe),
W64LIT(0x473708b16e9f603b),
W64LIT(0x1770643ae010af26),
W64LIT(0xa746a05d8c1a54b6),
W64LIT(0x90b3fc9a933d2e31),
W64LIT(0x35e2a52d31ff68ef),
W64LIT(0xab34a93e68d53833),
W64LIT(0xd81082d720d939d3),
W64LIT(0xb86aca25d480b3c5),
W64LIT(0xdfd8fa694528065f),
W64LIT(0x4f6b06f3d615286e),
W64LIT(0x578f1435eb7ef091),
W64LIT(0x9af80b32056f740c),
W64LIT(0x92a40570bde53c59),
W64LIT(0xdbf6fd48196d228f),
W64LIT(0x1b026d5904dfc3a3),
W64LIT(0x3c4f2d1a9e19298e),
W64LIT(0xc8a89e53a538a979),
W64LIT(0x991e74ad3cdb6f50),
W64LIT(0x042e07215c4524d0),
W64LIT(0x8e6e1097dccbc076),
W64LIT(0xe071a8ece285348d),
W64LIT(0xd784f42bfda24e0a),
W64LIT(0x7d41db60821b7f0d),
W64LIT(0x85d4614a5df5937f),
W64LIT(0xbb8cb5baed34a899),
W64LIT(0x40ff700f0b6e5fb7),
W64LIT(0x2cf7319e1bf8b924),
W64LIT(0x3a76d3d1ec841f36),
W64LIT(0x4520f15b40477253),
W64LIT(0xf138321d7008ad13),
W64LIT(0x42e889e525b64ddf),
W64LIT(0x65a5c9a6bf70a7f2),
W64LIT(0x208538fdff37d5a1),
W64LIT(0x410ef67a1c025683),
W64LIT(0x18e412c63d6bd8ff),
W64LIT(0x72d5ad9c5f6008d4),
W64LIT(0x255ab9a9b41ef845),
W64LIT(0x93558305aa89356d),
W64LIT(0x70c2547671b81abc),
W64LIT(0x3604dab2084b73b3),
W64LIT(0x05df81544b292de4),
W64LIT(0xf2de4d8249bcb64f),
W64LIT(0x0bba71dd813e5309),
W64LIT(0xa368a77cd05f7066),
W64LIT(0x796fdc41de5e5bdd),
W64LIT(0xec03a18f064a5808),
W64LIT(0x085c0e42b88a4855),
W64LIT(0x274d40439ac6ea2d),
W64LIT(0x31cca20c6dba4c3f),
W64LIT(0x322add93540e5763),
W64LIT(0xb60f3aac1e97cd28),
W64LIT(0x7cb05d1595777639),
W64LIT(0xb036c4676c0afb90),
W64LIT(0x0a4bf7a896525a3d),
W64LIT(0x73242be9480c01e0),
W64LIT(0x5bfd1d560fb19c14),
W64LIT(0x7b7825abf08649b5),
W64LIT(0xb7febcd909fbc41c),
W64LIT(0x81fa666b01b0b7af),
W64LIT(0xd25b757fb68b63ee),
W64LIT(0x0d838f16f3a365b1),
W64LIT(0x6a31bf5a620bd02b),
W64LIT(0x26bcc6368daae319),
W64LIT(0x9ed60c13592a50dc),
W64LIT(0x581b62c936058748),
W64LIT(0x9cc1f5f977f242b4),
W64LIT(0x83ed9f812f68a5c7),
W64LIT(0x74ec53572dfd3e6c),
W64LIT(0xb3d0bbf855bee0cc),
W64LIT(0xacfcd1800d2407bf),
W64LIT(0x303d24797ad6450b),
W64LIT(0x7a89a3dee7ea4081),
W64LIT(0x69d7c0c55bbfcb77),
W64LIT(0x770a2cc814492530),
W64LIT(0x0f9476fcdd7b77d9),
W64LIT(0xaeeb286a23fc15d7),
W64LIT(0x2174be88e85bdc95),
W64LIT(0xde297c1c52440f6b),
W64LIT(0xd04c8c9598537186),
W64LIT(0x2ee0c8743520ab4c),
W64LIT(0x977b8424f6cc11bd),
W64LIT(0x10b81c8485e190aa),
W64LIT(0xa4a0dfc2b5ae4fea),
W64LIT(0x98eff2d82bb76664),
W64LIT(0xa8d2d6a15161236f),
W64LIT(0xd4628bb4c4165556),
W64LIT(0x682646b04cd3c243),
W64LIT(0x2d06b7eb0c94b010),
W64LIT(0x626db118da81987e),
W64LIT(0x2928b0ca50d194c0),
W64LIT(0x6df9c7e407faefa7),
W64LIT(0x1681e24ff77ca612),
W64LIT(0x4952f838a4881ed6),
W64LIT(0x76fbaabd03252c04),
W64LIT(0xc73ce8af7843dea0),
W64LIT(0xe82da6ae5a0f7cd8),
W64LIT(0xc10516640adee818),
W64LIT(0x968a0251e1a01889),
W64LIT(0x37f55cc71f277a87),
W64LIT(0xe5ae29b8a9ac1969),
W64LIT(0xcabf67b98be0bb11),
W64LIT(0xf4e7b3493b2180f7),
W64LIT(0xe9dc20db4d6375ec),
W64LIT(0x639c376dcded914a),
W64LIT(0x12afe56eab3982c2),
W64LIT(0xc2e369fb336af344),
W64LIT(0xa6b726289b765d82),
W64LIT(0x14961ba5d9a4b47a),
W64LIT(0xbc44cd0488c59715),
W64LIT(0xd3aaf30aa1e76ada),
W64LIT(0x28d936bf47bd9df4),
W64LIT(0xaf1aae1f34901ce3),
W64LIT(0x2f114e01224ca278),
W64LIT(0xe648562790180235),
W64LIT(0x24ab3fdca372f171),
W64LIT(0x52509561a057dd75),
W64LIT(0xc6cd6eda6f2fd794),
W64LIT(0xa08ed8e3e9eb6b3a),
W64LIT(0x09ad8837afe64161),
W64LIT(0xbdb54b719fa99e21),
W64LIT(0x8c79e97df213d21e),
W64LIT(0xcf60e6edc0c996f5),
W64LIT(0x5dc4e39d7d2caaac),
W64LIT(0x11499af1928d999e),
W64LIT(0x5fd31a7753f4b8c4),
W64LIT(0x01f18675176c0934),
W64LIT(0xc52b1145569bccc8),
W64LIT(0x9f278a664e4659e8),
W64LIT(0x3dbeab6f897520ba),
W64LIT(0xa2992109c7337952),
W64LIT(0x9b098d4712037d38),
W64LIT(0xc9591826b254a04d),
W64LIT(0x3b8755a4fbe81602),
W64LIT(0xbe5334eea61d857d),
W64LIT(0x51b6eafe99e3c629),
W64LIT(0x191594b32a07d1cb),
W64LIT(0x1f2c6a78589ae773),
W64LIT(0x3fa95285a7ad32d2),
W64LIT(0x5c3565e86a40a398),
W64LIT(0xb2213d8d42d2e9f8),
W64LIT(0xefe5de103ffe4354),
W64LIT(0x4ab487a79d3c058a),
W64LIT(0xcd771f07ee11849d),
W64LIT(0xbfa2b29bb1718c49),
W64LIT(0xba7d33cffa58a1ad),
W64LIT(0x6fee3e0e2922fdcf),
W64LIT(0x64544fd3a81caec6),
W64LIT(0xd9e104a237b530e7),
W64LIT(0xf32fcbf75ed0bf7b),
W64LIT(0x3e58d4f0b0c13be6),
W64LIT(0xb418c346304fdf40),
W64LIT(0xaac52f4b7fb93107),
W64LIT(0xdc3e85f67c9c1d03),
W64LIT(0xd5930dc1d37a5c62),
W64LIT(0x0639fecb729d36b8),
W64LIT(0xc0f490111db2e12c),
W64LIT(0x7ea7a4ffbbaf6451),
W64LIT(0xf6f04aa315f9929f),
W64LIT(0x6643b63986c4bcae),
W64LIT(0x6c0841911096e693),
W64LIT(0x8425e73f4a999a4b),
W64LIT(0x7133d20366d41388),
W64LIT(0x38612a3bc25c0d5e),
W64LIT(0xb99b4c50c3ecbaf1),
W64LIT(0x1d3b93927642f51b),
W64LIT(0x7f56228aacc36d65),
W64LIT(0x9d30738c609e4b80),
W64LIT(0x48a37e4db3e417e2),
W64LIT(0x8bb191c397e2ed92),
W64LIT(0x2acecf5569658f9c),
W64LIT(0xda077b3d0e012bbb),
W64LIT(0xa55159b7a2c246de),
W64LIT(0x33db5be643625e57),
W64LIT(0x821c19f43804acf3),
W64LIT(0x3990ac4ed530046a),
W64LIT(0xd675725eeace473e),
W64LIT(0x789e5a34c93252e9),
W64LIT(0x86321ed564418823),
W64LIT(0xfa8243c0f136fe1a),
W64LIT(0xe45fafcdbec0105d),
W64LIT(0x2b3f49207e0986a8),
W64LIT(0xa92350d4460d2a5b),
W64LIT(0x1eddec0d4ff6ee47),
W64LIT(0x89a66829b93afffa),
W64LIT(0x607a48f2f4598a16),
W64LIT(0x6bc0392f7567d91f),
W64LIT(0xea3a5f4474d76eb0),
W64LIT(0x5598eddfc5a6e2f9),
W64LIT(0x4c8d796cefa13332),
W64LIT(0xf701ccd602959bab),
W64LIT(0xe2665106cc5d26e5),
};

static const word64 SHARK_dec_cbox[8*256] =
{
/* box 0 */
W64LIT(0xe6126af05e55aff3),
W64LIT(0x4b6c893f310b0835),
W64LIT(0xaa4c0e84ebfc8d57),
W64LIT(0xfb9b5c7bf3b3090d),
W64LIT(0x4508a6a9ccba5ce2),
W64LIT(0xe5d1d2064dc6bde9),
W64LIT(0x348343755288edde),
W64LIT(0xb684505de46b250c),
W64LIT(0xa8cede205a1e91e8),
W64LIT(0x40b89b46f9fa6acc),
W64LIT(0x8ee1ec1afab080ba),
W64LIT(0xde77d6b7408e0a45),
W64LIT(0x9a3e184c2e455802),
W64LIT(0xbe93fad23f0955ef),
W64LIT(0x3ae76ce3af39b909),
W64LIT(0xad7ee3cf6f5ea7c6),
W64LIT(0x8b51d1f5cff0b694),
W64LIT(0x70ca8d8e3c43bf99),
W64LIT(0xccdba7f8b2a8f6c9),
W64LIT(0x4c5e6474b5a922a4),
W64LIT(0x5d31adcd541ccc32),
W64LIT(0x9b7f701e8c3456a7),
W64LIT(0x2ac9cd08ecfd593a),
W64LIT(0x8fa0844858c18e1f),
W64LIT(0x32f0c66c745bc9ea),
W64LIT(0xc58d6525cbbb888f),
W64LIT(0x8c633cbe4b529c05),
W64LIT(0xf2cd9ea68aa0774b),
W64LIT(0x2cba4811ca2e7d0e),
W64LIT(0xe2e33f4dc9649778),
W64LIT(0xf4be1bbfac73537f),
W64LIT(0x22de6787379f29d9),
W64LIT(0x0956c2dd79137e46),
W64LIT(0xe061efe978868bc7),
W64LIT(0x1cc85ed90f97a85b),
W64LIT(0x31337e9a67c8dbf0),
W64LIT(0x360193d1e36af161),
W64LIT(0x7fefca4a6383e5eb),
W64LIT(0x8535fe633241e243),
W64LIT(0xc3fee03ced68acbb),
W64LIT(0x81c4abdea570dac8),
W64LIT(0x67d6c12efb25753b),
W64LIT(0xa4282112164dd980),
W64LIT(0xcf181f0ea13be4d3),
W64LIT(0xa98fb672f86f9f4d),
W64LIT(0x5c70c59ff66dc297),
W64LIT(0xb0f7d544c2b80138),
W64LIT(0x0da79760ee2246cd),
W64LIT(0x3740fb83411bffc4),
W64LIT(0x24ade29e114c0ded),
W64LIT(0xf858e48de0201b17),
W64LIT(0x0e642f96fdb154d7),
W64LIT(0xddb46e41531d185f),
W64LIT(0x25ec8accb33d0348),
W64LIT(0x0282d0a4b1e21cbf),
W64LIT(0x1bfab3928b3582ca),
W64LIT(0xaffc336bdebcbb79),
W64LIT(0x35c22b27f0f9e37b),
W64LIT(0x03c3b8f61393121a),
W64LIT(0xb8e07fcb19da71db),
W64LIT(0x99fda0ba3dd64a18),
W64LIT(0xce59775c034aea76),
W64LIT(0x49ee599b80e9148a),
W64LIT(0xfe2b6194c6f33f23),
W64LIT(0x4edcb4d0044b3e1b),
W64LIT(0xd5a3c4ce887f68bc),
W64LIT(0xdf36bee5e2ff04e0),
W64LIT(0x171c4ca0c766caa2),
W64LIT(0x0bd41279c8f162f9),
W64LIT(0xe490ba54efb7b34c),
W64LIT(0x5b4228d472cfe806),
W64LIT(0x5355825ba9ad98e5),
W64LIT(0x9f8e25a31b056e2c),
W64LIT(0xcd9acfaa10d9f86c),
W64LIT(0x88926903dc63a48e),
W64LIT(0xb40680f9558939b3),
W64LIT(0x239f0fd595ee277c),
W64LIT(0xec8710db34d5c3af),
W64LIT(0x87b72ec783a3fefc),
W64LIT(0x632794936c144db0),
W64LIT(0x46cb1e5fdf294ef8),
W64LIT(0x83467b7a1492c677),
W64LIT(0x9c4d9d5508967c36),
W64LIT(0xd6607c389bec7aa6),
W64LIT(0x165d24f26517c407),
W64LIT(0xc4cc0d7769ca862a),
W64LIT(0xcbe94ab3360adc58),
W64LIT(0x847496319030ece6),
W64LIT(0x7a5ff7a556c3d3c5),
W64LIT(0xc03d58cafefbbea1),
W64LIT(0x76b908971a909bad),
W64LIT(0x2f79f0e7d9bd6f14),
W64LIT(0x197863363ad79e75),
W64LIT(0xda86830ad7bf32ce),
W64LIT(0x5a034086d0bee6a3),
W64LIT(0x97998f2cc0671ecf),
W64LIT(0x552607428f7ebcd1),
W64LIT(0x51d752ff184f845a),
W64LIT(0xbb23c73d0a4963c1),
W64LIT(0x2b88a55a4e8c579f),
W64LIT(0xd80453ae665d2e71),
W64LIT(0xee05c07f8537df10),
W64LIT(0x423a4be248187673),
W64LIT(0xcaa822e1947bd2fd),
W64LIT(0x1abbdbc029448c6f),
W64LIT(0x96d8e77e6216106a),
W64LIT(0x6266fcc1ce654315),
W64LIT(0x89d301517e12aa2b),
W64LIT(0x730935782fd0ad83),
W64LIT(0x8085c38c0701d46d),
W64LIT(0x6b303e1cb7763d53),
W64LIT(0x3f57510c9a798f27),
W64LIT(0x4449cefb6ecb5247),
W64LIT(0x48af31c922981a2f),
W64LIT(0x98bcc8e89fa744bd),
W64LIT(0x69b2eeb8069421ec),
W64LIT(0xebb5fd90b077e93e),
W64LIT(0x6a71564e150733f6),
W64LIT(0x116fc9b9e1b5ee96),
W64LIT(0x4a2de16d937a0690),
W64LIT(0xb9a11799bbab7f7e),
W64LIT(0x9368da9157562644),
W64LIT(0x718be5dc9e32b13c),
W64LIT(0xc82af2452599ce42),
W64LIT(0xb547e8abf7f83716),
W64LIT(0x33b1ae3ed62ac74f),
W64LIT(0x799c4f534550c1df),
W64LIT(0x3e16395e38088182),
W64LIT(0x7c2c72bc7010f7f1),
W64LIT(0xf38cf6f428d179ee),
W64LIT(0xd29129850cdd422d),
W64LIT(0x41f9f3145b8b6469),
W64LIT(0x945a37dad3f40cd5),
W64LIT(0x757ab061090389b7),
W64LIT(0x6554118a4ac76984),
W64LIT(0x7d6d1aeed261f954),
W64LIT(0x01416852a2710ea5),
W64LIT(0xb27505e0735a1d87),
W64LIT(0x77f860c5b8e19508),
W64LIT(0x78dd2701e721cf7a),
W64LIT(0xe12087bbdaf78562),
W64LIT(0x86f6469521d2f059),
W64LIT(0xef44a82d2746d1b5),
W64LIT(0xbc112a768eeb4950),
W64LIT(0xc2bf886e4f19a21e),
W64LIT(0x307216c8c5b9d555),
W64LIT(0xc96b9a1787e8c0e7),
W64LIT(0xa31acc5992eff311),
W64LIT(0xa0d974af817ce10b),
W64LIT(0xdcf50613f16c16fa),
W64LIT(0xfca9b1307711239c),
W64LIT(0x57a4d7e63e9ca06e),
W64LIT(0xc64eddd3d8289a95),
W64LIT(0xa25ba40b309efdb4),
W64LIT(0x2e3898b57bcc61b1),
W64LIT(0xf5ff73ed0e025dda),
W64LIT(0xa6aaf1b6a7afc53f),
W64LIT(0xd9453bfcc42c20d4),
W64LIT(0x9d0cf507aae77293),
W64LIT(0x290a75feff6e4b20),
W64LIT(0xa7eb99e405decb9a),
W64LIT(0xa1981cfd230defae),
W64LIT(0x12ac714ff226fc8c),
W64LIT(0x743bd833ab728712),
W64LIT(0x6c02d35733d417c2),
W64LIT(0xe9372d340195f581),
W64LIT(0xf77da349bfe04165),
W64LIT(0x68f386eaa4e52f49),
W64LIT(0x211ddf71240c3bc3),
W64LIT(0x13ed191d5057f229),
W64LIT(0xe8764566a3e4fb24),
W64LIT(0xf9198cdf425115b2),
W64LIT(0xd013f921bd3f5e92),
W64LIT(0x91ea0a35e6b43afb),
W64LIT(0x0732ed4b84a22a91),
W64LIT(0xeaf495c21206e79b),
W64LIT(0x5214ea090bdc9640),
W64LIT(0x0000000000000000),
W64LIT(0xb3346db2d12b1322),
W64LIT(0x0ce6ff324c534868),
W64LIT(0xaebd5b397ccdb5dc),
W64LIT(0x0a957a2b6a806c5c),
W64LIT(0x1f0be62f1c04ba41),
W64LIT(0x14dff456d4f5d8b8),
W64LIT(0x58819022615cfa1c),
W64LIT(0x05b03def3540362e),
W64LIT(0xe3a2571f6b1599dd),
W64LIT(0x9229b2c3f52728e1),
W64LIT(0xba62af6fa8386d64),
W64LIT(0x0673851926d32434),
W64LIT(0x641579d8e8b66721),
W64LIT(0x04f155bd9731388b),
W64LIT(0x9ecf4df1b9746089),
W64LIT(0x205cb723867d3566),
W64LIT(0x102ea1eb43c4e033),
W64LIT(0x3ba604b10d48b7ac),
W64LIT(0x50963aadba3e8aff),
W64LIT(0xac3f8b9dcd2fa963),
W64LIT(0x7b1e9ff7f4b2dd60),
W64LIT(0xf63ccb1b1d914fc0),
W64LIT(0x7eaea218c1f2eb4e),
W64LIT(0x5fb37d69e5fed08d),
W64LIT(0x56e5bfb49cedaecb),
W64LIT(0x2dfb2043685f73ab),
W64LIT(0x61a54437ddf6510f),
W64LIT(0x6fc16ba1204705d8),
W64LIT(0xe75302a2fc24a156),
W64LIT(0x3dd581a82b9b9398),
W64LIT(0xdbc7eb5875ce3c6b),
W64LIT(0x90ab626744c5345e),
W64LIT(0x59c0f870c32df4b9),
W64LIT(0x6697a97c59547b9e),
W64LIT(0xfde8d962d5602d39),
W64LIT(0xd3d041d7aeac4c88),
W64LIT(0x5ef2153b478fde28),
W64LIT(0xd4e2ac9c2a0e6619),
W64LIT(0x1e4a8e7dbe75b4e4),
W64LIT(0x72485d2a8da1a326),
W64LIT(0x437b23b0ea6978d6),
W64LIT(0x159e9c047684d61d),
W64LIT(0x0f2547c45fc05a72),
W64LIT(0xf10e265099336551),
W64LIT(0x3c94e9fa89ea9d3d),
W64LIT(0xbfd292809d785b4a),
W64LIT(0x0817aa8fdb6270e3),
W64LIT(0x60e42c657f875faa),
W64LIT(0x18390b6498a690d0),
W64LIT(0x478a760d7d58405d),
W64LIT(0x284b1dac5d1f4585),
W64LIT(0xb1b6bd1660c90f9d),
W64LIT(0xd15291731f4e5037),
W64LIT(0x4d1f0c2617d82c01),
W64LIT(0xc70fb5817a599430),
W64LIT(0x6d43bb0591a51967),
W64LIT(0x6e8003f382360b7d),
W64LIT(0x1d89368bade6a6fe),
W64LIT(0x4f9ddc82a63a30be),
W64LIT(0xedc6788996a4cd0a),
W64LIT(0xab0d66d6498d83f2),
W64LIT(0x54676f102d0fb274),
W64LIT(0xc17c30985c8ab004),
W64LIT(0x3865bc471edba5b6),
W64LIT(0x3924d415bcaaab13),
W64LIT(0x951b5f8871850270),
W64LIT(0x8a10b9a76d81b831),
W64LIT(0xbd5042242c9a47f5),
W64LIT(0xa5694940b43cd725),
W64LIT(0xff6a09c664823186),
W64LIT(0x8d2254ece92392a0),
W64LIT(0xb7c5380f461a2ba9),
W64LIT(0x82071328b6e3c8d2),
W64LIT(0xd721146a399d7403),
W64LIT(0xfada342951c207a8),
W64LIT(0x262f323aa0ae1152),
W64LIT(0xf04f4e023b426bf4),
W64LIT(0x276e5a6802df1ff7),
/* box 1 */
W64LIT(0x3b4016dbfd16e203),
W64LIT(0x9a7574c51174530a),
W64LIT(0x90012e69c02ec8d3),
W64LIT(0xf44580e3d780e076),
W64LIT(0xf81dec2b49eca14b),
W64LIT(0x26cae3e8a6e3d7ef),
W64LIT(0x0962419e0c41f6ab),
W64LIT(0x54d1eb4070ebd951),
W64LIT(0x865e884b0188eec8),
W64LIT(0xdf76067ea406fe8a),
W64LIT(0x29849412e594fba0),
W64LIT(0x461569896869c0f2),
W64LIT(0xb5ddd6b3bbd6724e),
W64LIT(0x0c586cc89e6c413d),
W64LIT(0x6b0ad97054d904ea),
W64LIT(0xa135621eec62b109),
W64LIT(0x0eef7e47087ea461),
W64LIT(0xfaaafea4dffe4417),
W64LIT(0xe0ad344e80342331),
W64LIT(0xab4138b23d382ad0),
W64LIT(0x107390468e90fcff),
W64LIT(0xbe0885a2218561b9),
W64LIT(0xdbed22957d22c132),
W64LIT(0x2251c7037fc7e857),
W64LIT(0x33835ef8ba5e9c86),
W64LIT(0xb3f1e0d7f4e0a8aa),
W64LIT(0x3fdb32302432ddbb),
W64LIT(0xa719547aa3546bed),
W64LIT(0xe10c3df3cb3dab1f),
W64LIT(0x17feaf9f8aafae35),
W64LIT(0x9df84b1c154b01c0),
W64LIT(0x8364a51d93a5595e),
W64LIT(0x535cd49974d48b9b),
W64LIT(0x01a109bd4b09882e),
W64LIT(0xc4d0c529b0c51182),
W64LIT(0x2e09abcbe1aba96a),
W64LIT(0x1f3de7bccde7d0b0),
W64LIT(0x9317355b1d35a5a1),
W64LIT(0x6c87e6a950e65620),
W64LIT(0x8910ffb142ffc287),
W64LIT(0x40395fed275f1a16),
W64LIT(0x7b794936da49f815),
W64LIT(0xf269b68798b63a92),
W64LIT(0xfd27c17ddbc116dd),
W64LIT(0x8d8bdb5a9bdbfd3f),
W64LIT(0x1ba6c35714c3ef08),
W64LIT(0x6e30f426c6f4b37c),
W64LIT(0x7fe26ddd036dc7ad),
W64LIT(0x14e8b4ad57b4c347),
W64LIT(0xb985ba7b25ba3373),
W64LIT(0xe9cf75d08c75d59a),
W64LIT(0x626898ee5898f241),
W64LIT(0x5b9f9cba339cf51e),
W64LIT(0xb250e96abfe92084),
W64LIT(0x165fa622c1a6261b),
W64LIT(0xf5e4895e9c896858),
W64LIT(0xb76ac43c2dc49712),
W64LIT(0x02b7128f9612e55c),
W64LIT(0x1d8af5335bf535ec),
W64LIT(0x36b973ae28732b10),
W64LIT(0xa8572380e02347a2),
W64LIT(0xf6f2926c4192052a),
W64LIT(0x8c2ad2e7d0d27511),
W64LIT(0xd32e6ab63a6abfb7),
W64LIT(0xbd1e9e90fc9e0ccb),
W64LIT(0x03161b32dd1b6d72),
W64LIT(0x4dc03a98f23ad305),
W64LIT(0x81d3b79205b7bc02),
W64LIT(0x450372bbb572ad80),
W64LIT(0x2d1fb0f93cb0c418),
W64LIT(0x2a928f20388f96d2),
W64LIT(0x721b08a8d6080ebe),
W64LIT(0x92b63ce6563c2d8f),
W64LIT(0xeb78675f1a6730c6),
W64LIT(0x13658b74538b918d),
W64LIT(0x428e4d62b14dff4a),
W64LIT(0x88b1f60c09f64aa9),
W64LIT(0x75963771d2375c74),
W64LIT(0x7ad8408b9140703b),
W64LIT(0x57c7f072adf0b423),
W64LIT(0xe5971918121994a7),
W64LIT(0x5666f9cfe6f93c0d),
W64LIT(0x8f3cc9d50dc91863),
W64LIT(0x1e9cee0186ee589e),
W64LIT(0x8a06e4839fe4aff5),
W64LIT(0xb824b3c66eb3bb5d),
W64LIT(0xd1997839ac785aeb),
W64LIT(0x6752b5b8cab545d7),
W64LIT(0xb47cdf0ef0dffa60),
W64LIT(0x949a0a82190af76b),
W64LIT(0xc04be1c269e12e3a),
W64LIT(0xfc86c8c090c89ef3),
W64LIT(0xe3bb2f7c5d2f4e43),
W64LIT(0x6aabd0cd1fd08cc4),
W64LIT(0x2147dc31a2dc8525),
W64LIT(0xca3fbb6eb8bbb5e3),
W64LIT(0x48fa17ce60176493),
W64LIT(0x6444ae8a17ae28a5),
W64LIT(0x2b33869d73861efc),
W64LIT(0xd0387184e771d2c5),
W64LIT(0x7cf476efde76aadf),
W64LIT(0x63c9915313917a6f),
W64LIT(0xc929a05c65a0d891),
W64LIT(0xda4c2b28362b491c),
W64LIT(0xfe31da4f06da7baf),
W64LIT(0xc1eae87f22e8a614),
W64LIT(0x5c12a36337a3a7d4),
W64LIT(0x18b0d865c9d8827a),
W64LIT(0xe7200b97840b71fb),
W64LIT(0x4bec0cfcbd0c09e1),
W64LIT(0x0f4e77fa43772c4f),
W64LIT(0x4c613325b9335b2b),
W64LIT(0xf3c8bf3ad3bfb2bc),
W64LIT(0x87ff81f64a8166e6),
W64LIT(0xa38270917a705455),
W64LIT(0x1911d1d882d10a54),
W64LIT(0x44a27b06fe7b25ae),
W64LIT(0x049b24ebd9243fb8),
W64LIT(0xbb32a8f4b3a8d62f),
W64LIT(0x91a027d48b2740fd),
W64LIT(0x3d6c20bfb22038e7),
W64LIT(0xe681022acf02f9d5),
W64LIT(0xf17fadb545ad57e0),
W64LIT(0xcc138d0af78d6f07),
W64LIT(0x495b1e732b1eecbd),
W64LIT(0x38560de9200d8f71),
W64LIT(0xa9f62a3dab2acf8c),
W64LIT(0x47b46034236048dc),
W64LIT(0x8e9dc06846c0904d),
W64LIT(0xaccc076b3907781a),
W64LIT(0x32225745f15714a8),
W64LIT(0xd4a3556f3e55ed7d),
W64LIT(0xd7b54e5de34e800f),
W64LIT(0xddc114f132141bd6),
W64LIT(0x6d26ef141befde0e),
W64LIT(0x85489379dc9383ba),
W64LIT(0x0bd553119a5313f7),
W64LIT(0x786f520407529567),
W64LIT(0xcb9eb2d3f3b23dcd),
W64LIT(0xa223792c3179dc7b),
W64LIT(0x0a745aacd15a9bd9),
W64LIT(0x710d139a0b1363cc),
W64LIT(0x681cc24289c26998),
W64LIT(0x1a07caea5fca6726),
W64LIT(0x82c5aca0d8acd170),
W64LIT(0x25dcf8da7bf8ba9d),
W64LIT(0xc7c6de1b6dde7cf0),
W64LIT(0xc35dfaf0b4fa4348),
W64LIT(0xded70fc3ef0f76a4),
W64LIT(0x504acfaba9cfe6e9),
W64LIT(0xc571cc94fbcc99ac),
W64LIT(0x5ea5b1eca1b14288),
W64LIT(0xae7b15e4af159d46),
W64LIT(0xc888a9e12ea950bf),
W64LIT(0xf7539bd10a9b8d04),
W64LIT(0x962d180d8f181237),
W64LIT(0xe43610a559101c89),
W64LIT(0x772125fe4425b928),
W64LIT(0x84e99ac4979a0b94),
W64LIT(0xc667d7a626d7f4de),
W64LIT(0xefe343b4c3430f7e),
W64LIT(0xd5025cd2755c6553),
W64LIT(0xa6b85dc7e85de3c3),
W64LIT(0xd61447e0a8470821),
W64LIT(0x3e7a3b8d6f3b5595),
W64LIT(0x52fddd243fdd03b5),
W64LIT(0x8072be2f4ebe342c),
W64LIT(0x12c482c9188219a3),
W64LIT(0x9eee502ec8506cb2),
W64LIT(0xad6d0ed6720ef034),
W64LIT(0x59288e35a58e1042),
W64LIT(0xe21a26c11626c66d),
W64LIT(0x247df16730f132b3),
W64LIT(0xf0dea4080ea4dfce),
W64LIT(0x31344c772c4c79da),
W64LIT(0x4f77281764283659),
W64LIT(0x79ce5bb94c5b1d49),
W64LIT(0x0000000000000000),
W64LIT(0x73ba01159d018690),
W64LIT(0x74373ecc993ed45a),
W64LIT(0xbcbf972db79784e5),
W64LIT(0x4ed621aa2f21be77),
W64LIT(0xd95a301aeb30246e),
W64LIT(0x9c5942a15e4289ee),
W64LIT(0x37187a13637aa33e),
W64LIT(0x276bea55edea5fc1),
W64LIT(0x1c2bfc8e10fcbdc2),
W64LIT(0xed54513b5551ea22),
W64LIT(0x20e6d58ce9d50d0b),
W64LIT(0x3ae11f66b61f6a2d),
W64LIT(0x66f3bc0581bccdf9),
W64LIT(0x2cbeb94477b94c36),
W64LIT(0x99636ff7cc6f3e78),
W64LIT(0x953b033f52037f45),
W64LIT(0xb0e7fbe529fbc5d8),
W64LIT(0x60df8a61ce8a171d),
W64LIT(0x6f91fd9b8dfd3b52),
W64LIT(0xaae0310f7631a2fe),
W64LIT(0xbfa98c1f6a8ce997),
W64LIT(0x8ba7ed3ed4ed27db),
W64LIT(0x98c2664a8766b656),
W64LIT(0x062c36644f36dae4),
W64LIT(0x5570e2fd3be2517f),
W64LIT(0xead96ee2516eb8e8),
W64LIT(0x419856506c569238),
W64LIT(0x23f0cebe34ce6079),
W64LIT(0x309545ca6745f1f4),
W64LIT(0x5a3e950778957d30),
W64LIT(0x617e83dc85839f33),
W64LIT(0xfb0bf71994f7cc39),
W64LIT(0x3ccd2902f929b0c9),
W64LIT(0x70ac1a27401aebe2),
W64LIT(0xcea49f85619f8a5b),
W64LIT(0x39f704546b04075f),
W64LIT(0x0df96575d565c913),
W64LIT(0x08c3482347487e85),
W64LIT(0xd28f630b71633799),
W64LIT(0xecf558861e58620c),
W64LIT(0xc2fcf34dfff3cb66),
W64LIT(0x978c11b0c4119a19),
W64LIT(0x69bdcbffc2cbe1b6),
W64LIT(0xba93a149f8a15e01),
W64LIT(0x51ebc616e2c66ec7),
W64LIT(0x078d3fd9043f52ca),
W64LIT(0x58898788ee87986c),
W64LIT(0x4a4d0541f60581cf),
W64LIT(0xe86e7c6dc77c5db4),
W64LIT(0xee424a09884a8750),
W64LIT(0xcdb284b7bc84e729),
W64LIT(0x65e5a7375ca7a08b),
W64LIT(0x2fa8a276aaa22144),
W64LIT(0xa0946ba3a76b3927),
W64LIT(0xa5ae46f535468eb1),
W64LIT(0x35af689cf5684662),
W64LIT(0x28259dafae9d738e),
W64LIT(0xcf0596382a960275),
W64LIT(0xb6cbcd8166cd1f3c),
W64LIT(0x7e43646048644f83),
W64LIT(0x9bd47d785a7ddb24),
W64LIT(0x432f44dffa447764),
W64LIT(0x9f4f59938359e49c),
W64LIT(0x7d557f52957f22f1),
W64LIT(0x76802c430f2c3106),
W64LIT(0xdc601d4c791d93f8),
W64LIT(0x053a2d56922db796),
W64LIT(0x11d299fbc59974d1),
W64LIT(0xf9bce59602e52965),
W64LIT(0xd8fb39a7a039ac40),
W64LIT(0x340e6121be61ce4c),
W64LIT(0x5f04b851eab8caa6),
W64LIT(0x5db3aade7caa2ffa),
W64LIT(0x1549bd101cbd4b69),
W64LIT(0xff90d3f24dd3f381),
W64LIT(0xafda1c59e41c1568),
W64LIT(0xb146f25862f24df6),
W64LIT(0xa40f4f487e4f069f),
/* box 2 */
W64LIT(0xa1a35cebf8f0f94c),
W64LIT(0x2c203d650f3f095d),
W64LIT(0x1a2bdaee4084a2a7),
W64LIT(0xd32404574d7bcc68),
W64LIT(0xf785bea594a9adc4),
W64LIT(0xf2eb54456206949c),
W64LIT(0x3f5e334d0475ced1),
W64LIT(0x5994299b835d1f60),
W64LIT(0x785b7989ac204794),
W64LIT(0x025da6a2cf461a41),
W64LIT(0xdf1f3a71f01a901b),
W64LIT(0x27284f018bb77637),
W64LIT(0xe1955a6d694c5310),
W64LIT(0x24a1baf2d9d261ac),
W64LIT(0xe4fbb08d9fe36a48),
W64LIT(0x8d83618ef7cff011),
W64LIT(0x2ac72276abf5279e),
W64LIT(0xf9e32621e68eebf6),
W64LIT(0xbf323fb4d3f86f69),
W64LIT(0xbb888605b8745beb),
W64LIT(0x70dafe1e7acd2f65),
W64LIT(0xd0adf1a41f1edbf3),
W64LIT(0x1e91635f2b089625),
W64LIT(0xee2791b8864818f8),
W64LIT(0x99ce23e4c56c1484),
W64LIT(0xf33f0714ff259946),
W64LIT(0xbd6f99161cbe7528),
W64LIT(0x9f293cf761a63a47),
W64LIT(0xb80173f6ea114c70),
W64LIT(0x6543ef25d54dc62a),
W64LIT(0x39b92c5ea0bfe012),
W64LIT(0x63a4f0367187e8e9),
W64LIT(0x4c0d38a02cddf62f),
W64LIT(0x07334c4239e92319),
W64LIT(0x43bff375c3d9bdc7),
W64LIT(0xca862b4a5f9a7954),
W64LIT(0x5d2e902ae8d12be2),
W64LIT(0x137e0e280b4ac78c),
W64LIT(0xf162a1b630638307),
W64LIT(0x55af17bd3e3c4313),
W64LIT(0x358212781ddebc61),
W64LIT(0x94214e93e52e452d),
W64LIT(0xc18e592edb12063e),
W64LIT(0xec7a371a490e02b9),
W64LIT(0x4963d240da72cf77),
W64LIT(0x41e255d70c9fa786),
W64LIT(0xff0439324244c535),
W64LIT(0x88ed8b6e0160c949),
W64LIT(0x6c163be39e83a301),
W64LIT(0xc534e09fb09e32bc),
W64LIT(0x806c0cf9d78da1b8),
W64LIT(0xdba583c09b96a499),
W64LIT(0x746047af11411be7),
W64LIT(0xf40c4b56c6ccba5f),
W64LIT(0x6270a367eca4e533),
W64LIT(0xd41748157492ef71),
W64LIT(0xeff3c2e91b6b1522),
W64LIT(0x0e66988472274632),
W64LIT(0x534808ae9af66dd0),
W64LIT(0x8231aa5b18cbbbf9),
W64LIT(0xb2dd52c3f3ba3ec0),
W64LIT(0xdd429cd33f5c8a5a),
W64LIT(0x4e509e02e39bec6e),
W64LIT(0x26fc1c5016947bed),
W64LIT(0xd9f8256254d0bed8),
W64LIT(0x0955d4c64bce652b),
W64LIT(0x1610e4c8fde5fed4),
W64LIT(0x6dc268b203a0aedb),
W64LIT(0x2e7d9bc7c079131c),
W64LIT(0xc3d3ff8c14541c7f),
W64LIT(0xd64aeeb7bbd4f530),
W64LIT(0xab7f7ddee15b8bfc),
W64LIT(0x144d426a32a3e495),
W64LIT(0x8e0a947da5aae78a),
W64LIT(0x798f2ad831034a4e),
W64LIT(0x3be48afc6ff9fa53),
W64LIT(0x529c5bff07d5600a),
W64LIT(0xbee66ce54edb62b3),
W64LIT(0x931202d1dcc76634),
W64LIT(0x50c1fd5dc8937a4b),
W64LIT(0xa4cdb60b0e5fc014),
W64LIT(0x57f2b11ff17a5952),
W64LIT(0x47054ac4a8558945),
W64LIT(0x5a1ddc68d13808fb),
W64LIT(0x5cfac37b75f22638),
W64LIT(0xc207acdd897711a5),
W64LIT(0x289a84d464b33ddf),
W64LIT(0xc05a0a7f46310be4),
W64LIT(0xe6a6162f50a57009),
W64LIT(0x06e71f13a4ca2ec3),
W64LIT(0x5f733688279731a3),
W64LIT(0xeb497b5870e721a0),
W64LIT(0xb667eb7298360a42),
W64LIT(0xe3c8fccfa60a4951),
W64LIT(0xe772457ecd867dd3),
W64LIT(0x6978d103682c9a59),
W64LIT(0x0def6d77204251a9),
W64LIT(0xc90fdeb90dff6ecf),
W64LIT(0xd179a2f5823dd629),
W64LIT(0x2fa9c8965d5a1ec6),
W64LIT(0x81b85fa84aaeac62),
W64LIT(0xdc96cf82a27f8780),
W64LIT(0x602d05c523e2ff72),
W64LIT(0x19a22f1d12e1b53c),
W64LIT(0xe52fe3dc02c06792),
W64LIT(0x58407aca1e7e12ba),
W64LIT(0x61f95694bec1f2a8),
W64LIT(0x48b781114751c2ad),
W64LIT(0xaaab2e8f7c788626),
W64LIT(0x04bab9b16b8c3482),
W64LIT(0x2df46e34921c0487),
W64LIT(0x1123a88ac40cddcd),
W64LIT(0xc6bd156ce2fb2527),
W64LIT(0x7f6835cb95c9648d),
W64LIT(0x83e5f90a85e8b623),
W64LIT(0x4f84cd537eb8e1b4),
W64LIT(0x294ed785f9903005),
W64LIT(0x1cccc5fde44e8c64),
W64LIT(0xcb52781bc2b9748e),
W64LIT(0x1d1896ac796d81be),
W64LIT(0xb30901926e99331a),
W64LIT(0xad9862cd4591a53f),
W64LIT(0xc8db8de890dc6315),
W64LIT(0x7bd28c7afe45500f),
W64LIT(0x0adc213519ab72b0),
W64LIT(0xa8f6882db33e9c67),
W64LIT(0xb5ee1e81ca531dd9),
W64LIT(0x201b0343b25e552e),
W64LIT(0x4036068691bcaa5c),
W64LIT(0xae11973e17f4b2a4),
W64LIT(0x9efd6fa6fc85379d),
W64LIT(0x33650d6bb91492a2),
W64LIT(0x3a30d9adf2daf789),
W64LIT(0x0c3b3e26bd615c73),
W64LIT(0xf651edf4098aa01e),
W64LIT(0x710ead4fe7ee22bf),
W64LIT(0x3138abc9765288e3),
W64LIT(0x9d749a55aee02006),
W64LIT(0x6e4b9d4151c5b940),
W64LIT(0x84d6b548bc01953a),
W64LIT(0x360be78b4fbbabfa),
W64LIT(0xa22aa918aa95eed7),
W64LIT(0xedae644bd42d0f63),
W64LIT(0x46d119953576849f),
W64LIT(0x6497bc74486ecbf0),
W64LIT(0xfbbe808329c8f1b7),
W64LIT(0x4aea27b38817d8ec),
W64LIT(0x5626e24e6c595488),
W64LIT(0x056eeae0f6af3958),
W64LIT(0x4558ec6667139304),
W64LIT(0x448cbf37fa309ede),
W64LIT(0x6f9fce10cce6b49a),
W64LIT(0xa0770fba65d3f496),
W64LIT(0x671e49871a0bdc6b),
W64LIT(0xda71d09106b5a943),
W64LIT(0x08818797d6ed68f1),
W64LIT(0xa3fefa4937b6e30d),
W64LIT(0xb080f4613cfc2481),
W64LIT(0x763de10dde0701a6),
W64LIT(0x4dd96bf1b1fefbf5),
W64LIT(0x92c6518041e46bee),
W64LIT(0x3456412980fdb1bb),
W64LIT(0x981a70b5584f195e),
W64LIT(0x3d0395efcb33d490),
W64LIT(0xba5cd55425575631),
W64LIT(0x4b3e74e21534d536),
W64LIT(0x6af124f03a498dc2),
W64LIT(0x7ebc669a08ea6957),
W64LIT(0x30ecf898eb718539),
W64LIT(0xa922db7c2e1d91bd),
W64LIT(0x7a06df2b63665dd5),
W64LIT(0xb154a730a1df295b),
W64LIT(0xfc8dccc11021d2ae),
W64LIT(0xcfe8c1aaa935400c),
W64LIT(0x97a8bb60b74b52b6),
W64LIT(0x18767c4c8fc2b8e6),
W64LIT(0x9a47d6179709031f),
W64LIT(0x0000000000000000),
W64LIT(0xac4c319cd8b2a8e5),
W64LIT(0xb9d520a7773241aa),
W64LIT(0xdecb69206d399dc1),
W64LIT(0x1f45300eb62b9bff),
W64LIT(0x10f7fbdb592fd017),
W64LIT(0x3e8a601c9956c30b),
W64LIT(0x8502e619212298e0),
W64LIT(0xf5d818075befb785),
W64LIT(0x547b44eca31f4ec9),
W64LIT(0x9ca0c90433c32ddc),
W64LIT(0xe041093cf46f5eca),
W64LIT(0xa69010a9c119da55),
W64LIT(0xc769463d7fd828fd),
W64LIT(0xc4e0b3ce2dbd3f66),
W64LIT(0x2575e9a344f16c76),
W64LIT(0x01d453519d230dda),
W64LIT(0xfa6ad3d2b4ebfc6d),
W64LIT(0xd5c31b44e9b1e2ab),
W64LIT(0xf83775707bade62c),
W64LIT(0xbcbbca47819d78f2),
W64LIT(0xd79ebde626f7f8ea),
W64LIT(0x5bc98f394c1b0521),
W64LIT(0x2246a5e17d184f6f),
W64LIT(0x12aa5d799669ca56),
W64LIT(0x5ea765d9bab43c79),
W64LIT(0x8939d83f9c43c493),
W64LIT(0x32b15e3a24379f78),
W64LIT(0xe914ddfabfa13be1),
W64LIT(0x909bf7228ea271af),
W64LIT(0x73530bed28a838fe),
W64LIT(0xd2f05706d058c1b2),
W64LIT(0xfed06a63df67c8ef),
W64LIT(0xb43a4dd057701003),
W64LIT(0xa519e55a937ccdce),
W64LIT(0x75b414fe8c62163d),
W64LIT(0xafc5c46f8ad7bf7e),
W64LIT(0x2392f6b0e03b42b5),
W64LIT(0x386d7f0f3d9cedc8),
W64LIT(0x21cf50122f7d58f4),
W64LIT(0x9b9385460a2a0ec5),
W64LIT(0x5115ae0c55b07791),
W64LIT(0x0fb2cbd5ef044be8),
W64LIT(0xea9d2809edc42c7a),
W64LIT(0xcc613459fb505797),
W64LIT(0x426ba0245efab01d),
W64LIT(0x1599113baf80e94f),
W64LIT(0x7d3593695a8f7ecc),
W64LIT(0x0389f5f35265179b),
W64LIT(0x875f40bbee6482a1),
W64LIT(0x95f51dc2780d48f7),
W64LIT(0x7ce1c038c7ac7316),
W64LIT(0xce3c92fb34164dd6),
W64LIT(0xcdb5670866735a4d),
W64LIT(0x8ab02dccce26d308),
W64LIT(0x914fa47313817c75),
W64LIT(0x8b647e9d5305ded2),
W64LIT(0xd82c7633c9f3b302),
W64LIT(0x728758bcb58b3524),
W64LIT(0xe8c08eab2282363b),
W64LIT(0x8fdec72c3889ea50),
W64LIT(0x2b13712736d62a44),
W64LIT(0x3cd7c6be5610d94a),
W64LIT(0x37dfb4dad298a620),
W64LIT(0x868b13ea73478f7b),
W64LIT(0xb7b3b82305150798),
W64LIT(0x0b08726484887f6a),
W64LIT(0x1bff89bfdda7af7d),
W64LIT(0x77e9b25c43240c7c),
W64LIT(0xf0b6f2e7ad408edd),
W64LIT(0x17c4b79960c6f30e),
W64LIT(0x8c5732df6aecfdcb),
W64LIT(0x68ac8252f50f9783),
W64LIT(0x66ca1ad68728d1b1),
W64LIT(0x6b2577a1a76a8018),
W64LIT(0xe21caf9e3b29448b),
W64LIT(0xa74443f85c3ad78f),
W64LIT(0xfd599f908d02df74),
W64LIT(0x967ce8312a685f6c),
/* box 3 */
W64LIT(0xfa7b9775ba3af751),
W64LIT(0x03ef98cb769c2d13),
W64LIT(0x7191ce067072359e),
W64LIT(0xbab18b6bff7516a8),
W64LIT(0xe6e5ef4efbc1065e),
W64LIT(0x7bec74a3b1d0dbf4),
W64LIT(0x656b4fb907c31c4a),
W64LIT(0x4e8520f99fc86304),
W64LIT(0x8fd8df31d16dae58),
W64LIT(0x90a93fc1e60a7244),
W64LIT(0x30ad09f2b449cfc5),
W64LIT(0x8453be7e91bb5b90),
W64LIT(0x1d68a3d1c08feaad),
W64LIT(0x5c54642504b410f6),
W64LIT(0x8061383c8a9e3707),
W64LIT(0xf9940fbecca6da42),
W64LIT(0x46e1d97da982bbdf),
W64LIT(0xfc50521656f7ad77),
W64LIT(0x5e4d2704f35c2647),
W64LIT(0x8bea5973ca48c2cf),
W64LIT(0xd06323dfa34593bd),
W64LIT(0x62b651306a7a5dce),
W64LIT(0xa436b0714966d116),
W64LIT(0x4f73fb131ebc78a6),
W64LIT(0x92b07ce011e244f5),
W64LIT(0x33429139c2d5e2d6),
W64LIT(0xcee418c515565403),
W64LIT(0xd7be3d56cefcd239),
W64LIT(0x53ed83285f4789a9),
W64LIT(0xf3e9b51b0d043428),
W64LIT(0x20650e0fd8dd8a86),
W64LIT(0xb6e7f4add21aa2e4),
W64LIT(0x6d0fb63d3189c491),
W64LIT(0x0da0a42cac1bafee),
W64LIT(0x3f14eeffefba569a),
W64LIT(0x13279f361a086850),
W64LIT(0x9b225e8ea6dc878c),
W64LIT(0x6684d772715f3159),
W64LIT(0xa3ebaef824df9092),
W64LIT(0xc499a260d4f4ba69),
W64LIT(0xaa798c9693e153eb),
W64LIT(0x50021be329dba4ba),
W64LIT(0x949bb983fd2f1ed3),
W64LIT(0xdfdac4d2f8b60ae2),
W64LIT(0xf0062dd07b98193b),
W64LIT(0xafbdd13e09b024de),
W64LIT(0xb95e13a089e93bbb),
W64LIT(0x649d945386b707e8),
W64LIT(0xe4fcac6f0c2930ef),
W64LIT(0x413cc7f4c43bfa5b),
W64LIT(0x3b2668bdf49f3a0d),
W64LIT(0xe50a77858d5d2b4d),
W64LIT(0x05c45da89a517735),
W64LIT(0x3ee235156ece4d38),
W64LIT(0xfe491137a11f9bc6),
W64LIT(0xb7112f47536eb946),
W64LIT(0x07dd1e896db94184),
W64LIT(0x1ab5bd58ad36ab29),
W64LIT(0x8197e3d60bea2ca5),
W64LIT(0xab8f577c12954849),
W64LIT(0x9cff4007cb65c608),
W64LIT(0xa00436335243bd81),
W64LIT(0xfda689fcd783b6d5),
W64LIT(0xccfd5be4e2be62b2),
W64LIT(0x75a348446b575909),
W64LIT(0x17151974012d04c7),
W64LIT(0xfb8d4c9f3b4eecf3),
W64LIT(0xac5249f57f2c09cd),
W64LIT(0x9346a70a90965f57),
W64LIT(0x043286421b256c97),
W64LIT(0x27b81086b564cb02),
W64LIT(0x3569545a2e18b8f0),
W64LIT(0x6b24735edd449eb7),
W64LIT(0x2193d5e559a99124),
W64LIT(0xc7763aaba268977a),
W64LIT(0xb0cc31ce3ed7f8c2),
W64LIT(0xc939064c78ef1587),
W64LIT(0x16e3c29e80591f65),
W64LIT(0x5da2bfcf85c00b54),
W64LIT(0x5990398d9ee567c3),
W64LIT(0x67720c98f02b2afb),
W64LIT(0x54309da132fec82d),
W64LIT(0xeab39088d6aeb212),
W64LIT(0x9682faa20ac72862),
W64LIT(0xd38cbb14d5d9beae),
W64LIT(0x4c9c63d8682055b5),
W64LIT(0xd648e6bc4f88c99b),
W64LIT(0xdc355c198e2a27f1),
W64LIT(0x10c807fd6c944543),
W64LIT(0x450e41b6df1e96cc),
W64LIT(0x0b8b614f40d6f5c8),
W64LIT(0xd27a60fe54ada50c),
W64LIT(0x49583e70f2712280),
W64LIT(0x8dc19c10268598e9),
W64LIT(0x5866e2671f917c61),
W64LIT(0x79f537824638ed45),
W64LIT(0xc2b267033839e04f),
W64LIT(0xcb20456d8f072336),
W64LIT(0x2a18b4aa197f64ec),
W64LIT(0xdbe84290e3936675),
W64LIT(0x73888d27879a032f),
W64LIT(0xe8aad3a9214684a3),
W64LIT(0x6ee02ef64715e982),
W64LIT(0xa996145de57d7ef8),
W64LIT(0xc8cfdda6f99b0e25),
W64LIT(0x062bc563eccd5a26),
W64LIT(0x264ecb6c3410d0a0),
W64LIT(0xb8a8c84a089d2019),
W64LIT(0x7dc7b1c05d1d81d2),
W64LIT(0xd5a77e773914e488),
W64LIT(0x4b417d5105991431),
W64LIT(0xf62de8b39755431d),
W64LIT(0x993b1daf5134b13d),
W64LIT(0x82787b1d7d7601b6),
W64LIT(0xe321b2e66190716b),
W64LIT(0xb5086c66a4868ff7),
W64LIT(0x9ee603263c8df0b9),
W64LIT(0x349f8fb0af6ca352),
W64LIT(0x5b897aac690d5172),
W64LIT(0x7c316a2adc699a70),
W64LIT(0xd451a59db860ff2a),
W64LIT(0x706715ecf1062e3c),
W64LIT(0x838ea0f7fc021a14),
W64LIT(0x57df056a4462e53e),
W64LIT(0xcf12c32f94224fa1),
W64LIT(0xed6e8e01bb17f396),
W64LIT(0x915fe42b677e69e6),
W64LIT(0x89f31a523da0f47e),
W64LIT(0xe71334a47ab51dfc),
W64LIT(0xa860cfb76409655a),
W64LIT(0x9f10d8ccbdf9eb1b),
W64LIT(0xef77cd204cffc527),
W64LIT(0xf862d4544dd2c1e0),
W64LIT(0x8a1c82994b3cd96d),
W64LIT(0xae4b0ad488c43f7c),
W64LIT(0x98cdc645d040aa9f),
W64LIT(0x7fdef2e1aaf5b763),
W64LIT(0x4717029728f6a07d),
W64LIT(0x745593aeea2342ab),
W64LIT(0xee8116cacd8bde85),
W64LIT(0x727e56cd06ee188d),
W64LIT(0x227c4d2e2f35bc37),
W64LIT(0x977421488bb333c0),
W64LIT(0xa21d7512a5ab8b30),
W64LIT(0xbb4750817e010d0a),
W64LIT(0x6cf96dd7b0fddf33),
W64LIT(0x2801f78bee97525d),
W64LIT(0x1c9e783b41fbf10f),
W64LIT(0x9d099bed4a11ddaa),
W64LIT(0x7a1aaf4930a4c056),
W64LIT(0x32b44ad343a1f974),
W64LIT(0x3cfb763499267b89),
W64LIT(0xb2d572efc93fce73),
W64LIT(0x63408adaeb0e466c),
W64LIT(0xada4921ffe58126f),
W64LIT(0x5fbbfcee72283de5),
W64LIT(0x6ad2a8b45c308515),
W64LIT(0x0c567fc62d6fb44c),
W64LIT(0x956d62697c5b0571),
W64LIT(0x25a153a7428cfdb3),
W64LIT(0x150c5a55f6c53276),
W64LIT(0xe2d7690ce0e46ac9),
W64LIT(0xda1e997a62e77dd7),
W64LIT(0xf5c27078e1c96e0e),
W64LIT(0xc344bce9b94dfbed),
W64LIT(0x60af12119d926b7f),
W64LIT(0xa1f2edd9d337a623),
W64LIT(0xcad69e870e733894),
W64LIT(0x3770177bd9f08e41),
W64LIT(0xa5c06b9bc812cab4),
W64LIT(0x1f71e0f03767dc1c),
W64LIT(0x44f89a5c5e6a8d6e),
W64LIT(0x6159c9fb1ce670dd),
W64LIT(0x8e2e04db5019b5fa),
W64LIT(0x8805c1b8bcd4efdc),
W64LIT(0xe138f1c7967847da),
W64LIT(0x4ab7a6bb84ed0f93),
W64LIT(0x0000000000000000),
W64LIT(0x38c9f0768203171e),
W64LIT(0x1b4366b22c42b08b),
W64LIT(0x7803ec68c74cf6e7),
W64LIT(0xec9855eb3a63e834),
W64LIT(0xbe830d29e4507a3f),
W64LIT(0x2dc5aa2374c62568),
W64LIT(0xa62ff350be8ee7a7),
W64LIT(0x764cd08f1dcb741a),
W64LIT(0x8c3747faa7f1834b),
W64LIT(0x0fb9e70d5bf3995f),
W64LIT(0x55c6464bb38ad38f),
W64LIT(0xf7db3359162158bf),
W64LIT(0xd195f8352231881f),
W64LIT(0x0992226eb73ec379),
W64LIT(0x14fa81bf77b129d4),
W64LIT(0x48aee59a73053922),
W64LIT(0x2457884dc3f8e611),
W64LIT(0xffbfcadd206b8064),
W64LIT(0xb4feb78c25f29455),
W64LIT(0x864afd5f66536d21),
W64LIT(0x6f16f51cc661f220),
W64LIT(0xde2c1f3879c21140),
W64LIT(0x195a2593dbaa863a),
W64LIT(0x2e2a32e8025a087b),
W64LIT(0x432584d533d3ccea),
W64LIT(0x2c3371c9f5b23eca),
W64LIT(0xa7d928ba3ffafc05),
W64LIT(0x42d35f3fb2a7d748),
W64LIT(0x85a5659410cf4032),
W64LIT(0x0864f984364ad8db),
W64LIT(0xf21f6ef18c702f8a),
W64LIT(0xf1f0f63afaec0299),
W64LIT(0xd9f101b1147b50c4),
W64LIT(0x2fdce902832e13d9),
W64LIT(0x4d6ab832e9544e17),
W64LIT(0xe0ce2a2d170c5c78),
W64LIT(0x51f4c009a8afbf18),
W64LIT(0x68cbeb95abd8b3a4),
W64LIT(0xc15dffc84ea5cd5c),
W64LIT(0x02194321f7e836b1),
W64LIT(0x113edc17ede05ee1),
W64LIT(0x521b58c2de33920b),
W64LIT(0x9ad4856427a89c2e),
W64LIT(0x5629de80c516fe9c),
W64LIT(0x77ba0b659cbf6fb8),
W64LIT(0x238a96c4ae41a795),
W64LIT(0x12d144dc9b7c73f2),
W64LIT(0xd807da5b950f4b66),
W64LIT(0x3686cc91588495e3),
W64LIT(0x18acfe795ade9d98),
W64LIT(0x5a7fa146e8794ad0),
W64LIT(0xc680e141231c8cd8),
W64LIT(0x1e873b1ab613c7be),
W64LIT(0xf434ab9260bd75ac),
W64LIT(0xcd0b800e63ca7910),
W64LIT(0xbc9a4e0813b84c8e),
W64LIT(0x3d0dadde1852602b),
W64LIT(0x40ca1c1e454fe1f9),
W64LIT(0x0a7dbaa5c1a2ee6a),
W64LIT(0x693d307f2aaca806),
W64LIT(0x0e4f3ce7da8782fd),
W64LIT(0xbd6c95e292cc572c),
W64LIT(0x3ad0b35775eb21af),
W64LIT(0x7e28290b2b81acc1),
W64LIT(0x01f6dbea81741ba2),
W64LIT(0x87bc26b5e7277683),
W64LIT(0x393f2b9c03770cbc),
W64LIT(0xddc387f30f5e3c53),
W64LIT(0xeb454b6257daa9b0),
W64LIT(0xb323a905484bd5d1),
W64LIT(0xb13aea24bfa3e360),
W64LIT(0x315bd218353dd467),
W64LIT(0x2bee6f40980b7f4e),
W64LIT(0xe95c0843a0329f01),
W64LIT(0xc56f798a5580a1cb),
W64LIT(0xbf75d6c36524619d),
W64LIT(0x29f72c616fe349ff),
W64LIT(0xc0ab2422cfd1d6fe),
/* box 4 */
W64LIT(0x561fc423e957943c),
W64LIT(0x014287ca69079288),
W64LIT(0x2f086129dfcd1d21),
W64LIT(0xc537d4aea044fd99),
W64LIT(0xf1e8c3bfd7c8a457),
W64LIT(0x2971998a5cdf9bfb),
W64LIT(0x23fa649a2ce9e460),
W64LIT(0x3aa9e9c356a6716a),
W64LIT(0xd6efa4e7aa3d1708),
W64LIT(0x705a24b1fda5b5eb),
W64LIT(0x101e0ce2b170a9fc),
W64LIT(0x7ca821020e814caa),
W64LIT(0x0bc97ada1931ed13),
W64LIT(0x34df1711778c59ce),
W64LIT(0xd35020ef9226d2bf),
W64LIT(0x575d43e9805006b4),
W64LIT(0x91acebec9b1db840),
W64LIT(0x549b3f423b5945d9),
W64LIT(0x99a3ed9d3925163e),
W64LIT(0x7917a50a369a891d),
W64LIT(0xe372343cb4b6dc4e),
W64LIT(0x8d40e2bdd949e8fd),
W64LIT(0xcfbc29bed0728202),
W64LIT(0x969794857108ac12),
W64LIT(0xdd26de3db30cfa1b),
W64LIT(0x115c8b28d8773b74),
W64LIT(0xe9f9c92cc480a3d5),
W64LIT(0x4dc8b21b4116d0d3),
W64LIT(0x316093194f979c79),
W64LIT(0x5124bb4a0342806e),
W64LIT(0xb31408bcdef3cea8),
W64LIT(0xc1cad76cf158aaa6),
W64LIT(0x88ff66b5e1522d4a),
W64LIT(0xa8c37e8476b28a47),
W64LIT(0x15a188ea896b6c4b),
W64LIT(0xa24883940684f5dc),
W64LIT(0xda1da1545919ee49),
W64LIT(0x22b8e35045ee76e8),
W64LIT(0x6106af9925d28e9f),
W64LIT(0xef80318f4792250f),
W64LIT(0x663dd0f0cfc79acd),
W64LIT(0x302214d326900ef1),
W64LIT(0xdfa2255c61022bfe),
W64LIT(0xe6cdb0348cad19f9),
W64LIT(0x50663c806a4512e6),
W64LIT(0x65fbac5b74ced9a0),
W64LIT(0xc4755364c9436f11),
W64LIT(0x8fc419dc0b473918),
W64LIT(0x5c9439339961eba7),
W64LIT(0x3f166dcb6ebdb4dd),
W64LIT(0xba59890715ccf25e),
W64LIT(0xf0aa4475becf36df),
W64LIT(0x03c67cabbb09436d),
W64LIT(0xb99ff5acaec5b133),
W64LIT(0xf9e7c5ce75f00a29),
W64LIT(0x6df4aa2ad6f677de),
W64LIT(0xaeba8627f5a00c9d),
W64LIT(0xa573fcfdec91e18e),
W64LIT(0x7f6e5da9b5880fc7),
W64LIT(0xca03adb6e86947b5),
W64LIT(0x74a72773acb9e2d4),
W64LIT(0x604428534cd51c17),
W64LIT(0xf8a542041cf798a1),
W64LIT(0x448533a08a29ec25),
W64LIT(0x80f060c4436a8334),
W64LIT(0x0db082799a236bc9),
W64LIT(0xfa21b965cef94944),
W64LIT(0x64b92b911dc94b28),
W64LIT(0x7118a37b94a22763),
W64LIT(0xaff801ed9ca79e15),
W64LIT(0x1dae8e9b2b53c235),
W64LIT(0x13d870490a79ea91),
W64LIT(0x8a7b9dd4335cfcaf),
W64LIT(0x1f2a75faf95d13d0),
W64LIT(0xeec2b6452e95b787),
W64LIT(0xc34e2c0d23567b43),
W64LIT(0x47434f0b3120af48),
W64LIT(0xa18eff3fbd8db6b1),
W64LIT(0x98e16a57502284b6),
W64LIT(0x37196bbacc851aa3),
W64LIT(0x8e869e166240ab90),
W64LIT(0x9fda153eba3790e4),
W64LIT(0xf515c07d86d4f368),
W64LIT(0x72dedfd02fab640e),
W64LIT(0xe230b3f6ddb14ec6),
W64LIT(0x97d5134f180f3e9a),
W64LIT(0xe1f6cf5d66b80dab),
W64LIT(0xe78f37fee5aa8b71),
W64LIT(0xa30a045e6f836754),
W64LIT(0x90ee6c26f21a2ac8),
W64LIT(0xaa4785e5a4bc5ba2),
W64LIT(0x4e0eceb0fa1f93be),
W64LIT(0x94136fe4a3067df7),
W64LIT(0x7b935e6be49458f8),
W64LIT(0x9b2716fceb2bc7db),
W64LIT(0x840d63061276d40b),
W64LIT(0xed04caee959cf4ea),
W64LIT(0xea3fb5877f89e0b8),
W64LIT(0xb56df01f5de14872),
W64LIT(0x4935b1d9100a87ec),
W64LIT(0x82749ba5916452d1),
W64LIT(0x58693af1c87dbc98),
W64LIT(0x89bde17f8855bfc2),
W64LIT(0x677f573aa6c00845),
W64LIT(0xeb7d324d168e7230),
W64LIT(0x0284fb61d20ed1e5),
W64LIT(0xb190f3dd0cfd1f4d),
W64LIT(0x684b2e22eeedb269),
W64LIT(0x2bf562eb8ed14a1e),
W64LIT(0xe0b448970fbf9f23),
W64LIT(0x396f9568edaf3207),
W64LIT(0x52e2c7e1b84bc303),
W64LIT(0x77615bd817b0a1b9),
W64LIT(0x7e2cda63dc8f9d4f),
W64LIT(0xf22ebf146cc1e73a),
W64LIT(0xc08850a6985f382e),
W64LIT(0xd9dbddffe210ad24),
W64LIT(0xbfe60d0f2dd737e9),
W64LIT(0x9a659136822c5553),
W64LIT(0x87cb1fada97f9766),
W64LIT(0x4c8a35d12811425b),
W64LIT(0x83361c6ff863c059),
W64LIT(0xd212a725fb214037),
W64LIT(0x9e9892f4d330026c),
W64LIT(0x45c7b46ae32e7ead),
W64LIT(0x5baf465a7374fff5),
W64LIT(0xdc6459f7da0b6893),
W64LIT(0xd46b5f867833c6ed),
W64LIT(0x5dd6bef9f066792f),
W64LIT(0xcb412a7c816ed53d),
W64LIT(0x75e5a0b9c5be705c),
W64LIT(0xf6d3bcd63dddb005),
W64LIT(0xfb633eafa7fedbcc),
W64LIT(0xd529d84c11345465),
W64LIT(0xc9c5d11d536004d8),
W64LIT(0xdb5f269e301e7cc1),
W64LIT(0x86899867c07805ee),
W64LIT(0x3d9296aabcb36538),
W64LIT(0x2cce1d8264c45e4c),
W64LIT(0x5aedc1901a736d7d),
W64LIT(0x2e4ae6e3b6ca8fa9),
W64LIT(0x1e68f230905a8158),
W64LIT(0xdee0a2960805b976),
W64LIT(0xcd38d2df027c53e7),
W64LIT(0x6909a9e887ea20e1),
W64LIT(0x24c11bf3c6fcf032),
W64LIT(0x18110a9313480782),
W64LIT(0xa7f7079c3e9f306b),
W64LIT(0xd8995a358b173fac),
W64LIT(0x854fe4cc7b714683),
W64LIT(0xbd62f66effd9e60c),
W64LIT(0x14e30f20e06cfec3),
W64LIT(0x6e32d6816dff34b3),
W64LIT(0x217e9ffbfee73585),
W64LIT(0xc88756d73a679650),
W64LIT(0x359d90db1e8bcb46),
W64LIT(0x2645e09214f221d7),
W64LIT(0x04fd03c2511c573f),
W64LIT(0x739c581a46acf686),
W64LIT(0xb0d2741765fa8dc5),
W64LIT(0xa0cc78f5d48a2439),
W64LIT(0x5e10c2524b6f3a42),
W64LIT(0xe50bcc9f37a45a94),
W64LIT(0x53a0402bd14c518b),
W64LIT(0x413ab7a8b2322992),
W64LIT(0x203c183197e0a70d),
W64LIT(0xcc7a55156b7bc16f),
W64LIT(0x4601c8c158273dc0),
W64LIT(0xbea48ac544d0a561),
W64LIT(0x638254f8f7dc5f7a),
W64LIT(0xa6b580565798a2e3),
W64LIT(0x3cd01160d5b4f7b0),
W64LIT(0x8c026577b04e7a75),
W64LIT(0x7ad1d9a18d93ca70),
W64LIT(0x785522c05f9d1b95),
W64LIT(0x5f5245982268a8ca),
W64LIT(0x9551e82eca01ef7f),
W64LIT(0x0000000000000000),
W64LIT(0xbb1b0ecd7ccb60d6),
W64LIT(0x094d81bbcb3f3cf6),
W64LIT(0x28331e4035d80973),
W64LIT(0xf7913b1c54da228d),
W64LIT(0x6acfd5433ce3638c),
W64LIT(0x1bd77638a84144ef),
W64LIT(0x62c0d3329edbcdf2),
W64LIT(0x81b2e70e2a6d11bc),
W64LIT(0xd7ad232dc33a8580),
W64LIT(0x05bf8408381bc5b7),
W64LIT(0x33e468789d994d9c),
W64LIT(0xfedcbaa79fe51e7b),
W64LIT(0x4f4c497a93180136),
W64LIT(0x073b7f69ea151452),
W64LIT(0x0cf205b3f324f941),
W64LIT(0x382d12a284a8a08f),
W64LIT(0x1cec0951425450bd),
W64LIT(0x55d9b888525ed751),
W64LIT(0x6cb62de0bff1e556),
W64LIT(0xd1d4db8e4028035a),
W64LIT(0x25839c39affb62ba),
W64LIT(0x4af3cd72ab03c481),
W64LIT(0xa4317b3785967306),
W64LIT(0x1a95f1f2c146d667),
W64LIT(0x926a97472014fb2d),
W64LIT(0xb7e90b7e8fef9997),
W64LIT(0xcefeae74b975108a),
W64LIT(0x3e54ea0107ba2655),
W64LIT(0xd0965c44292f91d2),
W64LIT(0xab05022fcdbbc92a),
W64LIT(0xfd1ac60c24ec5d16),
W64LIT(0xfc5841c64debcf9e),
W64LIT(0xe4494b555ea3c81c),
W64LIT(0xb6ab8cb4e6e80b1f),
W64LIT(0x3beb6e093fa1e3e2),
W64LIT(0xf36c38de05c675b2),
W64LIT(0x9c1c6995013ed389),
W64LIT(0x8b391a1e5a5b6e27),
W64LIT(0xec464d24fc9b6662),
W64LIT(0xad7cfa8c4ea94ff0),
W64LIT(0x0f347918482dba2c),
W64LIT(0x9d5eee5f68394101),
W64LIT(0x7623dc127eb73331),
W64LIT(0x32a6efb2f49edf14),
W64LIT(0x2d8c9a480dc3ccc4),
W64LIT(0xb2568f76b7f45c20),
W64LIT(0x0e76fed2212a28a4),
W64LIT(0x48773613790d1564),
W64LIT(0x129af783637e7819),
W64LIT(0x080f0671a238ae7e),
W64LIT(0x365bec70a582882b),
W64LIT(0x42fccb03093b6aff),
W64LIT(0x0a8bfd1070367f9b),
W64LIT(0xff9e3d6df6e28cf3),
W64LIT(0xe8bb4ee6ad87315d),
W64LIT(0xc7b32fcf724a2c7c),
W64LIT(0xb8dd7266c7c223bb),
W64LIT(0x9328108d491369a5),
W64LIT(0x0679f8a3831286da),
W64LIT(0x270767587df5b35f),
W64LIT(0xa981f94e1fb518cf),
W64LIT(0x6b8d528955e4f104),
W64LIT(0x1667f44132622f26),
W64LIT(0x2ab7e521e7d6d896),
W64LIT(0xac3e7d4627aedd78),
W64LIT(0x7deaa6c86786de22),
W64LIT(0x1725738b5b65bdae),
W64LIT(0x4bb14ab8c2045609),
W64LIT(0x592bbd3ba17a2e10),
W64LIT(0xc20cabc74a51e9cb),
W64LIT(0x6f70514b04f8a63b),
W64LIT(0xbc2071a496de7484),
W64LIT(0x19538d597a4f950a),
W64LIT(0xf45747b7efd361e0),
W64LIT(0x43be4cc9603cf877),
W64LIT(0xc6f1a8051b4dbef4),
W64LIT(0xb42f77d534e6dafa),
W64LIT(0x40783062db35bb1a),
/* box 5 */
W64LIT(0xf5a96c292deb0a4e),
W64LIT(0x211c9df6ee653c51),
W64LIT(0x04de5ddcbeeef596),
W64LIT(0xe1e5b06f7457c19f),
W64LIT(0x74ca30f014a54fb6),
W64LIT(0xc296f9f7c5457d85),
W64LIT(0x7d4ee08a484d10b0),
W64LIT(0xae87f2d0bf9b13ad),
W64LIT(0x8df4bb480e89afb7),
W64LIT(0x2d8b7a67d9a2d61e),
W64LIT(0x0f3559c8bd712adb),
W64LIT(0x541bc7312f013338),
W64LIT(0x9ec4848b636d5164),
W64LIT(0x952f809f60f28e29),
W64LIT(0x28984d8cb28d6357),
W64LIT(0xd4b5f1dfc38e361f),
W64LIT(0x5674135f7076b373),
W64LIT(0xb791a330042172ec),
W64LIT(0xab94c53bd4b4a6e4),
W64LIT(0xf17731f59305ffd8),
W64LIT(0x39c7a621801e1dcf),
W64LIT(0x20d1f7c13ba47c8e),
W64LIT(0x5e3da912f95facaa),
W64LIT(0xb1202a82e5b80731),
W64LIT(0x13303fc36de4fed3),
W64LIT(0x2e29c43e5314168a),
W64LIT(0x861fbf5c0d1670fa),
W64LIT(0x6458b16af3f771f1),
W64LIT(0x3043765bdcf642c9),
W64LIT(0x12fd55f4b825be0c),
W64LIT(0x0a266e23d65e9f92),
W64LIT(0x6595db5d2636312e),
W64LIT(0x85bd010587a0b06e),
W64LIT(0x9bd7b3600842e42d),
W64LIT(0xaa59af0c0175e63b),
W64LIT(0x240faa1d854a8918),
W64LIT(0xf464061ef82a4a91),
W64LIT(0x5c527d7ca6282ce1),
W64LIT(0x03a2be598ab6c094),
W64LIT(0x40571b7776bdf8e9),
W64LIT(0xe4f687841f7874d6),
W64LIT(0x115febad32937e98),
W64LIT(0x5108f0da442e8671),
W64LIT(0x9cab50e53c1ad12f),
W64LIT(0x33e1c8025640825d),
W64LIT(0x87d2d56bd8d73025),
W64LIT(0xc0f92d999a32fdce),
W64LIT(0x62e938d8126e042c),
W64LIT(0x4a717554a0e3677b),
W64LIT(0x0beb0414039fdf4d),
W64LIT(0xd6da25b19cf9b654),
W64LIT(0x55d6ad06fac073e7),
W64LIT(0x632452efc7af44f3),
W64LIT(0xb5fe775e5b56f2a7),
W64LIT(0x892ae694b0675a21),
W64LIT(0x7a32030f7c1525b2),
W64LIT(0x5d9f174b73e96c3e),
W64LIT(0xc35b93c010843d5a),
W64LIT(0x373f95dee8ae77cb),
W64LIT(0xfb515fd6455b604a),
W64LIT(0xa9fb11558bc326af),
W64LIT(0x22be23af64d3fcc5),
W64LIT(0xa8367b625e026670),
W64LIT(0xb8a4faf8b9505837),
W64LIT(0x785dd7612362a5f9),
W64LIT(0x588c20a018c6d977),
W64LIT(0xea0eb47b77c81ed2),
W64LIT(0xa6ce489d36b20c74),
W64LIT(0x0c97e79137c7ea4f),
W64LIT(0x7c838abd9d8c506f),
W64LIT(0x57b97968a5b7f3ac),
W64LIT(0x6c110b277ade6e28),
W64LIT(0xc785ce1cae6ac8cc),
W64LIT(0x1581b6718c7d8b0e),
W64LIT(0x614b868198d8c4b8),
W64LIT(0x27ad14440ffc498c),
W64LIT(0xdb80a8177eff1cc4),
W64LIT(0x472bf8f242e5cdeb),
W64LIT(0x8a8858cd3ad19ab5),
W64LIT(0xf60bd270a75dcada),
W64LIT(0x43f5a52efc0b387d),
W64LIT(0x6ddc6110af1f2ef7),
W64LIT(0xf0ba5bc246c4bf07),
W64LIT(0x6fb3b57ef068aebc),
W64LIT(0x18db3bd76e7b219e),
W64LIT(0x903cb7740bdd3b60),
W64LIT(0x7bff6938a9d4656d),
W64LIT(0xbdb7cd13d27fed7e),
W64LIT(0x051337eb6b2fb549),
W64LIT(0x77688ea99e138f22),
W64LIT(0xd9ef7c7921889c8f),
W64LIT(0x077ce38534583502),
W64LIT(0xf318e59bcc727f93),
W64LIT(0xb34ffeecbacf877a),
W64LIT(0xe9ac0a22fd7ede46),
W64LIT(0xfc2dbc5371035548),
W64LIT(0x026fd46e5f77804b),
W64LIT(0xe53bedb3cab93409),
W64LIT(0xcc6eca08adf51781),
W64LIT(0xe028da58a1968140),
W64LIT(0x3a6518780aa8dd5b),
W64LIT(0xce011e66f28297ca),
W64LIT(0xa4a19cf369c58c3f),
W64LIT(0xc5ea1a72f11d4887),
W64LIT(0xc427704524dc0858),
W64LIT(0x4238cf1929ca78a2),
W64LIT(0x481ea13aff94e730),
W64LIT(0xdf5ef5cbc011e952),
W64LIT(0x80ae36eeec8f0527),
W64LIT(0x5ae3f4ce47b1593c),
W64LIT(0xcda3a03f7834575e),
W64LIT(0x71d9071b7f8afaff),
W64LIT(0xcadf43ba4c6c625c),
W64LIT(0x1623082806cb4b9a),
W64LIT(0x17ee621fd30a0b45),
W64LIT(0x448946abc8530d7f),
W64LIT(0x974054f13f850e62),
W64LIT(0x73b6d37520fd7ab4),
W64LIT(0xc8b097d4131be217),
W64LIT(0x9f09eebcb6ac11bb),
W64LIT(0x45442c9c1d924da0),
W64LIT(0x1b79858ee4cde10a),
W64LIT(0x0984d07a5ce85f06),
W64LIT(0x4cc0fce6417a12a6),
W64LIT(0x99b8670e57356466),
W64LIT(0xad254c89352dd339),
W64LIT(0x322ca2358381c282),
W64LIT(0xcfcc74512743d715),
W64LIT(0x6b6de8a24e865b2a),
W64LIT(0xda4dc220ab3e5c1b),
W64LIT(0x88e78ca365a61afe),
W64LIT(0x939e092d816bfbf4),
W64LIT(0xcb12298d99ad2283),
W64LIT(0xeed0e9a7c926eb44),
W64LIT(0x98750d3982f424b9),
W64LIT(0xd5789be8164f76c0),
W64LIT(0xbe15734a58c92dea),
W64LIT(0x49d3cb0d2a55a7ef),
W64LIT(0x67fa0f337941b165),
W64LIT(0x8c39d17fdb48ef68),
W64LIT(0x25c2c02a508bc9c7),
W64LIT(0x349d2b876218b75f),
W64LIT(0x70146d2caa4bba20),
W64LIT(0x1c05660bd095d408),
W64LIT(0xfe42683d2e74d503),
W64LIT(0x9a1ad957dd83a4f2),
W64LIT(0xf2d58fac19b33f4c),
W64LIT(0x81635cd9394e45f8),
W64LIT(0xb65cc907d1e03233),
W64LIT(0xdd3121a59f666919),
W64LIT(0x318e1c6c09370216),
W64LIT(0x8b4532faef10da6a),
W64LIT(0x191651e0bbba6141),
W64LIT(0x3f762f9361876812),
W64LIT(0xb96990cf6c9118e8),
W64LIT(0xb4331d698e97b278),
W64LIT(0xd822164ef449dc50),
W64LIT(0x84706b325261f0b1),
W64LIT(0x4eaf28881e0d92ed),
W64LIT(0x69023ccc11f1db61),
W64LIT(0x66376504ac80f1ba),
W64LIT(0x0849ba4d89291fd9),
W64LIT(0xff8f020afbb595dc),
W64LIT(0x50c59aed91efc6ae),
W64LIT(0x1dc80c3c055494d7),
W64LIT(0x1e6ab2658fe25443),
W64LIT(0x3d19fbfd3ef0e859),
W64LIT(0xfa9c35e1909a2095),
W64LIT(0x52aa4e83ce9846e5),
W64LIT(0x419a7140a37cb836),
W64LIT(0xa07fc12fd72b79a9),
W64LIT(0x68cf56fbc4309bbe),
W64LIT(0x01cd6a37d5c140df),
W64LIT(0x9253631a54aabb2b),
W64LIT(0xd06bac037d60c389),
W64LIT(0x295527bb674c2388),
W64LIT(0xd204786d221743c2),
W64LIT(0x0000000000000000),
W64LIT(0xf7c6b847729c8a05),
W64LIT(0xdcfc4b924aa729c6),
W64LIT(0xe38a64012b2041d4),
W64LIT(0xb28294db6f0ec7a5),
W64LIT(0x9d663ad2e9db91f0),
W64LIT(0x91f1dd43de1c7bbf),
W64LIT(0x6086ecb64d198467),
W64LIT(0x59414a97cd0799a8),
W64LIT(0xace826bee0ec93e6),
W64LIT(0xa56cf6c4bc04cce0),
W64LIT(0x727bb942f53c3a6b),
W64LIT(0x6e7edf4925a9ee63),
W64LIT(0x26607e73da3d0953),
W64LIT(0xe75439dd95ceb442),
W64LIT(0x7990bd56f6a3e526),
W64LIT(0xecbf3dc996516b0f),
W64LIT(0x76a5e49e4bd2cffd),
W64LIT(0x968d3ec6ea444ebd),
W64LIT(0x5b2e9ef9927019e3),
W64LIT(0x6aa082959b471bf5),
W64LIT(0xbb0644a133e698a3),
W64LIT(0x830c88b76639c5b3),
W64LIT(0xe2470e36fee1010b),
W64LIT(0xb0ed40b5307947ee),
W64LIT(0x355041b0b7d9f780),
W64LIT(0x8e560511843f6f23),
W64LIT(0x7f2134e4173a90fb),
W64LIT(0x2af799e2edfae31c),
W64LIT(0x4bbc1f63752227a4),
W64LIT(0xf8f3e18fcfeda0de),
W64LIT(0x0d5a8da6e206aa90),
W64LIT(0x2c4610500c6396c1),
W64LIT(0xde939ffc15d0a98d),
W64LIT(0xaf4a98e76a5a5372),
W64LIT(0x8f9b6f2651fe2ffc),
W64LIT(0x36f2ffe93d6f3714),
W64LIT(0x0ef833ff68b06a04),
W64LIT(0xe69953ea400ff49d),
W64LIT(0x23734998b112bc1a),
W64LIT(0x3ebb45a4b44628cd),
W64LIT(0x1ab4efb9310ca1d5),
W64LIT(0x2fe4ae0986d55655),
W64LIT(0xebc3de4ca2095e0d),
W64LIT(0x536724b41b59063a),
W64LIT(0x46e692c597248d34),
W64LIT(0x2b3af3d5383ba3c3),
W64LIT(0x3ba8724fdf699d84),
W64LIT(0xc13447ae4ff3bd11),
W64LIT(0x4d0d96d194bb5279),
W64LIT(0xfde0d664a4c21597),
W64LIT(0xd7174f864938f68b),
W64LIT(0x7eec5ed3c2fbd024),
W64LIT(0xbfd8197d8d086d35),
W64LIT(0x4f6242bfcbccd232),
W64LIT(0xa70322aae3734cab),
W64LIT(0xa3dd7f765d9db93d),
W64LIT(0x94e2eaa8b533cef6),
W64LIT(0x144cdc4659bccbd1),
W64LIT(0xc648a42b7bab8813),
W64LIT(0xf93e8bb81a2ce001),
W64LIT(0xbacb2e96e627d87c),
W64LIT(0xbc7aa72407beada1),
W64LIT(0xc97dfde3c6daa2c8),
W64LIT(0xa1b2ab1802ea3976),
W64LIT(0x1fa7d8525a23149c),
W64LIT(0x75075ac7c1640f69),
W64LIT(0xe861601528bf9e99),
W64LIT(0xa2101541885cf9e2),
W64LIT(0xef1d83901ce7ab9b),
W64LIT(0x06b189b2e19975dd),
W64LIT(0x380acc1655df5d10),
W64LIT(0x1092819ae7523e47),
W64LIT(0xd3c9125af7d6031d),
W64LIT(0xd1a6c634a8a18356),
W64LIT(0x5ff0c3252c9eec75),
W64LIT(0x82c1e280b3f8856c),
W64LIT(0xed7257fe43902bd0),
W64LIT(0x3cd491caeb31a886),
/* box 6 */
W64LIT(0x94af9eb6fad9e7df),
W64LIT(0x9208ae5e03c94ddd),
W64LIT(0x1d8de8d67158480b),
W64LIT(0xfd093cd2ba147af8),
W64LIT(0xa45ceb22e6597ccf),
W64LIT(0x9bbde6e77bf113da),
W64LIT(0xe4edf4b465fffe5c),
W64LIT(0x7125622e4e8d2a2f),
W64LIT(0x1791b81b8f68430d),
W64LIT(0xb56a63d1902195c0),
W64LIT(0xa980832b30d2ee67),
W64LIT(0x4c0a7fb384862397),
W64LIT(0xed58bc0d1dc7a05b),
W64LIT(0x5955d7f05c4d0637),
W64LIT(0xd2b9b1c8806fcf4e),
W64LIT(0x06a730e8f910aa02),
W64LIT(0xb8b60bd846aa0768),
W64LIT(0x45bf370afcbe7d90),
W64LIT(0x16f6b0375ec370a1),
W64LIT(0x892276608b81afd4),
W64LIT(0xdcccc1b5d0ec08e7),
W64LIT(0xe856949162df5f58),
W64LIT(0x82592e81a41a977e),
W64LIT(0xac8eabb74fca1164),
W64LIT(0xfac9041692afe356),
W64LIT(0x3b882d75331ba3ba),
W64LIT(0xa39cd3e6cee2e561),
W64LIT(0xd077a190d7cca9e3),
W64LIT(0x9c7dde23534a8a74),
W64LIT(0x80973ed9f3b9f1d3),
W64LIT(0xce535132209cb4e9),
W64LIT(0xaa299b5fb6dabb66),
W64LIT(0x2d7e9d426dd8d31b),
W64LIT(0x8a8b6e140d89fad5),
W64LIT(0x6ca88af83fd56224),
W64LIT(0xf5db7c4713871753),
W64LIT(0xeef1a4799bcff55a),
W64LIT(0x76e55aea6636b381),
W64LIT(0x8ee24ea4a33a367a),
W64LIT(0x25acddd7c44bbeb0),
W64LIT(0x9adaeecbaa5a2076),
W64LIT(0x0e75707d5083c7a9),
W64LIT(0x2bd9adaa94c87919),
W64LIT(0x19e4c866dfeb84a4),
W64LIT(0x129f9087f070bc0e),
W64LIT(0xd9c2e929aff4f7e4),
W64LIT(0x6f01928cb9dd3725),
W64LIT(0x39463d2d64b8c517),
W64LIT(0xebff8ce5e4d70a59),
W64LIT(0xb40d6bfd418aa66c),
W64LIT(0xf21b44833b3c8efd),
W64LIT(0x3654457ce5903112),
W64LIT(0x431807e205aed792),
W64LIT(0xb10343613e92596f),
W64LIT(0x0a1c50cdfe300b06),
W64LIT(0x778252c6b79d802d),
W64LIT(0x0cbb60250720a104),
W64LIT(0xe1e3dc281ae7015f),
W64LIT(0x0f1278518128f405),
W64LIT(0x47712752ab1d1b3d),
W64LIT(0xe24ac45c9cef545e),
W64LIT(0x1ceae0faa0f37ba7),
W64LIT(0x9814fe93fdf946db),
W64LIT(0xec3fb421cc6c93f7),
W64LIT(0x833e26ad75b1a4d2),
W64LIT(0x6b68b23c176efb8a),
W64LIT(0x4904572ffb9edc94),
W64LIT(0x4bca4777ac3dba39),
W64LIT(0x2762cd8f93e8d81d),
W64LIT(0x9eb3ce7b04e9ecd9),
W64LIT(0xc2e8311727bc15ed),
W64LIT(0xea9884c9357c39f5),
W64LIT(0xfc6e34fe6bbf4954),
W64LIT(0x13f898ab21db8fa2),
W64LIT(0xb7a47389c782f36d),
W64LIT(0x7b3932e3b0bd2129),
W64LIT(0xaf27b3c3c9c24465),
W64LIT(0xb6c37ba51629c0c1),
W64LIT(0x84fe1e695d0a3d7c),
W64LIT(0x1a4dd01259e3d1a5),
W64LIT(0xab4e9373677188ca),
W64LIT(0x90c6be06546a2b70),
W64LIT(0xf37c4cafea97bd51),
W64LIT(0x647aca6d96460f8f),
W64LIT(0x4ec46febd325453a),
W64LIT(0x3e8605e94c035cb9),
W64LIT(0x0ddc6809d68b92a8),
W64LIT(0x8bec6638dc22c979),
W64LIT(0x67d3d219104e5a8e),
W64LIT(0x2abea58645634ab5),
W64LIT(0x5b9bc7a80bee609a),
W64LIT(0x936fa672d2627e71),
W64LIT(0x7d9e020b49ad8b2b),
W64LIT(0x5832dfdc8de6359b),
W64LIT(0xc7e6198b58a4eaee),
W64LIT(0xd41e8120797f654c),
W64LIT(0xf4bc746bc22c24ff),
W64LIT(0xe084d404cb4c32f3),
W64LIT(0x48635f032a35ef38),
W64LIT(0x8757061ddb02687d),
W64LIT(0x522e8f1173d63e9d),
W64LIT(0xbcdf2b68e819cbc7),
W64LIT(0xbf76331c6e119ec6),
W64LIT(0x08d24095a9936dab),
W64LIT(0x728c7a5ac8857f2e),
W64LIT(0xd110a9bc06679a4f),
W64LIT(0x1f43f88e26fb2ea6),
W64LIT(0xb2aa5b15b89a0c6e),
W64LIT(0x4aad4f5b7d968995),
W64LIT(0x9fd4c657d542df75),
W64LIT(0x323d65cc4b23fdbd),
W64LIT(0xc38f393bf6172641),
W64LIT(0xa152c3be994183cc),
W64LIT(0x9d1ad60f82e1b9d8),
W64LIT(0xe744ecc0e3f7ab5d),
W64LIT(0x38213501b513f6bb),
W64LIT(0xade9a39b9e6122c8),
W64LIT(0x37334d50343b02be),
W64LIT(0x55eeb7d55b6da733),
W64LIT(0x970686c27cd1b2de),
W64LIT(0x427f0fced405e43e),
W64LIT(0xc026214f701f7340),
W64LIT(0x40b11f9683a68293),
W64LIT(0x02ce105857a366ad),
W64LIT(0x7e371a7fcfa5de2a),
W64LIT(0xffc72c8aedb71c55),
W64LIT(0x68c1aa489166ae8b),
W64LIT(0xc68111a7890fd942),
W64LIT(0x79f722bbe71e4784),
W64LIT(0xd579890ca8d456e0),
W64LIT(0x70426a029f261983),
W64LIT(0xb0644b4def396ac3),
W64LIT(0xdb0cf971f8579149),
W64LIT(0x5489bff98ac6949f),
W64LIT(0x046920b0aeb3ccaf),
W64LIT(0x7cf90a279806b887),
W64LIT(0x050e289c7f18ff03),
W64LIT(0x651dc24147ed3c23),
W64LIT(0x5e95ef3474f69f99),
W64LIT(0x6dcf82d4ee7e5188),
W64LIT(0x8f854688729105d6),
W64LIT(0x81f036f52212c27f),
W64LIT(0xb9d103f4970134c4),
W64LIT(0x5349873da27d0d31),
W64LIT(0x20a2f54bbb5341b3),
W64LIT(0xf0d554db6c9fe850),
W64LIT(0x07c038c428bb99ae),
W64LIT(0x30f375941c809b10),
W64LIT(0x3fe10dc59da86f15),
W64LIT(0x46162f7e7ab62891),
W64LIT(0xe623e4ec325c98f1),
W64LIT(0xfea024a63c1c2ff9),
W64LIT(0x349a5524b23357bf),
W64LIT(0x35fd5d0863986413),
W64LIT(0x96618eeead7a8172),
W64LIT(0xcb5d79ae5f844bea),
W64LIT(0x21c5fd676af8721f),
W64LIT(0x5720a78d0ccec19e),
W64LIT(0xf6726433958f4252),
W64LIT(0x8d4b56d02532637b),
W64LIT(0x24cbd5fb15e08d1c),
W64LIT(0x3aef2559e2b09016),
W64LIT(0x5afccf84da455336),
W64LIT(0x51879765f5de6b9c),
W64LIT(0x2917bdf2c36b1fb4),
W64LIT(0xa7f5f356605129ce),
W64LIT(0xc1412963a1b440ec),
W64LIT(0x3d2f1d9dca0b09b8),
W64LIT(0xa53be30e37f24f63),
W64LIT(0x5ff2e718a55dac35),
W64LIT(0xa2fbdbca1f49d6cd),
W64LIT(0xf7156c1f442471fe),
W64LIT(0x7a5e3acf61161285),
W64LIT(0xca3a71828e2f7846),
W64LIT(0x1b2ad83e8848e209),
W64LIT(0xa8e78b07e179ddcb),
W64LIT(0xef96ac554a64c6f6),
W64LIT(0x0000000000000000),
W64LIT(0x6013eadd38f5c320),
W64LIT(0x3c4815b11ba03a14),
W64LIT(0x09b548b978385e07),
W64LIT(0x226ce513ecf0271e),
W64LIT(0x63baf2a9befd9621),
W64LIT(0x44d83f262d154e3c),
W64LIT(0xcdfa4946a694e1e8),
W64LIT(0x113688f37678e90f),
W64LIT(0x859916458ca10ed0),
W64LIT(0xc52809d30f078c43),
W64LIT(0x4d6d779f552d103b),
W64LIT(0x1e24f0a2f7501d0a),
W64LIT(0x0167082cd1ab33ac),
W64LIT(0x1438a06f0960160c),
W64LIT(0xf9601c6214a7b657),
W64LIT(0xa035cb9248eab060),
W64LIT(0x50e09f4924755830),
W64LIT(0xd7b79954ff77304d),
W64LIT(0xe58afc98b454cdf0),
W64LIT(0x03a9187486085501),
W64LIT(0x62ddfa856f56a58d),
W64LIT(0xc44f01ffdeacbfef),
W64LIT(0x73eb7276192e4c82),
W64LIT(0xd6d091782edc03e1),
W64LIT(0xfbae0c3a4304d0fa),
W64LIT(0x9973f6bf2c527577),
W64LIT(0x105180dfa7d3daa3),
W64LIT(0x2605c5a34243ebb1),
W64LIT(0x91a1b62a85c118dc),
W64LIT(0xc99369f608272d47),
W64LIT(0x5d3cf740f2feca98),
W64LIT(0xcf34591ef1378745),
W64LIT(0xc8f461dad98c1eeb),
W64LIT(0x0b7b58e12f9b38aa),
W64LIT(0xe32dcc704d4467f2),
W64LIT(0x754c429ee03ee680),
W64LIT(0xd3deb9e451c4fce2),
W64LIT(0x6e669aa068760489),
W64LIT(0x66b4da35c1e56922),
W64LIT(0x4fa367c7028e7696),
W64LIT(0xba781b80110961c5),
W64LIT(0x41d617ba520db13f),
W64LIT(0x335a6de09a88ce11),
W64LIT(0xdf65d9c156e45de6),
W64LIT(0xcc9d416a773fd244),
W64LIT(0x5c5bff6c2355f934),
W64LIT(0x2870b5de12c02c18),
W64LIT(0x155fa843d8cb25a0),
W64LIT(0x78902a9736b57428),
W64LIT(0xae40bbef186977c9),
W64LIT(0x88457e4c5a2a9c78),
W64LIT(0x6a0fba10c6c5c826),
W64LIT(0x7f5012531e0eed86),
W64LIT(0x8c2c5efcf49950d7),
W64LIT(0x31947db8cd2ba8bc),
W64LIT(0x2c19956ebc73e0b7),
W64LIT(0x230bed3f3d5b14b2),
W64LIT(0x69a6a26440cd9d27),
W64LIT(0x86300e310aa95bd1),
W64LIT(0xb3cd533969313fc2),
W64LIT(0x1883c04a0e40b708),
W64LIT(0xf1b25cf7bd34dbfc),
W64LIT(0x2fb08d1a3a7bb5b6),
W64LIT(0xd8a5e1057e5fc448),
W64LIT(0xddabc99901473b4b),
W64LIT(0xde02d1ed874f6e4a),
W64LIT(0xbdb8234439b2f86b),
W64LIT(0x5647afa1dd65f232),
W64LIT(0x2ed78536ebd0861a),
W64LIT(0xe9319cbdb3746cf4),
W64LIT(0xa692fb7ab1fa1a62),
W64LIT(0x742b4ab23195d52c),
W64LIT(0x95c8969a2b72d473),
W64LIT(0x6174e2f1e95ef08c),
W64LIT(0xf807144ec50c85fb),
W64LIT(0xbe113b30bfbaad6a),
W64LIT(0xda6bf15d29fca2e5),
W64LIT(0xbb1f13acc0a25269),
/* box 7 */
W64LIT(0xc22b27f0f9e37bf9),
W64LIT(0x93fad23f0955ef09),
W64LIT(0x32ed4b84a22a91a2),
W64LIT(0x3898b57bcc61b1cc),
W64LIT(0x55825ba9ad98e5ad),
W64LIT(0xb2eeb8069421ec94),
W64LIT(0xc7eb5875ce3c6bce),
W64LIT(0x4b1dac5d1f45851f),
W64LIT(0xc16ba1204705d847),
W64LIT(0xc5380f461a2ba91a),
W64LIT(0xb908971a909bad90),
W64LIT(0x303e1cb7763d5376),
W64LIT(0xe6ff324c53486853),
W64LIT(0x6d1aeed261f95461),
W64LIT(0x0193d1e36af1616a),
W64LIT(0x51d1f5cff0b694f0),
W64LIT(0x29b2c3f52728e127),
W64LIT(0x112a768eeb4950eb),
W64LIT(0x8fb672f86f9f4d6f),
W64LIT(0xf0c66c745bc9ea5b),
W64LIT(0x3f8b9dcd2fa9632f),
W64LIT(0x65bc471edba5b6db),
W64LIT(0x4d9d5508967c3696),
W64LIT(0x3a4be24818767318),
W64LIT(0x2794936c144db014),
W64LIT(0x2af2452599ce4299),
W64LIT(0x4a8e7dbe75b4e475),
W64LIT(0x9ddc82a63a30be3a),
W64LIT(0xade29e114c0ded4c),
W64LIT(0xd1d2064dc6bde9c6),
W64LIT(0x7da349bfe04165e0),
W64LIT(0x6b9a1787e8c0e7e8),
W64LIT(0xa54437ddf6510ff6),
W64LIT(0x2254ece92392a023),
W64LIT(0x79f0e7d9bd6f14bd),
W64LIT(0x57510c9a798f2779),
W64LIT(0x346db2d12b13222b),
W64LIT(0x54118a4ac76984c7),
W64LIT(0xefca4a6383e5eb83),
W64LIT(0xca8d8e3c43bf9943),
W64LIT(0xfc336bdebcbb79bc),
W64LIT(0x3e184c2e45580245),
W64LIT(0xf495c21206e79b06),
W64LIT(0xff73ed0e025dda02),
W64LIT(0x4228d472cfe806cf),
W64LIT(0xbcc8e89fa744bda7),
W64LIT(0xab626744c5345ec5),
W64LIT(0xb6bd1660c90f9dc9),
W64LIT(0xb72ec783a3fefca3),
W64LIT(0x8be5dc9e32b13c32),
W64LIT(0x485d2a8da1a326a1),
W64LIT(0xc6788996a4cd0aa4),
W64LIT(0x40fb83411bffc41b),
W64LIT(0x08a6a9ccba5ce2ba),
W64LIT(0xf386eaa4e52f49e5),
W64LIT(0x1acc5992eff311ef),
W64LIT(0xa2571f6b1599dd15),
W64LIT(0x44a82d2746d1b546),
W64LIT(0x70c59ff66dc2976d),
W64LIT(0x8d6525cbbb888fbb),
W64LIT(0x963aadba3e8aff3e),
W64LIT(0x7c30985c8ab0048a),
W64LIT(0x607c389bec7aa6ec),
W64LIT(0xa822e1947bd2fd7b),
W64LIT(0x034086d0bee6a3be),
W64LIT(0x66fcc1ce65431565),
W64LIT(0xb37d69e5fed08dfe),
W64LIT(0x2f323aa0ae1152ae),
W64LIT(0x56c2dd79137e4613),
W64LIT(0x31adcd541ccc321c),
W64LIT(0xdff456d4f5d8b8f5),
W64LIT(0xf9f3145b8b64698b),
W64LIT(0x764566a3e4fb24e4),
W64LIT(0x0cf507aae77293e7),
W64LIT(0x59775c034aea764a),
W64LIT(0xb89b46f9fa6accfa),
W64LIT(0xe8d962d5602d3960),
W64LIT(0x17aa8fdb6270e362),
W64LIT(0x1c4ca0c766caa266),
W64LIT(0x2de16d937a06907a),
W64LIT(0x2547c45fc05a72c0),
W64LIT(0x0fb5817a59943059),
W64LIT(0x0680f9558939b389),
W64LIT(0x16395e3808818208),
W64LIT(0xac714ff226fc8c26),
W64LIT(0xa9b1307711239c11),
W64LIT(0xec8accb33d03483d),
W64LIT(0x6c893f310b08350b),
W64LIT(0xc4abdea570dac870),
W64LIT(0xba4811ca2e7d0e2e),
W64LIT(0xf155bd9731388b31),
W64LIT(0xdd2701e721cf7a21),
W64LIT(0xe94ab3360adc580a),
W64LIT(0x23c73d0a4963c149),
W64LIT(0x5cb723867d35667d),
W64LIT(0x5042242c9a47f59a),
W64LIT(0x198cdf425115b251),
W64LIT(0x0a75feff6e4b206e),
W64LIT(0xfda0ba3dd64a18d6),
W64LIT(0xcede205a1e91e81e),
W64LIT(0xd041d7aeac4c88ac),
W64LIT(0xe42c657f875faa87),
W64LIT(0x36bee5e2ff04e0ff),
W64LIT(0x6fc9b9e1b5ee96b5),
W64LIT(0x998f2cc0671ecf67),
W64LIT(0xd301517e12aa2b12),
W64LIT(0xaea218c1f2eb4ef2),
W64LIT(0xda342951c207a8c2),
W64LIT(0x61efe978868bc786),
W64LIT(0x7f701e8c3456a734),
W64LIT(0x0be62f1c04ba4104),
W64LIT(0x9129850cdd422ddd),
W64LIT(0xd6c12efb25753b25),
W64LIT(0xe33f4dc964977864),
W64LIT(0x1579d8e8b66721b6),
W64LIT(0xf860c5b8e19508e1),
W64LIT(0x7496319030ece630),
W64LIT(0x88a55a4e8c579f8c),
W64LIT(0xcf4df1b974608974),
W64LIT(0x10b9a76d81b83181),
W64LIT(0x0e26509933655133),
W64LIT(0x43bb0591a51967a5),
W64LIT(0x926903dc63a48e63),
W64LIT(0x9c4f534550c1df50),
W64LIT(0x3bd833ab72871272),
W64LIT(0xa4d7e63e9ca06e9c),
W64LIT(0xb46e41531d185f1d),
W64LIT(0x126af05e55aff355),
W64LIT(0x24d415bcaaab13aa),
W64LIT(0x1e9ff7f4b2dd60b2),
W64LIT(0x05c07f8537df1037),
W64LIT(0x467b7a1492c67792),
W64LIT(0x2087bbdaf78562f7),
W64LIT(0x819022615cfa1c5c),
W64LIT(0xcd9ea68aa0774ba0),
W64LIT(0xa79760ee2246cd22),
W64LIT(0x8343755288edde88),
W64LIT(0x58e48de0201b1720),
W64LIT(0x7216c8c5b9d555b9),
W64LIT(0x372d340195f58195),
W64LIT(0xa11799bbab7f7eab),
W64LIT(0x9f0fd595ee277cee),
W64LIT(0x676f102d0fb2740f),
W64LIT(0x9e9c047684d61d84),
W64LIT(0x49cefb6ecb5247cb),
W64LIT(0xd41279c8f162f9f1),
W64LIT(0x1f0c2617d82c01d8),
W64LIT(0x97a97c59547b9e54),
W64LIT(0xe76ce3af39b90939),
W64LIT(0xc3b8f61393121a93),
W64LIT(0x5ba40b309efdb49e),
W64LIT(0xea0a35e6b43afbb4),
W64LIT(0x5a37dad3f40cd5f4),
W64LIT(0x14ea090bdc9640dc),
W64LIT(0x5e6474b5a922a4a9),
W64LIT(0xfee03ced68acbb68),
W64LIT(0x071328b6e3c8d2e3),
W64LIT(0x5302a2fc24a15624),
W64LIT(0x85c38c0701d46d01),
W64LIT(0x3d58cafefbbea1fb),
W64LIT(0x84505de46b250c6b),
W64LIT(0x642f96fdb154d7b1),
W64LIT(0xbf886e4f19a21e19),
W64LIT(0x02d35733d417c2d4),
W64LIT(0x68da915756264456),
W64LIT(0x8710db34d5c3afd5),
W64LIT(0x0d66d6498d83f28d),
W64LIT(0x7b23b0ea6978d669),
W64LIT(0x1b5f887185027085),
W64LIT(0x3ccb1b1d914fc091),
W64LIT(0x0453ae665d2e715d),
W64LIT(0xcb1e5fdf294ef829),
W64LIT(0xf6469521d2f059d2),
W64LIT(0xb03def3540362e40),
W64LIT(0x633cbe4b529c0552),
W64LIT(0xf7d544c2b80138b8),
W64LIT(0x7ab061090389b703),
W64LIT(0x0000000000000000),
W64LIT(0xdba7f8b2a8f6c9a8),
W64LIT(0x35fe633241e24341),
W64LIT(0x21146a399d74039d),
W64LIT(0xd581a82b9b93989b),
W64LIT(0x0935782fd0ad83d0),
W64LIT(0x5ff7a556c3d3c5c3),
W64LIT(0xaf31c922981a2f98),
W64LIT(0x90ba54efb7b34cb7),
W64LIT(0x5291731f4e50374e),
W64LIT(0xc0f870c32df4b92d),
W64LIT(0x7ee3cf6f5ea7c65e),
W64LIT(0xe07fcb19da71dbda),
W64LIT(0x4eddd3d8289a9528),
W64LIT(0x13f921bd3f5e923f),
W64LIT(0xf50613f16c16fa6c),
W64LIT(0x981cfd230defae0d),
W64LIT(0x4c0e84ebfc8d57fc),
W64LIT(0x82d0a4b1e21cbfe2),
W64LIT(0x89368bade6a6fee6),
W64LIT(0xd292809d785b4a78),
W64LIT(0x47e8abf7f83716f8),
W64LIT(0x8e25a31b056e2c05),
W64LIT(0xd752ff184f845a4f),
W64LIT(0xcc0d7769ca862aca),
W64LIT(0x694940b43cd7253c),
W64LIT(0x2ea1eb43c4e033c4),
W64LIT(0xde6787379f29d99f),
W64LIT(0x181f0ea13be4d33b),
W64LIT(0x416852a2710ea571),
W64LIT(0x62af6fa8386d6438),
W64LIT(0xa0844858c18e1fc1),
W64LIT(0x337e9a67c8dbf0c8),
W64LIT(0x2c72bc7010f7f110),
W64LIT(0xbd5b397ccdb5dccd),
W64LIT(0xd8e77e6216106a16),
W64LIT(0x86830ad7bf32cebf),
W64LIT(0x4f4e023b426bf442),
W64LIT(0xe5bfb49cedaecbed),
W64LIT(0x8a760d7d58405d58),
W64LIT(0xe2ac9c2a0e66190e),
W64LIT(0xb5fd90b077e93e77),
W64LIT(0xdcb4d0044b3e1b4b),
W64LIT(0x453bfcc42c20d42c),
W64LIT(0xed191d5057f22957),
W64LIT(0xe1ec1afab080bab0),
W64LIT(0xee599b80e9148ae9),
W64LIT(0x2607428f7ebcd17e),
W64LIT(0x5d24f26517c40717),
W64LIT(0x6a09c66482318682),
W64LIT(0xa604b10d48b7ac48),
W64LIT(0xbe1bbfac73537f73),
W64LIT(0x282112164dd9804d),
W64LIT(0x7505e0735a1d875a),
W64LIT(0x73851926d32434d3),
W64LIT(0xd974af817ce10b7c),
W64LIT(0xeb99e405decb9ade),
W64LIT(0x9b5c7bf3b3090db3),
W64LIT(0xfab3928b3582ca35),
W64LIT(0x8003f382360b7d36),
W64LIT(0x94e9fa89ea9d3dea),
W64LIT(0xb1ae3ed62ac74f2a),
W64LIT(0x9acfaa10d9f86cd9),
W64LIT(0x390b6498a690d0a6),
W64LIT(0xf2153b478fde288f),
W64LIT(0x71564e150733f607),
W64LIT(0xa3c4ce887f68bc7f),
W64LIT(0xaaf1b6a7afc53faf),
W64LIT(0x1ddf71240c3bc30c),
W64LIT(0x77d6b7408e0a458e),
W64LIT(0x2b6194c6f33f23f3),
W64LIT(0xc9cd08ecfd593afd),
W64LIT(0xc85ed90f97a85b97),
W64LIT(0x8cf6f428d179eed1),
W64LIT(0x957a2b6a806c5c80),
W64LIT(0xbbdbc029448c6f44),
W64LIT(0x7863363ad79e75d7),
W64LIT(0x6e5a6802df1ff7df),
W64LIT(0xfb2043685f73ab5f),
};

static const byte SHARK_iG[8*8] =
{
  0xe7, 0x30, 0x90, 0x85, 0xd0, 0x4b, 0x91, 0x41,
  0x53, 0x95, 0x9b, 0xa5, 0x96, 0xbc, 0xa1, 0x68,
  0x02, 0x45, 0xf7, 0x65, 0x5c, 0x1f, 0xb6, 0x52,
  0xa2, 0xca, 0x22, 0x94, 0x44, 0x63, 0x2a, 0xa2,
  0xfc, 0x67, 0x8e, 0x10, 0x29, 0x75, 0x85, 0x71,
  0x24, 0x45, 0xa2, 0xcf, 0x2f, 0x22, 0xc1, 0x0e,
  0xa1, 0xf1, 0x71, 0x40, 0x91, 0x27, 0x18, 0xa5,
  0x56, 0xf4, 0xaf, 0x32, 0xd2, 0xa4, 0xdc, 0x71,
};
//-----------------
static const word32 SHA256_K[64] =
{
  0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
  0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
  0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
  0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
  0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
  0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
  0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
  0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
  0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
  0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
  0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
  0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
  0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
  0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
  0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
  0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2
};

static const word64 SHA512_K[80] =
{
  W64LIT(0x428a2f98d728ae22), W64LIT(0x7137449123ef65cd),
  W64LIT(0xb5c0fbcfec4d3b2f), W64LIT(0xe9b5dba58189dbbc),
  W64LIT(0x3956c25bf348b538), W64LIT(0x59f111f1b605d019),
  W64LIT(0x923f82a4af194f9b), W64LIT(0xab1c5ed5da6d8118),
  W64LIT(0xd807aa98a3030242), W64LIT(0x12835b0145706fbe),
  W64LIT(0x243185be4ee4b28c), W64LIT(0x550c7dc3d5ffb4e2),
  W64LIT(0x72be5d74f27b896f), W64LIT(0x80deb1fe3b1696b1),
  W64LIT(0x9bdc06a725c71235), W64LIT(0xc19bf174cf692694),
  W64LIT(0xe49b69c19ef14ad2), W64LIT(0xefbe4786384f25e3),
  W64LIT(0x0fc19dc68b8cd5b5), W64LIT(0x240ca1cc77ac9c65),
  W64LIT(0x2de92c6f592b0275), W64LIT(0x4a7484aa6ea6e483),
  W64LIT(0x5cb0a9dcbd41fbd4), W64LIT(0x76f988da831153b5),
  W64LIT(0x983e5152ee66dfab), W64LIT(0xa831c66d2db43210),
  W64LIT(0xb00327c898fb213f), W64LIT(0xbf597fc7beef0ee4),
  W64LIT(0xc6e00bf33da88fc2), W64LIT(0xd5a79147930aa725),
  W64LIT(0x06ca6351e003826f), W64LIT(0x142929670a0e6e70),
  W64LIT(0x27b70a8546d22ffc), W64LIT(0x2e1b21385c26c926),
  W64LIT(0x4d2c6dfc5ac42aed), W64LIT(0x53380d139d95b3df),
  W64LIT(0x650a73548baf63de), W64LIT(0x766a0abb3c77b2a8),
  W64LIT(0x81c2c92e47edaee6), W64LIT(0x92722c851482353b),
  W64LIT(0xa2bfe8a14cf10364), W64LIT(0xa81a664bbc423001),
  W64LIT(0xc24b8b70d0f89791), W64LIT(0xc76c51a30654be30),
  W64LIT(0xd192e819d6ef5218), W64LIT(0xd69906245565a910),
  W64LIT(0xf40e35855771202a), W64LIT(0x106aa07032bbd1b8),
  W64LIT(0x19a4c116b8d2d0c8), W64LIT(0x1e376c085141ab53),
  W64LIT(0x2748774cdf8eeb99), W64LIT(0x34b0bcb5e19b48a8),
  W64LIT(0x391c0cb3c5c95a63), W64LIT(0x4ed8aa4ae3418acb),
  W64LIT(0x5b9cca4f7763e373), W64LIT(0x682e6ff3d6b2b8a3),
  W64LIT(0x748f82ee5defb2fc), W64LIT(0x78a5636f43172f60),
  W64LIT(0x84c87814a1f0ab72), W64LIT(0x8cc702081a6439ec),
  W64LIT(0x90befffa23631e28), W64LIT(0xa4506cebde82bde9),
  W64LIT(0xbef9a3f7b2c67915), W64LIT(0xc67178f2e372532b),
  W64LIT(0xca273eceea26619c), W64LIT(0xd186b8c721c0c207),
  W64LIT(0xeada7dd6cde0eb1e), W64LIT(0xf57d4f7fee6ed178),
  W64LIT(0x06f067aa72176fba), W64LIT(0x0a637dc5a2c898a6),
  W64LIT(0x113f9804bef90dae), W64LIT(0x1b710b35131c471b),
  W64LIT(0x28db77f523047d84), W64LIT(0x32caab7b40c72493),
  W64LIT(0x3c9ebe0a15c9bebc), W64LIT(0x431d67c49c100d4c),
  W64LIT(0x4cc5d4becb3e42b6), W64LIT(0x597f299cfc657e2a),
  W64LIT(0x5fcb6fab3ad6faec), W64LIT(0x6c44198c4a475817)
};

//-----------------
static const byte SAFER_exp_tab[256] =
{
  1, 45, 226, 147, 190, 69, 21, 174, 120, 3, 135, 164, 184, 56, 207, 63,
  8, 103, 9, 148, 235, 38, 168, 107, 189, 24, 52, 27, 187, 191, 114, 247,
  64, 53, 72, 156, 81, 47, 59, 85, 227, 192, 159, 216, 211, 243, 141, 177,
  255, 167, 62, 220, 134, 119, 215, 166, 17, 251, 244, 186, 146, 145, 100, 131,
  241, 51, 239, 218, 44, 181, 178, 43, 136, 209, 153, 203, 140, 132, 29, 20,
  129, 151, 113, 202, 95, 163, 139, 87, 60, 130, 196, 82, 92, 28, 232, 160,
  4, 180, 133, 74, 246, 19, 84, 182, 223, 12, 26, 142, 222, 224, 57, 252,
  32, 155, 36, 78, 169, 152, 158, 171, 242, 96, 208, 108, 234, 250, 199, 217,
  0, 212, 31, 110, 67, 188, 236, 83, 137, 254, 122, 93, 73, 201, 50, 194,
  249, 154, 248, 109, 22, 219, 89, 150, 68, 233, 205, 230, 70, 66, 143, 10,
  193, 204, 185, 101, 176, 210, 198, 172, 30, 65, 98, 41, 46, 14, 116, 80,
  2, 90, 195, 37, 123, 138, 42, 91, 240, 6, 13, 71, 111, 112, 157, 126,
  16, 206, 18, 39, 213, 76, 79, 214, 121, 48, 104, 54, 117, 125, 228, 237,
  128, 106, 144, 55, 162, 94, 118, 170, 197, 127, 61, 175, 165, 229, 25, 97,
  253, 77, 124, 183, 11, 238, 173, 75, 34, 245, 231, 115, 35, 33, 200, 5,
  225, 102, 221, 179, 88, 105, 99, 86, 15, 161, 49, 149, 23, 7, 58, 40
};

static const byte SAFER_log_tab[256] =
{
  128, 0, 176, 9, 96, 239, 185, 253, 16, 18, 159, 228, 105, 186, 173, 248,
  192, 56, 194, 101, 79, 6, 148, 252, 25, 222, 106, 27, 93, 78, 168, 130,
  112, 237, 232, 236, 114, 179, 21, 195, 255, 171, 182, 71, 68, 1, 172, 37,
  201, 250, 142, 65, 26, 33, 203, 211, 13, 110, 254, 38, 88, 218, 50, 15,
  32, 169, 157, 132, 152, 5, 156, 187, 34, 140, 99, 231, 197, 225, 115, 198,
  175, 36, 91, 135, 102, 39, 247, 87, 244, 150, 177, 183, 92, 139, 213, 84,
  121, 223, 170, 246, 62, 163, 241, 17, 202, 245, 209, 23, 123, 147, 131, 188,
  189, 82, 30, 235, 174, 204, 214, 53, 8, 200, 138, 180, 226, 205, 191, 217,
  208, 80, 89, 63, 77, 98, 52, 10, 72, 136, 181, 86, 76, 46, 107, 158,
  210, 61, 60, 3, 19, 251, 151, 81, 117, 74, 145, 113, 35, 190, 118, 42,
  95, 249, 212, 85, 11, 220, 55, 49, 22, 116, 215, 119, 167, 230, 7, 219,
  164, 47, 70, 243, 97, 69, 103, 227, 12, 162, 59, 28, 133, 24, 4, 29,
  41, 160, 143, 178, 90, 216, 166, 126, 238, 141, 83, 75, 161, 154, 193, 14,
  122, 73, 165, 44, 129, 196, 199, 54, 43, 127, 67, 149, 51, 242, 108, 104,
  109, 240, 2, 40, 206, 221, 155, 234, 94, 153, 124, 20, 134, 207, 229, 66,
  184, 64, 120, 45, 58, 233, 100, 31, 146, 144, 125, 57, 111, 224, 137, 48
};


//-----------------
static const word32 Rijndael_Te0[256] =
{
  0xc66363a5, 0xf87c7c84, 0xee777799, 0xf67b7b8d,
  0xfff2f20d, 0xd66b6bbd, 0xde6f6fb1, 0x91c5c554,
  0x60303050, 0x02010103, 0xce6767a9, 0x562b2b7d,
  0xe7fefe19, 0xb5d7d762, 0x4dababe6, 0xec76769a,
  0x8fcaca45, 0x1f82829d, 0x89c9c940, 0xfa7d7d87,
  0xeffafa15, 0xb25959eb, 0x8e4747c9, 0xfbf0f00b,
  0x41adadec, 0xb3d4d467, 0x5fa2a2fd, 0x45afafea,
  0x239c9cbf, 0x53a4a4f7, 0xe4727296, 0x9bc0c05b,
  0x75b7b7c2, 0xe1fdfd1c, 0x3d9393ae, 0x4c26266a,
  0x6c36365a, 0x7e3f3f41, 0xf5f7f702, 0x83cccc4f,
  0x6834345c, 0x51a5a5f4, 0xd1e5e534, 0xf9f1f108,
  0xe2717193, 0xabd8d873, 0x62313153, 0x2a15153f,
  0x0804040c, 0x95c7c752, 0x46232365, 0x9dc3c35e,
  0x30181828, 0x379696a1, 0x0a05050f, 0x2f9a9ab5,
  0x0e070709, 0x24121236, 0x1b80809b, 0xdfe2e23d,
  0xcdebeb26, 0x4e272769, 0x7fb2b2cd, 0xea75759f,
  0x1209091b, 0x1d83839e, 0x582c2c74, 0x341a1a2e,
  0x361b1b2d, 0xdc6e6eb2, 0xb45a5aee, 0x5ba0a0fb,
  0xa45252f6, 0x763b3b4d, 0xb7d6d661, 0x7db3b3ce,
  0x5229297b, 0xdde3e33e, 0x5e2f2f71, 0x13848497,
  0xa65353f5, 0xb9d1d168, 0x00000000, 0xc1eded2c,
  0x40202060, 0xe3fcfc1f, 0x79b1b1c8, 0xb65b5bed,
  0xd46a6abe, 0x8dcbcb46, 0x67bebed9, 0x7239394b,
  0x944a4ade, 0x984c4cd4, 0xb05858e8, 0x85cfcf4a,
  0xbbd0d06b, 0xc5efef2a, 0x4faaaae5, 0xedfbfb16,
  0x864343c5, 0x9a4d4dd7, 0x66333355, 0x11858594,
  0x8a4545cf, 0xe9f9f910, 0x04020206, 0xfe7f7f81,
  0xa05050f0, 0x783c3c44, 0x259f9fba, 0x4ba8a8e3,
  0xa25151f3, 0x5da3a3fe, 0x804040c0, 0x058f8f8a,
  0x3f9292ad, 0x219d9dbc, 0x70383848, 0xf1f5f504,
  0x63bcbcdf, 0x77b6b6c1, 0xafdada75, 0x42212163,
  0x20101030, 0xe5ffff1a, 0xfdf3f30e, 0xbfd2d26d,
  0x81cdcd4c, 0x180c0c14, 0x26131335, 0xc3ecec2f,
  0xbe5f5fe1, 0x359797a2, 0x884444cc, 0x2e171739,
  0x93c4c457, 0x55a7a7f2, 0xfc7e7e82, 0x7a3d3d47,
  0xc86464ac, 0xba5d5de7, 0x3219192b, 0xe6737395,
  0xc06060a0, 0x19818198, 0x9e4f4fd1, 0xa3dcdc7f,
  0x44222266, 0x542a2a7e, 0x3b9090ab, 0x0b888883,
  0x8c4646ca, 0xc7eeee29, 0x6bb8b8d3, 0x2814143c,
  0xa7dede79, 0xbc5e5ee2, 0x160b0b1d, 0xaddbdb76,
  0xdbe0e03b, 0x64323256, 0x743a3a4e, 0x140a0a1e,
  0x924949db, 0x0c06060a, 0x4824246c, 0xb85c5ce4,
  0x9fc2c25d, 0xbdd3d36e, 0x43acacef, 0xc46262a6,
  0x399191a8, 0x319595a4, 0xd3e4e437, 0xf279798b,
  0xd5e7e732, 0x8bc8c843, 0x6e373759, 0xda6d6db7,
  0x018d8d8c, 0xb1d5d564, 0x9c4e4ed2, 0x49a9a9e0,
  0xd86c6cb4, 0xac5656fa, 0xf3f4f407, 0xcfeaea25,
  0xca6565af, 0xf47a7a8e, 0x47aeaee9, 0x10080818,
  0x6fbabad5, 0xf0787888, 0x4a25256f, 0x5c2e2e72,
  0x381c1c24, 0x57a6a6f1, 0x73b4b4c7, 0x97c6c651,
  0xcbe8e823, 0xa1dddd7c, 0xe874749c, 0x3e1f1f21,
  0x964b4bdd, 0x61bdbddc, 0x0d8b8b86, 0x0f8a8a85,
  0xe0707090, 0x7c3e3e42, 0x71b5b5c4, 0xcc6666aa,
  0x904848d8, 0x06030305, 0xf7f6f601, 0x1c0e0e12,
  0xc26161a3, 0x6a35355f, 0xae5757f9, 0x69b9b9d0,
  0x17868691, 0x99c1c158, 0x3a1d1d27, 0x279e9eb9,
  0xd9e1e138, 0xebf8f813, 0x2b9898b3, 0x22111133,
  0xd26969bb, 0xa9d9d970, 0x078e8e89, 0x339494a7,
  0x2d9b9bb6, 0x3c1e1e22, 0x15878792, 0xc9e9e920,
  0x87cece49, 0xaa5555ff, 0x50282878, 0xa5dfdf7a,
  0x038c8c8f, 0x59a1a1f8, 0x09898980, 0x1a0d0d17,
  0x65bfbfda, 0xd7e6e631, 0x844242c6, 0xd06868b8,
  0x824141c3, 0x299999b0, 0x5a2d2d77, 0x1e0f0f11,
  0x7bb0b0cb, 0xa85454fc, 0x6dbbbbd6, 0x2c16163a,
};
static const word32 Rijndael_Te1[256] =
{
  0xa5c66363, 0x84f87c7c, 0x99ee7777, 0x8df67b7b,
  0x0dfff2f2, 0xbdd66b6b, 0xb1de6f6f, 0x5491c5c5,
  0x50603030, 0x03020101, 0xa9ce6767, 0x7d562b2b,
  0x19e7fefe, 0x62b5d7d7, 0xe64dabab, 0x9aec7676,
  0x458fcaca, 0x9d1f8282, 0x4089c9c9, 0x87fa7d7d,
  0x15effafa, 0xebb25959, 0xc98e4747, 0x0bfbf0f0,
  0xec41adad, 0x67b3d4d4, 0xfd5fa2a2, 0xea45afaf,
  0xbf239c9c, 0xf753a4a4, 0x96e47272, 0x5b9bc0c0,
  0xc275b7b7, 0x1ce1fdfd, 0xae3d9393, 0x6a4c2626,
  0x5a6c3636, 0x417e3f3f, 0x02f5f7f7, 0x4f83cccc,
  0x5c683434, 0xf451a5a5, 0x34d1e5e5, 0x08f9f1f1,
  0x93e27171, 0x73abd8d8, 0x53623131, 0x3f2a1515,
  0x0c080404, 0x5295c7c7, 0x65462323, 0x5e9dc3c3,
  0x28301818, 0xa1379696, 0x0f0a0505, 0xb52f9a9a,
  0x090e0707, 0x36241212, 0x9b1b8080, 0x3ddfe2e2,
  0x26cdebeb, 0x694e2727, 0xcd7fb2b2, 0x9fea7575,
  0x1b120909, 0x9e1d8383, 0x74582c2c, 0x2e341a1a,
  0x2d361b1b, 0xb2dc6e6e, 0xeeb45a5a, 0xfb5ba0a0,
  0xf6a45252, 0x4d763b3b, 0x61b7d6d6, 0xce7db3b3,
  0x7b522929, 0x3edde3e3, 0x715e2f2f, 0x97138484,
  0xf5a65353, 0x68b9d1d1, 0x00000000, 0x2cc1eded,
  0x60402020, 0x1fe3fcfc, 0xc879b1b1, 0xedb65b5b,
  0xbed46a6a, 0x468dcbcb, 0xd967bebe, 0x4b723939,
  0xde944a4a, 0xd4984c4c, 0xe8b05858, 0x4a85cfcf,
  0x6bbbd0d0, 0x2ac5efef, 0xe54faaaa, 0x16edfbfb,
  0xc5864343, 0xd79a4d4d, 0x55663333, 0x94118585,
  0xcf8a4545, 0x10e9f9f9, 0x06040202, 0x81fe7f7f,
  0xf0a05050, 0x44783c3c, 0xba259f9f, 0xe34ba8a8,
  0xf3a25151, 0xfe5da3a3, 0xc0804040, 0x8a058f8f,
  0xad3f9292, 0xbc219d9d, 0x48703838, 0x04f1f5f5,
  0xdf63bcbc, 0xc177b6b6, 0x75afdada, 0x63422121,
  0x30201010, 0x1ae5ffff, 0x0efdf3f3, 0x6dbfd2d2,
  0x4c81cdcd, 0x14180c0c, 0x35261313, 0x2fc3ecec,
  0xe1be5f5f, 0xa2359797, 0xcc884444, 0x392e1717,
  0x5793c4c4, 0xf255a7a7, 0x82fc7e7e, 0x477a3d3d,
  0xacc86464, 0xe7ba5d5d, 0x2b321919, 0x95e67373,
  0xa0c06060, 0x98198181, 0xd19e4f4f, 0x7fa3dcdc,
  0x66442222, 0x7e542a2a, 0xab3b9090, 0x830b8888,
  0xca8c4646, 0x29c7eeee, 0xd36bb8b8, 0x3c281414,
  0x79a7dede, 0xe2bc5e5e, 0x1d160b0b, 0x76addbdb,
  0x3bdbe0e0, 0x56643232, 0x4e743a3a, 0x1e140a0a,
  0xdb924949, 0x0a0c0606, 0x6c482424, 0xe4b85c5c,
  0x5d9fc2c2, 0x6ebdd3d3, 0xef43acac, 0xa6c46262,
  0xa8399191, 0xa4319595, 0x37d3e4e4, 0x8bf27979,
  0x32d5e7e7, 0x438bc8c8, 0x596e3737, 0xb7da6d6d,
  0x8c018d8d, 0x64b1d5d5, 0xd29c4e4e, 0xe049a9a9,
  0xb4d86c6c, 0xfaac5656, 0x07f3f4f4, 0x25cfeaea,
  0xafca6565, 0x8ef47a7a, 0xe947aeae, 0x18100808,
  0xd56fbaba, 0x88f07878, 0x6f4a2525, 0x725c2e2e,
  0x24381c1c, 0xf157a6a6, 0xc773b4b4, 0x5197c6c6,
  0x23cbe8e8, 0x7ca1dddd, 0x9ce87474, 0x213e1f1f,
  0xdd964b4b, 0xdc61bdbd, 0x860d8b8b, 0x850f8a8a,
  0x90e07070, 0x427c3e3e, 0xc471b5b5, 0xaacc6666,
  0xd8904848, 0x05060303, 0x01f7f6f6, 0x121c0e0e,
  0xa3c26161, 0x5f6a3535, 0xf9ae5757, 0xd069b9b9,
  0x91178686, 0x5899c1c1, 0x273a1d1d, 0xb9279e9e,
  0x38d9e1e1, 0x13ebf8f8, 0xb32b9898, 0x33221111,
  0xbbd26969, 0x70a9d9d9, 0x89078e8e, 0xa7339494,
  0xb62d9b9b, 0x223c1e1e, 0x92158787, 0x20c9e9e9,
  0x4987cece, 0xffaa5555, 0x78502828, 0x7aa5dfdf,
  0x8f038c8c, 0xf859a1a1, 0x80098989, 0x171a0d0d,
  0xda65bfbf, 0x31d7e6e6, 0xc6844242, 0xb8d06868,
  0xc3824141, 0xb0299999, 0x775a2d2d, 0x111e0f0f,
  0xcb7bb0b0, 0xfca85454, 0xd66dbbbb, 0x3a2c1616,
};
static const word32 Rijndael_Te2[256] =
{
  0x63a5c663, 0x7c84f87c, 0x7799ee77, 0x7b8df67b,
  0xf20dfff2, 0x6bbdd66b, 0x6fb1de6f, 0xc55491c5,
  0x30506030, 0x01030201, 0x67a9ce67, 0x2b7d562b,
  0xfe19e7fe, 0xd762b5d7, 0xabe64dab, 0x769aec76,
  0xca458fca, 0x829d1f82, 0xc94089c9, 0x7d87fa7d,
  0xfa15effa, 0x59ebb259, 0x47c98e47, 0xf00bfbf0,
  0xadec41ad, 0xd467b3d4, 0xa2fd5fa2, 0xafea45af,
  0x9cbf239c, 0xa4f753a4, 0x7296e472, 0xc05b9bc0,
  0xb7c275b7, 0xfd1ce1fd, 0x93ae3d93, 0x266a4c26,
  0x365a6c36, 0x3f417e3f, 0xf702f5f7, 0xcc4f83cc,
  0x345c6834, 0xa5f451a5, 0xe534d1e5, 0xf108f9f1,
  0x7193e271, 0xd873abd8, 0x31536231, 0x153f2a15,
  0x040c0804, 0xc75295c7, 0x23654623, 0xc35e9dc3,
  0x18283018, 0x96a13796, 0x050f0a05, 0x9ab52f9a,
  0x07090e07, 0x12362412, 0x809b1b80, 0xe23ddfe2,
  0xeb26cdeb, 0x27694e27, 0xb2cd7fb2, 0x759fea75,
  0x091b1209, 0x839e1d83, 0x2c74582c, 0x1a2e341a,
  0x1b2d361b, 0x6eb2dc6e, 0x5aeeb45a, 0xa0fb5ba0,
  0x52f6a452, 0x3b4d763b, 0xd661b7d6, 0xb3ce7db3,
  0x297b5229, 0xe33edde3, 0x2f715e2f, 0x84971384,
  0x53f5a653, 0xd168b9d1, 0x00000000, 0xed2cc1ed,
  0x20604020, 0xfc1fe3fc, 0xb1c879b1, 0x5bedb65b,
  0x6abed46a, 0xcb468dcb, 0xbed967be, 0x394b7239,
  0x4ade944a, 0x4cd4984c, 0x58e8b058, 0xcf4a85cf,
  0xd06bbbd0, 0xef2ac5ef, 0xaae54faa, 0xfb16edfb,
  0x43c58643, 0x4dd79a4d, 0x33556633, 0x85941185,
  0x45cf8a45, 0xf910e9f9, 0x02060402, 0x7f81fe7f,
  0x50f0a050, 0x3c44783c, 0x9fba259f, 0xa8e34ba8,
  0x51f3a251, 0xa3fe5da3, 0x40c08040, 0x8f8a058f,
  0x92ad3f92, 0x9dbc219d, 0x38487038, 0xf504f1f5,
  0xbcdf63bc, 0xb6c177b6, 0xda75afda, 0x21634221,
  0x10302010, 0xff1ae5ff, 0xf30efdf3, 0xd26dbfd2,
  0xcd4c81cd, 0x0c14180c, 0x13352613, 0xec2fc3ec,
  0x5fe1be5f, 0x97a23597, 0x44cc8844, 0x17392e17,
  0xc45793c4, 0xa7f255a7, 0x7e82fc7e, 0x3d477a3d,
  0x64acc864, 0x5de7ba5d, 0x192b3219, 0x7395e673,
  0x60a0c060, 0x81981981, 0x4fd19e4f, 0xdc7fa3dc,
  0x22664422, 0x2a7e542a, 0x90ab3b90, 0x88830b88,
  0x46ca8c46, 0xee29c7ee, 0xb8d36bb8, 0x143c2814,
  0xde79a7de, 0x5ee2bc5e, 0x0b1d160b, 0xdb76addb,
  0xe03bdbe0, 0x32566432, 0x3a4e743a, 0x0a1e140a,
  0x49db9249, 0x060a0c06, 0x246c4824, 0x5ce4b85c,
  0xc25d9fc2, 0xd36ebdd3, 0xacef43ac, 0x62a6c462,
  0x91a83991, 0x95a43195, 0xe437d3e4, 0x798bf279,
  0xe732d5e7, 0xc8438bc8, 0x37596e37, 0x6db7da6d,
  0x8d8c018d, 0xd564b1d5, 0x4ed29c4e, 0xa9e049a9,
  0x6cb4d86c, 0x56faac56, 0xf407f3f4, 0xea25cfea,
  0x65afca65, 0x7a8ef47a, 0xaee947ae, 0x08181008,
  0xbad56fba, 0x7888f078, 0x256f4a25, 0x2e725c2e,
  0x1c24381c, 0xa6f157a6, 0xb4c773b4, 0xc65197c6,
  0xe823cbe8, 0xdd7ca1dd, 0x749ce874, 0x1f213e1f,
  0x4bdd964b, 0xbddc61bd, 0x8b860d8b, 0x8a850f8a,
  0x7090e070, 0x3e427c3e, 0xb5c471b5, 0x66aacc66,
  0x48d89048, 0x03050603, 0xf601f7f6, 0x0e121c0e,
  0x61a3c261, 0x355f6a35, 0x57f9ae57, 0xb9d069b9,
  0x86911786, 0xc15899c1, 0x1d273a1d, 0x9eb9279e,
  0xe138d9e1, 0xf813ebf8, 0x98b32b98, 0x11332211,
  0x69bbd269, 0xd970a9d9, 0x8e89078e, 0x94a73394,
  0x9bb62d9b, 0x1e223c1e, 0x87921587, 0xe920c9e9,
  0xce4987ce, 0x55ffaa55, 0x28785028, 0xdf7aa5df,
  0x8c8f038c, 0xa1f859a1, 0x89800989, 0x0d171a0d,
  0xbfda65bf, 0xe631d7e6, 0x42c68442, 0x68b8d068,
  0x41c38241, 0x99b02999, 0x2d775a2d, 0x0f111e0f,
  0xb0cb7bb0, 0x54fca854, 0xbbd66dbb, 0x163a2c16,
};

static const word32 Rijndael_Te3[256] =
{
  0x6363a5c6, 0x7c7c84f8, 0x777799ee, 0x7b7b8df6,
  0xf2f20dff, 0x6b6bbdd6, 0x6f6fb1de, 0xc5c55491,
  0x30305060, 0x01010302, 0x6767a9ce, 0x2b2b7d56,
  0xfefe19e7, 0xd7d762b5, 0xababe64d, 0x76769aec,
  0xcaca458f, 0x82829d1f, 0xc9c94089, 0x7d7d87fa,
  0xfafa15ef, 0x5959ebb2, 0x4747c98e, 0xf0f00bfb,
  0xadadec41, 0xd4d467b3, 0xa2a2fd5f, 0xafafea45,
  0x9c9cbf23, 0xa4a4f753, 0x727296e4, 0xc0c05b9b,
  0xb7b7c275, 0xfdfd1ce1, 0x9393ae3d, 0x26266a4c,
  0x36365a6c, 0x3f3f417e, 0xf7f702f5, 0xcccc4f83,
  0x34345c68, 0xa5a5f451, 0xe5e534d1, 0xf1f108f9,
  0x717193e2, 0xd8d873ab, 0x31315362, 0x15153f2a,
  0x04040c08, 0xc7c75295, 0x23236546, 0xc3c35e9d,
  0x18182830, 0x9696a137, 0x05050f0a, 0x9a9ab52f,
  0x0707090e, 0x12123624, 0x80809b1b, 0xe2e23ddf,
  0xebeb26cd, 0x2727694e, 0xb2b2cd7f, 0x75759fea,
  0x09091b12, 0x83839e1d, 0x2c2c7458, 0x1a1a2e34,
  0x1b1b2d36, 0x6e6eb2dc, 0x5a5aeeb4, 0xa0a0fb5b,
  0x5252f6a4, 0x3b3b4d76, 0xd6d661b7, 0xb3b3ce7d,
  0x29297b52, 0xe3e33edd, 0x2f2f715e, 0x84849713,
  0x5353f5a6, 0xd1d168b9, 0x00000000, 0xeded2cc1,
  0x20206040, 0xfcfc1fe3, 0xb1b1c879, 0x5b5bedb6,
  0x6a6abed4, 0xcbcb468d, 0xbebed967, 0x39394b72,
  0x4a4ade94, 0x4c4cd498, 0x5858e8b0, 0xcfcf4a85,
  0xd0d06bbb, 0xefef2ac5, 0xaaaae54f, 0xfbfb16ed,
  0x4343c586, 0x4d4dd79a, 0x33335566, 0x85859411,
  0x4545cf8a, 0xf9f910e9, 0x02020604, 0x7f7f81fe,
  0x5050f0a0, 0x3c3c4478, 0x9f9fba25, 0xa8a8e34b,
  0x5151f3a2, 0xa3a3fe5d, 0x4040c080, 0x8f8f8a05,
  0x9292ad3f, 0x9d9dbc21, 0x38384870, 0xf5f504f1,
  0xbcbcdf63, 0xb6b6c177, 0xdada75af, 0x21216342,
  0x10103020, 0xffff1ae5, 0xf3f30efd, 0xd2d26dbf,
  0xcdcd4c81, 0x0c0c1418, 0x13133526, 0xecec2fc3,
  0x5f5fe1be, 0x9797a235, 0x4444cc88, 0x1717392e,
  0xc4c45793, 0xa7a7f255, 0x7e7e82fc, 0x3d3d477a,
  0x6464acc8, 0x5d5de7ba, 0x19192b32, 0x737395e6,
  0x6060a0c0, 0x81819819, 0x4f4fd19e, 0xdcdc7fa3,
  0x22226644, 0x2a2a7e54, 0x9090ab3b, 0x8888830b,
  0x4646ca8c, 0xeeee29c7, 0xb8b8d36b, 0x14143c28,
  0xdede79a7, 0x5e5ee2bc, 0x0b0b1d16, 0xdbdb76ad,
  0xe0e03bdb, 0x32325664, 0x3a3a4e74, 0x0a0a1e14,
  0x4949db92, 0x06060a0c, 0x24246c48, 0x5c5ce4b8,
  0xc2c25d9f, 0xd3d36ebd, 0xacacef43, 0x6262a6c4,
  0x9191a839, 0x9595a431, 0xe4e437d3, 0x79798bf2,
  0xe7e732d5, 0xc8c8438b, 0x3737596e, 0x6d6db7da,
  0x8d8d8c01, 0xd5d564b1, 0x4e4ed29c, 0xa9a9e049,
  0x6c6cb4d8, 0x5656faac, 0xf4f407f3, 0xeaea25cf,
  0x6565afca, 0x7a7a8ef4, 0xaeaee947, 0x08081810,
  0xbabad56f, 0x787888f0, 0x25256f4a, 0x2e2e725c,
  0x1c1c2438, 0xa6a6f157, 0xb4b4c773, 0xc6c65197,
  0xe8e823cb, 0xdddd7ca1, 0x74749ce8, 0x1f1f213e,
  0x4b4bdd96, 0xbdbddc61, 0x8b8b860d, 0x8a8a850f,
  0x707090e0, 0x3e3e427c, 0xb5b5c471, 0x6666aacc,
  0x4848d890, 0x03030506, 0xf6f601f7, 0x0e0e121c,
  0x6161a3c2, 0x35355f6a, 0x5757f9ae, 0xb9b9d069,
  0x86869117, 0xc1c15899, 0x1d1d273a, 0x9e9eb927,
  0xe1e138d9, 0xf8f813eb, 0x9898b32b, 0x11113322,
  0x6969bbd2, 0xd9d970a9, 0x8e8e8907, 0x9494a733,
  0x9b9bb62d, 0x1e1e223c, 0x87879215, 0xe9e920c9,
  0xcece4987, 0x5555ffaa, 0x28287850, 0xdfdf7aa5,
  0x8c8c8f03, 0xa1a1f859, 0x89898009, 0x0d0d171a,
  0xbfbfda65, 0xe6e631d7, 0x4242c684, 0x6868b8d0,
  0x4141c382, 0x9999b029, 0x2d2d775a, 0x0f0f111e,
  0xb0b0cb7b, 0x5454fca8, 0xbbbbd66d, 0x16163a2c,
};

static const word32 Rijndael_Te4[256] =
{
  0x63636363, 0x7c7c7c7c, 0x77777777, 0x7b7b7b7b,
  0xf2f2f2f2, 0x6b6b6b6b, 0x6f6f6f6f, 0xc5c5c5c5,
  0x30303030, 0x01010101, 0x67676767, 0x2b2b2b2b,
  0xfefefefe, 0xd7d7d7d7, 0xabababab, 0x76767676,
  0xcacacaca, 0x82828282, 0xc9c9c9c9, 0x7d7d7d7d,
  0xfafafafa, 0x59595959, 0x47474747, 0xf0f0f0f0,
  0xadadadad, 0xd4d4d4d4, 0xa2a2a2a2, 0xafafafaf,
  0x9c9c9c9c, 0xa4a4a4a4, 0x72727272, 0xc0c0c0c0,
  0xb7b7b7b7, 0xfdfdfdfd, 0x93939393, 0x26262626,
  0x36363636, 0x3f3f3f3f, 0xf7f7f7f7, 0xcccccccc,
  0x34343434, 0xa5a5a5a5, 0xe5e5e5e5, 0xf1f1f1f1,
  0x71717171, 0xd8d8d8d8, 0x31313131, 0x15151515,
  0x04040404, 0xc7c7c7c7, 0x23232323, 0xc3c3c3c3,
  0x18181818, 0x96969696, 0x05050505, 0x9a9a9a9a,
  0x07070707, 0x12121212, 0x80808080, 0xe2e2e2e2,
  0xebebebeb, 0x27272727, 0xb2b2b2b2, 0x75757575,
  0x09090909, 0x83838383, 0x2c2c2c2c, 0x1a1a1a1a,
  0x1b1b1b1b, 0x6e6e6e6e, 0x5a5a5a5a, 0xa0a0a0a0,
  0x52525252, 0x3b3b3b3b, 0xd6d6d6d6, 0xb3b3b3b3,
  0x29292929, 0xe3e3e3e3, 0x2f2f2f2f, 0x84848484,
  0x53535353, 0xd1d1d1d1, 0x00000000, 0xedededed,
  0x20202020, 0xfcfcfcfc, 0xb1b1b1b1, 0x5b5b5b5b,
  0x6a6a6a6a, 0xcbcbcbcb, 0xbebebebe, 0x39393939,
  0x4a4a4a4a, 0x4c4c4c4c, 0x58585858, 0xcfcfcfcf,
  0xd0d0d0d0, 0xefefefef, 0xaaaaaaaa, 0xfbfbfbfb,
  0x43434343, 0x4d4d4d4d, 0x33333333, 0x85858585,
  0x45454545, 0xf9f9f9f9, 0x02020202, 0x7f7f7f7f,
  0x50505050, 0x3c3c3c3c, 0x9f9f9f9f, 0xa8a8a8a8,
  0x51515151, 0xa3a3a3a3, 0x40404040, 0x8f8f8f8f,
  0x92929292, 0x9d9d9d9d, 0x38383838, 0xf5f5f5f5,
  0xbcbcbcbc, 0xb6b6b6b6, 0xdadadada, 0x21212121,
  0x10101010, 0xffffffff, 0xf3f3f3f3, 0xd2d2d2d2,
  0xcdcdcdcd, 0x0c0c0c0c, 0x13131313, 0xecececec,
  0x5f5f5f5f, 0x97979797, 0x44444444, 0x17171717,
  0xc4c4c4c4, 0xa7a7a7a7, 0x7e7e7e7e, 0x3d3d3d3d,
  0x64646464, 0x5d5d5d5d, 0x19191919, 0x73737373,
  0x60606060, 0x81818181, 0x4f4f4f4f, 0xdcdcdcdc,
  0x22222222, 0x2a2a2a2a, 0x90909090, 0x88888888,
  0x46464646, 0xeeeeeeee, 0xb8b8b8b8, 0x14141414,
  0xdededede, 0x5e5e5e5e, 0x0b0b0b0b, 0xdbdbdbdb,
  0xe0e0e0e0, 0x32323232, 0x3a3a3a3a, 0x0a0a0a0a,
  0x49494949, 0x06060606, 0x24242424, 0x5c5c5c5c,
  0xc2c2c2c2, 0xd3d3d3d3, 0xacacacac, 0x62626262,
  0x91919191, 0x95959595, 0xe4e4e4e4, 0x79797979,
  0xe7e7e7e7, 0xc8c8c8c8, 0x37373737, 0x6d6d6d6d,
  0x8d8d8d8d, 0xd5d5d5d5, 0x4e4e4e4e, 0xa9a9a9a9,
  0x6c6c6c6c, 0x56565656, 0xf4f4f4f4, 0xeaeaeaea,
  0x65656565, 0x7a7a7a7a, 0xaeaeaeae, 0x08080808,
  0xbabababa, 0x78787878, 0x25252525, 0x2e2e2e2e,
  0x1c1c1c1c, 0xa6a6a6a6, 0xb4b4b4b4, 0xc6c6c6c6,
  0xe8e8e8e8, 0xdddddddd, 0x74747474, 0x1f1f1f1f,
  0x4b4b4b4b, 0xbdbdbdbd, 0x8b8b8b8b, 0x8a8a8a8a,
  0x70707070, 0x3e3e3e3e, 0xb5b5b5b5, 0x66666666,
  0x48484848, 0x03030303, 0xf6f6f6f6, 0x0e0e0e0e,
  0x61616161, 0x35353535, 0x57575757, 0xb9b9b9b9,
  0x86868686, 0xc1c1c1c1, 0x1d1d1d1d, 0x9e9e9e9e,
  0xe1e1e1e1, 0xf8f8f8f8, 0x98989898, 0x11111111,
  0x69696969, 0xd9d9d9d9, 0x8e8e8e8e, 0x94949494,
  0x9b9b9b9b, 0x1e1e1e1e, 0x87878787, 0xe9e9e9e9,
  0xcececece, 0x55555555, 0x28282828, 0xdfdfdfdf,
  0x8c8c8c8c, 0xa1a1a1a1, 0x89898989, 0x0d0d0d0d,
  0xbfbfbfbf, 0xe6e6e6e6, 0x42424242, 0x68686868,
  0x41414141, 0x99999999, 0x2d2d2d2d, 0x0f0f0f0f,
  0xb0b0b0b0, 0x54545454, 0xbbbbbbbb, 0x16161616,
};

static const word32 Rijndael_Td0[256] =
{
  0x51f4a750, 0x7e416553, 0x1a17a4c3, 0x3a275e96,
  0x3bab6bcb, 0x1f9d45f1, 0xacfa58ab, 0x4be30393,
  0x2030fa55, 0xad766df6, 0x88cc7691, 0xf5024c25,
  0x4fe5d7fc, 0xc52acbd7, 0x26354480, 0xb562a38f,
  0xdeb15a49, 0x25ba1b67, 0x45ea0e98, 0x5dfec0e1,
  0xc32f7502, 0x814cf012, 0x8d4697a3, 0x6bd3f9c6,
  0x038f5fe7, 0x15929c95, 0xbf6d7aeb, 0x955259da,
  0xd4be832d, 0x587421d3, 0x49e06929, 0x8ec9c844,
  0x75c2896a, 0xf48e7978, 0x99583e6b, 0x27b971dd,
  0xbee14fb6, 0xf088ad17, 0xc920ac66, 0x7dce3ab4,
  0x63df4a18, 0xe51a3182, 0x97513360, 0x62537f45,
  0xb16477e0, 0xbb6bae84, 0xfe81a01c, 0xf9082b94,
  0x70486858, 0x8f45fd19, 0x94de6c87, 0x527bf8b7,
  0xab73d323, 0x724b02e2, 0xe31f8f57, 0x6655ab2a,
  0xb2eb2807, 0x2fb5c203, 0x86c57b9a, 0xd33708a5,
  0x302887f2, 0x23bfa5b2, 0x02036aba, 0xed16825c,
  0x8acf1c2b, 0xa779b492, 0xf307f2f0, 0x4e69e2a1,
  0x65daf4cd, 0x0605bed5, 0xd134621f, 0xc4a6fe8a,
  0x342e539d, 0xa2f355a0, 0x058ae132, 0xa4f6eb75,
  0x0b83ec39, 0x4060efaa, 0x5e719f06, 0xbd6e1051,
  0x3e218af9, 0x96dd063d, 0xdd3e05ae, 0x4de6bd46,
  0x91548db5, 0x71c45d05, 0x0406d46f, 0x605015ff,
  0x1998fb24, 0xd6bde997, 0x894043cc, 0x67d99e77,
  0xb0e842bd, 0x07898b88, 0xe7195b38, 0x79c8eedb,
  0xa17c0a47, 0x7c420fe9, 0xf8841ec9, 0x00000000,
  0x09808683, 0x322bed48, 0x1e1170ac, 0x6c5a724e,
  0xfd0efffb, 0x0f853856, 0x3daed51e, 0x362d3927,
  0x0a0fd964, 0x685ca621, 0x9b5b54d1, 0x24362e3a,
  0x0c0a67b1, 0x9357e70f, 0xb4ee96d2, 0x1b9b919e,
  0x80c0c54f, 0x61dc20a2, 0x5a774b69, 0x1c121a16,
  0xe293ba0a, 0xc0a02ae5, 0x3c22e043, 0x121b171d,
  0x0e090d0b, 0xf28bc7ad, 0x2db6a8b9, 0x141ea9c8,
  0x57f11985, 0xaf75074c, 0xee99ddbb, 0xa37f60fd,
  0xf701269f, 0x5c72f5bc, 0x44663bc5, 0x5bfb7e34,
  0x8b432976, 0xcb23c6dc, 0xb6edfc68, 0xb8e4f163,
  0xd731dcca, 0x42638510, 0x13972240, 0x84c61120,
  0x854a247d, 0xd2bb3df8, 0xaef93211, 0xc729a16d,
  0x1d9e2f4b, 0xdcb230f3, 0x0d8652ec, 0x77c1e3d0,
  0x2bb3166c, 0xa970b999, 0x119448fa, 0x47e96422,
  0xa8fc8cc4, 0xa0f03f1a, 0x567d2cd8, 0x223390ef,
  0x87494ec7, 0xd938d1c1, 0x8ccaa2fe, 0x98d40b36,
  0xa6f581cf, 0xa57ade28, 0xdab78e26, 0x3fadbfa4,
  0x2c3a9de4, 0x5078920d, 0x6a5fcc9b, 0x547e4662,
  0xf68d13c2, 0x90d8b8e8, 0x2e39f75e, 0x82c3aff5,
  0x9f5d80be, 0x69d0937c, 0x6fd52da9, 0xcf2512b3,
  0xc8ac993b, 0x10187da7, 0xe89c636e, 0xdb3bbb7b,
  0xcd267809, 0x6e5918f4, 0xec9ab701, 0x834f9aa8,
  0xe6956e65, 0xaaffe67e, 0x21bccf08, 0xef15e8e6,
  0xbae79bd9, 0x4a6f36ce, 0xea9f09d4, 0x29b07cd6,
  0x31a4b2af, 0x2a3f2331, 0xc6a59430, 0x35a266c0,
  0x744ebc37, 0xfc82caa6, 0xe090d0b0, 0x33a7d815,
  0xf104984a, 0x41ecdaf7, 0x7fcd500e, 0x1791f62f,
  0x764dd68d, 0x43efb04d, 0xccaa4d54, 0xe49604df,
  0x9ed1b5e3, 0x4c6a881b, 0xc12c1fb8, 0x4665517f,
  0x9d5eea04, 0x018c355d, 0xfa877473, 0xfb0b412e,
  0xb3671d5a, 0x92dbd252, 0xe9105633, 0x6dd64713,
  0x9ad7618c, 0x37a10c7a, 0x59f8148e, 0xeb133c89,
  0xcea927ee, 0xb761c935, 0xe11ce5ed, 0x7a47b13c,
  0x9cd2df59, 0x55f2733f, 0x1814ce79, 0x73c737bf,
  0x53f7cdea, 0x5ffdaa5b, 0xdf3d6f14, 0x7844db86,
  0xcaaff381, 0xb968c43e, 0x3824342c, 0xc2a3405f,
  0x161dc372, 0xbce2250c, 0x283c498b, 0xff0d9541,
  0x39a80171, 0x080cb3de, 0xd8b4e49c, 0x6456c190,
  0x7bcb8461, 0xd532b670, 0x486c5c74, 0xd0b85742,
};

static const word32 Rijndael_Td1[256] =
{
  0x5051f4a7, 0x537e4165, 0xc31a17a4, 0x963a275e,
  0xcb3bab6b, 0xf11f9d45, 0xabacfa58, 0x934be303,
  0x552030fa, 0xf6ad766d, 0x9188cc76, 0x25f5024c,
  0xfc4fe5d7, 0xd7c52acb, 0x80263544, 0x8fb562a3,
  0x49deb15a, 0x6725ba1b, 0x9845ea0e, 0xe15dfec0,
  0x02c32f75, 0x12814cf0, 0xa38d4697, 0xc66bd3f9,
  0xe7038f5f, 0x9515929c, 0xebbf6d7a, 0xda955259,
  0x2dd4be83, 0xd3587421, 0x2949e069, 0x448ec9c8,
  0x6a75c289, 0x78f48e79, 0x6b99583e, 0xdd27b971,
  0xb6bee14f, 0x17f088ad, 0x66c920ac, 0xb47dce3a,
  0x1863df4a, 0x82e51a31, 0x60975133, 0x4562537f,
  0xe0b16477, 0x84bb6bae, 0x1cfe81a0, 0x94f9082b,
  0x58704868, 0x198f45fd, 0x8794de6c, 0xb7527bf8,
  0x23ab73d3, 0xe2724b02, 0x57e31f8f, 0x2a6655ab,
  0x07b2eb28, 0x032fb5c2, 0x9a86c57b, 0xa5d33708,
  0xf2302887, 0xb223bfa5, 0xba02036a, 0x5ced1682,
  0x2b8acf1c, 0x92a779b4, 0xf0f307f2, 0xa14e69e2,
  0xcd65daf4, 0xd50605be, 0x1fd13462, 0x8ac4a6fe,
  0x9d342e53, 0xa0a2f355, 0x32058ae1, 0x75a4f6eb,
  0x390b83ec, 0xaa4060ef, 0x065e719f, 0x51bd6e10,
  0xf93e218a, 0x3d96dd06, 0xaedd3e05, 0x464de6bd,
  0xb591548d, 0x0571c45d, 0x6f0406d4, 0xff605015,
  0x241998fb, 0x97d6bde9, 0xcc894043, 0x7767d99e,
  0xbdb0e842, 0x8807898b, 0x38e7195b, 0xdb79c8ee,
  0x47a17c0a, 0xe97c420f, 0xc9f8841e, 0x00000000,
  0x83098086, 0x48322bed, 0xac1e1170, 0x4e6c5a72,
  0xfbfd0eff, 0x560f8538, 0x1e3daed5, 0x27362d39,
  0x640a0fd9, 0x21685ca6, 0xd19b5b54, 0x3a24362e,
  0xb10c0a67, 0x0f9357e7, 0xd2b4ee96, 0x9e1b9b91,
  0x4f80c0c5, 0xa261dc20, 0x695a774b, 0x161c121a,
  0x0ae293ba, 0xe5c0a02a, 0x433c22e0, 0x1d121b17,
  0x0b0e090d, 0xadf28bc7, 0xb92db6a8, 0xc8141ea9,
  0x8557f119, 0x4caf7507, 0xbbee99dd, 0xfda37f60,
  0x9ff70126, 0xbc5c72f5, 0xc544663b, 0x345bfb7e,
  0x768b4329, 0xdccb23c6, 0x68b6edfc, 0x63b8e4f1,
  0xcad731dc, 0x10426385, 0x40139722, 0x2084c611,
  0x7d854a24, 0xf8d2bb3d, 0x11aef932, 0x6dc729a1,
  0x4b1d9e2f, 0xf3dcb230, 0xec0d8652, 0xd077c1e3,
  0x6c2bb316, 0x99a970b9, 0xfa119448, 0x2247e964,
  0xc4a8fc8c, 0x1aa0f03f, 0xd8567d2c, 0xef223390,
  0xc787494e, 0xc1d938d1, 0xfe8ccaa2, 0x3698d40b,
  0xcfa6f581, 0x28a57ade, 0x26dab78e, 0xa43fadbf,
  0xe42c3a9d, 0x0d507892, 0x9b6a5fcc, 0x62547e46,
  0xc2f68d13, 0xe890d8b8, 0x5e2e39f7, 0xf582c3af,
  0xbe9f5d80, 0x7c69d093, 0xa96fd52d, 0xb3cf2512,
  0x3bc8ac99, 0xa710187d, 0x6ee89c63, 0x7bdb3bbb,
  0x09cd2678, 0xf46e5918, 0x01ec9ab7, 0xa8834f9a,
  0x65e6956e, 0x7eaaffe6, 0x0821bccf, 0xe6ef15e8,
  0xd9bae79b, 0xce4a6f36, 0xd4ea9f09, 0xd629b07c,
  0xaf31a4b2, 0x312a3f23, 0x30c6a594, 0xc035a266,
  0x37744ebc, 0xa6fc82ca, 0xb0e090d0, 0x1533a7d8,
  0x4af10498, 0xf741ecda, 0x0e7fcd50, 0x2f1791f6,
  0x8d764dd6, 0x4d43efb0, 0x54ccaa4d, 0xdfe49604,
  0xe39ed1b5, 0x1b4c6a88, 0xb8c12c1f, 0x7f466551,
  0x049d5eea, 0x5d018c35, 0x73fa8774, 0x2efb0b41,
  0x5ab3671d, 0x5292dbd2, 0x33e91056, 0x136dd647,
  0x8c9ad761, 0x7a37a10c, 0x8e59f814, 0x89eb133c,
  0xeecea927, 0x35b761c9, 0xede11ce5, 0x3c7a47b1,
  0x599cd2df, 0x3f55f273, 0x791814ce, 0xbf73c737,
  0xea53f7cd, 0x5b5ffdaa, 0x14df3d6f, 0x867844db,
  0x81caaff3, 0x3eb968c4, 0x2c382434, 0x5fc2a340,
  0x72161dc3, 0x0cbce225, 0x8b283c49, 0x41ff0d95,
  0x7139a801, 0xde080cb3, 0x9cd8b4e4, 0x906456c1,
  0x617bcb84, 0x70d532b6, 0x74486c5c, 0x42d0b857,
};

static const word32 Rijndael_Td2[256] =
{
  0xa75051f4, 0x65537e41, 0xa4c31a17, 0x5e963a27,
  0x6bcb3bab, 0x45f11f9d, 0x58abacfa, 0x03934be3,
  0xfa552030, 0x6df6ad76, 0x769188cc, 0x4c25f502,
  0xd7fc4fe5, 0xcbd7c52a, 0x44802635, 0xa38fb562,
  0x5a49deb1, 0x1b6725ba, 0x0e9845ea, 0xc0e15dfe,
  0x7502c32f, 0xf012814c, 0x97a38d46, 0xf9c66bd3,
  0x5fe7038f, 0x9c951592, 0x7aebbf6d, 0x59da9552,
  0x832dd4be, 0x21d35874, 0x692949e0, 0xc8448ec9,
  0x896a75c2, 0x7978f48e, 0x3e6b9958, 0x71dd27b9,
  0x4fb6bee1, 0xad17f088, 0xac66c920, 0x3ab47dce,
  0x4a1863df, 0x3182e51a, 0x33609751, 0x7f456253,
  0x77e0b164, 0xae84bb6b, 0xa01cfe81, 0x2b94f908,
  0x68587048, 0xfd198f45, 0x6c8794de, 0xf8b7527b,
  0xd323ab73, 0x02e2724b, 0x8f57e31f, 0xab2a6655,
  0x2807b2eb, 0xc2032fb5, 0x7b9a86c5, 0x08a5d337,
  0x87f23028, 0xa5b223bf, 0x6aba0203, 0x825ced16,
  0x1c2b8acf, 0xb492a779, 0xf2f0f307, 0xe2a14e69,
  0xf4cd65da, 0xbed50605, 0x621fd134, 0xfe8ac4a6,
  0x539d342e, 0x55a0a2f3, 0xe132058a, 0xeb75a4f6,
  0xec390b83, 0xefaa4060, 0x9f065e71, 0x1051bd6e,

  0x8af93e21, 0x063d96dd, 0x05aedd3e, 0xbd464de6,
  0x8db59154, 0x5d0571c4, 0xd46f0406, 0x15ff6050,
  0xfb241998, 0xe997d6bd, 0x43cc8940, 0x9e7767d9,
  0x42bdb0e8, 0x8b880789, 0x5b38e719, 0xeedb79c8,
  0x0a47a17c, 0x0fe97c42, 0x1ec9f884, 0x00000000,
  0x86830980, 0xed48322b, 0x70ac1e11, 0x724e6c5a,
  0xfffbfd0e, 0x38560f85, 0xd51e3dae, 0x3927362d,
  0xd9640a0f, 0xa621685c, 0x54d19b5b, 0x2e3a2436,
  0x67b10c0a, 0xe70f9357, 0x96d2b4ee, 0x919e1b9b,
  0xc54f80c0, 0x20a261dc, 0x4b695a77, 0x1a161c12,
  0xba0ae293, 0x2ae5c0a0, 0xe0433c22, 0x171d121b,
  0x0d0b0e09, 0xc7adf28b, 0xa8b92db6, 0xa9c8141e,
  0x198557f1, 0x074caf75, 0xddbbee99, 0x60fda37f,
  0x269ff701, 0xf5bc5c72, 0x3bc54466, 0x7e345bfb,
  0x29768b43, 0xc6dccb23, 0xfc68b6ed, 0xf163b8e4,
  0xdccad731, 0x85104263, 0x22401397, 0x112084c6,
  0x247d854a, 0x3df8d2bb, 0x3211aef9, 0xa16dc729,
  0x2f4b1d9e, 0x30f3dcb2, 0x52ec0d86, 0xe3d077c1,
  0x166c2bb3, 0xb999a970, 0x48fa1194, 0x642247e9,
  0x8cc4a8fc, 0x3f1aa0f0, 0x2cd8567d, 0x90ef2233,
  0x4ec78749, 0xd1c1d938, 0xa2fe8cca, 0x0b3698d4,
  0x81cfa6f5, 0xde28a57a, 0x8e26dab7, 0xbfa43fad,
  0x9de42c3a, 0x920d5078, 0xcc9b6a5f, 0x4662547e,
  0x13c2f68d, 0xb8e890d8, 0xf75e2e39, 0xaff582c3,
  0x80be9f5d, 0x937c69d0, 0x2da96fd5, 0x12b3cf25,
  0x993bc8ac, 0x7da71018, 0x636ee89c, 0xbb7bdb3b,
  0x7809cd26, 0x18f46e59, 0xb701ec9a, 0x9aa8834f,
  0x6e65e695, 0xe67eaaff, 0xcf0821bc, 0xe8e6ef15,
  0x9bd9bae7, 0x36ce4a6f, 0x09d4ea9f, 0x7cd629b0,
  0xb2af31a4, 0x23312a3f, 0x9430c6a5, 0x66c035a2,
  0xbc37744e, 0xcaa6fc82, 0xd0b0e090, 0xd81533a7,
  0x984af104, 0xdaf741ec, 0x500e7fcd, 0xf62f1791,
  0xd68d764d, 0xb04d43ef, 0x4d54ccaa, 0x04dfe496,
  0xb5e39ed1, 0x881b4c6a, 0x1fb8c12c, 0x517f4665,
  0xea049d5e, 0x355d018c, 0x7473fa87, 0x412efb0b,
  0x1d5ab367, 0xd25292db, 0x5633e910, 0x47136dd6,
  0x618c9ad7, 0x0c7a37a1, 0x148e59f8, 0x3c89eb13,
  0x27eecea9, 0xc935b761, 0xe5ede11c, 0xb13c7a47,
  0xdf599cd2, 0x733f55f2, 0xce791814, 0x37bf73c7,
  0xcdea53f7, 0xaa5b5ffd, 0x6f14df3d, 0xdb867844,
  0xf381caaf, 0xc43eb968, 0x342c3824, 0x405fc2a3,
  0xc372161d, 0x250cbce2, 0x498b283c, 0x9541ff0d,
  0x017139a8, 0xb3de080c, 0xe49cd8b4, 0xc1906456,
  0x84617bcb, 0xb670d532, 0x5c74486c, 0x5742d0b8,
};

static const word32 Rijndael_Td3[256] =
{
  0xf4a75051, 0x4165537e, 0x17a4c31a, 0x275e963a,
  0xab6bcb3b, 0x9d45f11f, 0xfa58abac, 0xe303934b,
  0x30fa5520, 0x766df6ad, 0xcc769188, 0x024c25f5,
  0xe5d7fc4f, 0x2acbd7c5, 0x35448026, 0x62a38fb5,
  0xb15a49de, 0xba1b6725, 0xea0e9845, 0xfec0e15d,
  0x2f7502c3, 0x4cf01281, 0x4697a38d, 0xd3f9c66b,
  0x8f5fe703, 0x929c9515, 0x6d7aebbf, 0x5259da95,
  0xbe832dd4, 0x7421d358, 0xe0692949, 0xc9c8448e,
  0xc2896a75, 0x8e7978f4, 0x583e6b99, 0xb971dd27,
  0xe14fb6be, 0x88ad17f0, 0x20ac66c9, 0xce3ab47d,
  0xdf4a1863, 0x1a3182e5, 0x51336097, 0x537f4562,
  0x6477e0b1, 0x6bae84bb, 0x81a01cfe, 0x082b94f9,
  0x48685870, 0x45fd198f, 0xde6c8794, 0x7bf8b752,
  0x73d323ab, 0x4b02e272, 0x1f8f57e3, 0x55ab2a66,
  0xeb2807b2, 0xb5c2032f, 0xc57b9a86, 0x3708a5d3,
  0x2887f230, 0xbfa5b223, 0x036aba02, 0x16825ced,
  0xcf1c2b8a, 0x79b492a7, 0x07f2f0f3, 0x69e2a14e,
  0xdaf4cd65, 0x05bed506, 0x34621fd1, 0xa6fe8ac4,
  0x2e539d34, 0xf355a0a2, 0x8ae13205, 0xf6eb75a4,
  0x83ec390b, 0x60efaa40, 0x719f065e, 0x6e1051bd,
  0x218af93e, 0xdd063d96, 0x3e05aedd, 0xe6bd464d,
  0x548db591, 0xc45d0571, 0x06d46f04, 0x5015ff60,
  0x98fb2419, 0xbde997d6, 0x4043cc89, 0xd99e7767,
  0xe842bdb0, 0x898b8807, 0x195b38e7, 0xc8eedb79,
  0x7c0a47a1, 0x420fe97c, 0x841ec9f8, 0x00000000,
  0x80868309, 0x2bed4832, 0x1170ac1e, 0x5a724e6c,
  0x0efffbfd, 0x8538560f, 0xaed51e3d, 0x2d392736,
  0x0fd9640a, 0x5ca62168, 0x5b54d19b, 0x362e3a24,
  0x0a67b10c, 0x57e70f93, 0xee96d2b4, 0x9b919e1b,
  0xc0c54f80, 0xdc20a261, 0x774b695a, 0x121a161c,
  0x93ba0ae2, 0xa02ae5c0, 0x22e0433c, 0x1b171d12,
  0x090d0b0e, 0x8bc7adf2, 0xb6a8b92d, 0x1ea9c814,
  0xf1198557, 0x75074caf, 0x99ddbbee, 0x7f60fda3,
  0x01269ff7, 0x72f5bc5c, 0x663bc544, 0xfb7e345b,
  0x4329768b, 0x23c6dccb, 0xedfc68b6, 0xe4f163b8,
  0x31dccad7, 0x63851042, 0x97224013, 0xc6112084,
  0x4a247d85, 0xbb3df8d2, 0xf93211ae, 0x29a16dc7,
  0x9e2f4b1d, 0xb230f3dc, 0x8652ec0d, 0xc1e3d077,
  0xb3166c2b, 0x70b999a9, 0x9448fa11, 0xe9642247,
  0xfc8cc4a8, 0xf03f1aa0, 0x7d2cd856, 0x3390ef22,
  0x494ec787, 0x38d1c1d9, 0xcaa2fe8c, 0xd40b3698,
  0xf581cfa6, 0x7ade28a5, 0xb78e26da, 0xadbfa43f,
  0x3a9de42c, 0x78920d50, 0x5fcc9b6a, 0x7e466254,
  0x8d13c2f6, 0xd8b8e890, 0x39f75e2e, 0xc3aff582,
  0x5d80be9f, 0xd0937c69, 0xd52da96f, 0x2512b3cf,
  0xac993bc8, 0x187da710, 0x9c636ee8, 0x3bbb7bdb,
  0x267809cd, 0x5918f46e, 0x9ab701ec, 0x4f9aa883,
  0x956e65e6, 0xffe67eaa, 0xbccf0821, 0x15e8e6ef,
  0xe79bd9ba, 0x6f36ce4a, 0x9f09d4ea, 0xb07cd629,
  0xa4b2af31, 0x3f23312a, 0xa59430c6, 0xa266c035,
  0x4ebc3774, 0x82caa6fc, 0x90d0b0e0, 0xa7d81533,
  0x04984af1, 0xecdaf741, 0xcd500e7f, 0x91f62f17,
  0x4dd68d76, 0xefb04d43, 0xaa4d54cc, 0x9604dfe4,
  0xd1b5e39e, 0x6a881b4c, 0x2c1fb8c1, 0x65517f46,
  0x5eea049d, 0x8c355d01, 0x877473fa, 0x0b412efb,
  0x671d5ab3, 0xdbd25292, 0x105633e9, 0xd647136d,
  0xd7618c9a, 0xa10c7a37, 0xf8148e59, 0x133c89eb,
  0xa927eece, 0x61c935b7, 0x1ce5ede1, 0x47b13c7a,
  0xd2df599c, 0xf2733f55, 0x14ce7918, 0xc737bf73,
  0xf7cdea53, 0xfdaa5b5f, 0x3d6f14df, 0x44db8678,
  0xaff381ca, 0x68c43eb9, 0x24342c38, 0xa3405fc2,
  0x1dc37216, 0xe2250cbc, 0x3c498b28, 0x0d9541ff,
  0xa8017139, 0x0cb3de08, 0xb4e49cd8, 0x56c19064,
  0xcb84617b, 0x32b670d5, 0x6c5c7448, 0xb85742d0,
};

static const word32 Rijndael_Td4[256] =
{
  0x52525252, 0x09090909, 0x6a6a6a6a, 0xd5d5d5d5,
  0x30303030, 0x36363636, 0xa5a5a5a5, 0x38383838,
  0xbfbfbfbf, 0x40404040, 0xa3a3a3a3, 0x9e9e9e9e,
  0x81818181, 0xf3f3f3f3, 0xd7d7d7d7, 0xfbfbfbfb,
  0x7c7c7c7c, 0xe3e3e3e3, 0x39393939, 0x82828282,
  0x9b9b9b9b, 0x2f2f2f2f, 0xffffffff, 0x87878787,
  0x34343434, 0x8e8e8e8e, 0x43434343, 0x44444444,
  0xc4c4c4c4, 0xdededede, 0xe9e9e9e9, 0xcbcbcbcb,
  0x54545454, 0x7b7b7b7b, 0x94949494, 0x32323232,
  0xa6a6a6a6, 0xc2c2c2c2, 0x23232323, 0x3d3d3d3d,
  0xeeeeeeee, 0x4c4c4c4c, 0x95959595, 0x0b0b0b0b,
  0x42424242, 0xfafafafa, 0xc3c3c3c3, 0x4e4e4e4e,
  0x08080808, 0x2e2e2e2e, 0xa1a1a1a1, 0x66666666,
  0x28282828, 0xd9d9d9d9, 0x24242424, 0xb2b2b2b2,
  0x76767676, 0x5b5b5b5b, 0xa2a2a2a2, 0x49494949,
  0x6d6d6d6d, 0x8b8b8b8b, 0xd1d1d1d1, 0x25252525,
  0x72727272, 0xf8f8f8f8, 0xf6f6f6f6, 0x64646464,
  0x86868686, 0x68686868, 0x98989898, 0x16161616,
  0xd4d4d4d4, 0xa4a4a4a4, 0x5c5c5c5c, 0xcccccccc,
  0x5d5d5d5d, 0x65656565, 0xb6b6b6b6, 0x92929292,
  0x6c6c6c6c, 0x70707070, 0x48484848, 0x50505050,
  0xfdfdfdfd, 0xedededed, 0xb9b9b9b9, 0xdadadada,
  0x5e5e5e5e, 0x15151515, 0x46464646, 0x57575757,
  0xa7a7a7a7, 0x8d8d8d8d, 0x9d9d9d9d, 0x84848484,
  0x90909090, 0xd8d8d8d8, 0xabababab, 0x00000000,
  0x8c8c8c8c, 0xbcbcbcbc, 0xd3d3d3d3, 0x0a0a0a0a,
  0xf7f7f7f7, 0xe4e4e4e4, 0x58585858, 0x05050505,
  0xb8b8b8b8, 0xb3b3b3b3, 0x45454545, 0x06060606,
  0xd0d0d0d0, 0x2c2c2c2c, 0x1e1e1e1e, 0x8f8f8f8f,
  0xcacacaca, 0x3f3f3f3f, 0x0f0f0f0f, 0x02020202,
  0xc1c1c1c1, 0xafafafaf, 0xbdbdbdbd, 0x03030303,
  0x01010101, 0x13131313, 0x8a8a8a8a, 0x6b6b6b6b,
  0x3a3a3a3a, 0x91919191, 0x11111111, 0x41414141,
  0x4f4f4f4f, 0x67676767, 0xdcdcdcdc, 0xeaeaeaea,
  0x97979797, 0xf2f2f2f2, 0xcfcfcfcf, 0xcececece,
  0xf0f0f0f0, 0xb4b4b4b4, 0xe6e6e6e6, 0x73737373,
  0x96969696, 0xacacacac, 0x74747474, 0x22222222,
  0xe7e7e7e7, 0xadadadad, 0x35353535, 0x85858585,
  0xe2e2e2e2, 0xf9f9f9f9, 0x37373737, 0xe8e8e8e8,
  0x1c1c1c1c, 0x75757575, 0xdfdfdfdf, 0x6e6e6e6e,
  0x47474747, 0xf1f1f1f1, 0x1a1a1a1a, 0x71717171,
  0x1d1d1d1d, 0x29292929, 0xc5c5c5c5, 0x89898989,
  0x6f6f6f6f, 0xb7b7b7b7, 0x62626262, 0x0e0e0e0e,
  0xaaaaaaaa, 0x18181818, 0xbebebebe, 0x1b1b1b1b,
  0xfcfcfcfc, 0x56565656, 0x3e3e3e3e, 0x4b4b4b4b,
  0xc6c6c6c6, 0xd2d2d2d2, 0x79797979, 0x20202020,
  0x9a9a9a9a, 0xdbdbdbdb, 0xc0c0c0c0, 0xfefefefe,
  0x78787878, 0xcdcdcdcd, 0x5a5a5a5a, 0xf4f4f4f4,
  0x1f1f1f1f, 0xdddddddd, 0xa8a8a8a8, 0x33333333,
  0x88888888, 0x07070707, 0xc7c7c7c7, 0x31313131,
  0xb1b1b1b1, 0x12121212, 0x10101010, 0x59595959,
  0x27272727, 0x80808080, 0xecececec, 0x5f5f5f5f,
  0x60606060, 0x51515151, 0x7f7f7f7f, 0xa9a9a9a9,
  0x19191919, 0xb5b5b5b5, 0x4a4a4a4a, 0x0d0d0d0d,
  0x2d2d2d2d, 0xe5e5e5e5, 0x7a7a7a7a, 0x9f9f9f9f,
  0x93939393, 0xc9c9c9c9, 0x9c9c9c9c, 0xefefefef,
  0xa0a0a0a0, 0xe0e0e0e0, 0x3b3b3b3b, 0x4d4d4d4d,
  0xaeaeaeae, 0x2a2a2a2a, 0xf5f5f5f5, 0xb0b0b0b0,
  0xc8c8c8c8, 0xebebebeb, 0xbbbbbbbb, 0x3c3c3c3c,
  0x83838383, 0x53535353, 0x99999999, 0x61616161,
  0x17171717, 0x2b2b2b2b, 0x04040404, 0x7e7e7e7e,
  0xbabababa, 0x77777777, 0xd6d6d6d6, 0x26262626,
  0xe1e1e1e1, 0x69696969, 0x14141414, 0x63636363,
  0x55555555, 0x21212121, 0x0c0c0c0c, 0x7d7d7d7d,
};

//-----------------------
static const unsigned char rc2_PITABLE[256] =
{
        217,120,249,196, 25,221,181,237, 40,233,253,121, 74,160,216,157,
        198,126, 55,131, 43,118, 83,142, 98, 76,100,136, 68,139,251,162,
         23,154, 89,245,135,179, 79, 19, 97, 69,109,141,  9,129,125, 50,
        189,143, 64,235,134,183,123, 11,240,149, 33, 34, 92,107, 78,130,
         84,214,101,147,206, 96,178, 28,115, 86,192, 20,167,140,241,220,
         18,117,202, 31, 59,190,228,209, 66, 61,212, 48,163, 60,182, 38,
        111,191, 14,218, 70,105,  7, 87, 39,242, 29,155,188,148, 67,  3,
        248, 17,199,246,144,239, 62,231,  6,195,213, 47,200,102, 30,215,
          8,232,234,222,128, 82,238,247,132,170,114,172, 53, 77,106, 42,
        150, 26,210,113, 90, 21, 73,116, 75,159,208, 94,  4, 24,164,236,
        194,224, 65,110, 15, 81,203,204, 36,145,175, 80,161,244,112, 57,
        153,124, 58,133, 35,184,180,122,252,  2, 54, 91, 37, 85,151, 49,
         45, 93,250,152,227,138,146,174,  5,223, 41, 16,103,108,186,201,
        211,  0,230,207,225,158,168, 44, 99, 22,  1, 63, 88,226,137,169,
         13, 56, 52, 27,171, 51,255,176,187, 72, 12, 95,185,177,205, 46,
        197,243,219, 71,229,165,156,119, 10,166, 32,104,254,127,193,173
};
//-----------------------

static const byte PKCS_DigestDecoration_MD2[] = { 0x30,0x20,0x30,0x0c,0x06,0x08,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x02,0x05,0x00,0x04,0x10 };
static const byte PKCS_DigestDecoration_MD5[] = { 0x30,0x20,0x30,0x0c,0x06,0x08,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x05,0x05,0x00,0x04,0x10 };
static const byte PKCS_DigestDecoration_RIPEMD160[] = { 0x30,0x21,0x30,0x09,0x06,0x05,0x2b,0x24,0x03,0x02,0x01,0x05,0x00,0x04,0x14 };
static const byte PKCS_DigestDecoration_Tiger[] = { 0x30,0x29,0x30,0x0D,0x06,0x09,0x2B,0x06,0x01,0x04,0x01,0xDA,0x47,0x0C,0x02,0x05,0x00,0x04,0x18 };
static const byte PKCS_DigestDecoration_SHA256[] = { 0x30,0x31,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x01,0x05,0x00,0x04,0x20 };
static const byte PKCS_DigestDecoration_SHA384[] = { 0x30,0x41,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x02,0x05,0x00,0x04,0x30 };
static const byte PKCS_DigestDecoration_SHA512[] = { 0x30,0x51,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x03,0x05,0x00,0x04,0x40 };
//--------------------
static const word32 MD5MAC_T[12] =
        { 0xac45ef97,0xcd430f29,0x551b7e45,0x3411801c,
          0x96ce77b1,0x7c8e722e,0x0aab5a5f,0x18be4336,
          0x21b4219d,0x4db987bc,0xbd279da2,0xc3d75bc7 };
//-----------------
static const byte MD2_S[256] =
{
        41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6,
        19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188,
        76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24,
        138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251,
        245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63,
        148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50,
        39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165,
        181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210,
        150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157,
        112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27,
        96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15,
        85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197,
        234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65,
        129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123,
        8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233,
        203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228,
        166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237,
        31, 26, 219, 153, 141, 51, 159, 17, 131, 20
};

//-----------------
static const word32 MARS_Sbox[512] =
{
  0x09d0c479, 0x28c8ffe0, 0x84aa6c39, 0x9dad7287,
  0x7dff9be3, 0xd4268361, 0xc96da1d4, 0x7974cc93,
  0x85d0582e, 0x2a4b5705, 0x1ca16a62, 0xc3bd279d,
  0x0f1f25e5, 0x5160372f, 0xc695c1fb, 0x4d7ff1e4,
  0xae5f6bf4, 0x0d72ee46, 0xff23de8a, 0xb1cf8e83,
  0xf14902e2, 0x3e981e42, 0x8bf53eb6, 0x7f4bf8ac,
  0x83631f83, 0x25970205, 0x76afe784, 0x3a7931d4,
  0x4f846450, 0x5c64c3f6, 0x210a5f18, 0xc6986a26,
  0x28f4e826, 0x3a60a81c, 0xd340a664, 0x7ea820c4,
  0x526687c5, 0x7eddd12b, 0x32a11d1d, 0x9c9ef086,
  0x80f6e831, 0xab6f04ad, 0x56fb9b53, 0x8b2e095c,
  0xb68556ae, 0xd2250b0d, 0x294a7721, 0xe21fb253,
  0xae136749, 0xe82aae86, 0x93365104, 0x99404a66,
  0x78a784dc, 0xb69ba84b, 0x04046793, 0x23db5c1e,
  0x46cae1d6, 0x2fe28134, 0x5a223942, 0x1863cd5b,
  0xc190c6e3, 0x07dfb846, 0x6eb88816, 0x2d0dcc4a,
  0xa4ccae59, 0x3798670d, 0xcbfa9493, 0x4f481d45,
  0xeafc8ca8, 0xdb1129d6, 0xb0449e20, 0x0f5407fb,
  0x6167d9a8, 0xd1f45763, 0x4daa96c3, 0x3bec5958,
  0xababa014, 0xb6ccd201, 0x38d6279f, 0x02682215,
  0x8f376cd5, 0x092c237e, 0xbfc56593, 0x32889d2c,
  0x854b3e95, 0x05bb9b43, 0x7dcd5dcd, 0xa02e926c,
  0xfae527e5, 0x36a1c330, 0x3412e1ae, 0xf257f462,
  0x3c4f1d71, 0x30a2e809, 0x68e5f551, 0x9c61ba44,
  0x5ded0ab8, 0x75ce09c8, 0x9654f93e, 0x698c0cca,
  0x243cb3e4, 0x2b062b97, 0x0f3b8d9e, 0x00e050df,
  0xfc5d6166, 0xe35f9288, 0xc079550d, 0x0591aee8,
  0x8e531e74, 0x75fe3578, 0x2f6d829a, 0xf60b21ae,
  0x95e8eb8d, 0x6699486b, 0x901d7d9b, 0xfd6d6e31,
  0x1090acef, 0xe0670dd8, 0xdab2e692, 0xcd6d4365,
  0xe5393514, 0x3af345f0, 0x6241fc4d, 0x460da3a3,
  0x7bcf3729, 0x8bf1d1e0, 0x14aac070, 0x1587ed55,
  0x3afd7d3e, 0xd2f29e01, 0x29a9d1f6, 0xefb10c53,
  0xcf3b870f, 0xb414935c, 0x664465ed, 0x024acac7,
  0x59a744c1, 0x1d2936a7, 0xdc580aa6, 0xcf574ca8,
  0x040a7a10, 0x6cd81807, 0x8a98be4c, 0xaccea063,
  0xc33e92b5, 0xd1e0e03d, 0xb322517e, 0x2092bd13,
  0x386b2c4a, 0x52e8dd58, 0x58656dfb, 0x50820371,
  0x41811896, 0xe337ef7e, 0xd39fb119, 0xc97f0df6,
  0x68fea01b, 0xa150a6e5, 0x55258962, 0xeb6ff41b,
  0xd7c9cd7a, 0xa619cd9e, 0xbcf09576, 0x2672c073,
  0xf003fb3c, 0x4ab7a50b, 0x1484126a, 0x487ba9b1,
  0xa64fc9c6, 0xf6957d49, 0x38b06a75, 0xdd805fcd,
  0x63d094cf, 0xf51c999e, 0x1aa4d343, 0xb8495294,
  0xce9f8e99, 0xbffcd770, 0xc7c275cc, 0x378453a7,
  0x7b21be33, 0x397f41bd, 0x4e94d131, 0x92cc1f98,
  0x5915ea51, 0x99f861b7, 0xc9980a88, 0x1d74fd5f,
  0xb0a495f8, 0x614deed0, 0xb5778eea, 0x5941792d,
  0xfa90c1f8, 0x33f824b4, 0xc4965372, 0x3ff6d550,
  0x4ca5fec0, 0x8630e964, 0x5b3fbbd6, 0x7da26a48,
  0xb203231a, 0x04297514, 0x2d639306, 0x2eb13149,
  0x16a45272, 0x532459a0, 0x8e5f4872, 0xf966c7d9,
  0x07128dc0, 0x0d44db62, 0xafc8d52d, 0x06316131,
  0xd838e7ce, 0x1bc41d00, 0x3a2e8c0f, 0xea83837e,
  0xb984737d, 0x13ba4891, 0xc4f8b949, 0xa6d6acb3,
  0xa215cdce, 0x8359838b, 0x6bd1aa31, 0xf579dd52,
  0x21b93f93, 0xf5176781, 0x187dfdde, 0xe94aeb76,
  0x2b38fd54, 0x431de1da, 0xab394825, 0x9ad3048f,
  0xdfea32aa, 0x659473e3, 0x623f7863, 0xf3346c59,
  0xab3ab685, 0x3346a90b, 0x6b56443e, 0xc6de01f8,
  0x8d421fc0, 0x9b0ed10c, 0x88f1a1e9, 0x54c1f029,
  0x7dead57b, 0x8d7ba426, 0x4cf5178a, 0x551a7cca,
  0x1a9a5f08, 0xfcd651b9, 0x25605182, 0xe11fc6c3,
  0xb6fd9676, 0x337b3027, 0xb7c8eb14, 0x9e5fd030,
  0x6b57e354, 0xad913cf7, 0x7e16688d, 0x58872a69,
  0x2c2fc7df, 0xe389ccc6, 0x30738df1, 0x0824a734,
  0xe1797a8b, 0xa4a8d57b, 0x5b5d193b, 0xc8a8309b,
  0x73f9a978, 0x73398d32, 0x0f59573e, 0xe9df2b03,
  0xe8a5b6c8, 0x848d0704, 0x98df93c2, 0x720a1dc3,
  0x684f259a, 0x943ba848, 0xa6370152, 0x863b5ea3,
  0xd17b978b, 0x6d9b58ef, 0x0a700dd4, 0xa73d36bf,
  0x8e6a0829, 0x8695bc14, 0xe35b3447, 0x933ac568,
  0x8894b022, 0x2f511c27, 0xddfbcc3c, 0x006662b6,
  0x117c83fe, 0x4e12b414, 0xc2bca766, 0x3a2fec10,
  0xf4562420, 0x55792e2a, 0x46f5d857, 0xceda25ce,
  0xc3601d3b, 0x6c00ab46, 0xefac9c28, 0xb3c35047,
  0x611dfee3, 0x257c3207, 0xfdd58482, 0x3b14d84f,
  0x23becb64, 0xa075f3a3, 0x088f8ead, 0x07adf158,
  0x7796943c, 0xfacabf3d, 0xc09730cd, 0xf7679969,
  0xda44e9ed, 0x2c854c12, 0x35935fa3, 0x2f057d9f,
  0x690624f8, 0x1cb0bafd, 0x7b0dbdc6, 0x810f23bb,
  0xfa929a1a, 0x6d969a17, 0x6742979b, 0x74ac7d05,
  0x010e65c4, 0x86a3d963, 0xf907b5a0, 0xd0042bd3,
  0x158d7d03, 0x287a8255, 0xbba8366f, 0x096edc33,
  0x21916a7b, 0x77b56b86, 0x951622f9, 0xa6c5e650,
  0x8cea17d1, 0xcd8c62bc, 0xa3d63433, 0x358a68fd,
  0x0f9b9d3c, 0xd6aa295b, 0xfe33384a, 0xc000738e,
  0xcd67eb2f, 0xe2eb6dc2, 0x97338b02, 0x06c9f246,
  0x419cf1ad, 0x2b83c045, 0x3723f18a, 0xcb5b3089,
  0x160bead7, 0x5d494656, 0x35f8a74b, 0x1e4e6c9e,
  0x000399bd, 0x67466880, 0xb4174831, 0xacf423b2,
  0xca815ab3, 0x5a6395e7, 0x302a67c5, 0x8bdb446b,
  0x108f8fa4, 0x10223eda, 0x92b8b48b, 0x7f38d0ee,
  0xab2701d4, 0x0262d415, 0xaf224a30, 0xb3d88aba,
  0xf8b2c3af, 0xdaf7ef70, 0xcc97d3b7, 0xe9614b6c,
  0x2baebff4, 0x70f687cf, 0x386c9156, 0xce092ee5,
  0x01e87da6, 0x6ce91e6a, 0xbb7bcc84, 0xc7922c20,
  0x9d3b71fd, 0x060e41c6, 0xd7590f15, 0x4e03bb47,
  0x183c198e, 0x63eeb240, 0x2ddbf49a, 0x6d5cba54,
  0x923750af, 0xf9e14236, 0x7838162b, 0x59726c72,
  0x81b66760, 0xbb2926c1, 0x48a0ce0d, 0xa6c0496d,
  0xad43507b, 0x718d496a, 0x9df057af, 0x44b1bde6,
  0x054356dc, 0xde7ced35, 0xd51a138b, 0x62088cc9,
  0x35830311, 0xc96efca2, 0x686f86ec, 0x8e77cb68,
  0x63e1d6b8, 0xc80f9778, 0x79c491fd, 0x1b4c67f2,
  0x72698d7d, 0x5e368c31, 0xf7d95e2e, 0xa1d3493f,
  0xdcd9433e, 0x896f1552, 0x4bc4ca7a, 0xa6d1baf4,
  0xa5a96dcc, 0x0bef8b46, 0xa169fda7, 0x74df40b7,
  0x4e208804, 0x9a756607, 0x038e87c8, 0x20211e44,
  0x8b7ad4bf, 0xc6403f35, 0x1848e36d, 0x80bdb038,
  0x1e62891c, 0x643d2107, 0xbf04d6f8, 0x21092c8c,
  0xf644f389, 0x0778404e, 0x7b78adb8, 0xa2c52d53,
  0x42157abe, 0xa2253e2e, 0x7bf3f4ae, 0x80f594f9,
  0x953194e7, 0x77eb92ed, 0xb3816930, 0xda8d9336,
  0xbf447469, 0xf26d9483, 0xee6faed5, 0x71371235,
  0xde425f73, 0xb4e59f43, 0x7dbe2d4e, 0x2d37b185,
  0x49dc9a63, 0x98c39d98, 0x1301c9a2, 0x389b1bbf,
  0x0c18588d, 0xa421c1ba, 0x7aa3865c, 0x71e08558,
  0x3c5cfcaa, 0x7d239ca4, 0x0297d9dd, 0xd7dc2830,
  0x4b37802b, 0x7428ab54, 0xaeee0347, 0x4b3fbb85,
  0x692f2f08, 0x134e578e, 0x36d9e0bf, 0xae8b5fcf,
  0xedb93ecf, 0x2b27248e, 0x170eb1ef, 0x7dc57fd6,
  0x1e760f16, 0xb1136601, 0x864e1b9b, 0xd7ea7319,
  0x3ab871bd, 0xcfa4d76f, 0xe31bd782, 0x0dbeb469,
  0xabb96061, 0x5370f85d, 0xffb07e37, 0xda30d0fb,
  0xebc977b6, 0x0b98b40f, 0x3a4d0fe6, 0xdf4fc26b,
  0x159cf22a, 0xc298d6e2, 0x2b78ef6a, 0x61a94ac0,
  0xab561187, 0x14eea0f0, 0xdf0d4164, 0x19af70ee
};
//--------------

static const unsigned int HAVAL_wi2[32] = {  5,14,26,18,11,28, 7,16, 0,23,20,22, 1,10, 4, 8,30, 3,21, 9,17,24,29, 6,19,12,15,13, 2,25,31,27 };
static const unsigned int HAVAL_wi3[32] = { 19, 9, 4,20,28,17, 8,22,29,14,25,12,24,30,16,26,31,15, 7, 3, 1, 0,18,27,13, 6,21,10,23,11, 5, 2 };
static const unsigned int HAVAL_wi4[32] = { 24, 4, 0,14, 2, 7,28,23,26, 6,30,20,18,25,19, 3,22,11,31,21, 8,27,12, 9, 1,29, 5,15,17,10,16,13 };
static const unsigned int HAVAL_wi5[32] = { 27, 3,21,26,17,11,20,29,19, 0,12, 7,13, 8,31,10, 5, 9,14,30,18, 6,28,24, 2,23,16,22, 4, 1,25,15 };

static const word32 HAVAL_mc2[32] =
{
  0x452821E6, 0x38D01377, 0xBE5466CF, 0x34E90C6C, 0xC0AC29B7, 0xC97C50DD, 0x3F84D5B5, 0xB5470917,
  0x9216D5D9, 0x8979FB1B, 0xD1310BA6, 0x98DFB5AC, 0x2FFD72DB, 0xD01ADFB7, 0xB8E1AFED, 0x6A267E96,
  0xBA7C9045, 0xF12C7F99, 0x24A19947, 0xB3916CF7, 0x0801F2E2, 0x858EFC16, 0x636920D8, 0x71574E69,
  0xA458FEA3, 0xF4933D7E, 0x0D95748F, 0x728EB658, 0x718BCD58, 0x82154AEE, 0x7B54A41D, 0xC25A59B5
};

static const word32 HAVAL_mc3[32] =
{
  0x9C30D539,0x2AF26013,0xC5D1B023,0x286085F0,0xCA417918,0xB8DB38EF,0x8E79DCB0,0x603A180E,
  0x6C9E0E8B,0xB01E8A3E,0xD71577C1,0xBD314B27,0x78AF2FDA,0x55605C60,0xE65525F3,0xAA55AB94,
  0x57489862,0x63E81440,0x55CA396A,0x2AAB10B6,0xB4CC5C34,0x1141E8CE,0xA15486AF,0x7C72E993,
  0xB3EE1411,0x636FBC2A,0x2BA9C55D,0x741831F6,0xCE5C3E16,0x9B87931E,0xAFD6BA33,0x6C24CF5C
};

static const word32 HAVAL_mc4[32] =
{
  0x7A325381,0x28958677,0x3B8F4898,0x6B4BB9AF,0xC4BFE81B,0x66282193,0x61D809CC,0xFB21A991,
  0x487CAC60,0x5DEC8032,0xEF845D5D,0xE98575B1,0xDC262302,0xEB651B88,0x23893E81,0xD396ACC5,
  0x0F6D6FF3,0x83F44239,0x2E0B4482,0xA4842004,0x69C8F04A,0x9E1F9B5E,0x21C66842,0xF6E96C9A,
  0x670C9C61,0xABD388F0,0x6A51A0D2,0xD8542F68,0x960FA728,0xAB5133A3,0x6EEF0B6C,0x137A3BE4
};

static const word32 HAVAL_mc5[32] =
{
  0xBA3BF050,0x7EFB2A98,0xA1F1651D,0x39AF0176,0x66CA593E,0x82430E88,0x8CEE8619,0x456F9FB4,
  0x7D84A5C3,0x3B8B5EBE,0xE06F75D8,0x85C12073,0x401A449F,0x56C16AA6,0x4ED3AA62,0x363F7706,
  0x1BFEDF72,0x429B023D,0x37D0D724,0xD00A1248,0xDB0FEAD3,0x49F1C09B,0x075372C9,0x80991B7B,
  0x25D479D8,0xF6E8DEF7,0xE3FE501A,0xB6794C3B,0x976CE0BD,0x04C006BA,0xC1A94FB6,0x409F60C4
};

//----------------
static const byte GOST_sBox[8*16] =
{
  4, 10, 9, 2, 13, 8, 0, 14, 6, 11, 1, 12, 7, 15, 5, 3,
  14, 11, 4, 12, 6, 13, 15, 10, 2, 3, 8, 1, 0, 7, 5, 9,
  5, 8, 1, 13, 10, 3, 4, 2, 14, 15, 12, 7, 6, 0, 9, 11,
  7, 13, 10, 1, 0, 8, 9, 15, 14, 4, 6, 12, 11, 2, 5, 3,
  6, 12, 7, 1, 5, 15, 13, 8, 4, 10, 9, 14, 0, 3, 11, 2,
  4, 11, 10, 0, 7, 2, 1, 13, 3, 6, 8, 5, 9, 12, 15, 14,
  13, 11, 4, 1, 3, 15, 5, 9, 0, 10, 14, 7, 6, 8, 2, 12,
  1, 15, 13, 0, 5, 7, 10, 4, 9, 2, 3, 14, 6, 11, 8, 12
};

//------------
static const word32 RawDES_Spbox[8*64] =
{

0x01010400,0x00000000,0x00010000,0x01010404, 0x01010004,0x00010404,0x00000004,0x00010000,
0x00000400,0x01010400,0x01010404,0x00000400, 0x01000404,0x01010004,0x01000000,0x00000004,
0x00000404,0x01000400,0x01000400,0x00010400, 0x00010400,0x01010000,0x01010000,0x01000404,
0x00010004,0x01000004,0x01000004,0x00010004, 0x00000000,0x00000404,0x00010404,0x01000000,
0x00010000,0x01010404,0x00000004,0x01010000, 0x01010400,0x01000000,0x01000000,0x00000400,
0x01010004,0x00010000,0x00010400,0x01000004, 0x00000400,0x00000004,0x01000404,0x00010404,
0x01010404,0x00010004,0x01010000,0x01000404, 0x01000004,0x00000404,0x00010404,0x01010400,
0x00000404,0x01000400,0x01000400,0x00000000, 0x00010004,0x00010400,0x00000000,0x01010004,

0x80108020,0x80008000,0x00008000,0x00108020, 0x00100000,0x00000020,0x80100020,0x80008020,
0x80000020,0x80108020,0x80108000,0x80000000, 0x80008000,0x00100000,0x00000020,0x80100020,
0x00108000,0x00100020,0x80008020,0x00000000, 0x80000000,0x00008000,0x00108020,0x80100000,
0x00100020,0x80000020,0x00000000,0x00108000, 0x00008020,0x80108000,0x80100000,0x00008020,
0x00000000,0x00108020,0x80100020,0x00100000, 0x80008020,0x80100000,0x80108000,0x00008000,
0x80100000,0x80008000,0x00000020,0x80108020, 0x00108020,0x00000020,0x00008000,0x80000000,
0x00008020,0x80108000,0x00100000,0x80000020, 0x00100020,0x80008020,0x80000020,0x00100020,
0x00108000,0x00000000,0x80008000,0x00008020, 0x80000000,0x80100020,0x80108020,0x00108000,

0x00000208,0x08020200,0x00000000,0x08020008, 0x08000200,0x00000000,0x00020208,0x08000200,
0x00020008,0x08000008,0x08000008,0x00020000, 0x08020208,0x00020008,0x08020000,0x00000208,
0x08000000,0x00000008,0x08020200,0x00000200, 0x00020200,0x08020000,0x08020008,0x00020208,
0x08000208,0x00020200,0x00020000,0x08000208, 0x00000008,0x08020208,0x00000200,0x08000000,
0x08020200,0x08000000,0x00020008,0x00000208, 0x00020000,0x08020200,0x08000200,0x00000000,
0x00000200,0x00020008,0x08020208,0x08000200, 0x08000008,0x00000200,0x00000000,0x08020008,
0x08000208,0x00020000,0x08000000,0x08020208, 0x00000008,0x00020208,0x00020200,0x08000008,
0x08020000,0x08000208,0x00000208,0x08020000, 0x00020208,0x00000008,0x08020008,0x00020200,

0x00802001,0x00002081,0x00002081,0x00000080, 0x00802080,0x00800081,0x00800001,0x00002001,
0x00000000,0x00802000,0x00802000,0x00802081, 0x00000081,0x00000000,0x00800080,0x00800001,
0x00000001,0x00002000,0x00800000,0x00802001, 0x00000080,0x00800000,0x00002001,0x00002080,
0x00800081,0x00000001,0x00002080,0x00800080, 0x00002000,0x00802080,0x00802081,0x00000081,
0x00800080,0x00800001,0x00802000,0x00802081, 0x00000081,0x00000000,0x00000000,0x00802000,
0x00002080,0x00800080,0x00800081,0x00000001, 0x00802001,0x00002081,0x00002081,0x00000080,
0x00802081,0x00000081,0x00000001,0x00002000, 0x00800001,0x00002001,0x00802080,0x00800081,
0x00002001,0x00002080,0x00800000,0x00802001, 0x00000080,0x00800000,0x00002000,0x00802080,

0x00000100,0x02080100,0x02080000,0x42000100, 0x00080000,0x00000100,0x40000000,0x02080000,
0x40080100,0x00080000,0x02000100,0x40080100, 0x42000100,0x42080000,0x00080100,0x40000000,
0x02000000,0x40080000,0x40080000,0x00000000, 0x40000100,0x42080100,0x42080100,0x02000100,
0x42080000,0x40000100,0x00000000,0x42000000, 0x02080100,0x02000000,0x42000000,0x00080100,
0x00080000,0x42000100,0x00000100,0x02000000, 0x40000000,0x02080000,0x42000100,0x40080100,
0x02000100,0x40000000,0x42080000,0x02080100, 0x40080100,0x00000100,0x02000000,0x42080000,
0x42080100,0x00080100,0x42000000,0x42080100, 0x02080000,0x00000000,0x40080000,0x42000000,
0x00080100,0x02000100,0x40000100,0x00080000, 0x00000000,0x40080000,0x02080100,0x40000100,

0x20000010,0x20400000,0x00004000,0x20404010, 0x20400000,0x00000010,0x20404010,0x00400000,
0x20004000,0x00404010,0x00400000,0x20000010, 0x00400010,0x20004000,0x20000000,0x00004010,
0x00000000,0x00400010,0x20004010,0x00004000, 0x00404000,0x20004010,0x00000010,0x20400010,
0x20400010,0x00000000,0x00404010,0x20404000, 0x00004010,0x00404000,0x20404000,0x20000000,
0x20004000,0x00000010,0x20400010,0x00404000, 0x20404010,0x00400000,0x00004010,0x20000010,
0x00400000,0x20004000,0x20000000,0x00004010, 0x20000010,0x20404010,0x00404000,0x20400000,
0x00404010,0x20404000,0x00000000,0x20400010, 0x00000010,0x00004000,0x20400000,0x00404010,
0x00004000,0x00400010,0x20004010,0x00000000, 0x20404000,0x20000000,0x00400010,0x20004010,

0x00200000,0x04200002,0x04000802,0x00000000, 0x00000800,0x04000802,0x00200802,0x04200800,
0x04200802,0x00200000,0x00000000,0x04000002, 0x00000002,0x04000000,0x04200002,0x00000802,
0x04000800,0x00200802,0x00200002,0x04000800, 0x04000002,0x04200000,0x04200800,0x00200002,
0x04200000,0x00000800,0x00000802,0x04200802, 0x00200800,0x00000002,0x04000000,0x00200800,
0x04000000,0x00200800,0x00200000,0x04000802, 0x04000802,0x04200002,0x04200002,0x00000002,
0x00200002,0x04000000,0x04000800,0x00200000, 0x04200800,0x00000802,0x00200802,0x04200800,
0x00000802,0x04000002,0x04200802,0x04200000, 0x00200800,0x00000000,0x00000002,0x04200802,
0x00000000,0x00200802,0x04200000,0x00000800, 0x04000002,0x04000800,0x00000800,0x00200002,

0x10001040,0x00001000,0x00040000,0x10041040, 0x10000000,0x10001040,0x00000040,0x10000000,
0x00040040,0x10040000,0x10041040,0x00041000, 0x10041000,0x00041040,0x00001000,0x00000040,
0x10040000,0x10000040,0x10001000,0x00001040, 0x00041000,0x00040040,0x10040040,0x10041000,
0x00001040,0x00000000,0x00000000,0x10040040, 0x10000040,0x10001000,0x00041040,0x00040000,
0x00041040,0x00040000,0x10041000,0x00001000, 0x00000040,0x10040040,0x00001000,0x00041040,
0x10001000,0x00000040,0x10000040,0x10040000, 0x10040040,0x10000000,0x00040000,0x10001040,
0x00000000,0x10041040,0x00040040,0x10000040, 0x10040000,0x10001000,0x10001040,0x00000000,
0x10041040,0x00041000,0x00041000,0x00001040, 0x00001040,0x00040040,0x10000000,0x10041000
};
//------------------
static const byte DES_ip[] =
{
           58, 50, 42, 34, 26, 18, 10,  2,
           60, 52, 44, 36, 28, 20, 12,  4,
           62, 54, 46, 38, 30, 22, 14,  6,
           64, 56, 48, 40, 32, 24, 16,  8,
           57, 49, 41, 33, 25, 17,  9,  1,
           59, 51, 43, 35, 27, 19, 11,  3,
           61, 53, 45, 37, 29, 21, 13,  5,
           63, 55, 47, 39, 31, 23, 15,  7
};

/* final permutation IP^-1 */
static const byte DES_fp[] =
{
           40,  8, 48, 16, 56, 24, 64, 32,
           39,  7, 47, 15, 55, 23, 63, 31,
           38,  6, 46, 14, 54, 22, 62, 30,
           37,  5, 45, 13, 53, 21, 61, 29,
           36,  4, 44, 12, 52, 20, 60, 28,
           35,  3, 43, 11, 51, 19, 59, 27,
           34,  2, 42, 10, 50, 18, 58, 26,
           33,  1, 41,  9, 49, 17, 57, 25
};
/* expansion operation matrix */
static const byte DES_ei[] =
{
           32,  1,  2,  3,  4,  5,
            4,  5,  6,  7,  8,  9,
            8,  9, 10, 11, 12, 13,
           12, 13, 14, 15, 16, 17,
           16, 17, 18, 19, 20, 21,
           20, 21, 22, 23, 24, 25,
           24, 25, 26, 27, 28, 29,
           28, 29, 30, 31, 32,  1
};
/* The (in)famous S-boxes */
static const byte DES_sbox[8*64] =
{
  /* S1 */
  14,  4, 13,  1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9,  0,  7,
       0, 15,  7,  4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5,  3,  8,
       4,  1, 14,  8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10,  5,  0,
  15, 12,  8,  2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0,  6, 13,

  /* S2 */
  15,  1,  8, 14,  6, 11,  3,  4,  9,  7,  2, 13, 12,  0,  5, 10,
       3, 13,  4,  7, 15,  2,  8, 14, 12,  0,  1, 10,  6,  9, 11,  5,
       0, 14,  7, 11, 10,  4, 13,  1,  5,  8, 12,  6,  9,  3,  2, 15,
  13,  8, 10,  1,  3, 15,  4,  2, 11,  6,  7, 12,  0,  5, 14,  9,

  /* S3 */
  10,  0,  9, 14,  6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8,
  13,  7,  0,  9,  3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1,
  13,  6,  4,  9,  8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7,
       1, 10, 13,  0,  6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12,

  /* S4 */
       7, 13, 14,  3,  0,  6,  9, 10,  1,  2,  8,  5, 11, 12,  4, 15,
  13,  8, 11,  5,  6, 15,  0,  3,  4,  7,  2, 12,  1, 10, 14,  9,
  10,  6,  9,  0, 12, 11,  7, 13, 15,  1,  3, 14,  5,  2,  8,  4,
       3, 15,  0,  6, 10,  1, 13,  8,  9,  4,  5, 11, 12,  7,  2, 14,

  /* S5 */
       2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13,  0, 14,  9,
  14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3,  9,  8,  6,
       4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6,  3,  0, 14,
  11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10,  4,  5,  3,

  /* S6 */
  12,  1, 10, 15,  9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11,
  10, 15,  4,  2,  7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8,
       9, 14, 15,  5,  2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6,
       4,  3,  2, 12,  9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13,

  /* S7 */
       4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1,
  13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6,
       1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2,
       6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12,

  /* S8 */
  13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7,
       1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2,
       7, 11,  4,  1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8,
       2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11
};

/* 32-bit permutation function P used on the output of the S-boxes */
static const byte DES_p32i[] =
{
  16,  7, 20, 21,
  29, 12, 28, 17,
       1, 15, 23, 26,
       5, 18, 31, 10,
       2,  8, 24, 14,
  32, 27,  3,  9,
  19, 13, 30,  6,
  22, 11,  4, 25
};

/* permuted choice table (key) */
static const byte DES_pc1[] =
{
  57, 49, 41, 33, 25, 17,  9,
       1, 58, 50, 42, 34, 26, 18,
  10,  2, 59, 51, 43, 35, 27,
  19, 11,  3, 60, 52, 44, 36,

  63, 55, 47, 39, 31, 23, 15,
       7, 62, 54, 46, 38, 30, 22,
  14,  6, 61, 53, 45, 37, 29,
  21, 13,  5, 28, 20, 12,  4
};

/* permuted choice key (table) */
static const byte DES_pc2[] =
{
  14, 17, 11, 24,  1,  5,
   3, 28, 15,  6, 21, 10,
  23, 19, 12,  4, 26,  8,
  16,  7, 27, 20, 13,  2,
  41, 52, 31, 37, 47, 55,
  30, 40, 51, 45, 33, 48,
  44, 49, 39, 56, 34, 53,
  46, 42, 50, 36, 29, 32
};
//-----------------
static const word32 CRC32_m_tab[] =
{
#ifdef IS_LITTLE_ENDIAN
        0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419,
        0x706af48f, 0xe963a535, 0x9e6495a3, 0x0edb8832, 0x79dcb8a4,
        0xe0d5e91e, 0x97d2d988, 0x09b64c2b, 0x7eb17cbd, 0xe7b82d07,
        0x90bf1d91, 0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de,
        0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7, 0x136c9856,
        0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9,
        0xfa0f3d63, 0x8d080df5, 0x3b6e20c8, 0x4c69105e, 0xd56041e4,
        0xa2677172, 0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b,
        0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940, 0x32d86ce3,
        0x45df5c75, 0xdcd60dcf, 0xabd13d59, 0x26d930ac, 0x51de003a,
        0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423, 0xcfba9599,
        0xb8bda50f, 0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924,
        0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d, 0x76dc4190,
        0x01db7106, 0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f,
        0x9fbfe4a5, 0xe8b8d433, 0x7807c9a2, 0x0f00f934, 0x9609a88e,
        0xe10e9818, 0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01,
        0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e, 0x6c0695ed,
        0x1b01a57b, 0x8208f4c1, 0xf50fc457, 0x65b0d9c6, 0x12b7e950,
        0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3,
        0xfbd44c65, 0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2,
        0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb, 0x4369e96a,
        0x346ed9fc, 0xad678846, 0xda60b8d0, 0x44042d73, 0x33031de5,
        0xaa0a4c5f, 0xdd0d7cc9, 0x5005713c, 0x270241aa, 0xbe0b1010,
        0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
        0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17,
        0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad, 0xedb88320, 0x9abfb3b6,
        0x03b6e20c, 0x74b1d29a, 0xead54739, 0x9dd277af, 0x04db2615,
        0x73dc1683, 0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8,
        0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1, 0xf00f9344,
        0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb,
        0x196c3671, 0x6e6b06e7, 0xfed41b76, 0x89d32be0, 0x10da7a5a,
        0x67dd4acc, 0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5,
        0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252, 0xd1bb67f1,
        0xa6bc5767, 0x3fb506dd, 0x48b2364b, 0xd80d2bda, 0xaf0a1b4c,
        0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55, 0x316e8eef,
        0x4669be79, 0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236,
        0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f, 0xc5ba3bbe,
        0xb2bd0b28, 0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31,
        0x2cd99e8b, 0x5bdeae1d, 0x9b64c2b0, 0xec63f226, 0x756aa39c,
        0x026d930a, 0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713,
        0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38, 0x92d28e9b,
        0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21, 0x86d3d2d4, 0xf1d4e242,
        0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1,
        0x18b74777, 0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c,
        0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45, 0xa00ae278,
        0xd70dd2ee, 0x4e048354, 0x3903b3c2, 0xa7672661, 0xd06016f7,
        0x4969474d, 0x3e6e77db, 0xaed16a4a, 0xd9d65adc, 0x40df0b66,
        0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
        0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605,
        0xcdd70693, 0x54de5729, 0x23d967bf, 0xb3667a2e, 0xc4614ab8,
        0x5d681b02, 0x2a6f2b94, 0xb40bbe37, 0xc30c8ea1, 0x5a05df1b,
        0x2d02ef8d
#else
        0x00000000, 0x96300777, 0x2c610eee, 0xba510999, 0x19c46d07,
        0x8ff46a70, 0x35a563e9, 0xa395649e, 0x3288db0e, 0xa4b8dc79,
        0x1ee9d5e0, 0x88d9d297, 0x2b4cb609, 0xbd7cb17e, 0x072db8e7,
        0x911dbf90, 0x6410b71d, 0xf220b06a, 0x4871b9f3, 0xde41be84,
        0x7dd4da1a, 0xebe4dd6d, 0x51b5d4f4, 0xc785d383, 0x56986c13,
        0xc0a86b64, 0x7af962fd, 0xecc9658a, 0x4f5c0114, 0xd96c0663,
        0x633d0ffa, 0xf50d088d, 0xc8206e3b, 0x5e10694c, 0xe44160d5,
        0x727167a2, 0xd1e4033c, 0x47d4044b, 0xfd850dd2, 0x6bb50aa5,
        0xfaa8b535, 0x6c98b242, 0xd6c9bbdb, 0x40f9bcac, 0xe36cd832,
        0x755cdf45, 0xcf0dd6dc, 0x593dd1ab, 0xac30d926, 0x3a00de51,
        0x8051d7c8, 0x1661d0bf, 0xb5f4b421, 0x23c4b356, 0x9995bacf,
        0x0fa5bdb8, 0x9eb80228, 0x0888055f, 0xb2d90cc6, 0x24e90bb1,
        0x877c6f2f, 0x114c6858, 0xab1d61c1, 0x3d2d66b6, 0x9041dc76,
        0x0671db01, 0xbc20d298, 0x2a10d5ef, 0x8985b171, 0x1fb5b606,
        0xa5e4bf9f, 0x33d4b8e8, 0xa2c90778, 0x34f9000f, 0x8ea80996,
        0x18980ee1, 0xbb0d6a7f, 0x2d3d6d08, 0x976c6491, 0x015c63e6,
        0xf4516b6b, 0x62616c1c, 0xd8306585, 0x4e0062f2, 0xed95066c,
        0x7ba5011b, 0xc1f40882, 0x57c40ff5, 0xc6d9b065, 0x50e9b712,
        0xeab8be8b, 0x7c88b9fc, 0xdf1ddd62, 0x492dda15, 0xf37cd38c,
        0x654cd4fb, 0x5861b24d, 0xce51b53a, 0x7400bca3, 0xe230bbd4,
        0x41a5df4a, 0xd795d83d, 0x6dc4d1a4, 0xfbf4d6d3, 0x6ae96943,
        0xfcd96e34, 0x468867ad, 0xd0b860da, 0x732d0444, 0xe51d0333,
        0x5f4c0aaa, 0xc97c0ddd, 0x3c710550, 0xaa410227, 0x10100bbe,
        0x86200cc9, 0x25b56857, 0xb3856f20, 0x09d466b9, 0x9fe461ce,
        0x0ef9de5e, 0x98c9d929, 0x2298d0b0, 0xb4a8d7c7, 0x173db359,
        0x810db42e, 0x3b5cbdb7, 0xad6cbac0, 0x2083b8ed, 0xb6b3bf9a,
        0x0ce2b603, 0x9ad2b174, 0x3947d5ea, 0xaf77d29d, 0x1526db04,
        0x8316dc73, 0x120b63e3, 0x843b6494, 0x3e6a6d0d, 0xa85a6a7a,
        0x0bcf0ee4, 0x9dff0993, 0x27ae000a, 0xb19e077d, 0x44930ff0,
        0xd2a30887, 0x68f2011e, 0xfec20669, 0x5d5762f7, 0xcb676580,
        0x71366c19, 0xe7066b6e, 0x761bd4fe, 0xe02bd389, 0x5a7ada10,
        0xcc4add67, 0x6fdfb9f9, 0xf9efbe8e, 0x43beb717, 0xd58eb060,
        0xe8a3d6d6, 0x7e93d1a1, 0xc4c2d838, 0x52f2df4f, 0xf167bbd1,
        0x6757bca6, 0xdd06b53f, 0x4b36b248, 0xda2b0dd8, 0x4c1b0aaf,
        0xf64a0336, 0x607a0441, 0xc3ef60df, 0x55df67a8, 0xef8e6e31,
        0x79be6946, 0x8cb361cb, 0x1a8366bc, 0xa0d26f25, 0x36e26852,
        0x95770ccc, 0x03470bbb, 0xb9160222, 0x2f260555, 0xbe3bbac5,
        0x280bbdb2, 0x925ab42b, 0x046ab35c, 0xa7ffd7c2, 0x31cfd0b5,
        0x8b9ed92c, 0x1daede5b, 0xb0c2649b, 0x26f263ec, 0x9ca36a75,
        0x0a936d02, 0xa906099c, 0x3f360eeb, 0x85670772, 0x13570005,
        0x824abf95, 0x147ab8e2, 0xae2bb17b, 0x381bb60c, 0x9b8ed292,
        0x0dbed5e5, 0xb7efdc7c, 0x21dfdb0b, 0xd4d2d386, 0x42e2d4f1,
        0xf8b3dd68, 0x6e83da1f, 0xcd16be81, 0x5b26b9f6, 0xe177b06f,
        0x7747b718, 0xe65a0888, 0x706a0fff, 0xca3b0666, 0x5c0b0111,
        0xff9e658f, 0x69ae62f8, 0xd3ff6b61, 0x45cf6c16, 0x78e20aa0,
        0xeed20dd7, 0x5483044e, 0xc2b30339, 0x612667a7, 0xf71660d0,
        0x4d476949, 0xdb776e3e, 0x4a6ad1ae, 0xdc5ad6d9, 0x660bdf40,
        0xf03bd837, 0x53aebca9, 0xc59ebbde, 0x7fcfb247, 0xe9ffb530,
        0x1cf2bdbd, 0x8ac2baca, 0x3093b353, 0xa6a3b424, 0x0536d0ba,
        0x9306d7cd, 0x2957de54, 0xbf67d923, 0x2e7a66b3, 0xb84a61c4,
        0x021b685d, 0x942b6f2a, 0x37be0bb4, 0xa18e0cc3, 0x1bdf055a,
        0x8def022d
#endif
};

//-----------------

static const word32 CAST_S[8*256] =
{
  0x30FB40D4, 0x9FA0FF0B, 0x6BECCD2F, 0x3F258C7A,
  0x1E213F2F, 0x9C004DD3, 0x6003E540, 0xCF9FC949,
  0xBFD4AF27, 0x88BBBDB5, 0xE2034090, 0x98D09675,
  0x6E63A0E0, 0x15C361D2, 0xC2E7661D, 0x22D4FF8E,
  0x28683B6F, 0xC07FD059, 0xFF2379C8, 0x775F50E2,
  0x43C340D3, 0xDF2F8656, 0x887CA41A, 0xA2D2BD2D,
  0xA1C9E0D6, 0x346C4819, 0x61B76D87, 0x22540F2F,
  0x2ABE32E1, 0xAA54166B, 0x22568E3A, 0xA2D341D0,
  0x66DB40C8, 0xA784392F, 0x004DFF2F, 0x2DB9D2DE,
  0x97943FAC, 0x4A97C1D8, 0x527644B7, 0xB5F437A7,
  0xB82CBAEF, 0xD751D159, 0x6FF7F0ED, 0x5A097A1F,
  0x827B68D0, 0x90ECF52E, 0x22B0C054, 0xBC8E5935,
  0x4B6D2F7F, 0x50BB64A2, 0xD2664910, 0xBEE5812D,
  0xB7332290, 0xE93B159F, 0xB48EE411, 0x4BFF345D,
  0xFD45C240, 0xAD31973F, 0xC4F6D02E, 0x55FC8165,
  0xD5B1CAAD, 0xA1AC2DAE, 0xA2D4B76D, 0xC19B0C50,
  0x882240F2, 0x0C6E4F38, 0xA4E4BFD7, 0x4F5BA272,
  0x564C1D2F, 0xC59C5319, 0xB949E354, 0xB04669FE,
  0xB1B6AB8A, 0xC71358DD, 0x6385C545, 0x110F935D,
  0x57538AD5, 0x6A390493, 0xE63D37E0, 0x2A54F6B3,
  0x3A787D5F, 0x6276A0B5, 0x19A6FCDF, 0x7A42206A,
  0x29F9D4D5, 0xF61B1891, 0xBB72275E, 0xAA508167,
  0x38901091, 0xC6B505EB, 0x84C7CB8C, 0x2AD75A0F,
  0x874A1427, 0xA2D1936B, 0x2AD286AF, 0xAA56D291,
  0xD7894360, 0x425C750D, 0x93B39E26, 0x187184C9,
  0x6C00B32D, 0x73E2BB14, 0xA0BEBC3C, 0x54623779,
  0x64459EAB, 0x3F328B82, 0x7718CF82, 0x59A2CEA6,
  0x04EE002E, 0x89FE78E6, 0x3FAB0950, 0x325FF6C2,
  0x81383F05, 0x6963C5C8, 0x76CB5AD6, 0xD49974C9,
  0xCA180DCF, 0x380782D5, 0xC7FA5CF6, 0x8AC31511,
  0x35E79E13, 0x47DA91D0, 0xF40F9086, 0xA7E2419E,
  0x31366241, 0x051EF495, 0xAA573B04, 0x4A805D8D,
  0x548300D0, 0x00322A3C, 0xBF64CDDF, 0xBA57A68E,
  0x75C6372B, 0x50AFD341, 0xA7C13275, 0x915A0BF5,
  0x6B54BFAB, 0x2B0B1426, 0xAB4CC9D7, 0x449CCD82,
  0xF7FBF265, 0xAB85C5F3, 0x1B55DB94, 0xAAD4E324,
  0xCFA4BD3F, 0x2DEAA3E2, 0x9E204D02, 0xC8BD25AC,
  0xEADF55B3, 0xD5BD9E98, 0xE31231B2, 0x2AD5AD6C,
  0x954329DE, 0xADBE4528, 0xD8710F69, 0xAA51C90F,
  0xAA786BF6, 0x22513F1E, 0xAA51A79B, 0x2AD344CC,
  0x7B5A41F0, 0xD37CFBAD, 0x1B069505, 0x41ECE491,
  0xB4C332E6, 0x032268D4, 0xC9600ACC, 0xCE387E6D,
  0xBF6BB16C, 0x6A70FB78, 0x0D03D9C9, 0xD4DF39DE,
  0xE01063DA, 0x4736F464, 0x5AD328D8, 0xB347CC96,
  0x75BB0FC3, 0x98511BFB, 0x4FFBCC35, 0xB58BCF6A,
  0xE11F0ABC, 0xBFC5FE4A, 0xA70AEC10, 0xAC39570A,
  0x3F04442F, 0x6188B153, 0xE0397A2E, 0x5727CB79,
  0x9CEB418F, 0x1CACD68D, 0x2AD37C96, 0x0175CB9D,
  0xC69DFF09, 0xC75B65F0, 0xD9DB40D8, 0xEC0E7779,
  0x4744EAD4, 0xB11C3274, 0xDD24CB9E, 0x7E1C54BD,
  0xF01144F9, 0xD2240EB1, 0x9675B3FD, 0xA3AC3755,
  0xD47C27AF, 0x51C85F4D, 0x56907596, 0xA5BB15E6,
  0x580304F0, 0xCA042CF1, 0x011A37EA, 0x8DBFAADB,
  0x35BA3E4A, 0x3526FFA0, 0xC37B4D09, 0xBC306ED9,
  0x98A52666, 0x5648F725, 0xFF5E569D, 0x0CED63D0,
  0x7C63B2CF, 0x700B45E1, 0xD5EA50F1, 0x85A92872,
  0xAF1FBDA7, 0xD4234870, 0xA7870BF3, 0x2D3B4D79,
  0x42E04198, 0x0CD0EDE7, 0x26470DB8, 0xF881814C,
  0x474D6AD7, 0x7C0C5E5C, 0xD1231959, 0x381B7298,
  0xF5D2F4DB, 0xAB838653, 0x6E2F1E23, 0x83719C9E,
  0xBD91E046, 0x9A56456E, 0xDC39200C, 0x20C8C571,
  0x962BDA1C, 0xE1E696FF, 0xB141AB08, 0x7CCA89B9,
  0x1A69E783, 0x02CC4843, 0xA2F7C579, 0x429EF47D,
  0x427B169C, 0x5AC9F049, 0xDD8F0F00, 0x5C8165BF
,


  0x1F201094, 0xEF0BA75B, 0x69E3CF7E, 0x393F4380,
  0xFE61CF7A, 0xEEC5207A, 0x55889C94, 0x72FC0651,
  0xADA7EF79, 0x4E1D7235, 0xD55A63CE, 0xDE0436BA,
  0x99C430EF, 0x5F0C0794, 0x18DCDB7D, 0xA1D6EFF3,
  0xA0B52F7B, 0x59E83605, 0xEE15B094, 0xE9FFD909,
  0xDC440086, 0xEF944459, 0xBA83CCB3, 0xE0C3CDFB,
  0xD1DA4181, 0x3B092AB1, 0xF997F1C1, 0xA5E6CF7B,
  0x01420DDB, 0xE4E7EF5B, 0x25A1FF41, 0xE180F806,
  0x1FC41080, 0x179BEE7A, 0xD37AC6A9, 0xFE5830A4,
  0x98DE8B7F, 0x77E83F4E, 0x79929269, 0x24FA9F7B,
  0xE113C85B, 0xACC40083, 0xD7503525, 0xF7EA615F,
  0x62143154, 0x0D554B63, 0x5D681121, 0xC866C359,
  0x3D63CF73, 0xCEE234C0, 0xD4D87E87, 0x5C672B21,
  0x071F6181, 0x39F7627F, 0x361E3084, 0xE4EB573B,
  0x602F64A4, 0xD63ACD9C, 0x1BBC4635, 0x9E81032D,
  0x2701F50C, 0x99847AB4, 0xA0E3DF79, 0xBA6CF38C,
  0x10843094, 0x2537A95E, 0xF46F6FFE, 0xA1FF3B1F,
  0x208CFB6A, 0x8F458C74, 0xD9E0A227, 0x4EC73A34,
  0xFC884F69, 0x3E4DE8DF, 0xEF0E0088, 0x3559648D,
  0x8A45388C, 0x1D804366, 0x721D9BFD, 0xA58684BB,
  0xE8256333, 0x844E8212, 0x128D8098, 0xFED33FB4,
  0xCE280AE1, 0x27E19BA5, 0xD5A6C252, 0xE49754BD,
  0xC5D655DD, 0xEB667064, 0x77840B4D, 0xA1B6A801,
  0x84DB26A9, 0xE0B56714, 0x21F043B7, 0xE5D05860,
  0x54F03084, 0x066FF472, 0xA31AA153, 0xDADC4755,
  0xB5625DBF, 0x68561BE6, 0x83CA6B94, 0x2D6ED23B,
  0xECCF01DB, 0xA6D3D0BA, 0xB6803D5C, 0xAF77A709,
  0x33B4A34C, 0x397BC8D6, 0x5EE22B95, 0x5F0E5304,
  0x81ED6F61, 0x20E74364, 0xB45E1378, 0xDE18639B,
  0x881CA122, 0xB96726D1, 0x8049A7E8, 0x22B7DA7B,
  0x5E552D25, 0x5272D237, 0x79D2951C, 0xC60D894C,
  0x488CB402, 0x1BA4FE5B, 0xA4B09F6B, 0x1CA815CF,
  0xA20C3005, 0x8871DF63, 0xB9DE2FCB, 0x0CC6C9E9,
  0x0BEEFF53, 0xE3214517, 0xB4542835, 0x9F63293C,
  0xEE41E729, 0x6E1D2D7C, 0x50045286, 0x1E6685F3,
  0xF33401C6, 0x30A22C95, 0x31A70850, 0x60930F13,
  0x73F98417, 0xA1269859, 0xEC645C44, 0x52C877A9,
  0xCDFF33A6, 0xA02B1741, 0x7CBAD9A2, 0x2180036F,
  0x50D99C08, 0xCB3F4861, 0xC26BD765, 0x64A3F6AB,
  0x80342676, 0x25A75E7B, 0xE4E6D1FC, 0x20C710E6,
  0xCDF0B680, 0x17844D3B, 0x31EEF84D, 0x7E0824E4,
  0x2CCB49EB, 0x846A3BAE, 0x8FF77888, 0xEE5D60F6,
  0x7AF75673, 0x2FDD5CDB, 0xA11631C1, 0x30F66F43,
  0xB3FAEC54, 0x157FD7FA, 0xEF8579CC, 0xD152DE58,
  0xDB2FFD5E, 0x8F32CE19, 0x306AF97A, 0x02F03EF8,
  0x99319AD5, 0xC242FA0F, 0xA7E3EBB0, 0xC68E4906,
  0xB8DA230C, 0x80823028, 0xDCDEF3C8, 0xD35FB171,
  0x088A1BC8, 0xBEC0C560, 0x61A3C9E8, 0xBCA8F54D,
  0xC72FEFFA, 0x22822E99, 0x82C570B4, 0xD8D94E89,
  0x8B1C34BC, 0x301E16E6, 0x273BE979, 0xB0FFEAA6,
  0x61D9B8C6, 0x00B24869, 0xB7FFCE3F, 0x08DC283B,
  0x43DAF65A, 0xF7E19798, 0x7619B72F, 0x8F1C9BA4,
  0xDC8637A0, 0x16A7D3B1, 0x9FC393B7, 0xA7136EEB,
  0xC6BCC63E, 0x1A513742, 0xEF6828BC, 0x520365D6,
  0x2D6A77AB, 0x3527ED4B, 0x821FD216, 0x095C6E2E,
  0xDB92F2FB, 0x5EEA29CB, 0x145892F5, 0x91584F7F,
  0x5483697B, 0x2667A8CC, 0x85196048, 0x8C4BACEA,
  0x833860D4, 0x0D23E0F9, 0x6C387E8A, 0x0AE6D249,
  0xB284600C, 0xD835731D, 0xDCB1C647, 0xAC4C56EA,
  0x3EBD81B3, 0x230EABB0, 0x6438BC87, 0xF0B5B1FA,
  0x8F5EA2B3, 0xFC184642, 0x0A036B7A, 0x4FB089BD,
  0x649DA589, 0xA345415E, 0x5C038323, 0x3E5D3BB9,
  0x43D79572, 0x7E6DD07C, 0x06DFDF1E, 0x6C6CC4EF,
  0x7160A539, 0x73BFBE70, 0x83877605, 0x4523ECF1
,


  0x8DEFC240, 0x25FA5D9F, 0xEB903DBF, 0xE810C907,
  0x47607FFF, 0x369FE44B, 0x8C1FC644, 0xAECECA90,
  0xBEB1F9BF, 0xEEFBCAEA, 0xE8CF1950, 0x51DF07AE,
  0x920E8806, 0xF0AD0548, 0xE13C8D83, 0x927010D5,
  0x11107D9F, 0x07647DB9, 0xB2E3E4D4, 0x3D4F285E,
  0xB9AFA820, 0xFADE82E0, 0xA067268B, 0x8272792E,
  0x553FB2C0, 0x489AE22B, 0xD4EF9794, 0x125E3FBC,
  0x21FFFCEE, 0x825B1BFD, 0x9255C5ED, 0x1257A240,
  0x4E1A8302, 0xBAE07FFF, 0x528246E7, 0x8E57140E,
  0x3373F7BF, 0x8C9F8188, 0xA6FC4EE8, 0xC982B5A5,
  0xA8C01DB7, 0x579FC264, 0x67094F31, 0xF2BD3F5F,
  0x40FFF7C1, 0x1FB78DFC, 0x8E6BD2C1, 0x437BE59B,
  0x99B03DBF, 0xB5DBC64B, 0x638DC0E6, 0x55819D99,
  0xA197C81C, 0x4A012D6E, 0xC5884A28, 0xCCC36F71,
  0xB843C213, 0x6C0743F1, 0x8309893C, 0x0FEDDD5F,
  0x2F7FE850, 0xD7C07F7E, 0x02507FBF, 0x5AFB9A04,
  0xA747D2D0, 0x1651192E, 0xAF70BF3E, 0x58C31380,
  0x5F98302E, 0x727CC3C4, 0x0A0FB402, 0x0F7FEF82,
  0x8C96FDAD, 0x5D2C2AAE, 0x8EE99A49, 0x50DA88B8,
  0x8427F4A0, 0x1EAC5790, 0x796FB449, 0x8252DC15,
  0xEFBD7D9B, 0xA672597D, 0xADA840D8, 0x45F54504,
  0xFA5D7403, 0xE83EC305, 0x4F91751A, 0x925669C2,
  0x23EFE941, 0xA903F12E, 0x60270DF2, 0x0276E4B6,
  0x94FD6574, 0x927985B2, 0x8276DBCB, 0x02778176,
  0xF8AF918D, 0x4E48F79E, 0x8F616DDF, 0xE29D840E,
  0x842F7D83, 0x340CE5C8, 0x96BBB682, 0x93B4B148,
  0xEF303CAB, 0x984FAF28, 0x779FAF9B, 0x92DC560D,
  0x224D1E20, 0x8437AA88, 0x7D29DC96, 0x2756D3DC,
  0x8B907CEE, 0xB51FD240, 0xE7C07CE3, 0xE566B4A1,
  0xC3E9615E, 0x3CF8209D, 0x6094D1E3, 0xCD9CA341,
  0x5C76460E, 0x00EA983B, 0xD4D67881, 0xFD47572C,
  0xF76CEDD9, 0xBDA8229C, 0x127DADAA, 0x438A074E,
  0x1F97C090, 0x081BDB8A, 0x93A07EBE, 0xB938CA15,
  0x97B03CFF, 0x3DC2C0F8, 0x8D1AB2EC, 0x64380E51,
  0x68CC7BFB, 0xD90F2788, 0x12490181, 0x5DE5FFD4,
  0xDD7EF86A, 0x76A2E214, 0xB9A40368, 0x925D958F,
  0x4B39FFFA, 0xBA39AEE9, 0xA4FFD30B, 0xFAF7933B,
  0x6D498623, 0x193CBCFA, 0x27627545, 0x825CF47A,
  0x61BD8BA0, 0xD11E42D1, 0xCEAD04F4, 0x127EA392,
  0x10428DB7, 0x8272A972, 0x9270C4A8, 0x127DE50B,
  0x285BA1C8, 0x3C62F44F, 0x35C0EAA5, 0xE805D231,
  0x428929FB, 0xB4FCDF82, 0x4FB66A53, 0x0E7DC15B,
  0x1F081FAB, 0x108618AE, 0xFCFD086D, 0xF9FF2889,
  0x694BCC11, 0x236A5CAE, 0x12DECA4D, 0x2C3F8CC5,
  0xD2D02DFE, 0xF8EF5896, 0xE4CF52DA, 0x95155B67,
  0x494A488C, 0xB9B6A80C, 0x5C8F82BC, 0x89D36B45,
  0x3A609437, 0xEC00C9A9, 0x44715253, 0x0A874B49,
  0xD773BC40, 0x7C34671C, 0x02717EF6, 0x4FEB5536,
  0xA2D02FFF, 0xD2BF60C4, 0xD43F03C0, 0x50B4EF6D,
  0x07478CD1, 0x006E1888, 0xA2E53F55, 0xB9E6D4BC,
  0xA2048016, 0x97573833, 0xD7207D67, 0xDE0F8F3D,
  0x72F87B33, 0xABCC4F33, 0x7688C55D, 0x7B00A6B0,
  0x947B0001, 0x570075D2, 0xF9BB88F8, 0x8942019E,
  0x4264A5FF, 0x856302E0, 0x72DBD92B, 0xEE971B69,
  0x6EA22FDE, 0x5F08AE2B, 0xAF7A616D, 0xE5C98767,
  0xCF1FEBD2, 0x61EFC8C2, 0xF1AC2571, 0xCC8239C2,
  0x67214CB8, 0xB1E583D1, 0xB7DC3E62, 0x7F10BDCE,
  0xF90A5C38, 0x0FF0443D, 0x606E6DC6, 0x60543A49,
  0x5727C148, 0x2BE98A1D, 0x8AB41738, 0x20E1BE24,
  0xAF96DA0F, 0x68458425, 0x99833BE5, 0x600D457D,
  0x282F9350, 0x8334B362, 0xD91D1120, 0x2B6D8DA0,
  0x642B1E31, 0x9C305A00, 0x52BCE688, 0x1B03588A,
  0xF7BAEFD5, 0x4142ED9C, 0xA4315C11, 0x83323EC5,
  0xDFEF4636, 0xA133C501, 0xE9D3531C, 0xEE353783
,


  0x9DB30420, 0x1FB6E9DE, 0xA7BE7BEF, 0xD273A298,
  0x4A4F7BDB, 0x64AD8C57, 0x85510443, 0xFA020ED1,
  0x7E287AFF, 0xE60FB663, 0x095F35A1, 0x79EBF120,
  0xFD059D43, 0x6497B7B1, 0xF3641F63, 0x241E4ADF,
  0x28147F5F, 0x4FA2B8CD, 0xC9430040, 0x0CC32220,
  0xFDD30B30, 0xC0A5374F, 0x1D2D00D9, 0x24147B15,
  0xEE4D111A, 0x0FCA5167, 0x71FF904C, 0x2D195FFE,
  0x1A05645F, 0x0C13FEFE, 0x081B08CA, 0x05170121,
  0x80530100, 0xE83E5EFE, 0xAC9AF4F8, 0x7FE72701,
  0xD2B8EE5F, 0x06DF4261, 0xBB9E9B8A, 0x7293EA25,
  0xCE84FFDF, 0xF5718801, 0x3DD64B04, 0xA26F263B,
  0x7ED48400, 0x547EEBE6, 0x446D4CA0, 0x6CF3D6F5,
  0x2649ABDF, 0xAEA0C7F5, 0x36338CC1, 0x503F7E93,
  0xD3772061, 0x11B638E1, 0x72500E03, 0xF80EB2BB,
  0xABE0502E, 0xEC8D77DE, 0x57971E81, 0xE14F6746,
  0xC9335400, 0x6920318F, 0x081DBB99, 0xFFC304A5,
  0x4D351805, 0x7F3D5CE3, 0xA6C866C6, 0x5D5BCCA9,
  0xDAEC6FEA, 0x9F926F91, 0x9F46222F, 0x3991467D,
  0xA5BF6D8E, 0x1143C44F, 0x43958302, 0xD0214EEB,
  0x022083B8, 0x3FB6180C, 0x18F8931E, 0x281658E6,
  0x26486E3E, 0x8BD78A70, 0x7477E4C1, 0xB506E07C,
  0xF32D0A25, 0x79098B02, 0xE4EABB81, 0x28123B23,
  0x69DEAD38, 0x1574CA16, 0xDF871B62, 0x211C40B7,
  0xA51A9EF9, 0x0014377B, 0x041E8AC8, 0x09114003,
  0xBD59E4D2, 0xE3D156D5, 0x4FE876D5, 0x2F91A340,
  0x557BE8DE, 0x00EAE4A7, 0x0CE5C2EC, 0x4DB4BBA6,
  0xE756BDFF, 0xDD3369AC, 0xEC17B035, 0x06572327,
  0x99AFC8B0, 0x56C8C391, 0x6B65811C, 0x5E146119,
  0x6E85CB75, 0xBE07C002, 0xC2325577, 0x893FF4EC,
  0x5BBFC92D, 0xD0EC3B25, 0xB7801AB7, 0x8D6D3B24,
  0x20C763EF, 0xC366A5FC, 0x9C382880, 0x0ACE3205,
  0xAAC9548A, 0xECA1D7C7, 0x041AFA32, 0x1D16625A,
  0x6701902C, 0x9B757A54, 0x31D477F7, 0x9126B031,
  0x36CC6FDB, 0xC70B8B46, 0xD9E66A48, 0x56E55A79,
  0x026A4CEB, 0x52437EFF, 0x2F8F76B4, 0x0DF980A5,
  0x8674CDE3, 0xEDDA04EB, 0x17A9BE04, 0x2C18F4DF,
  0xB7747F9D, 0xAB2AF7B4, 0xEFC34D20, 0x2E096B7C,
  0x1741A254, 0xE5B6A035, 0x213D42F6, 0x2C1C7C26,
  0x61C2F50F, 0x6552DAF9, 0xD2C231F8, 0x25130F69,
  0xD8167FA2, 0x0418F2C8, 0x001A96A6, 0x0D1526AB,
  0x63315C21, 0x5E0A72EC, 0x49BAFEFD, 0x187908D9,
  0x8D0DBD86, 0x311170A7, 0x3E9B640C, 0xCC3E10D7,
  0xD5CAD3B6, 0x0CAEC388, 0xF73001E1, 0x6C728AFF,
  0x71EAE2A1, 0x1F9AF36E, 0xCFCBD12F, 0xC1DE8417,
  0xAC07BE6B, 0xCB44A1D8, 0x8B9B0F56, 0x013988C3,
  0xB1C52FCA, 0xB4BE31CD, 0xD8782806, 0x12A3A4E2,
  0x6F7DE532, 0x58FD7EB6, 0xD01EE900, 0x24ADFFC2,
  0xF4990FC5, 0x9711AAC5, 0x001D7B95, 0x82E5E7D2,
  0x109873F6, 0x00613096, 0xC32D9521, 0xADA121FF,
  0x29908415, 0x7FBB977F, 0xAF9EB3DB, 0x29C9ED2A,
  0x5CE2A465, 0xA730F32C, 0xD0AA3FE8, 0x8A5CC091,
  0xD49E2CE7, 0x0CE454A9, 0xD60ACD86, 0x015F1919,
  0x77079103, 0xDEA03AF6, 0x78A8565E, 0xDEE356DF,
  0x21F05CBE, 0x8B75E387, 0xB3C50651, 0xB8A5C3EF,
  0xD8EEB6D2, 0xE523BE77, 0xC2154529, 0x2F69EFDF,
  0xAFE67AFB, 0xF470C4B2, 0xF3E0EB5B, 0xD6CC9876,
  0x39E4460C, 0x1FDA8538, 0x1987832F, 0xCA007367,
  0xA99144F8, 0x296B299E, 0x492FC295, 0x9266BEAB,
  0xB5676E69, 0x9BD3DDDA, 0xDF7E052F, 0xDB25701C,
  0x1B5E51EE, 0xF65324E6, 0x6AFCE36C, 0x0316CC04,
  0x8644213E, 0xB7DC59D0, 0x7965291F, 0xCCD6FD43,
  0x41823979, 0x932BCDF6, 0xB657C34D, 0x4EDFD282,
  0x7AE5290C, 0x3CB9536B, 0x851E20FE, 0x9833557E,
  0x13ECF0B0, 0xD3FFB372, 0x3F85C5C1, 0x0AEF7ED2
,


  0x7EC90C04, 0x2C6E74B9, 0x9B0E66DF, 0xA6337911,
  0xB86A7FFF, 0x1DD358F5, 0x44DD9D44, 0x1731167F,
  0x08FBF1FA, 0xE7F511CC, 0xD2051B00, 0x735ABA00,
  0x2AB722D8, 0x386381CB, 0xACF6243A, 0x69BEFD7A,
  0xE6A2E77F, 0xF0C720CD, 0xC4494816, 0xCCF5C180,
  0x38851640, 0x15B0A848, 0xE68B18CB, 0x4CAADEFF,
  0x5F480A01, 0x0412B2AA, 0x259814FC, 0x41D0EFE2,
  0x4E40B48D, 0x248EB6FB, 0x8DBA1CFE, 0x41A99B02,
  0x1A550A04, 0xBA8F65CB, 0x7251F4E7, 0x95A51725,
  0xC106ECD7, 0x97A5980A, 0xC539B9AA, 0x4D79FE6A,
  0xF2F3F763, 0x68AF8040, 0xED0C9E56, 0x11B4958B,
  0xE1EB5A88, 0x8709E6B0, 0xD7E07156, 0x4E29FEA7,
  0x6366E52D, 0x02D1C000, 0xC4AC8E05, 0x9377F571,
  0x0C05372A, 0x578535F2, 0x2261BE02, 0xD642A0C9,
  0xDF13A280, 0x74B55BD2, 0x682199C0, 0xD421E5EC,
  0x53FB3CE8, 0xC8ADEDB3, 0x28A87FC9, 0x3D959981,
  0x5C1FF900, 0xFE38D399, 0x0C4EFF0B, 0x062407EA,
  0xAA2F4FB1, 0x4FB96976, 0x90C79505, 0xB0A8A774,
  0xEF55A1FF, 0xE59CA2C2, 0xA6B62D27, 0xE66A4263,
  0xDF65001F, 0x0EC50966, 0xDFDD55BC, 0x29DE0655,
  0x911E739A, 0x17AF8975, 0x32C7911C, 0x89F89468,
  0x0D01E980, 0x524755F4, 0x03B63CC9, 0x0CC844B2,
  0xBCF3F0AA, 0x87AC36E9, 0xE53A7426, 0x01B3D82B,
  0x1A9E7449, 0x64EE2D7E, 0xCDDBB1DA, 0x01C94910,
  0xB868BF80, 0x0D26F3FD, 0x9342EDE7, 0x04A5C284,
  0x636737B6, 0x50F5B616, 0xF24766E3, 0x8ECA36C1,
  0x136E05DB, 0xFEF18391, 0xFB887A37, 0xD6E7F7D4,
  0xC7FB7DC9, 0x3063FCDF, 0xB6F589DE, 0xEC2941DA,
  0x26E46695, 0xB7566419, 0xF654EFC5, 0xD08D58B7,
  0x48925401, 0xC1BACB7F, 0xE5FF550F, 0xB6083049,
  0x5BB5D0E8, 0x87D72E5A, 0xAB6A6EE1, 0x223A66CE,
  0xC62BF3CD, 0x9E0885F9, 0x68CB3E47, 0x086C010F,
  0xA21DE820, 0xD18B69DE, 0xF3F65777, 0xFA02C3F6,
  0x407EDAC3, 0xCBB3D550, 0x1793084D, 0xB0D70EBA,
  0x0AB378D5, 0xD951FB0C, 0xDED7DA56, 0x4124BBE4,
  0x94CA0B56, 0x0F5755D1, 0xE0E1E56E, 0x6184B5BE,
  0x580A249F, 0x94F74BC0, 0xE327888E, 0x9F7B5561,
  0xC3DC0280, 0x05687715, 0x646C6BD7, 0x44904DB3,
  0x66B4F0A3, 0xC0F1648A, 0x697ED5AF, 0x49E92FF6,
  0x309E374F, 0x2CB6356A, 0x85808573, 0x4991F840,
  0x76F0AE02, 0x083BE84D, 0x28421C9A, 0x44489406,
  0x736E4CB8, 0xC1092910, 0x8BC95FC6, 0x7D869CF4,
  0x134F616F, 0x2E77118D, 0xB31B2BE1, 0xAA90B472,
  0x3CA5D717, 0x7D161BBA, 0x9CAD9010, 0xAF462BA2,
  0x9FE459D2, 0x45D34559, 0xD9F2DA13, 0xDBC65487,
  0xF3E4F94E, 0x176D486F, 0x097C13EA, 0x631DA5C7,
  0x445F7382, 0x175683F4, 0xCDC66A97, 0x70BE0288,
  0xB3CDCF72, 0x6E5DD2F3, 0x20936079, 0x459B80A5,
  0xBE60E2DB, 0xA9C23101, 0xEBA5315C, 0x224E42F2,
  0x1C5C1572, 0xF6721B2C, 0x1AD2FFF3, 0x8C25404E,
  0x324ED72F, 0x4067B7FD, 0x0523138E, 0x5CA3BC78,
  0xDC0FD66E, 0x75922283, 0x784D6B17, 0x58EBB16E,
  0x44094F85, 0x3F481D87, 0xFCFEAE7B, 0x77B5FF76,
  0x8C2302BF, 0xAAF47556, 0x5F46B02A, 0x2B092801,
  0x3D38F5F7, 0x0CA81F36, 0x52AF4A8A, 0x66D5E7C0,
  0xDF3B0874, 0x95055110, 0x1B5AD7A8, 0xF61ED5AD,
  0x6CF6E479, 0x20758184, 0xD0CEFA65, 0x88F7BE58,
  0x4A046826, 0x0FF6F8F3, 0xA09C7F70, 0x5346ABA0,
  0x5CE96C28, 0xE176EDA3, 0x6BAC307F, 0x376829D2,
  0x85360FA9, 0x17E3FE2A, 0x24B79767, 0xF5A96B20,
  0xD6CD2595, 0x68FF1EBF, 0x7555442C, 0xF19F06BE,
  0xF9E0659A, 0xEEB9491D, 0x34010718, 0xBB30CAB8,
  0xE822FE15, 0x88570983, 0x750E6249, 0xDA627E55,
  0x5E76FFA8, 0xB1534546, 0x6D47DE08, 0xEFE9E7D4
,


  0xF6FA8F9D, 0x2CAC6CE1, 0x4CA34867, 0xE2337F7C,
  0x95DB08E7, 0x016843B4, 0xECED5CBC, 0x325553AC,
  0xBF9F0960, 0xDFA1E2ED, 0x83F0579D, 0x63ED86B9,
  0x1AB6A6B8, 0xDE5EBE39, 0xF38FF732, 0x8989B138,
  0x33F14961, 0xC01937BD, 0xF506C6DA, 0xE4625E7E,
  0xA308EA99, 0x4E23E33C, 0x79CBD7CC, 0x48A14367,
  0xA3149619, 0xFEC94BD5, 0xA114174A, 0xEAA01866,
  0xA084DB2D, 0x09A8486F, 0xA888614A, 0x2900AF98,
  0x01665991, 0xE1992863, 0xC8F30C60, 0x2E78EF3C,
  0xD0D51932, 0xCF0FEC14, 0xF7CA07D2, 0xD0A82072,
  0xFD41197E, 0x9305A6B0, 0xE86BE3DA, 0x74BED3CD,
  0x372DA53C, 0x4C7F4448, 0xDAB5D440, 0x6DBA0EC3,
  0x083919A7, 0x9FBAEED9, 0x49DBCFB0, 0x4E670C53,
  0x5C3D9C01, 0x64BDB941, 0x2C0E636A, 0xBA7DD9CD,
  0xEA6F7388, 0xE70BC762, 0x35F29ADB, 0x5C4CDD8D,
  0xF0D48D8C, 0xB88153E2, 0x08A19866, 0x1AE2EAC8,
  0x284CAF89, 0xAA928223, 0x9334BE53, 0x3B3A21BF,
  0x16434BE3, 0x9AEA3906, 0xEFE8C36E, 0xF890CDD9,
  0x80226DAE, 0xC340A4A3, 0xDF7E9C09, 0xA694A807,
  0x5B7C5ECC, 0x221DB3A6, 0x9A69A02F, 0x68818A54,
  0xCEB2296F, 0x53C0843A, 0xFE893655, 0x25BFE68A,
  0xB4628ABC, 0xCF222EBF, 0x25AC6F48, 0xA9A99387,
  0x53BDDB65, 0xE76FFBE7, 0xE967FD78, 0x0BA93563,
  0x8E342BC1, 0xE8A11BE9, 0x4980740D, 0xC8087DFC,
  0x8DE4BF99, 0xA11101A0, 0x7FD37975, 0xDA5A26C0,
  0xE81F994F, 0x9528CD89, 0xFD339FED, 0xB87834BF,
  0x5F04456D, 0x22258698, 0xC9C4C83B, 0x2DC156BE,
  0x4F628DAA, 0x57F55EC5, 0xE2220ABE, 0xD2916EBF,
  0x4EC75B95, 0x24F2C3C0, 0x42D15D99, 0xCD0D7FA0,
  0x7B6E27FF, 0xA8DC8AF0, 0x7345C106, 0xF41E232F,
  0x35162386, 0xE6EA8926, 0x3333B094, 0x157EC6F2,
  0x372B74AF, 0x692573E4, 0xE9A9D848, 0xF3160289,
  0x3A62EF1D, 0xA787E238, 0xF3A5F676, 0x74364853,
  0x20951063, 0x4576698D, 0xB6FAD407, 0x592AF950,
  0x36F73523, 0x4CFB6E87, 0x7DA4CEC0, 0x6C152DAA,
  0xCB0396A8, 0xC50DFE5D, 0xFCD707AB, 0x0921C42F,
  0x89DFF0BB, 0x5FE2BE78, 0x448F4F33, 0x754613C9,
  0x2B05D08D, 0x48B9D585, 0xDC049441, 0xC8098F9B,
  0x7DEDE786, 0xC39A3373, 0x42410005, 0x6A091751,
  0x0EF3C8A6, 0x890072D6, 0x28207682, 0xA9A9F7BE,
  0xBF32679D, 0xD45B5B75, 0xB353FD00, 0xCBB0E358,
  0x830F220A, 0x1F8FB214, 0xD372CF08, 0xCC3C4A13,
  0x8CF63166, 0x061C87BE, 0x88C98F88, 0x6062E397,
  0x47CF8E7A, 0xB6C85283, 0x3CC2ACFB, 0x3FC06976,
  0x4E8F0252, 0x64D8314D, 0xDA3870E3, 0x1E665459,
  0xC10908F0, 0x513021A5, 0x6C5B68B7, 0x822F8AA0,
  0x3007CD3E, 0x74719EEF, 0xDC872681, 0x073340D4,
  0x7E432FD9, 0x0C5EC241, 0x8809286C, 0xF592D891,
  0x08A930F6, 0x957EF305, 0xB7FBFFBD, 0xC266E96F,
  0x6FE4AC98, 0xB173ECC0, 0xBC60B42A, 0x953498DA,
  0xFBA1AE12, 0x2D4BD736, 0x0F25FAAB, 0xA4F3FCEB,
  0xE2969123, 0x257F0C3D, 0x9348AF49, 0x361400BC,
  0xE8816F4A, 0x3814F200, 0xA3F94043, 0x9C7A54C2,
  0xBC704F57, 0xDA41E7F9, 0xC25AD33A, 0x54F4A084,
  0xB17F5505, 0x59357CBE, 0xEDBD15C8, 0x7F97C5AB,
  0xBA5AC7B5, 0xB6F6DEAF, 0x3A479C3A, 0x5302DA25,
  0x653D7E6A, 0x54268D49, 0x51A477EA, 0x5017D55B,
  0xD7D25D88, 0x44136C76, 0x0404A8C8, 0xB8E5A121,
  0xB81A928A, 0x60ED5869, 0x97C55B96, 0xEAEC991B,
  0x29935913, 0x01FDB7F1, 0x088E8DFA, 0x9AB6F6F5,
  0x3B4CBF9F, 0x4A5DE3AB, 0xE6051D35, 0xA0E1D855,
  0xD36B4CF1, 0xF544EDEB, 0xB0E93524, 0xBEBB8FBD,
  0xA2D762CF, 0x49C92F54, 0x38B5F331, 0x7128A454,
  0x48392905, 0xA65B1DB8, 0x851C97BD, 0xD675CF2F
,


  0x85E04019, 0x332BF567, 0x662DBFFF, 0xCFC65693,
  0x2A8D7F6F, 0xAB9BC912, 0xDE6008A1, 0x2028DA1F,
  0x0227BCE7, 0x4D642916, 0x18FAC300, 0x50F18B82,
  0x2CB2CB11, 0xB232E75C, 0x4B3695F2, 0xB28707DE,
  0xA05FBCF6, 0xCD4181E9, 0xE150210C, 0xE24EF1BD,
  0xB168C381, 0xFDE4E789, 0x5C79B0D8, 0x1E8BFD43,
  0x4D495001, 0x38BE4341, 0x913CEE1D, 0x92A79C3F,
  0x089766BE, 0xBAEEADF4, 0x1286BECF, 0xB6EACB19,
  0x2660C200, 0x7565BDE4, 0x64241F7A, 0x8248DCA9,
  0xC3B3AD66, 0x28136086, 0x0BD8DFA8, 0x356D1CF2,
  0x107789BE, 0xB3B2E9CE, 0x0502AA8F, 0x0BC0351E,
  0x166BF52A, 0xEB12FF82, 0xE3486911, 0xD34D7516,
  0x4E7B3AFF, 0x5F43671B, 0x9CF6E037, 0x4981AC83,
  0x334266CE, 0x8C9341B7, 0xD0D854C0, 0xCB3A6C88,
  0x47BC2829, 0x4725BA37, 0xA66AD22B, 0x7AD61F1E,
  0x0C5CBAFA, 0x4437F107, 0xB6E79962, 0x42D2D816,
  0x0A961288, 0xE1A5C06E, 0x13749E67, 0x72FC081A,
  0xB1D139F7, 0xF9583745, 0xCF19DF58, 0xBEC3F756,
  0xC06EBA30, 0x07211B24, 0x45C28829, 0xC95E317F,
  0xBC8EC511, 0x38BC46E9, 0xC6E6FA14, 0xBAE8584A,
  0xAD4EBC46, 0x468F508B, 0x7829435F, 0xF124183B,
  0x821DBA9F, 0xAFF60FF4, 0xEA2C4E6D, 0x16E39264,
  0x92544A8B, 0x009B4FC3, 0xABA68CED, 0x9AC96F78,
  0x06A5B79A, 0xB2856E6E, 0x1AEC3CA9, 0xBE838688,
  0x0E0804E9, 0x55F1BE56, 0xE7E5363B, 0xB3A1F25D,
  0xF7DEBB85, 0x61FE033C, 0x16746233, 0x3C034C28,
  0xDA6D0C74, 0x79AAC56C, 0x3CE4E1AD, 0x51F0C802,
  0x98F8F35A, 0x1626A49F, 0xEED82B29, 0x1D382FE3,
  0x0C4FB99A, 0xBB325778, 0x3EC6D97B, 0x6E77A6A9,
  0xCB658B5C, 0xD45230C7, 0x2BD1408B, 0x60C03EB7,
  0xB9068D78, 0xA33754F4, 0xF430C87D, 0xC8A71302,
  0xB96D8C32, 0xEBD4E7BE, 0xBE8B9D2D, 0x7979FB06,
  0xE7225308, 0x8B75CF77, 0x11EF8DA4, 0xE083C858,
  0x8D6B786F, 0x5A6317A6, 0xFA5CF7A0, 0x5DDA0033,
  0xF28EBFB0, 0xF5B9C310, 0xA0EAC280, 0x08B9767A,
  0xA3D9D2B0, 0x79D34217, 0x021A718D, 0x9AC6336A,
  0x2711FD60, 0x438050E3, 0x069908A8, 0x3D7FEDC4,
  0x826D2BEF, 0x4EEB8476, 0x488DCF25, 0x36C9D566,
  0x28E74E41, 0xC2610ACA, 0x3D49A9CF, 0xBAE3B9DF,
  0xB65F8DE6, 0x92AEAF64, 0x3AC7D5E6, 0x9EA80509,
  0xF22B017D, 0xA4173F70, 0xDD1E16C3, 0x15E0D7F9,
  0x50B1B887, 0x2B9F4FD5, 0x625ABA82, 0x6A017962,
  0x2EC01B9C, 0x15488AA9, 0xD716E740, 0x40055A2C,
  0x93D29A22, 0xE32DBF9A, 0x058745B9, 0x3453DC1E,
  0xD699296E, 0x496CFF6F, 0x1C9F4986, 0xDFE2ED07,
  0xB87242D1, 0x19DE7EAE, 0x053E561A, 0x15AD6F8C,
  0x66626C1C, 0x7154C24C, 0xEA082B2A, 0x93EB2939,
  0x17DCB0F0, 0x58D4F2AE, 0x9EA294FB, 0x52CF564C,
  0x9883FE66, 0x2EC40581, 0x763953C3, 0x01D6692E,
  0xD3A0C108, 0xA1E7160E, 0xE4F2DFA6, 0x693ED285,
  0x74904698, 0x4C2B0EDD, 0x4F757656, 0x5D393378,
  0xA132234F, 0x3D321C5D, 0xC3F5E194, 0x4B269301,
  0xC79F022F, 0x3C997E7E, 0x5E4F9504, 0x3FFAFBBD,
  0x76F7AD0E, 0x296693F4, 0x3D1FCE6F, 0xC61E45BE,
  0xD3B5AB34, 0xF72BF9B7, 0x1B0434C0, 0x4E72B567,
  0x5592A33D, 0xB5229301, 0xCFD2A87F, 0x60AEB767,
  0x1814386B, 0x30BCC33D, 0x38A0C07D, 0xFD1606F2,
  0xC363519B, 0x589DD390, 0x5479F8E6, 0x1CB8D647,
  0x97FD61A9, 0xEA7759F4, 0x2D57539D, 0x569A58CF,
  0xE84E63AD, 0x462E1B78, 0x6580F87E, 0xF3817914,
  0x91DA55F4, 0x40A230F3, 0xD1988F35, 0xB6E318D2,
  0x3FFA50BC, 0x3D40F021, 0xC3C0BDAE, 0x4958C24C,
  0x518F36B2, 0x84B1D370, 0x0FEDCE83, 0x878DDADA,
  0xF2A279C7, 0x94E01BE8, 0x90716F4B, 0x954B8AA3
,


  0xE216300D, 0xBBDDFFFC, 0xA7EBDABD, 0x35648095,
  0x7789F8B7, 0xE6C1121B, 0x0E241600, 0x052CE8B5,
  0x11A9CFB0, 0xE5952F11, 0xECE7990A, 0x9386D174,
  0x2A42931C, 0x76E38111, 0xB12DEF3A, 0x37DDDDFC,
  0xDE9ADEB1, 0x0A0CC32C, 0xBE197029, 0x84A00940,
  0xBB243A0F, 0xB4D137CF, 0xB44E79F0, 0x049EEDFD,
  0x0B15A15D, 0x480D3168, 0x8BBBDE5A, 0x669DED42,
  0xC7ECE831, 0x3F8F95E7, 0x72DF191B, 0x7580330D,
  0x94074251, 0x5C7DCDFA, 0xABBE6D63, 0xAA402164,
  0xB301D40A, 0x02E7D1CA, 0x53571DAE, 0x7A3182A2,
  0x12A8DDEC, 0xFDAA335D, 0x176F43E8, 0x71FB46D4,
  0x38129022, 0xCE949AD4, 0xB84769AD, 0x965BD862,
  0x82F3D055, 0x66FB9767, 0x15B80B4E, 0x1D5B47A0,
  0x4CFDE06F, 0xC28EC4B8, 0x57E8726E, 0x647A78FC,
  0x99865D44, 0x608BD593, 0x6C200E03, 0x39DC5FF6,
  0x5D0B00A3, 0xAE63AFF2, 0x7E8BD632, 0x70108C0C,
  0xBBD35049, 0x2998DF04, 0x980CF42A, 0x9B6DF491,
  0x9E7EDD53, 0x06918548, 0x58CB7E07, 0x3B74EF2E,
  0x522FFFB1, 0xD24708CC, 0x1C7E27CD, 0xA4EB215B,
  0x3CF1D2E2, 0x19B47A38, 0x424F7618, 0x35856039,
  0x9D17DEE7, 0x27EB35E6, 0xC9AFF67B, 0x36BAF5B8,
  0x09C467CD, 0xC18910B1, 0xE11DBF7B, 0x06CD1AF8,
  0x7170C608, 0x2D5E3354, 0xD4DE495A, 0x64C6D006,
  0xBCC0C62C, 0x3DD00DB3, 0x708F8F34, 0x77D51B42,
  0x264F620F, 0x24B8D2BF, 0x15C1B79E, 0x46A52564,
  0xF8D7E54E, 0x3E378160, 0x7895CDA5, 0x859C15A5,
  0xE6459788, 0xC37BC75F, 0xDB07BA0C, 0x0676A3AB,
  0x7F229B1E, 0x31842E7B, 0x24259FD7, 0xF8BEF472,
  0x835FFCB8, 0x6DF4C1F2, 0x96F5B195, 0xFD0AF0FC,
  0xB0FE134C, 0xE2506D3D, 0x4F9B12EA, 0xF215F225,
  0xA223736F, 0x9FB4C428, 0x25D04979, 0x34C713F8,
  0xC4618187, 0xEA7A6E98, 0x7CD16EFC, 0x1436876C,
  0xF1544107, 0xBEDEEE14, 0x56E9AF27, 0xA04AA441,
  0x3CF7C899, 0x92ECBAE6, 0xDD67016D, 0x151682EB,
  0xA842EEDF, 0xFDBA60B4, 0xF1907B75, 0x20E3030F,
  0x24D8C29E, 0xE139673B, 0xEFA63FB8, 0x71873054,
  0xB6F2CF3B, 0x9F326442, 0xCB15A4CC, 0xB01A4504,
  0xF1E47D8D, 0x844A1BE5, 0xBAE7DFDC, 0x42CBDA70,
  0xCD7DAE0A, 0x57E85B7A, 0xD53F5AF6, 0x20CF4D8C,
  0xCEA4D428, 0x79D130A4, 0x3486EBFB, 0x33D3CDDC,
  0x77853B53, 0x37EFFCB5, 0xC5068778, 0xE580B3E6,
  0x4E68B8F4, 0xC5C8B37E, 0x0D809EA2, 0x398FEB7C,
  0x132A4F94, 0x43B7950E, 0x2FEE7D1C, 0x223613BD,
  0xDD06CAA2, 0x37DF932B, 0xC4248289, 0xACF3EBC3,
  0x5715F6B7, 0xEF3478DD, 0xF267616F, 0xC148CBE4,
  0x9052815E, 0x5E410FAB, 0xB48A2465, 0x2EDA7FA4,
  0xE87B40E4, 0xE98EA084, 0x5889E9E1, 0xEFD390FC,
  0xDD07D35B, 0xDB485694, 0x38D7E5B2, 0x57720101,
  0x730EDEBC, 0x5B643113, 0x94917E4F, 0x503C2FBA,
  0x646F1282, 0x7523D24A, 0xE0779695, 0xF9C17A8F,
  0x7A5B2121, 0xD187B896, 0x29263A4D, 0xBA510CDF,
  0x81F47C9F, 0xAD1163ED, 0xEA7B5965, 0x1A00726E,
  0x11403092, 0x00DA6D77, 0x4A0CDD61, 0xAD1F4603,
  0x605BDFB0, 0x9EEDC364, 0x22EBE6A8, 0xCEE7D28A,
  0xA0E736A0, 0x5564A6B9, 0x10853209, 0xC7EB8F37,
  0x2DE705CA, 0x8951570F, 0xDF09822B, 0xBD691A6C,
  0xAA12E4F2, 0x87451C0F, 0xE0F6A27A, 0x3ADA4819,
  0x4CF1764F, 0x0D771C2B, 0x67CDB156, 0x350D8384,
  0x5938FA0F, 0x42399EF3, 0x36997B07, 0x0E84093D,
  0x4AA93E61, 0x8360D87B, 0x1FA98B0C, 0x1149382C,
  0xE97625A5, 0x0614D1B7, 0x0E25244B, 0x0C768347,
  0x589E8D82, 0x0D2059D1, 0xA466BB1E, 0xF8DA0A82,
  0x04F19130, 0xBA6E4EC0, 0x99265164, 0x1EE7230D,
  0x50B2AD80, 0xEAEE6801, 0x8DB2A283, 0xEA8BF59E
};

//-----------------
// The following CAST-256 implementation was contributed by Leonard Janke

static const word32 CAST256_t_m[8*24] =
{
        0x5a827999, 0xd151d6a1, 0x482133a9, 0xbef090b1, 0x35bfedb9, 0xac8f4ac1,
        0x235ea7c9, 0x9a2e04d1, 0x10fd61d9, 0x87ccbee1, 0xfe9c1be9, 0x756b78f1,
        0xec3ad5f9, 0x630a3301, 0xd9d99009, 0x50a8ed11, 0xc7784a19, 0x3e47a721,
        0xb5170429, 0x2be66131, 0xa2b5be39, 0x19851b41, 0x90547849, 0x0723d551,
        0xc95c653a, 0x402bc242, 0xb6fb1f4a, 0x2dca7c52, 0xa499d95a, 0x1b693662,
        0x9238936a, 0x0907f072, 0x7fd74d7a, 0xf6a6aa82, 0x6d76078a, 0xe4456492,
        0x5b14c19a, 0xd1e41ea2, 0x48b37baa, 0xbf82d8b2, 0x365235ba, 0xad2192c2,
        0x23f0efca, 0x9ac04cd2, 0x118fa9da, 0x885f06e2, 0xff2e63ea, 0x75fdc0f2,
        0x383650db, 0xaf05ade3, 0x25d50aeb, 0x9ca467f3, 0x1373c4fb, 0x8a432203,
        0x01127f0b, 0x77e1dc13, 0xeeb1391b, 0x65809623, 0xdc4ff32b, 0x531f5033,
        0xc9eead3b, 0x40be0a43, 0xb78d674b, 0x2e5cc453, 0xa52c215b, 0x1bfb7e63,
        0x92cadb6b, 0x099a3873, 0x8069957b, 0xf738f283, 0x6e084f8b, 0xe4d7ac93,
        0xa7103c7c, 0x1ddf9984, 0x94aef68c, 0x0b7e5394, 0x824db09c, 0xf91d0da4,
        0x6fec6aac, 0xe6bbc7b4, 0x5d8b24bc, 0xd45a81c4, 0x4b29decc, 0xc1f93bd4,
        0x38c898dc, 0xaf97f5e4, 0x266752ec, 0x9d36aff4, 0x14060cfc, 0x8ad56a04,
        0x01a4c70c, 0x78742414, 0xef43811c, 0x6612de24, 0xdce23b2c, 0x53b19834,
        0x15ea281d, 0x8cb98525, 0x0388e22d, 0x7a583f35, 0xf1279c3d, 0x67f6f945,
        0xdec6564d, 0x5595b355, 0xcc65105d, 0x43346d65, 0xba03ca6d, 0x30d32775,
        0xa7a2847d, 0x1e71e185, 0x95413e8d, 0x0c109b95, 0x82dff89d, 0xf9af55a5,
        0x707eb2ad, 0xe74e0fb5, 0x5e1d6cbd, 0xd4ecc9c5, 0x4bbc26cd, 0xc28b83d5,
        0x84c413be, 0xfb9370c6, 0x7262cdce, 0xe9322ad6, 0x600187de, 0xd6d0e4e6,
        0x4da041ee, 0xc46f9ef6, 0x3b3efbfe, 0xb20e5906, 0x28ddb60e, 0x9fad1316,
        0x167c701e, 0x8d4bcd26, 0x041b2a2e, 0x7aea8736, 0xf1b9e43e, 0x68894146,
        0xdf589e4e, 0x5627fb56, 0xccf7585e, 0x43c6b566, 0xba96126e, 0x31656f76,
        0xf39dff5f, 0x6a6d5c67, 0xe13cb96f, 0x580c1677, 0xcedb737f, 0x45aad087,
        0xbc7a2d8f, 0x33498a97, 0xaa18e79f, 0x20e844a7, 0x97b7a1af, 0x0e86feb7,
        0x85565bbf, 0xfc25b8c7, 0x72f515cf, 0xe9c472d7, 0x6093cfdf, 0xd7632ce7,
        0x4e3289ef, 0xc501e6f7, 0x3bd143ff, 0xb2a0a107, 0x296ffe0f, 0xa03f5b17,
        0x6277eb00, 0xd9474808, 0x5016a510, 0xc6e60218, 0x3db55f20, 0xb484bc28,
        0x2b541930, 0xa2237638, 0x18f2d340, 0x8fc23048, 0x06918d50, 0x7d60ea58,
        0xf4304760, 0x6affa468, 0xe1cf0170, 0x589e5e78, 0xcf6dbb80, 0x463d1888,
        0xbd0c7590, 0x33dbd298, 0xaaab2fa0, 0x217a8ca8, 0x9849e9b0, 0x0f1946b8
};

static const unsigned int CAST256_t_r[8*24] =
{
  19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11,
  4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28,
  21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13,
  6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30,
  23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15,
  8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0,
  25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17,
  10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2
};
//-----------------
// The Camellia s-boxes

static const byte Camellia_s1[256] =
{
  112,130,44,236,179,39,192,229,228,133,87,53,234,12,174,65,
  35,239,107,147,69,25,165,33,237,14,79,78,29,101,146,189,
  134,184,175,143,124,235,31,206,62,48,220,95,94,197,11,26,
  166,225,57,202,213,71,93,61,217,1,90,214,81,86,108,77,
  139,13,154,102,251,204,176,45,116,18,43,32,240,177,132,153,
  223,76,203,194,52,126,118,5,109,183,169,49,209,23,4,215,
  20,88,58,97,222,27,17,28,50,15,156,22,83,24,242,34,
  254,68,207,178,195,181,122,145,36,8,232,168,96,252,105,80,
  170,208,160,125,161,137,98,151,84,91,30,149,224,255,100,210,
  16,196,0,72,163,247,117,219,138,3,230,218,9,63,221,148,
  135,92,131,2,205,74,144,51,115,103,246,243,157,127,191,226,
  82,155,216,38,200,55,198,59,129,150,111,75,19,190,99,46,
  233,121,167,140,159,110,188,142,41,245,249,182,47,253,180,89,
  120,152,6,106,231,70,113,186,212,37,171,66,136,162,141,250,
  114,7,185,85,248,238,172,10,54,73,42,104,60,56,241,164,
  64,40,211,123,187,201,67,193,21,227,173,244,119,199,128,158
};

static const byte Camellia_s2[256] =
{
  224,5,88,217,103,78,129,203,201,11,174,106,213,24,93,130,
  70,223,214,39,138,50,75,66,219,28,158,156,58,202,37,123,
  13,113,95,31,248,215,62,157,124,96,185,190,188,139,22,52,
  77,195,114,149,171,142,186,122,179,2,180,173,162,172,216,154,
  23,26,53,204,247,153,97,90,232,36,86,64,225,99,9,51,
  191,152,151,133,104,252,236,10,218,111,83,98,163,46,8,175,
  40,176,116,194,189,54,34,56,100,30,57,44,166,48,229,68,
  253,136,159,101,135,107,244,35,72,16,209,81,192,249,210,160,
  85,161,65,250,67,19,196,47,168,182,60,43,193,255,200,165,
  32,137,0,144,71,239,234,183,21,6,205,181,18,126,187,41,
  15,184,7,4,155,148,33,102,230,206,237,231,59,254,127,197,
  164,55,177,76,145,110,141,118,3,45,222,150,38,125,198,92,
  211,242,79,25,63,220,121,29,82,235,243,109,94,251,105,178,
  240,49,12,212,207,140,226,117,169,74,87,132,17,69,27,245,
  228,14,115,170,241,221,89,20,108,146,84,208,120,112,227,73,
  128,80,167,246,119,147,134,131,42,199,91,233,238,143,1,61
};

static const byte Camellia_s3[256] =
{
  56,65,22,118,217,147,96,242,114,194,171,154,117,6,87,160,
  145,247,181,201,162,140,210,144,246,7,167,39,142,178,73,222,
  67,92,215,199,62,245,143,103,31,24,110,175,47,226,133,13,
  83,240,156,101,234,163,174,158,236,128,45,107,168,43,54,166,
  197,134,77,51,253,102,88,150,58,9,149,16,120,216,66,204,
  239,38,229,97,26,63,59,130,182,219,212,152,232,139,2,235,
  10,44,29,176,111,141,136,14,25,135,78,11,169,12,121,17,
  127,34,231,89,225,218,61,200,18,4,116,84,48,126,180,40,
  85,104,80,190,208,196,49,203,42,173,15,202,112,255,50,105,
  8,98,0,36,209,251,186,237,69,129,115,109,132,159,238,74,
  195,46,193,1,230,37,72,153,185,179,123,249,206,191,223,113,
  41,205,108,19,100,155,99,157,192,75,183,165,137,95,177,23,
  244,188,211,70,207,55,94,71,148,250,252,91,151,254,90,172,
  60,76,3,53,243,35,184,93,106,146,213,33,68,81,198,125,
  57,131,220,170,124,119,86,5,27,164,21,52,30,28,248,82,
  32,20,233,189,221,228,161,224,138,241,214,122,187,227,64,79
};

static const byte Camellia_s4[256] =
{
  112,44,179,192,228,87,234,174,35,107,69,165,237,79,29,146,
  134,175,124,31,62,220,94,11,166,57,213,93,217,90,81,108,
  139,154,251,176,116,43,240,132,223,203,52,118,109,169,209,4,
  20,58,222,17,50,156,83,242,254,207,195,122,36,232,96,105,
  170,160,161,98,84,30,224,100,16,0,163,117,138,230,9,221,
  135,131,205,144,115,246,157,191,82,216,200,198,129,111,19,99,
  233,167,159,188,41,249,47,180,120,6,231,113,212,171,136,141,
  114,185,248,172,54,42,60,241,64,211,187,67,21,173,119,128,
  130,236,39,229,133,53,12,65,239,147,25,33,14,78,101,189,
  184,143,235,206,48,95,197,26,225,202,71,61,1,214,86,77,
  13,102,204,45,18,32,177,153,76,194,126,5,183,49,23,215,
  88,97,27,28,15,22,24,34,68,178,181,145,8,168,252,80,
  208,125,137,151,91,149,255,210,196,72,247,219,3,218,63,148,
  92,2,74,51,103,243,127,226,155,38,55,59,150,75,190,46,
  121,140,110,142,245,182,253,89,152,106,70,186,37,66,162,250,
  7,85,238,10,73,104,56,164,40,123,201,193,227,244,199,158
};
//-------------------

static const word32 Blowfish_p_init[] =
{
  608135816, 2242054355,  320440878,   57701188,
 2752067618,  698298832,  137296536, 3964562569,
 1160258022,  953160567, 3193202383,  887688300,
 3232508343, 3380367581, 1065670069, 3041331479,
 2450970073, 2306472731
};

static const word32 Blowfish_s_init[4*256] =
{
  3509652390, 2564797868,  805139163, 3491422135,
  3101798381, 1780907670, 3128725573, 4046225305,
   614570311, 3012652279,  134345442, 2240740374,
  1667834072, 1901547113, 2757295779, 4103290238,
   227898511, 1921955416, 1904987480, 2182433518,
  2069144605, 3260701109, 2620446009,  720527379,
  3318853667,  677414384, 3393288472, 3101374703,
  2390351024, 1614419982, 1822297739, 2954791486,
  3608508353, 3174124327, 2024746970, 1432378464,
  3864339955, 2857741204, 1464375394, 1676153920,
  1439316330,  715854006, 3033291828,  289532110,
  2706671279, 2087905683, 3018724369, 1668267050,
   732546397, 1947742710, 3462151702, 2609353502,
  2950085171, 1814351708, 2050118529,  680887927,
   999245976, 1800124847, 3300911131, 1713906067,
  1641548236, 4213287313, 1216130144, 1575780402,
  4018429277, 3917837745, 3693486850, 3949271944,
   596196993, 3549867205,  258830323, 2213823033,
   772490370, 2760122372, 1774776394, 2652871518,
   566650946, 4142492826, 1728879713, 2882767088,
  1783734482, 3629395816, 2517608232, 2874225571,
  1861159788,  326777828, 3124490320, 2130389656,
  2716951837,  967770486, 1724537150, 2185432712,
  2364442137, 1164943284, 2105845187,  998989502,
  3765401048, 2244026483, 1075463327, 1455516326,
  1322494562,  910128902,  469688178, 1117454909,
   936433444, 3490320968, 3675253459, 1240580251,
   122909385, 2157517691,  634681816, 4142456567,
  3825094682, 3061402683, 2540495037,   79693498,
  3249098678, 1084186820, 1583128258,  426386531,
  1761308591, 1047286709,  322548459,  995290223,
  1845252383, 2603652396, 3431023940, 2942221577,
  3202600964, 3727903485, 1712269319,  422464435,
  3234572375, 1170764815, 3523960633, 3117677531,
  1434042557,  442511882, 3600875718, 1076654713,
  1738483198, 4213154764, 2393238008, 3677496056,
  1014306527, 4251020053,  793779912, 2902807211,
   842905082, 4246964064, 1395751752, 1040244610,
  2656851899, 3396308128,  445077038, 3742853595,
  3577915638,  679411651, 2892444358, 2354009459,
  1767581616, 3150600392, 3791627101, 3102740896,
   284835224, 4246832056, 1258075500,  768725851,
  2589189241, 3069724005, 3532540348, 1274779536,
  3789419226, 2764799539, 1660621633, 3471099624,
  4011903706,  913787905, 3497959166,  737222580,
  2514213453, 2928710040, 3937242737, 1804850592,
  3499020752, 2949064160, 2386320175, 2390070455,
  2415321851, 4061277028, 2290661394, 2416832540,
  1336762016, 1754252060, 3520065937, 3014181293,
   791618072, 3188594551, 3933548030, 2332172193,
  3852520463, 3043980520,  413987798, 3465142937,
  3030929376, 4245938359, 2093235073, 3534596313,
   375366246, 2157278981, 2479649556,  555357303,
  3870105701, 2008414854, 3344188149, 4221384143,
  3956125452, 2067696032, 3594591187, 2921233993,
     2428461,  544322398,  577241275, 1471733935,
   610547355, 4027169054, 1432588573, 1507829418,
  2025931657, 3646575487,  545086370,   48609733,
  2200306550, 1653985193,  298326376, 1316178497,
  3007786442, 2064951626,  458293330, 2589141269,
  3591329599, 3164325604,  727753846, 2179363840,
   146436021, 1461446943, 4069977195,  705550613,
  3059967265, 3887724982, 4281599278, 3313849956,
  1404054877, 2845806497,  146425753, 1854211946,

  1266315497, 3048417604, 3681880366, 3289982499,
  2909710000, 1235738493, 2632868024, 2414719590,
  3970600049, 1771706367, 1449415276, 3266420449,
   422970021, 1963543593, 2690192192, 3826793022,
  1062508698, 1531092325, 1804592342, 2583117782,
  2714934279, 4024971509, 1294809318, 4028980673,
  1289560198, 2221992742, 1669523910,   35572830,
   157838143, 1052438473, 1016535060, 1802137761,
  1753167236, 1386275462, 3080475397, 2857371447,
  1040679964, 2145300060, 2390574316, 1461121720,
  2956646967, 4031777805, 4028374788,   33600511,
  2920084762, 1018524850,  629373528, 3691585981,
  3515945977, 2091462646, 2486323059,  586499841,
   988145025,  935516892, 3367335476, 2599673255,
  2839830854,  265290510, 3972581182, 2759138881,
  3795373465, 1005194799,  847297441,  406762289,
  1314163512, 1332590856, 1866599683, 4127851711,
   750260880,  613907577, 1450815602, 3165620655,
  3734664991, 3650291728, 3012275730, 3704569646,
  1427272223,  778793252, 1343938022, 2676280711,
  2052605720, 1946737175, 3164576444, 3914038668,
  3967478842, 3682934266, 1661551462, 3294938066,
  4011595847,  840292616, 3712170807,  616741398,
   312560963,  711312465, 1351876610,  322626781,
  1910503582,  271666773, 2175563734, 1594956187,
    70604529, 3617834859, 1007753275, 1495573769,
  4069517037, 2549218298, 2663038764,  504708206,
  2263041392, 3941167025, 2249088522, 1514023603,
  1998579484, 1312622330,  694541497, 2582060303,
  2151582166, 1382467621,  776784248, 2618340202,
  3323268794, 2497899128, 2784771155,  503983604,
  4076293799,  907881277,  423175695,  432175456,
  1378068232, 4145222326, 3954048622, 3938656102,
  3820766613, 2793130115, 2977904593,   26017576,
  3274890735, 3194772133, 1700274565, 1756076034,
  4006520079, 3677328699,  720338349, 1533947780,
   354530856,  688349552, 3973924725, 1637815568,
   332179504, 3949051286,   53804574, 2852348879,
  3044236432, 1282449977, 3583942155, 3416972820,
  4006381244, 1617046695, 2628476075, 3002303598,
  1686838959,  431878346, 2686675385, 1700445008,
  1080580658, 1009431731,  832498133, 3223435511,
  2605976345, 2271191193, 2516031870, 1648197032,
  4164389018, 2548247927,  300782431,  375919233,
   238389289, 3353747414, 2531188641, 2019080857,
  1475708069,  455242339, 2609103871,  448939670,
  3451063019, 1395535956, 2413381860, 1841049896,
  1491858159,  885456874, 4264095073, 4001119347,
  1565136089, 3898914787, 1108368660,  540939232,
  1173283510, 2745871338, 3681308437, 4207628240,
  3343053890, 4016749493, 1699691293, 1103962373,
  3625875870, 2256883143, 3830138730, 1031889488,
  3479347698, 1535977030, 4236805024, 3251091107,
  2132092099, 1774941330, 1199868427, 1452454533,
   157007616, 2904115357,  342012276,  595725824,
  1480756522,  206960106,  497939518,  591360097,
   863170706, 2375253569, 3596610801, 1814182875,
  2094937945, 3421402208, 1082520231, 3463918190,
  2785509508,  435703966, 3908032597, 1641649973,
  2842273706, 3305899714, 1510255612, 2148256476,
  2655287854, 3276092548, 4258621189,  236887753,
  3681803219,  274041037, 1734335097, 3815195456,
  3317970021, 1899903192, 1026095262, 4050517792,
   356393447, 2410691914, 3873677099, 3682840055,

  3913112168, 2491498743, 4132185628, 2489919796,
  1091903735, 1979897079, 3170134830, 3567386728,
  3557303409,  857797738, 1136121015, 1342202287,
   507115054, 2535736646,  337727348, 3213592640,
  1301675037, 2528481711, 1895095763, 1721773893,
  3216771564,   62756741, 2142006736,  835421444,
  2531993523, 1442658625, 3659876326, 2882144922,
   676362277, 1392781812,  170690266, 3921047035,
  1759253602, 3611846912, 1745797284,  664899054,
  1329594018, 3901205900, 3045908486, 2062866102,
  2865634940, 3543621612, 3464012697, 1080764994,
   553557557, 3656615353, 3996768171,  991055499,
   499776247, 1265440854,  648242737, 3940784050,
   980351604, 3713745714, 1749149687, 3396870395,
  4211799374, 3640570775, 1161844396, 3125318951,
  1431517754,  545492359, 4268468663, 3499529547,
  1437099964, 2702547544, 3433638243, 2581715763,
  2787789398, 1060185593, 1593081372, 2418618748,
  4260947970,   69676912, 2159744348,   86519011,
  2512459080, 3838209314, 1220612927, 3339683548,
   133810670, 1090789135, 1078426020, 1569222167,
   845107691, 3583754449, 4072456591, 1091646820,
   628848692, 1613405280, 3757631651,  526609435,
   236106946,   48312990, 2942717905, 3402727701,
  1797494240,  859738849,  992217954, 4005476642,
  2243076622, 3870952857, 3732016268,  765654824,
  3490871365, 2511836413, 1685915746, 3888969200,
  1414112111, 2273134842, 3281911079, 4080962846,
   172450625, 2569994100,  980381355, 4109958455,
  2819808352, 2716589560, 2568741196, 3681446669,
  3329971472, 1835478071,  660984891, 3704678404,
  4045999559, 3422617507, 3040415634, 1762651403,
  1719377915, 3470491036, 2693910283, 3642056355,
  3138596744, 1364962596, 2073328063, 1983633131,
   926494387, 3423689081, 2150032023, 4096667949,
  1749200295, 3328846651,  309677260, 2016342300,
  1779581495, 3079819751,  111262694, 1274766160,
   443224088,  298511866, 1025883608, 3806446537,
  1145181785,  168956806, 3641502830, 3584813610,
  1689216846, 3666258015, 3200248200, 1692713982,
  2646376535, 4042768518, 1618508792, 1610833997,
  3523052358, 4130873264, 2001055236, 3610705100,
  2202168115, 4028541809, 2961195399, 1006657119,
  2006996926, 3186142756, 1430667929, 3210227297,
  1314452623, 4074634658, 4101304120, 2273951170,
  1399257539, 3367210612, 3027628629, 1190975929,
  2062231137, 2333990788, 2221543033, 2438960610,
  1181637006,  548689776, 2362791313, 3372408396,
  3104550113, 3145860560,  296247880, 1970579870,
  3078560182, 3769228297, 1714227617, 3291629107,
  3898220290,  166772364, 1251581989,  493813264,
   448347421,  195405023, 2709975567,  677966185,
  3703036547, 1463355134, 2715995803, 1338867538,
  1343315457, 2802222074, 2684532164,  233230375,
  2599980071, 2000651841, 3277868038, 1638401717,
  4028070440, 3237316320,    6314154,  819756386,
   300326615,  590932579, 1405279636, 3267499572,
  3150704214, 2428286686, 3959192993, 3461946742,
  1862657033, 1266418056,  963775037, 2089974820,
  2263052895, 1917689273,  448879540, 3550394620,
  3981727096,  150775221, 3627908307, 1303187396,
   508620638, 2975983352, 2726630617, 1817252668,
  1876281319, 1457606340,  908771278, 3720792119,
  3617206836, 2455994898, 1729034894, 1080033504,

   976866871, 3556439503, 2881648439, 1522871579,
  1555064734, 1336096578, 3548522304, 2579274686,
  3574697629, 3205460757, 3593280638, 3338716283,
  3079412587,  564236357, 2993598910, 1781952180,
  1464380207, 3163844217, 3332601554, 1699332808,
  1393555694, 1183702653, 3581086237, 1288719814,
   691649499, 2847557200, 2895455976, 3193889540,
  2717570544, 1781354906, 1676643554, 2592534050,
  3230253752, 1126444790, 2770207658, 2633158820,
  2210423226, 2615765581, 2414155088, 3127139286,
   673620729, 2805611233, 1269405062, 4015350505,
  3341807571, 4149409754, 1057255273, 2012875353,
  2162469141, 2276492801, 2601117357,  993977747,
  3918593370, 2654263191,  753973209,   36408145,
  2530585658,   25011837, 3520020182, 2088578344,
   530523599, 2918365339, 1524020338, 1518925132,
  3760827505, 3759777254, 1202760957, 3985898139,
  3906192525,  674977740, 4174734889, 2031300136,
  2019492241, 3983892565, 4153806404, 3822280332,
   352677332, 2297720250,   60907813,   90501309,
  3286998549, 1016092578, 2535922412, 2839152426,
   457141659,  509813237, 4120667899,  652014361,
  1966332200, 2975202805,   55981186, 2327461051,
   676427537, 3255491064, 2882294119, 3433927263,
  1307055953,  942726286,  933058658, 2468411793,
  3933900994, 4215176142, 1361170020, 2001714738,
  2830558078, 3274259782, 1222529897, 1679025792,
  2729314320, 3714953764, 1770335741,  151462246,
  3013232138, 1682292957, 1483529935,  471910574,
  1539241949,  458788160, 3436315007, 1807016891,
  3718408830,  978976581, 1043663428, 3165965781,
  1927990952, 4200891579, 2372276910, 3208408903,
  3533431907, 1412390302, 2931980059, 4132332400,
  1947078029, 3881505623, 4168226417, 2941484381,
  1077988104, 1320477388,  886195818,   18198404,
  3786409000, 2509781533,  112762804, 3463356488,
  1866414978,  891333506,   18488651,  661792760,
  1628790961, 3885187036, 3141171499,  876946877,
  2693282273, 1372485963,  791857591, 2686433993,
  3759982718, 3167212022, 3472953795, 2716379847,
   445679433, 3561995674, 3504004811, 3574258232,
    54117162, 3331405415, 2381918588, 3769707343,
  4154350007, 1140177722, 4074052095,  668550556,
  3214352940,  367459370,  261225585, 2610173221,
  4209349473, 3468074219, 3265815641,  314222801,
  3066103646, 3808782860,  282218597, 3406013506,
  3773591054,  379116347, 1285071038,  846784868,
  2669647154, 3771962079, 3550491691, 2305946142,
   453669953, 1268987020, 3317592352, 3279303384,
  3744833421, 2610507566, 3859509063,  266596637,
  3847019092,  517658769, 3462560207, 3443424879,
   370717030, 4247526661, 2224018117, 4143653529,
  4112773975, 2788324899, 2477274417, 1456262402,
  2901442914, 1517677493, 1846949527, 2295493580,
  3734397586, 2176403920, 1280348187, 1908823572,
  3871786941,  846861322, 1172426758, 3287448474,
  3383383037, 1655181056, 3139813346,  901632758,
  1897031941, 2986607138, 3066810236, 3447102507,
  1393639104,  373351379,  950779232,  625454576,
  3124240540, 4148612726, 2007998917,  544563296,
  2244738638, 2330496472, 2058025392, 1291430526,
   424198748,   50039436,   29584100, 3605783033,
  2429876329, 2791104160, 1057563949, 3255363231,
  3075367218, 3463963227, 1469046755,  985887462
};
//----------------

const array_info_t non_sparse_consts[] =
{
  { ARR(Blowfish_p_init),                 "Blowfish"       },
  { ARR(Blowfish_s_init),                 "Blowfish"       },
  { ARR(Camellia_s1),                     "Camellia"       },
  { ARR(Camellia_s2),                     "Camellia"       },
  { ARR(Camellia_s3),                     "Camellia"       },
  { ARR(Camellia_s4),                     "Camellia"       },
  { ARR(CAST_S),                          "CAST"           },
  { ARR(CAST256_t_m),                     "CAST256"        },
  { ARR(CAST256_t_r),                     "CAST256"        },
  { ARR(CRC32_m_tab),                     "CRC32"          },
  { ARR(DES_ei),                          "DES"            },
  { ARR(DES_fp),                          "DES"            },
  { ARR(DES_ip),                          "DES"            },
  { ARR(DES_p32i),                        "DES"            },
  { ARR(DES_pc1),                         "DES"            },
  { ARR(DES_pc2),                         "DES"            },
  { ARR(DES_sbox),                        "DES"            },
  { ARR(GOST_sBox),                       "GOST"           },
  { ARR(HAVAL_mc2),                       "HAVAL"          },
  { ARR(HAVAL_mc3),                       "HAVAL"          },
  { ARR(HAVAL_mc4),                       "HAVAL"          },
  { ARR(HAVAL_mc5),                       "HAVAL"          },
  { ARR(HAVAL_wi2),                       "HAVAL"          },
  { ARR(HAVAL_wi3),                       "HAVAL"          },
  { ARR(HAVAL_wi4),                       "HAVAL"          },
  { ARR(HAVAL_wi5),                       "HAVAL"          },
  { ARR(MARS_Sbox),                       "MARS"           },
  { ARR(MD2_S),                           "MD2"            },
  { ARR(MD5MAC_T),                        "MD5"            },
  { ARR(PKCS_DigestDecoration_MD2),       "PKCS_MD2"       },
  { ARR(PKCS_DigestDecoration_MD5),       "PKCS_MD5"       },
  { ARR(PKCS_DigestDecoration_RIPEMD160), "PKCS_RIPEMD160" },
  { ARR(PKCS_DigestDecoration_SHA256),    "PKCS_SHA256"    },
  { ARR(PKCS_DigestDecoration_SHA384),    "PKCS_SHA384"    },
  { ARR(PKCS_DigestDecoration_SHA512),    "PKCS_SHA512"    },
  { ARR(PKCS_DigestDecoration_Tiger),     "PKCS_Tiger"     },
  { ARR(RawDES_Spbox),                    "RawDES"         },
  { ARR(rc2_PITABLE),                     "RC2"            },
  { ARR(Rijndael_Td0),                    "Rijndael"       },
  { ARR(Rijndael_Td1),                    "Rijndael"       },
  { ARR(Rijndael_Td2),                    "Rijndael"       },
  { ARR(Rijndael_Td3),                    "Rijndael"       },
  { ARR(Rijndael_Td4),                    "Rijndael"       },
  { ARR(Rijndael_Te0),                    "Rijndael"       },
  { ARR(Rijndael_Te1),                    "Rijndael"       },
  { ARR(Rijndael_Te2),                    "Rijndael"       },
  { ARR(Rijndael_Te3),                    "Rijndael"       },
  { ARR(Rijndael_Te4),                    "Rijndael"       },
  { ARR(SAFER_exp_tab),                   "SAFER"          },
  { ARR(SAFER_log_tab),                   "SAFER"          },
  { ARR(SHA256_K),                        "SHA256"         },
  { ARR(SHA512_K),                        "SHA512"         },
  { ARR(SHARK_dec_cbox),                  "SHARK"          },
  { ARR(SHARK_enc_cbox),                  "SHARK"          },
  { ARR(SHARK_iG),                        "SHARK"          },
  { ARR(SKIPJACK_fTable),                 "SKIPJACK"       },
  { ARR(Square_Sd_or_SHARK_dec_sbox),     "Square/SHARK"   },
  { ARR(Square_Se_or_SHARK_enc_sbox),     "Square/SHARK"   },
  { ARR(Square_Td),                       "Square"         },
  { ARR(Square_Te),                       "Square"         },
  { ARR(Tiger_table),                     "Tiger"          },
  { ARR(Twofish_mds),                     "Twofish"        },
  { ARR(Twofish_q),                       "Twofish"        },
  { ARR(WAKE_tt),                         "WAKE"           },
  { ARR(Whirlpool_C0),                    "Whirlpool"      },
  { ARR(Whirlpool_C1),                    "Whirlpool"      },
  { ARR(Whirlpool_C2),                    "Whirlpool"      },
  { ARR(Whirlpool_C3),                    "Whirlpool"      },
  { ARR(Whirlpool_rc),                    "Whirlpool"      },
  { ARR(zdeflate_lengthCodes),            "zlib"           },
  { ARR(zinflate_distanceExtraBits),      "zlib"           },
  { ARR(zinflate_distanceStarts),         "zlib"           },
  { ARR(zinflate_lengthExtraBits),        "zlib"           },
  { ARR(zinflate_lengthStarts),           "zlib"           },
  { nullptr, 0, 0, nullptr, nullptr }
};
