#!/bin/sh

hv_output=$(./vault_server -f hexvault.conf  -d ./files)
hv_exit_code=$?
hv_output=$(echo "$hv_output" | tail -1)

echo "exit code $hv_exit_code, output: $hv_output"

contains() { case "$1" in *"$2"*) true ;; *) false ;; esac }

if ! [ -f /hexvault/files/hexvault.sqlite3 ]; then
    echo "Database will be created"
    ./vault_server -f hexvault.conf -d ./files --recreate-schema
    hv_exit_code=1
elif [ $hv_exit_code = 1 ] && contains "$hv_output" "Error: obsolete database schema"; then
    echo "db is not up to date"
    ./vault_server -f hexvault.conf -d ./files --upgrade-schema
    # output: Database has been initialized; exiting
    hv_exit_code=1
elif [ $hv_exit_code = 1 ] && contains "$hv_output" "Certificate chain file not found"; then
    echo "Database is already created"
    ./vault_server -f hexvault.conf -d ./files -c vault_server.crt -k vault_server.key -p 65433
    hv_exit_code=$?
else
    echo "unhandled case 1"
fi

exit $hv_exit_code
