#!/bin/sh

lumina_output=$(./lumina_server -f lumina.conf)
lumina_exit_code=$?
lumina_output=$(echo "$lumina_output" | tail -1)

echo "exit code $lumina_exit_code, output: $lumina_output"

contains() { case "$1" in *"$2"*) true ;; *) false ;; esac }

if [ $lumina_exit_code = 1 ] && contains "$lumina_output" "Error: Cannot connect to lumina db"; then
    echo "db is down or something"
    sleep 5
    lumina_exit_code=1
elif [ $lumina_exit_code = 1 ] && contains "$lumina_output" "Error: obsolete database schema (0)"; then
    echo "db is not initialized"
    ./lumina_server -f lumina.conf --recreate-schema
    # output: Database has been initialized; exiting
    lumina_exit_code=1
elif [ $lumina_exit_code = 1 ] && contains "$lumina_output" "Error: obsolete database schema (1)"; then
    echo "db is not up to date"
    ./lumina_server -f lumina.conf --upgrade-schema
    # output: Database has been initialized; exiting
    lumina_exit_code=1
elif [ $lumina_exit_code = 1 ] && contains "$lumina_output" "Certificate chain file not found"; then
    echo "db is initialized already"
    ./lumina_server -f lumina.conf -c lumina_server.crt -k lumina_server.key -p 65432
    lumina_exit_code=$?
else
    echo "unhandled case 1"
fi

exit $lumina_exit_code
